/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.common.ApplicationMigrationHelper;
import com.ibm.ws.migration.postupgrade.common.DeploymentConfig;
import com.ibm.ws.migration.postupgrade.common.LibrariesApplicationDocumentProcessor;
import com.ibm.ws.migration.postupgrade.common.ResourceApplicationDocumentProcessor;
import com.ibm.ws.migration.postupgrade.common.SecurityConfig;
import com.ibm.ws.migration.postupgrade.common.VariableApplicationDocumentProcessor;
import com.ibm.ws.migration.postupgrade.common.VirtualHostConfig;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.wsspi.migration.document.BasicDocument;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMTransformMapping;
import com.ibm.wsspi.migration.transform.BasicDocumentTransform;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.transform.TransactionalDocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class ApplicationTransactionalDocumentTransform
extends TransactionalDocumentTransform {
    private static TraceComponent _tc = Tr.register((Class)ApplicationTransactionalDocumentTransform.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    protected static final CommonarchiveFactory factory = CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    protected static final WCCMTransformMapping RESOURCES_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("resources.xml"), ResourceApplicationDocumentProcessor.class);
    protected static final WCCMTransformMapping DEPLOYMENT_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("deployment.xml"), DeploymentConfig.class);
    protected static final WCCMTransformMapping SECURITY_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("security.xml"), SecurityConfig.class);
    protected static final WCCMTransformMapping VIRTUAL_HOSTS_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("virtualhosts.xml"), VirtualHostConfig.class);
    protected static final WCCMTransformMapping LIBRARIES_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("libraries.xml"), LibrariesApplicationDocumentProcessor.class);
    protected static final WCCMTransformMapping VARIABLES_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("variables.xml"), VariableApplicationDocumentProcessor.class);
    protected boolean _saveCompletedSuccessfully = false;
    protected Scenario _scenario = null;
    protected static Vector _applications = new Vector();
    protected static ApplicationMigrationHelper _helper = null;
    static /* synthetic */ Class class$com$ibm$wsspi$migration$document$BasicDocument;

    public ApplicationTransactionalDocumentTransform(Scenario scenario, DocumentCollection documentCollection, DocumentCollection documentCollection2, DocumentTransform documentTransform) throws Exception {
        super(scenario, documentCollection, documentCollection2, documentTransform);
        this._scenario = scenario;
        _helper = new ApplicationMigrationHelper(this._scenario);
        this.populateTransform();
        this.createPropertiesFile();
    }

    protected void populateTransform() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"populateTransform");
        Vector vector = this.getChildren();
        String[] stringArray = this.getSampleApps();
        String[] stringArray2 = this.getAdminApps();
        for (int i = vector.size() - 1; i >= 0; --i) {
            Object object;
            DocumentTransform documentTransform = (DocumentTransform)vector.get(i);
            String string = documentTransform.getName();
            boolean bl = _helper.isSampleOrAdminApp(string, stringArray, stringArray2);
            boolean bl2 = _helper.isGatewayOrUddiAppOnBase(string);
            if (bl || bl2) {
                vector.remove(i);
                continue;
            }
            boolean bl3 = _helper.extractEARFile(documentTransform, string);
            if (!bl3) {
                vector.remove(i);
                continue;
            }
            try {
                DocumentCollection documentCollection = documentTransform.getOldDocumentCollection().getChild("deployments").getChildren()[0];
                object = documentTransform.getNewDocumentCollection().getChild("META-INF");
                DocumentCollection documentCollection2 = this.createIbmConfigDC((DocumentCollection)object);
                BasicDocumentTransform basicDocumentTransform = new BasicDocumentTransform(this._scenario, documentCollection, documentCollection2, documentTransform);
                DocumentCollection documentCollection3 = documentTransform.getOldDocumentCollection().getChild("deployments").getChildren()[0];
                DocumentCollection documentCollection4 = documentTransform.getNewDocumentCollection();
                BasicDocumentTransform basicDocumentTransform2 = new BasicDocumentTransform(this._scenario, documentCollection3, documentCollection4, documentTransform);
                Vector vector2 = documentTransform.getChildren();
                vector2.add(basicDocumentTransform);
                vector2.add(basicDocumentTransform2);
                ApplicationTransactionalDocumentTransform.copyDocumentCollection(basicDocumentTransform2.getOldDocumentCollection(), basicDocumentTransform2.getNewDocumentCollection());
                this.migrateApplicationFiles(basicDocumentTransform);
                continue;
            }
            catch (Exception exception) {
                object = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{exception}, "The migration of one or more applications terminated unexpectedly.");
                UpgradeBase.get_logger().println((String)object, exception);
            }
        }
    }

    protected void createPropertiesFile() {
        Tr.entry((TraceComponent)_tc, (String)"createPropertiesFile");
        try {
            File file = new File(UpgradeBase.get_backupDirectory(), "migration.props");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            PrintStream printStream = new PrintStream(bufferedOutputStream);
            String string = "#Props file used during WASPostUpgrade for installation of applications";
            printStream.println(string);
            String string2 = "com.ibm.websphere.security.jacc.donotpropagate=true";
            printStream.println(string2);
            printStream.flush();
            printStream.close();
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Unable to create migration.props file.");
        }
    }

    protected DocumentCollection createIbmConfigDC(DocumentCollection documentCollection) {
        Tr.entry((TraceComponent)_tc, (String)"createIbmConfigDC", (Object)new Object[]{documentCollection});
        DocumentCollection documentCollection2 = null;
        String[] stringArray = new String[]{"ibmconfig", "cells", "defaultCell", "applications", "defaultApp", "deployments", "defaultApp"};
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    documentCollection2 = documentCollection.getChild(stringArray[i]);
                }
                catch (NotFoundException notFoundException) {
                    documentCollection2 = documentCollection.addDocumentCollection(stringArray[i]);
                }
                documentCollection = documentCollection2;
                documentCollection2 = null;
            }
        }
        catch (Exception exception) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{exception}, "The migration of one or more applications terminated unexpectedly.");
            UpgradeBase.get_logger().println(string, exception);
        }
        return documentCollection;
    }

    protected void migrateApplicationFiles(DocumentTransform documentTransform) {
        Tr.entry((TraceComponent)_tc, (String)"migrateApplicationFiles", (Object)new Object[]{documentTransform});
        try {
            this.initDeploymentDocumentTransforms(documentTransform.getTransformMappings());
        }
        catch (Exception exception) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{exception}, "The migration of one or more applications terminated unexpectedly.");
            UpgradeBase.get_logger().println(string, exception);
        }
    }

    protected void initDeploymentDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initDeploymentDocumentTransforms", (Object)new Object[]{vector});
        vector.add(DEPLOYMENT_FILE_MAPPING);
        vector.add(SECURITY_FILE_MAPPING);
        vector.add(VIRTUAL_HOSTS_FILE_MAPPING);
        vector.add(VARIABLES_FILE_MAPPING);
        vector.add(LIBRARIES_FILE_MAPPING);
        vector.add(RESOURCES_FILE_MAPPING);
    }

    public static void copyDocumentCollection(DocumentCollection documentCollection, DocumentCollection documentCollection2) throws Exception {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"copyDocumentCollection", (Object)new Object[]{documentCollection, documentCollection2});
        String[] stringArray = documentCollection.getDocumentNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("deployment.xml") || stringArray[i].equals("resources.xml") || stringArray[i].equals("security.xml") || stringArray[i].equals("libraries.xml") || stringArray[i].equals("variables.xml") || stringArray[i].equals("virtualhosts.xml")) continue;
            BasicDocument basicDocument = (BasicDocument)documentCollection.openDocument(stringArray[i], class$com$ibm$wsspi$migration$document$BasicDocument == null ? ApplicationTransactionalDocumentTransform.class$("com.ibm.wsspi.migration.document.BasicDocument") : class$com$ibm$wsspi$migration$document$BasicDocument);
            object = (BasicDocument)documentCollection2.openDocument(stringArray[i], class$com$ibm$wsspi$migration$document$BasicDocument == null ? ApplicationTransactionalDocumentTransform.class$("com.ibm.wsspi.migration.document.BasicDocument") : class$com$ibm$wsspi$migration$document$BasicDocument, true, false);
            ((BasicDocument)object).setInputStream(basicDocument.getInputStream());
            basicDocument.close();
            ((BasicDocument)object).close();
        }
        DocumentCollection[] documentCollectionArray = documentCollection.getChildren();
        for (int i = 0; i < documentCollectionArray.length; ++i) {
            object = documentCollectionArray[i];
            DocumentCollection documentCollection3 = null;
            try {
                documentCollection3 = documentCollection2.getChild(object.getName());
            }
            catch (NotFoundException notFoundException) {
                documentCollection3 = documentCollection2.addDocumentCollection(object.getName());
            }
            ApplicationTransactionalDocumentTransform.copyDocumentCollection((DocumentCollection)object, documentCollection3);
        }
    }

    protected String[] getSampleApps() {
        Tr.entry((TraceComponent)_tc, (String)"getSampleApps");
        return new String[]{"DefaultApplication.ear", "PlantsByWebSphere.ear", "petstore.ear", "SamplesGallery.ear", "TechnologySamples.ear", "webservices.ear", "WebContainerTestApplication.ear", "greeting.ear", "MDBSamples.ear", "WebServicesSamples.ear", "StrutsTradeSample.ear", "DefaultEAR.ear", "StockQuoteExample.ear", "HospitalExample.ear", "ExpressSamples.ear", "AccountManagement.ear", "AccountReport.ear", "activitysession.ear", "BRBeansSamples.ear", "CompanyContext.ear", "CurrencyExchange.ear", "DynamicQuery.ear", "EMSSamples.ear", "JTAExtensionsSamples.ear", "TravelBooking.ear", "WebSphereTrader.ear", "TravelBookingSamp.ear", "cppsdkGallery.ear", "ValuetypeSample.ear", "BPELSamples.ear", "ivtApp.ear"};
    }

    protected String[] getAdminApps() {
        Tr.entry((TraceComponent)_tc, (String)"getAdminApps");
        return new String[]{"adminconsole.ear", "IBMUTC.ear", "filetransfer.ear"};
    }

    public void save() throws Exception {
        super.save();
        Vector vector = this.getChildren();
        try {
            for (int i = 0; i < vector.size(); ++i) {
                DocumentTransform documentTransform = (DocumentTransform)vector.get(i);
                String string = documentTransform.getName();
                _applications.add(i, string);
                String string2 = new File(new File(this._scenario.getNewProductImage().getProfile().getDirectory().getAbsolutePath(), "installableApps"), string).getAbsolutePath();
                EARFile eARFile = factory.openEARFile(string2);
                eARFile.save();
                eARFile.close();
            }
        }
        catch (Exception exception) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.application.failed.to.migrate", new Object[]{exception}, "The migration of one or more applications terminated unexpectedly.");
            UpgradeBase.get_logger().println(string, exception);
        }
        this._saveCompletedSuccessfully = true;
    }

    protected static Vector getApplicationList() {
        return _applications;
    }

    public boolean hasSaveCompletedSuccessfully() {
        return this._saveCompletedSuccessfully;
    }
}

