/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.ChannelsFactory;
import com.ibm.websphere.models.config.channelservice.channels.HTTPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.process.ProcessFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.threadpoolmanager.ThreadPoolManager;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.document.CellDocumentCollectionPostImpl;
import com.ibm.ws.migration.postupgrade.common.PortMapping;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.ServerDocumentCollection;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class ChannelFrameworkHelper {
    private static TraceComponent _tc = Tr.register((Class)ChannelFrameworkHelper.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static ChannelFrameworkHelper _cfHelper = null;
    protected DocumentTransform _transform = null;
    protected ServerDocumentCollection _serverDocumentCollection = null;
    protected CellDocumentCollectionPostImpl _cellDocumentCollectionPostImpl = null;
    static ArrayList _neverDeleteEndpoints = new ArrayList();

    public static ChannelFrameworkHelper getInstance(DocumentTransform documentTransform) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getInstance", (Object)new Object[]{documentTransform});
        if (_cfHelper == null) {
            _cfHelper = new ChannelFrameworkHelper(documentTransform);
        }
        return _cfHelper;
    }

    private ChannelFrameworkHelper(DocumentTransform documentTransform) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"ChannelFrameworkHelper", (Object)documentTransform);
        this._transform = documentTransform;
        this._serverDocumentCollection = (ServerDocumentCollection)documentTransform.getNewDocumentCollection();
        this._cellDocumentCollectionPostImpl = (CellDocumentCollectionPostImpl)documentTransform.getNewDocumentCollection().getParent().getParent().getParent().getParent();
    }

    public ThreadPool createDefaultThreadPoolForChannels(WebContainer webContainer) {
        Tr.entry((TraceComponent)_tc, (String)"createDefaultThreadPoolForChannels", (Object)webContainer);
        String string = "Default_Transport_To_Channel_pool";
        ThreadPoolManager threadPoolManager = this.getThreadPoolManager(webContainer);
        if (threadPoolManager != null) {
            ThreadPool threadPool;
            EList eList = threadPoolManager.getThreadPools();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                threadPool = (ThreadPool)iterator.next();
                if (!threadPool.getName().equals(string)) continue;
                return threadPool;
            }
            threadPool = ProcessFactory.eINSTANCE.createThreadPool();
            threadPool.setName(string);
            eList.add((Object)threadPool);
            return threadPool;
        }
        return null;
    }

    public void removeTCPInboundChain(EList eList, TCPInboundChannel tCPInboundChannel) {
        Tr.entry((TraceComponent)_tc, (String)"removeTCPInboundChain", (Object)new Object[]{eList, tCPInboundChannel});
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            TCPInboundChannel tCPInboundChannel2;
            Chain chain = (Chain)iterator.next();
            Object object = chain.getTransportChannels().get(0);
            if (!(object instanceof TCPInboundChannel) || !(tCPInboundChannel2 = (TCPInboundChannel)object).getName().equals(tCPInboundChannel.getName())) continue;
            iterator.remove();
        }
    }

    public void clearTransportsAndTCPChannels(List list, EList eList, EList eList2, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"clearTransportsAndTCPChannels");
        list.clear();
        Iterator iterator = eList2.iterator();
        while (iterator.hasNext()) {
            Object object;
            Iterator iterator2;
            Object object2;
            Chain chain = (Chain)iterator.next();
            if (!(chain.getTransportChannels().get(0) instanceof TCPInboundChannel) || !(chain.getTransportChannels().get(chain.getTransportChannels().size() - 1) instanceof WebContainerInboundChannel)) continue;
            String string2 = ((TCPInboundChannel)chain.getTransportChannels().get(0)).getEndPointName();
            if (string2 != null && !_neverDeleteEndpoints.contains(string2)) {
                this.clearServerIndexEndPoint(string2, string);
                object2 = chain.getTransportChannels().iterator();
                while (object2.hasNext()) {
                    iterator2 = (TransportChannel)object2.next();
                    eList.remove((Object)iterator2);
                    Tr.debug((TraceComponent)_tc, (String)("Removing channel " + iterator2.getName() + " on server " + string));
                }
                iterator.remove();
                continue;
            }
            object2 = (WCCMDocument)this._serverDocumentCollection.getParent().getParent().openDocument("serverindex.xml", class$com$ibm$wsspi$migration$document$wccm$WCCMDocument == null ? ChannelFrameworkHelper.class$("com.ibm.wsspi.migration.document.wccm.WCCMDocument") : class$com$ibm$wsspi$migration$document$wccm$WCCMDocument);
            iterator2 = this.getServerIndexEndPoints((WCCMDocument)object2, string).iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                object = (NamedEndPoint)iterator2.next();
                if (string2 == null || !string2.equals(object.getEndPointName())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                object = chain.getTransportChannels().iterator();
                while (object.hasNext()) {
                    TransportChannel transportChannel = (TransportChannel)object.next();
                    eList.remove((Object)transportChannel);
                    Tr.event((TraceComponent)_tc, (String)("Removing never delete channel " + transportChannel.getName() + " from server " + string + " because it is not in " + ((WCCMDocument)object2).getAbsoluteUrl()));
                }
                iterator.remove();
            }
            ((WCCMDocument)object2).close();
        }
    }

    public HTTPInboundChannel createHTTPChannelTransport(EList eList, EList eList2, int n) {
        Tr.entry((TraceComponent)_tc, (String)"createHTTPChannelTransport", (Object)new Object[]{eList, eList2, new Integer(n)});
        boolean bl = false;
        HTTPInboundChannel hTTPInboundChannel = null;
        if (!bl) {
            hTTPInboundChannel = ChannelsFactory.eINSTANCE.createHTTPInboundChannel();
            hTTPInboundChannel.setName("HTTP" + n);
            eList.add((Object)hTTPInboundChannel);
            eList2.add((Object)hTTPInboundChannel);
        }
        return hTTPInboundChannel;
    }

    public TCPInboundChannel doesTCPChannelTransportExist(EList eList, EList eList2, List list, int n) {
        TCPInboundChannel tCPInboundChannel;
        TransportChannel transportChannel;
        Tr.entry((TraceComponent)_tc, (String)"doesTCPChannelTransportExist", (Object)new Object[]{eList, eList2, new Integer(n)});
        TCPInboundChannel tCPInboundChannel2 = null;
        boolean bl = false;
        Iterator iterator = eList.iterator();
        block0: while (iterator.hasNext() && !bl) {
            transportChannel = (TransportChannel)iterator.next();
            if (!(transportChannel instanceof TCPInboundChannel)) continue;
            tCPInboundChannel = (TCPInboundChannel)transportChannel;
            String string = tCPInboundChannel.getEndPointName();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                if (!namedEndPoint.getEndPointName().equals(string) || namedEndPoint.getEndPoint().getPort() != n) continue;
                bl = true;
                tCPInboundChannel2 = tCPInboundChannel;
                continue block0;
            }
        }
        if (!bl) {
            transportChannel = list.iterator();
            while (transportChannel.hasNext()) {
                tCPInboundChannel = (Transport)transportChannel.next();
                if (tCPInboundChannel.getAddress().getPort() != n) continue;
                transportChannel.remove();
                break;
            }
        }
        return tCPInboundChannel2;
    }

    public SSLInboundChannel createSSLChannelTransport(EList eList, EList eList2, String string, int n) {
        Tr.entry((TraceComponent)_tc, (String)"createSSLChannelTransport", (Object)new Object[]{eList, eList2, string, new Integer(n)});
        boolean bl = false;
        SSLInboundChannel sSLInboundChannel = null;
        if (!bl) {
            sSLInboundChannel = ChannelsFactory.eINSTANCE.createSSLInboundChannel();
            sSLInboundChannel.setName("SSL" + n);
            sSLInboundChannel.setSslConfigAlias(string);
            eList.add((Object)sSLInboundChannel);
            eList2.add((Object)sSLInboundChannel);
        }
        return sSLInboundChannel;
    }

    public WebContainerInboundChannel createWebContainerChannelTransport(EList eList, EList eList2, int n) {
        Tr.entry((TraceComponent)_tc, (String)"createWebContainerChannelTransport", (Object)new Object[]{eList, eList2, new Integer(n)});
        boolean bl = false;
        WebContainerInboundChannel webContainerInboundChannel = null;
        if (!bl) {
            webContainerInboundChannel = ChannelsFactory.eINSTANCE.createWebContainerInboundChannel();
            webContainerInboundChannel.setName("WCC" + n);
            eList.add((Object)webContainerInboundChannel);
            eList2.add((Object)webContainerInboundChannel);
        }
        return webContainerInboundChannel;
    }

    public TCPInboundChannel createTCPChannelTransport(EList eList, EList eList2, String string, int n) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createTCPChannelTransport", (Object)new Object[]{eList, eList2, string, new Integer(n)});
        TCPInboundChannel tCPInboundChannel = ChannelsFactory.eINSTANCE.createTCPInboundChannel();
        String string2 = "TCP_" + n;
        tCPInboundChannel.setName("TCP" + n);
        tCPInboundChannel.setEndPointName(string2);
        eList.add((Object)tCPInboundChannel);
        NamedEndPoint namedEndPoint = ServerindexFactory.eINSTANCE.createNamedEndPoint();
        namedEndPoint.setEndPointName(string2);
        EndPoint endPoint = IpcFactory.eINSTANCE.createEndPoint();
        endPoint.setPort(n);
        if (string.equals("")) {
            endPoint.setHost("*");
        } else {
            endPoint.setHost(string);
        }
        namedEndPoint.setEndPoint(endPoint);
        eList2.add((Object)namedEndPoint);
        this.addChannelPortToPortMappings(n);
        return tCPInboundChannel;
    }

    protected void addChannelPortToPortMappings(int n) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"addChannelPortToPortMappings", (Object)new Integer(n));
        if (this._serverDocumentCollection != null && this._cellDocumentCollectionPostImpl.getPortUsage().getPortMappings().containsValue(new Integer(n))) {
            Iterator iterator = this._cellDocumentCollectionPostImpl.getPortUsage().getPortMappings().keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!k.equals(new Integer(n))) continue;
                this._cellDocumentCollectionPostImpl.getPortUsage().getPortMappings().remove(k);
            }
        }
        this._cellDocumentCollectionPostImpl.getPortUsage().getPortMappings().put(new Integer(n), new PortMapping(this._serverDocumentCollection.getParent().getParent().getName()));
    }

    public ThreadPoolManager getThreadPoolManager(WebContainer webContainer) {
        Tr.entry((TraceComponent)_tc, (String)"getThreadPoolManager", (Object)webContainer);
        ThreadPoolManager threadPoolManager = null;
        Iterator iterator = ((Server)webContainer.eContainer().eContainer()).getServices().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ThreadPoolManager)) continue;
            threadPoolManager = (ThreadPoolManager)e;
            break;
        }
        return threadPoolManager;
    }

    private void clearServerIndexEndPoint(String string, String string2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"clearServerIndexEndPoint", (Object)string);
        WCCMDocument wCCMDocument = (WCCMDocument)this._serverDocumentCollection.getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class, false, false);
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        WCCMDocument wCCMDocument2 = (WCCMDocument)this._transform.getOldDocumentCollection().getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class, false, true);
        ServerIndex serverIndex2 = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument2, ServerIndex.class);
        if (!this.doesOldServerIndexContainEndPoint(serverIndex2, string, string2)) {
            Iterator iterator = serverIndex.getServerEntries().iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry = (ServerEntry)iterator.next();
                if (!serverEntry.getServerName().equals(string2)) continue;
                Iterator iterator2 = serverEntry.getSpecialEndpoints().iterator();
                while (iterator2.hasNext()) {
                    NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                    if (!namedEndPoint.getEndPointName().equals(string)) continue;
                    iterator2.remove();
                }
            }
        }
        wCCMDocument2.close();
        wCCMDocument.close();
    }

    protected boolean doesOldServerIndexContainEndPoint(ServerIndex serverIndex, String string, String string2) {
        Tr.entry((TraceComponent)_tc, (String)"doesOldServerIndexContainEndPoint", (Object)new Object[]{serverIndex, string, string2});
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            if (!serverEntry.getServerName().equals(string2)) continue;
            Iterator iterator2 = serverEntry.getSpecialEndpoints().iterator();
            while (iterator2.hasNext()) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                if (!namedEndPoint.getEndPointName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public EList getServerIndexEndPoints(WCCMDocument wCCMDocument, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getServerIndexEndPoints");
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        EList eList = null;
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            if (!serverEntry.getServerName().equals(string)) continue;
            eList = serverEntry.getSpecialEndpoints();
        }
        return eList;
    }

    public TransportChannelService getTransportChannelService(WebContainer webContainer) {
        Tr.entry((TraceComponent)_tc, (String)"getTransportChannelService", (Object)webContainer);
        TransportChannelService transportChannelService = null;
        if (webContainer != null) {
            Iterator iterator = ((Server)webContainer.eContainer().eContainer()).getServices().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof TransportChannelService)) continue;
                transportChannelService = (TransportChannelService)e;
                break;
            }
        }
        return transportChannelService;
    }

    static {
        _neverDeleteEndpoints.add("WC_adminhost");
        _neverDeleteEndpoints.add("WC_adminhost_secure");
        if (!OSInfoFactory.isZSeries()) {
            _neverDeleteEndpoints.add("WC_defaulthost");
            _neverDeleteEndpoints.add("WC_defaulthost_secure");
        }
    }
}

