/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.adapter.migration.CloudscapeMigrationUtility;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.ConfigDocumentCollectionPostImpl;
import com.ibm.ws.migration.document.ConfigRepositoryDocumentCollectionHelper;
import com.ibm.ws.migration.document.policy.BasicPolicyDocumentProcessor;
import com.ibm.ws.migration.document.properties.BasicPropertiesDocumentProcessor;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.postupgrade.common.ApplicationMigrationHelper;
import com.ibm.ws.migration.postupgrade.common.ApplicationTransactionalDocumentTransform;
import com.ibm.ws.migration.postupgrade.common.CellConfig;
import com.ibm.ws.migration.postupgrade.common.CompositeTransformMapping;
import com.ibm.ws.migration.postupgrade.common.CoreGroupBridgeConfig;
import com.ibm.ws.migration.postupgrade.common.CoreGroupConfig;
import com.ibm.ws.migration.postupgrade.common.HAManagerServiceDocumentProcessor;
import com.ibm.ws.migration.postupgrade.common.JetStreamMigrationHelper;
import com.ibm.ws.migration.postupgrade.common.LegacyCloudscapeHelper;
import com.ibm.ws.migration.postupgrade.common.LibrariesConfig;
import com.ibm.ws.migration.postupgrade.common.MultibrokerConfig;
import com.ibm.ws.migration.postupgrade.common.NameBindingsConfig;
import com.ibm.ws.migration.postupgrade.common.NamestoreConfig;
import com.ibm.ws.migration.postupgrade.common.NodeGroupConfig;
import com.ibm.ws.migration.postupgrade.common.PMIConfigConfig;
import com.ibm.ws.migration.postupgrade.common.PerftunerConfig;
import com.ibm.ws.migration.postupgrade.common.PmirmConfig;
import com.ibm.ws.migration.postupgrade.common.ProxySettingsDocumentProcessor;
import com.ibm.ws.migration.postupgrade.common.R60.ResourcesPME502Config;
import com.ibm.ws.migration.postupgrade.common.R60.ResourcesPMEConfig;
import com.ibm.ws.migration.postupgrade.common.R60.ServerPME51Config;
import com.ibm.ws.migration.postupgrade.common.R60.ServerPMEConfig;
import com.ibm.ws.migration.postupgrade.common.ResourceConfig;
import com.ibm.ws.migration.postupgrade.common.ResourcesPME502Deserializer;
import com.ibm.ws.migration.postupgrade.common.ResourcesPMEDeserializer;
import com.ibm.ws.migration.postupgrade.common.RoleBasedAuthzConfig;
import com.ibm.ws.migration.postupgrade.common.SecurityConfig;
import com.ibm.ws.migration.postupgrade.common.ServerConfig;
import com.ibm.ws.migration.postupgrade.common.ServerCreationHelper;
import com.ibm.ws.migration.postupgrade.common.ServerIndexConfig;
import com.ibm.ws.migration.postupgrade.common.ServerPME51Deserializer;
import com.ibm.ws.migration.postupgrade.common.ServerPMEDeserializer;
import com.ibm.ws.migration.postupgrade.common.SystemAppsConfig;
import com.ibm.ws.migration.postupgrade.common.VariableConfig;
import com.ibm.ws.migration.postupgrade.common.VirtualHostConfig;
import com.ibm.ws.migration.postupgrade.common.WSSecurityConfig;
import com.ibm.ws.migration.transform.DescriptorEnabledTransform;
import com.ibm.ws.migration.transform.TransactionalDescriptorEnabledTransform;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.wsspi.migration.document.BasicTransformMapping;
import com.ibm.wsspi.migration.document.CopyDocumentProcessor;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMapping;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMTransformMapping;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

public class ConfigCommonTransactionalDocumentTransform
extends TransactionalDescriptorEnabledTransform {
    private static TraceComponent _tc = Tr.register((Class)ConfigCommonTransactionalDocumentTransform.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static final WCCMTransformMapping COREGROUP_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("coregroup.xml"), CoreGroupConfig.class);
    protected static final WCCMTransformMapping NODEGROUP_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("nodegroup.xml"), NodeGroupConfig.class);
    protected static final WCCMTransformMapping CELL_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("cell.xml"), CellConfig.class);
    protected static final WCCMTransformMapping ADMIN_AUTHZ_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("admin-authz.xml"), RoleBasedAuthzConfig.class);
    protected static final WCCMTransformMapping NAMING_AUTHZ_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("naming-authz.xml"), RoleBasedAuthzConfig.class);
    protected static final WCCMTransformMapping PMIRM_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("pmirm.xml"), PmirmConfig.class);
    protected static final WCCMTransformMapping SECURITY_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("security.xml"), SecurityConfig.class);
    protected static final WCCMTransformMapping VIRTUAL_HOST_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("virtualhosts.xml"), VirtualHostConfig.class);
    protected static final WCCMTransformMapping MULTIBROKER_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("multibroker.xml"), MultibrokerConfig.class);
    protected static final WCCMTransformMapping COREGROUPBRIDGE_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("coregroupbridge.xml"), CoreGroupBridgeConfig.class);
    protected static final BasicTransformMapping AMWAS_AMJACC_PROPERTY_TEMPLATE_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("amwas.amjacc.template.properties"), BasicPropertiesDocumentProcessor.class);
    protected static final BasicTransformMapping AMWAS_PDJLOG_PROPERTY_TEMPLATE_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("amwas.pdjlog.template.properties"), BasicPropertiesDocumentProcessor.class);
    protected static final BasicTransformMapping AMWAS_ACTION_PROPERTY_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("amwas.action.properties"), CopyDocumentProcessor.class);
    protected static final BasicTransformMapping FILTER_POLICY_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("filter.policy"), BasicPolicyDocumentProcessor.class);
    protected static final WCCMTransformMapping SERVERS_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("serverindex.xml"), ServerIndexConfig.class);
    protected static final BasicTransformMapping PERFTUNERS_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("perftuners.xml"), PerftunerConfig.class);
    protected static final WCCMTransformMapping SYSTEMAPPS_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("systemapps.xml"), SystemAppsConfig.class);
    protected static final BasicTransformMapping APP_POLICY_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("app.policy"), BasicPolicyDocumentProcessor.class);
    protected static final BasicTransformMapping LIBRARY_POLICY_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("library.policy"), BasicPolicyDocumentProcessor.class);
    protected static final BasicTransformMapping SPI_POLICY_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("spi.policy"), BasicPolicyDocumentProcessor.class);
    protected static final WCCMTransformMapping NAMESTORE_CELL_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("namestore-cell.xml"), NamestoreConfig.class);
    protected static final WCCMTransformMapping NAMESTORE_NODE_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("namestore-node.xml"), NamestoreConfig.class);
    protected static final WCCMTransformMapping WSSECURITY_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("ws-security.xml"), WSSecurityConfig.class);
    protected static final WCCMTransformMapping PMI_CONFIG_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("pmi-config.xml"), PMIConfigConfig.class);
    protected static final WCCMTransformMapping SERVER_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("server.xml"), ServerConfig.class);
    protected static final WCCMTransformMapping PROXY_SERVER_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("proxy-settings.xml"), ProxySettingsDocumentProcessor.class);
    protected static final BasicTransformMapping UDDI_PROPERTY_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("uddi.properties"), BasicPropertiesDocumentProcessor.class);
    protected static final WCCMTransformMapping HA_MANAGER_SERVICE_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("hamanagerservice.xml"), HAManagerServiceDocumentProcessor.class);
    protected static final WCCMTransformMapping SERVER_PME51_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("server-pme51.xml"), ServerPME51Config.class);
    protected static final BasicTransformMapping SERVER_PME51_SER_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("server-pme51.ser", "server-pme51.xml"), ServerPME51Deserializer.class);
    protected static final CompositeTransformMapping SERVER_PME51_SER_FILE_MAPPING_COMPLETE = new CompositeTransformMapping(new TransformMappingKey("server-pme51.ser", "server-pme51.xml"), new TransformMapping[]{SERVER_PME51_SER_FILE_MAPPING, SERVER_PME51_FILE_MAPPING});
    protected static final WCCMTransformMapping SERVER_PME_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("server-pme.xml"), com.ibm.ws.migration.postupgrade.common.ServerPMEConfig.class);
    protected static final BasicTransformMapping SERVER_PME_SER_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("server-pme.ser", "server-pme.xml"), ServerPMEDeserializer.class);
    protected static final CompositeTransformMapping SERVER_PME_SER_FILE_MAPPING_COMPLETE = new CompositeTransformMapping(new TransformMappingKey("server-pme.ser", "server-pme.xml"), new TransformMapping[]{SERVER_PME_SER_FILE_MAPPING, SERVER_PME_FILE_MAPPING});
    protected static final WCCMTransformMapping NAMESTORE_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("namestore.xml"), NamestoreConfig.class);
    protected static final WCCMTransformMapping RESOURCES_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("resources.xml"), ResourceConfig.class);
    protected static final WCCMTransformMapping VARIABLES_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("variables.xml"), VariableConfig.class);
    protected static final WCCMTransformMapping NAMEBINDINGS_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("namebindings.xml"), NameBindingsConfig.class);
    protected static final WCCMTransformMapping LIBRARIES_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("libraries.xml"), LibrariesConfig.class);
    protected static final WCCMTransformMapping RESOURCES_PME_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("resources-pme.xml"), ResourcesPMEConfig.class);
    protected static final BasicTransformMapping RESOURCES_PME_SER_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("resources-pme.ser", "resources-pme.xml"), ResourcesPMEDeserializer.class);
    protected static final CompositeTransformMapping RESOURCES_PME_SER_FILE_MAPPING_COMPLETE = new CompositeTransformMapping(new TransformMappingKey("resources-pme.ser", "resources-pme.xml"), new TransformMapping[]{RESOURCES_PME_SER_FILE_MAPPING, RESOURCES_PME_FILE_MAPPING});
    protected static final WCCMTransformMapping RESOURCES_PME502_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("resources-pme502.xml"), ResourcesPME502Config.class);
    protected static final BasicTransformMapping RESOURCES_PME502_SER_FILE_MAPPING = new BasicTransformMapping(new TransformMappingKey("resources-pme502.ser", "resources-pme502.xml"), ResourcesPME502Deserializer.class);
    protected static final CompositeTransformMapping RESOURCES_PME502_SER_FILE_MAPPING_COMPLETE = new CompositeTransformMapping(new TransformMappingKey("resources-pme502.ser", "resources-pme502.xml"), new TransformMapping[]{RESOURCES_PME502_SER_FILE_MAPPING, RESOURCES_PME502_FILE_MAPPING});
    private boolean _saveCompletedSuccessfully = true;
    protected ConfigRepository _jetstreamConfigRepository = null;
    protected DocumentContentSource[] _originalBusesDocuments = null;

    public ConfigCommonTransactionalDocumentTransform(Scenario scenario, DocumentCollection documentCollection, DocumentCollection documentCollection2, DocumentTransform documentTransform, DescriptorEnabledTransform.Descriptor descriptor) throws Exception {
        super(scenario, documentCollection, documentCollection2, documentTransform, descriptor);
        this.populateDescriptor();
        this.populateTransform();
    }

    protected void populateDescriptor() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"populateDescriptor");
        DescriptorEnabledTransform.Descriptor descriptor = this.getDescriptor().getChildDescriptor("cells").getChildDescriptor(((DocumentTransform)this.getChild("cells").getChildren().get(0)).getName());
        descriptor.setChildDescriptor("applications", DescriptorEnabledTransform.HIDE_CHILD);
    }

    protected void populateTransform() throws Exception {
        DocumentTransform documentTransform;
        int n;
        Vector vector;
        DocumentTransform documentTransform2;
        Tr.entry((TraceComponent)_tc, (String)"populateTransform");
        DocumentTransform documentTransform3 = (DocumentTransform)this.getChild("cells").getChildren().get(0);
        this.initCellDocumentTransforms(documentTransform3.getTransformMappings());
        try {
            documentTransform2 = documentTransform3.getChild("buses");
            if (documentTransform2 != null) {
                vector = documentTransform2.getChildren();
                for (n = 0; n < vector.size(); ++n) {
                    documentTransform = (DocumentTransform)vector.get(n);
                    Tr.debug((TraceComponent)_tc, (String)("Populating bus level Transforms for level: " + documentTransform.getName()));
                    this.initBusDocumentTransforms(documentTransform.getTransformMappings());
                }
            }
        }
        catch (NotFoundException notFoundException) {
            Tr.debug((TraceComponent)_tc, (String)"buses directory not found.");
        }
        try {
            documentTransform2 = documentTransform3.getChild("clusters");
            if (documentTransform2 != null) {
                vector = documentTransform2.getChildren();
                for (n = 0; n < vector.size(); ++n) {
                    documentTransform = (DocumentTransform)vector.get(n);
                    Tr.debug((TraceComponent)_tc, (String)("Populating cluster level Transforms for level: " + documentTransform.getName()));
                    this.initClustersDocumentTransforms(documentTransform.getTransformMappings());
                }
            }
        }
        catch (NotFoundException notFoundException) {
            Tr.debug((TraceComponent)_tc, (String)"clusters directory not found.");
        }
        try {
            documentTransform2 = documentTransform3.getChild("nodegroups");
            if (documentTransform2 != null) {
                vector = documentTransform2.getChildren();
                for (n = 0; n < vector.size(); ++n) {
                    documentTransform = (DocumentTransform)vector.get(n);
                    Tr.debug((TraceComponent)_tc, (String)("Populating nodegroup level Transforms for level: " + documentTransform.getName()));
                    this.initNodeGroupDocumentTransforms(documentTransform.getTransformMappings());
                }
            }
        }
        catch (NotFoundException notFoundException) {
            Tr.debug((TraceComponent)_tc, (String)"nodegroups directory not found.");
        }
        try {
            documentTransform2 = documentTransform3.getChild("coregroups");
            if (documentTransform2 != null) {
                vector = documentTransform2.getChildren();
                for (n = 0; n < vector.size(); ++n) {
                    documentTransform = (DocumentTransform)vector.get(n);
                    Tr.debug((TraceComponent)_tc, (String)("Populating coregroup level Transforms for level: " + documentTransform.getName()));
                    this.initCoreGroupDocumentTransforms(documentTransform.getTransformMappings());
                }
            }
        }
        catch (NotFoundException notFoundException) {
            Tr.debug((TraceComponent)_tc, (String)"coregroups directory not found.");
        }
        this.populateNodeLevelTransform(documentTransform3);
    }

    private void internalPopulateNodeLevelTransform(DocumentTransform documentTransform) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"internalPopulateNodeLevelTransform", (Object)new Object[]{documentTransform});
        Tr.debug((TraceComponent)_tc, (String)("Populating node level Transforms for level: " + documentTransform.getName()));
        this.initNodeDocumentTransforms(documentTransform.getTransformMappings());
        Vector vector = documentTransform.getChild("servers").getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            DocumentTransform documentTransform2 = (DocumentTransform)vector.get(i);
            if (this.isServerSupported(documentTransform2.getOldDocumentCollection())) {
                Tr.debug((TraceComponent)_tc, (String)("Populating server level Transforms for level: " + documentTransform2.getName()));
                this.initServerDocumentTransforms(documentTransform2.getTransformMappings());
                continue;
            }
            Tr.debug((TraceComponent)_tc, (String)("Not populating server " + documentTransform2.getName() + ".  serverType not supported."));
        }
    }

    protected void populateNodeLevelTransform(DocumentTransform documentTransform) throws Exception {
        DocumentTransform documentTransform2;
        int n;
        Tr.entry((TraceComponent)_tc, (String)"populateNodeLevelTransform", (Object)documentTransform);
        Vector vector = documentTransform.getChild("nodes").getChildren();
        ProfileImpl profileImpl = null;
        String string = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            profileImpl = (ProfileImpl)this.getScenario().getNewProductImage().getProfile();
            string = profileImpl.getOwningNodeName();
            bl = profileImpl.isApplicationServer();
            bl2 = false;
            for (n = 0; !bl2 && n < vector.size(); ++n) {
                documentTransform2 = (DocumentTransform)vector.get(n);
                bl2 = string != null && string.equals(documentTransform2.getName());
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"populateNodeLevelTransform - Exception encountered while processing configuration", (Object)exception);
            this.internalPopulateNodeLevelTransform((DocumentTransform)documentTransform.getChild("nodes").getChildren().get(0));
            return;
        }
        for (n = 0; n < vector.size(); ++n) {
            documentTransform2 = (DocumentTransform)vector.get(n);
            if (!(!bl2 && n == 0 || bl2 && string != null && string.equals(documentTransform2.getName())) && !bl) continue;
            this.internalPopulateNodeLevelTransform(documentTransform2);
        }
    }

    protected boolean isServerSupported(DocumentCollection documentCollection) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"isServerSupported", (Object)documentCollection);
        String string = documentCollection.getName();
        WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class, false, true);
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        wCCMDocument.close();
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            if (!serverEntry.getServerName().equals(string)) continue;
            return ServerCreationHelper.isSupportedServerType(serverEntry.getServerType());
        }
        return false;
    }

    protected void initCellDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initCellDocumentTransforms", (Object)vector);
        if (((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR51()) {
            Tr.debug((TraceComponent)_tc, (String)"Adding v5x cell level TransformMappings.");
            vector.add(RESOURCES_FILE_MAPPING);
            vector.add(LIBRARIES_FILE_MAPPING);
        } else {
            Tr.debug((TraceComponent)_tc, (String)"Adding v6x cell level TransformMappings.");
            vector.add(new WCCMTransformMapping(new TransformMappingKey("resources.xml"), com.ibm.ws.migration.postupgrade.common.R60.ResourceConfig.class));
            vector.add(new WCCMTransformMapping(new TransformMappingKey("libraries.xml"), com.ibm.ws.migration.postupgrade.common.R60.LibrariesConfig.class));
        }
        vector.add(SECURITY_FILE_MAPPING);
        vector.add(CELL_FILE_MAPPING);
        vector.add(ADMIN_AUTHZ_FILE_MAPPING);
        vector.add(MULTIBROKER_FILE_MAPPING);
        vector.add(NAMEBINDINGS_FILE_MAPPING);
        vector.add(NAMESTORE_FILE_MAPPING);
        vector.add(NAMING_AUTHZ_FILE_MAPPING);
        vector.add(PMIRM_FILE_MAPPING);
        vector.add(VARIABLES_FILE_MAPPING);
        vector.add(VIRTUAL_HOST_FILE_MAPPING);
        vector.add(COREGROUPBRIDGE_FILE_MAPPING);
        if (((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR51()) {
            Tr.debug((TraceComponent)_tc, (String)"Adding v5x cell level TransformMappings.");
            vector.add(RESOURCES_PME502_SER_FILE_MAPPING_COMPLETE);
            vector.add(RESOURCES_PME_SER_FILE_MAPPING_COMPLETE);
        } else {
            Tr.debug((TraceComponent)_tc, (String)"Adding v6x cell level TransformMappings.");
            vector.add(new WCCMTransformMapping(new TransformMappingKey("resources-pme.xml"), ResourcesPMEConfig.class));
            vector.add(new WCCMTransformMapping(new TransformMappingKey("resources-pme502.xml"), ResourcesPME502Config.class));
            vector.add(AMWAS_ACTION_PROPERTY_FILE_MAPPING);
        }
        vector.add(AMWAS_AMJACC_PROPERTY_TEMPLATE_FILE_MAPPING);
        vector.add(AMWAS_PDJLOG_PROPERTY_TEMPLATE_FILE_MAPPING);
        vector.add(FILTER_POLICY_FILE_MAPPING);
    }

    protected void initNodeDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initNodeDocumentTransforms", (Object)vector);
        if (((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR51()) {
            Tr.debug((TraceComponent)_tc, (String)"Adding v5x node level TransformMappings.");
            vector.add(RESOURCES_FILE_MAPPING);
            vector.add(LIBRARIES_FILE_MAPPING);
        } else {
            Tr.debug((TraceComponent)_tc, (String)"Adding v6x node level TransformMappings.");
            vector.add(new WCCMTransformMapping(new TransformMappingKey("resources.xml"), com.ibm.ws.migration.postupgrade.common.R60.ResourceConfig.class));
            vector.add(new WCCMTransformMapping(new TransformMappingKey("libraries.xml"), com.ibm.ws.migration.postupgrade.common.R60.LibrariesConfig.class));
        }
        vector.add(NAMEBINDINGS_FILE_MAPPING);
        vector.add(NAMESTORE_FILE_MAPPING);
        vector.add(SERVERS_FILE_MAPPING);
        vector.add(VARIABLES_FILE_MAPPING);
        if (((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR51()) {
            Tr.debug((TraceComponent)_tc, (String)"Adding v5x node level TransformMappings.");
            vector.add(RESOURCES_PME502_SER_FILE_MAPPING_COMPLETE);
            vector.add(RESOURCES_PME_SER_FILE_MAPPING_COMPLETE);
        } else {
            Tr.debug((TraceComponent)_tc, (String)"Adding v6x node level TransformMappings.");
            vector.add(new WCCMTransformMapping(new TransformMappingKey("resources-pme.xml"), ResourcesPMEConfig.class));
            vector.add(new WCCMTransformMapping(new TransformMappingKey("resources-pme502.xml"), ResourcesPME502Config.class));
        }
        vector.add(APP_POLICY_FILE_MAPPING);
        vector.add(SPI_POLICY_FILE_MAPPING);
        vector.add(LIBRARY_POLICY_FILE_MAPPING);
        vector.add(PERFTUNERS_FILE_MAPPING);
    }

    protected void initServerDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initServerDocumentTransforms", (Object)vector);
        if (((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR51()) {
            Tr.debug((TraceComponent)_tc, (String)"Adding v5x server level TransformMappings.");
            vector.add(RESOURCES_FILE_MAPPING);
            vector.add(LIBRARIES_FILE_MAPPING);
        } else {
            Tr.debug((TraceComponent)_tc, (String)"Adding v6x server level TransformMappings.");
            vector.add(new WCCMTransformMapping(new TransformMappingKey("resources.xml"), com.ibm.ws.migration.postupgrade.common.R60.ResourceConfig.class));
            vector.add(new WCCMTransformMapping(new TransformMappingKey("libraries.xml"), com.ibm.ws.migration.postupgrade.common.R60.LibrariesConfig.class));
        }
        vector.add(PROXY_SERVER_FILE_MAPPING);
        vector.add(SECURITY_FILE_MAPPING);
        vector.add(NAMEBINDINGS_FILE_MAPPING);
        vector.add(NAMESTORE_CELL_FILE_MAPPING);
        vector.add(NAMESTORE_NODE_FILE_MAPPING);
        vector.add(VARIABLES_FILE_MAPPING);
        vector.add(WSSECURITY_FILE_MAPPING);
        vector.add(PMI_CONFIG_FILE_MAPPING);
        vector.add(SERVER_FILE_MAPPING);
        vector.add(HA_MANAGER_SERVICE_FILE_MAPPING);
        if (((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this.getScenario().getOldProductImage().getReleaseVersion()).isR51()) {
            Tr.debug((TraceComponent)_tc, (String)"Adding v5x cell level TransformMappings.");
            vector.add(RESOURCES_PME502_SER_FILE_MAPPING_COMPLETE);
            vector.add(RESOURCES_PME_SER_FILE_MAPPING_COMPLETE);
            vector.add(SERVER_PME_SER_FILE_MAPPING_COMPLETE);
            vector.add(SERVER_PME51_SER_FILE_MAPPING_COMPLETE);
        } else {
            Tr.debug((TraceComponent)_tc, (String)"Adding v6x cell level TransformMappings.");
            vector.add(new WCCMTransformMapping(new TransformMappingKey("resources-pme.xml"), ResourcesPMEConfig.class));
            vector.add(new WCCMTransformMapping(new TransformMappingKey("resources-pme502.xml"), ResourcesPME502Config.class));
            vector.add(new WCCMTransformMapping(new TransformMappingKey("server-pme51.xml"), ServerPME51Config.class));
            vector.add(new WCCMTransformMapping(new TransformMappingKey("server-pme.xml"), ServerPMEConfig.class));
        }
        vector.add(UDDI_PROPERTY_FILE_MAPPING);
        vector.add(PERFTUNERS_FILE_MAPPING);
    }

    protected void initNodeGroupDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initnodeGroupDocumentTransforms", (Object)vector);
        vector.add(NODEGROUP_FILE_MAPPING);
    }

    protected void initCoreGroupDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initCoreGroupDocumentTransforms", (Object)vector);
        vector.add(COREGROUP_FILE_MAPPING);
    }

    protected void initClustersDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initClustersDocumentTransforms", (Object)vector);
    }

    protected void initBusDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initBusDocumentTransforms", (Object)vector);
    }

    public void save() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"save");
        super.save();
        this.performCloudscapeToDerbyPostSteps();
    }

    protected void performCloudscapeToDerbyPostSteps() {
        Tr.entry((TraceComponent)_tc, (String)"performCloudscapeToDerbyPostSteps");
        Iterator iterator = LegacyCloudscapeHelper.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object[] objectArray = LegacyCloudscapeHelper.get(string);
            String string2 = (String)objectArray[1];
            if (!((Boolean)objectArray[0]).booleanValue()) continue;
            Object[] objectArray2 = CloudscapeMigrationUtility.migrateCloudscape(string, string2, this.getScenario(), LoggerImpl.get_timeStamp());
            if (objectArray2[1] == null) {
                objectArray[0] = new Boolean(false);
                Tr.debug((TraceComponent)_tc, (String)("Old Cloudscape DB: " + string + " migrated successfully to DB: " + string2));
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.successful.cloudscape.db.migration", new Object[]{string, objectArray2[0]}, "Cloudscape Database {0} was successfully migrated.  See log {1}."));
                try {
                    UpgradeBase.get_newOSInfo().changeOwnership(new File(string2));
                }
                catch (Exception exception) {
                    Tr.debug((TraceComponent)_tc, (String)("Failed to change ownership of file: " + string2), (Object)exception);
                }
                continue;
            }
            Tr.debug((TraceComponent)_tc, (String)("Problem migrating oldDBName: " + string + " to newDBName: " + string2), (Object)objectArray2[1]);
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.failed.cloudscape.db.migration", new Object[]{string, string2, objectArray2[0]}, "Cloudscape Database {0} failed to migrate to {1} Database.  See log {2}."));
        }
    }

    protected void performJetStreamPostSteps() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"performJetStreamPostSteps");
        String string = this.getScenario().getNewProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getName();
        System.setProperty("local.cell", string);
        if (!this.getScenario().getOldProductImage().getOperatingSystem().isZSeries()) {
            try {
                this.prepareForJetstreamRollback();
                this.performJetStreamMigration();
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)("V5.x to V6.1 JetStream Migration failed with exception: " + exception.getMessage()));
                throw exception;
            }
        }
    }

    public void rollback() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"rollback");
        this.rollbackCloudscapeToDerbyModifications();
        this.rollbackJetStreamModifications();
        super.rollback();
    }

    protected void rollbackCloudscapeToDerbyModifications() {
        Tr.entry((TraceComponent)_tc, (String)"rollbackCloudscapeToDerbyModifications");
        Iterator iterator = LegacyCloudscapeHelper.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object[] objectArray = LegacyCloudscapeHelper.get(string);
            String string2 = (String)objectArray[1];
            if (((Boolean)objectArray[0]).booleanValue()) continue;
            CloudscapeMigrationUtility.rollbackCloudscape(string2, this.getScenario());
        }
    }

    protected void rollbackJetStreamModifications() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"rollbackJetStreamModifications");
        if (this._jetstreamConfigRepository != null && this._originalBusesDocuments != null) {
            DocumentCollection documentCollection = this.getNewDocumentCollection().getChild("cells").getChildren()[0].getChild("buses");
            String string = ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(documentCollection.getUrl().toString());
            String[] stringArray = this._jetstreamConfigRepository.listResourceNames(string, 1, Integer.MAX_VALUE);
            Document[] documentArray = new Document[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                documentArray[i] = new Document(stringArray[i]);
            }
            this._jetstreamConfigRepository.delete(documentArray);
            DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[this._originalBusesDocuments.length];
            for (int i = 0; i < this._originalBusesDocuments.length; ++i) {
                DocumentContentSource documentContentSource;
                Document document = new Document(this._originalBusesDocuments[i].getDocument().getURI());
                documentContentSourceArray[i] = documentContentSource = new DocumentContentSource(document, this._originalBusesDocuments[i].getSource());
            }
            this._jetstreamConfigRepository.create(documentContentSourceArray);
        }
    }

    protected void prepareForJetstreamRollback() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"prepareForJetstreamRollback");
        try {
            this._jetstreamConfigRepository = ((ConfigDocumentCollectionPostImpl)this.getNewDocumentCollection()).getLocalConfigRepository();
            DocumentCollection documentCollection = this.getNewDocumentCollection().getChild("cells").getChildren()[0].getChild("buses");
            String string = ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(documentCollection.getUrl().toString());
            String[] stringArray = this._jetstreamConfigRepository.listResourceNames(string, 1, Integer.MAX_VALUE);
            this._originalBusesDocuments = this._jetstreamConfigRepository.extract(stringArray);
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Problem backing up buses directory.  Possible condition, may not exist.");
        }
    }

    public boolean hasSaveCompletedSuccessfully() {
        Tr.entry((TraceComponent)_tc, (String)"hasSaveCompletedSuccessfully");
        if (!this._saveCompletedSuccessfully) {
            return this._saveCompletedSuccessfully;
        }
        return this.getNewTransactionalDocumentCollection().saveCompletedSuccessfully();
    }

    protected void performJetStreamMigration() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"performJetStreamMigration");
        if (ServerConfig._jmsSets.size() > 0) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.deprecated.attribute", new Object[]{"JMSServer", "server.xml"}, "The {0} setting in file {1} has been deprecated, see infocenter for further information."));
        }
        try {
            String string = this.getScenario().getNewProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getName();
            JetStreamMigrationHelper jetStreamMigrationHelper = new JetStreamMigrationHelper();
            jetStreamMigrationHelper.init(string);
            for (int i = 0; i < ServerConfig._jmsSets.size(); ++i) {
                Vector vector = (Vector)ServerConfig._jmsSets.get(i);
                Tr.debug((TraceComponent)_tc, (String)("JMSServer Ref: " + vector.get(0)));
                Tr.debug((TraceComponent)_tc, (String)("JMSServer node name: " + vector.get(1)));
                Tr.debug((TraceComponent)_tc, (String)("JMSServer server name: " + vector.get(2)));
                jetStreamMigrationHelper.migrateJMSServerToJetStream((JMSServer)vector.get(0), (String)vector.get(1), (String)vector.get(2));
            }
            if (ServerConfig._jmsSets.size() > 0) {
                jetStreamMigrationHelper.save();
            }
        }
        catch (Exception exception) {
            String string = LoggerImpl.get_nls().getString("advise.jmsserver.to.jetstream.migration.failed", "Service Integration Bus migration failed.");
            UpgradeBase.get_logger().println(string);
            throw exception;
        }
    }

    protected void replaceDocumentProcessor(TransformMapping transformMapping, TransformMappingKey transformMappingKey, Class clazz) {
        Tr.entry((TraceComponent)_tc, (String)"replaceDocumentProcessor", (Object)new Object[]{transformMapping, transformMappingKey, clazz});
        if (transformMapping.getKey().equals(transformMappingKey)) {
            transformMapping.getDocumentProcessors().clear();
            transformMapping.getDocumentProcessors().add(clazz);
        }
    }

    protected void appendDocumentProcessor(TransformMapping transformMapping, TransformMappingKey transformMappingKey, Class clazz) {
        Tr.entry((TraceComponent)_tc, (String)"appendDocumentProcessor", (Object)new Object[]{transformMapping, transformMappingKey, clazz});
        if (transformMapping.getKey().equals(transformMappingKey)) {
            transformMapping.getDocumentProcessors().add(clazz);
        }
    }

    public void complete() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"complete");
        this.updateSecurity();
        UpgradeBase.get_newOSInfo().changeOwnership(WASPostUpgrade.get_configRoot());
        Vector vector = ApplicationTransactionalDocumentTransform.getApplicationList();
        this.installApps(vector);
        if (OSInfoFactory.isZSeries()) {
            this.updateAdminApps();
        }
        this.updatePluginCfg();
        UpgradeBase.get_newOSInfo().changeOwnership(WASPostUpgrade.get_configRoot());
    }

    protected void updateSecurity() {
        Tr.entry((TraceComponent)_tc, (String)"updateSecurity");
        Security security = SecurityConfig.getOldSecurityObject();
        Security security2 = SecurityConfig.getNewSecurityObject();
        Tr.debug((TraceComponent)_tc, (String)"Start of post processing of security.xml");
        Security security3 = security;
        Iterator iterator = security3.getAuthMechanisms().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof LTPA)) continue;
            LTPA lTPA = (LTPA)e;
            LTPAServerObject lTPAServerObject = new LTPAServerObject();
            if (lTPAServerObject == null) continue;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            string = lTPA.getPassword();
            if (lTPA.getPublic() != null) {
                string2 = lTPA.getPublic().getByteArray();
            }
            if (lTPA.getPrivate() != null) {
                string3 = lTPA.getPrivate().getByteArray();
            }
            if (lTPA.getShared() != null) {
                string4 = lTPA.getShared().getByteArray();
            }
            Tr.debug((TraceComponent)_tc, (String)"ltpaPassword: xxxxxx");
            Tr.debug((TraceComponent)_tc, (String)("ltpaPublic: " + string2));
            Tr.debug((TraceComponent)_tc, (String)("ltpaPrivate: " + string3));
            Tr.debug((TraceComponent)_tc, (String)("ltpaShared: " + string4));
            if (string == null || string2 == null || string3 == null || string4 == null) continue;
            try {
                Tr.debug((TraceComponent)_tc, (String)"Before call to LTPAServerObject.importLTPAKeysToKeySetGroup(...)");
                lTPAServerObject.importLTPAKeysToKeySetGroup(string3, string2, string4, string.getBytes("UTF-8"), null, security2);
                Tr.debug((TraceComponent)_tc, (String)"After call to LTPAServerObject.importLTPAKeysToKeySetGroup(...)");
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Exception thrown from call to importLTPAKeysToKeySetGroup", (Object)exception);
            }
        }
        Tr.debug((TraceComponent)_tc, (String)"End of post processing of security.xml");
    }

    protected void updatePluginCfg() {
        Tr.entry((TraceComponent)_tc, (String)"updatePluginCfg");
    }

    protected void installApps(Vector vector) {
        ApplicationMigrationHelper applicationMigrationHelper = ApplicationTransactionalDocumentTransform._helper;
        if (applicationMigrationHelper != null && !WASPostUpgrade.get_includeApps().equals("false")) {
            applicationMigrationHelper.installApplications(vector);
        } else {
            Tr.debug((TraceComponent)_tc, (String)"Will not be installing Applications.");
            Tr.debug((TraceComponent)_tc, (String)("_applicationHelper: " + applicationMigrationHelper));
            Tr.debug((TraceComponent)_tc, (String)("WASPostUpgrade._includeApps: " + WASPostUpgrade.get_includeApps()));
        }
    }

    protected void updateAdminApps() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"updateAdminApps");
        ApplicationMigrationHelper applicationMigrationHelper = ApplicationTransactionalDocumentTransform._helper;
        if (applicationMigrationHelper != null) {
            applicationMigrationHelper.updateAdminApps();
        } else {
            new ApplicationMigrationHelper(this.getScenario()).updateAdminApps();
        }
    }
}

