/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.coregroup.CoreGroup;
import com.ibm.websphere.models.config.coregroup.CoreGroupServer;
import com.ibm.websphere.models.config.hamanagerservice.HAManagerService;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.CellDocumentCollectionPostImpl;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.NodeDocumentCollection;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class ConfigHelper {
    protected final String HAMANAGERSERVICE_FILE = "hamanagerservice.xml";
    private static TraceComponent _tc = Tr.register((Class)ConfigHelper.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected NodeDocumentCollection _newNodeDC = null;
    protected NodeDocumentCollection _oldNodeDC = null;
    protected final String DCS_UNICAST_NAME = "DCS_UNICAST_ADDRESS";
    protected int DCS_UNICAST_DEFAULT = 9353;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$topology$cluster$ServerCluster;

    public ConfigHelper(NodeDocumentCollection nodeDocumentCollection, NodeDocumentCollection nodeDocumentCollection2) throws Exception {
        this._newNodeDC = nodeDocumentCollection;
        this._oldNodeDC = nodeDocumentCollection2;
    }

    public void addHAManagerSettings(DocumentCollection documentCollection, WCCMDocument wCCMDocument, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"addHAManagerSettings", (Object)new Object[]{wCCMDocument, string});
        if (!UpgradeBase.get_oldOSInfo().releaseVersion().isR60()) {
            boolean bl = UpgradeBase.get_currentRelease().isExpressServerProductInstalled("embeddedEXPRESS");
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("isBobcat is: " + bl));
            }
            if (!bl && this.addToCoreGroupBasedOnCluster(documentCollection, string)) {
                this.addHAManagerEndPoint(wCCMDocument, string);
            }
        }
    }

    protected void addHAManagerEndPoint(WCCMDocument wCCMDocument, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"addHAManagerEndPoint", (Object)new Object[]{wCCMDocument, string});
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        String string2 = serverIndex.getHostName();
        EList eList = null;
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            if (!serverEntry.getServerName().equals(string)) continue;
            eList = serverEntry.getSpecialEndpoints();
        }
        if (eList != null) {
            NamedEndPoint namedEndPoint;
            boolean bl = false;
            Iterator iterator2 = eList.iterator();
            while (iterator2.hasNext()) {
                namedEndPoint = (NamedEndPoint)iterator2.next();
                if (!namedEndPoint.getEndPointName().equals("DCS_UNICAST_ADDRESS")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                namedEndPoint = (EndPoint)UtilityImpl.create("com.ibm.websphere.models.config.ipc.EndPoint");
                namedEndPoint.setHost(string2);
                namedEndPoint.setPort(((CellDocumentCollectionPostImpl)this._newNodeDC.getParent().getParent()).getPortUsage().createUniquePort(wCCMDocument, this.DCS_UNICAST_DEFAULT));
                NamedEndPoint namedEndPoint2 = (NamedEndPoint)UtilityImpl.create("com.ibm.websphere.models.config.serverindex.NamedEndPoint");
                namedEndPoint2.setEndPoint((EndPoint)namedEndPoint);
                namedEndPoint2.setEndPointName("DCS_UNICAST_ADDRESS");
                eList.add((Object)namedEndPoint2);
            }
        } else {
            throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{wCCMDocument.getName()}, "Unable to read configuration file (0)"), null, false);
        }
    }

    protected HashMap getClusterSiblings(String string) throws Exception {
        DocumentCollection[] documentCollectionArray;
        Tr.entry((TraceComponent)_tc, (String)"getClusterSiblings", (Object)new Object[]{string});
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            documentCollectionArray = this._oldNodeDC.getParent().getParent().getChild("clusters").getChildren();
        }
        catch (Exception exception) {
            return hashMap;
        }
        WCCMDocument wCCMDocument = null;
        for (int i = 0; i < documentCollectionArray.length; ++i) {
            wCCMDocument = (WCCMDocument)documentCollectionArray[i].openDocument("cluster.xml", class$com$ibm$wsspi$migration$document$wccm$WCCMDocument == null ? ConfigHelper.class$("com.ibm.wsspi.migration.document.wccm.WCCMDocument") : class$com$ibm$wsspi$migration$document$wccm$WCCMDocument, false, true);
            ServerCluster serverCluster = (ServerCluster)UtilityImpl.locateConfigFileObject(wCCMDocument, class$com$ibm$websphere$models$config$topology$cluster$ServerCluster == null ? ConfigHelper.class$("com.ibm.websphere.models.config.topology.cluster.ServerCluster") : class$com$ibm$websphere$models$config$topology$cluster$ServerCluster);
            boolean bl = false;
            Iterator iterator = serverCluster.getMembers().iterator();
            while (iterator.hasNext()) {
                ClusterMember clusterMember = (ClusterMember)iterator.next();
                hashMap.put(clusterMember.getMemberName(), clusterMember.getNodeName());
                Tr.debug((TraceComponent)_tc, (String)("Adding Cluster Sibling: " + clusterMember.getMemberName() + " with nodeName: " + clusterMember.getNodeName()));
                if (!clusterMember.getMemberName().equals(string) || !clusterMember.getNodeName().equals(this._newNodeDC.getName())) continue;
                hashMap.remove(clusterMember.getMemberName());
                Tr.debug((TraceComponent)_tc, (String)"Found correct ClusterGroup: ");
                bl = true;
            }
            if (bl) break;
            hashMap.clear();
        }
        if (wCCMDocument != null) {
            wCCMDocument.close();
        }
        return hashMap;
    }

    protected WCCMDocument getSiblingCoreGroup(HashMap hashMap) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getSiblingCoreGroup", (Object)hashMap);
        if (hashMap.isEmpty()) {
            Tr.debug((TraceComponent)_tc, (String)"Siblings empty.");
            WCCMDocument wCCMDocument = (WCCMDocument)this._newNodeDC.getParent().getParent().getChild("coregroups").getChild("DefaultCoreGroup").openDocument("coregroup.xml", WCCMDocument.class, false, false);
            return wCCMDocument;
        }
        Object object = this._newNodeDC.getParent().getParent().getChild("coregroups");
        DocumentCollection documentCollection = this._oldNodeDC.getParent().getParent().getChild("coregroups");
        DocumentCollection[] documentCollectionArray = documentCollection.getChildren();
        for (int i = 0; i < documentCollectionArray.length; ++i) {
            WCCMDocument wCCMDocument = (WCCMDocument)documentCollectionArray[i].openDocument("coregroup.xml", class$com$ibm$wsspi$migration$document$wccm$WCCMDocument == null ? ConfigHelper.class$("com.ibm.wsspi.migration.document.wccm.WCCMDocument") : class$com$ibm$wsspi$migration$document$wccm$WCCMDocument, false, true);
            DocumentCollection documentCollection2 = null;
            try {
                documentCollection2 = object.getChild(wCCMDocument.getDocumentCollection().getName());
            }
            catch (NotFoundException notFoundException) {
                object.addDocumentCollection(wCCMDocument.getDocumentCollection().getName());
                documentCollection2 = object.getChild(wCCMDocument.getDocumentCollection().getName());
            }
            WCCMDocument wCCMDocument2 = (WCCMDocument)documentCollection2.openDocument("coregroup.xml", class$com$ibm$wsspi$migration$document$wccm$WCCMDocument == null ? ConfigHelper.class$("com.ibm.wsspi.migration.document.wccm.WCCMDocument") : class$com$ibm$wsspi$migration$document$wccm$WCCMDocument, true, false);
            CoreGroup coreGroup = (CoreGroup)UtilityImpl.locateConfigFileObject(wCCMDocument, class$com$ibm$websphere$models$config$coregroup$CoreGroup == null ? ConfigHelper.class$("com.ibm.websphere.models.config.coregroup.CoreGroup") : class$com$ibm$websphere$models$config$coregroup$CoreGroup);
            Iterator iterator = coreGroup.getCoreGroupServers().iterator();
            while (iterator.hasNext()) {
                CoreGroupServer coreGroupServer = (CoreGroupServer)iterator.next();
                Iterator iterator2 = hashMap.keySet().iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    if (!coreGroupServer.getServerName().equals(string) || !coreGroupServer.getNodeName().equals(hashMap.get(string))) continue;
                    Tr.debug((TraceComponent)_tc, (String)("Found matching CoreGroup from file: " + wCCMDocument.getName()));
                    CoreGroup coreGroup2 = (CoreGroup)UtilityImpl.locateConfigFileObject(wCCMDocument2, CoreGroup.class);
                    coreGroup2.setName(coreGroup.getName());
                    return wCCMDocument2;
                }
            }
            wCCMDocument2.close();
            wCCMDocument.close();
        }
        object = (WCCMDocument)this._newNodeDC.getParent().getParent().getChild("coregroups").getChild("DefaultCoreGroup").openDocument("coregroup.xml", WCCMDocument.class, false, false);
        return object;
    }

    protected boolean addToCoreGroupBasedOnCluster(DocumentCollection documentCollection, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"addToCoreGroupBasedOnCluster", (Object)new Object[]{string});
        HashMap hashMap = this.getClusterSiblings(string);
        WCCMDocument wCCMDocument = this.getSiblingCoreGroup(hashMap);
        CoreGroup coreGroup = (CoreGroup)UtilityImpl.locateConfigFileObject(wCCMDocument, CoreGroup.class);
        EList eList = coreGroup.getCoreGroupServers();
        boolean bl = true;
        Iterator iterator = eList.iterator();
        CoreGroupServer coreGroupServer = null;
        String string2 = this._newNodeDC.getName();
        while (iterator.hasNext() && bl) {
            coreGroupServer = (CoreGroupServer)iterator.next();
            if (!coreGroupServer.getNodeName().equals(string2) || !coreGroupServer.getServerName().equals(string)) continue;
            bl = false;
        }
        if (bl) {
            coreGroupServer = (CoreGroupServer)UtilityImpl.create("com.ibm.websphere.models.config.coregroup.CoreGroupServer");
            coreGroupServer.setNodeName(string2);
            coreGroupServer.setServerName(string);
            coreGroupServer.setPreferredIPAddress("0.0.0.0");
            eList.add((Object)coreGroupServer);
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.adding.coregroup.server", new Object[]{string}, "Server {0} has been added to the default coregroup"), true);
        }
        WCCMDocument wCCMDocument2 = (WCCMDocument)documentCollection.openDocument("hamanagerservice.xml", WCCMDocument.class, false, false);
        HAManagerService hAManagerService = (HAManagerService)UtilityImpl.locateConfigFileObject(wCCMDocument2, HAManagerService.class);
        hAManagerService.setCoreGroupName(coreGroup.getName());
        Tr.debug((TraceComponent)_tc, (String)"Updating HAManagerService for server", (Object)new Object[]{wCCMDocument2, coreGroup.getName()});
        wCCMDocument2.close();
        wCCMDocument.close();
        return bl;
    }
}

