/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.Invoker;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.common.ConfigCommonTransactionalDocumentTransform;
import com.ibm.ws.migration.postupgrade.common.ServerConfig;
import com.ibm.ws.migration.postupgrade.common.SibAuthorisationsConfig;
import com.ibm.ws.migration.postupgrade.common.SibBusConfig;
import com.ibm.ws.migration.postupgrade.common.SibDestinationsConfig;
import com.ibm.ws.migration.postupgrade.common.SibEnginesConfig;
import com.ibm.ws.migration.postupgrade.common.SibMediationsConfig;
import com.ibm.ws.migration.postupgrade.common.SibServiceConfig;
import com.ibm.ws.migration.postupgrade.common.SibWSEplDocumentProcessor;
import com.ibm.ws.migration.postupgrade.common.SibWSGatewayDocumentProcessor;
import com.ibm.ws.migration.postupgrade.common.SibWSInboundDocumentProcessor;
import com.ibm.ws.migration.postupgrade.common.SibWSOutboundDocumentProcessor;
import com.ibm.ws.migration.postupgrade.common.SibWSSecurityConfig;
import com.ibm.ws.migration.postupgrade.common.SibWSSecurityDraft13DocumentProcessor;
import com.ibm.ws.migration.postupgrade.common.SibWSWebServicesConfig;
import com.ibm.ws.migration.transform.DescriptorEnabledTransform;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.WCCMTransformMapping;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class ConfigTransactionalDocumentTransform
extends ConfigCommonTransactionalDocumentTransform {
    private static TraceComponent _tc = Tr.register((Class)ConfigTransactionalDocumentTransform.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static final WCCMTransformMapping SIBWS_WEBSERVICES_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sibws-webservices.xml"), SibWSWebServicesConfig.class);
    protected static final WCCMTransformMapping SIBWS_WSSECURITY_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sibws-wssecurity.xml"), SibWSSecurityConfig.class);
    protected static final WCCMTransformMapping SIB_BUS_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sib-bus.xml"), SibBusConfig.class);
    protected static final WCCMTransformMapping SIB_MEDIATIONS_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sib-mediations.xml"), SibMediationsConfig.class);
    protected static final WCCMTransformMapping SIB_DESTINATIONS_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sib-destinations.xml"), SibDestinationsConfig.class);
    protected static final WCCMTransformMapping SIB_AUTHORISATIONS_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sib-authorisations.xml"), SibAuthorisationsConfig.class);
    protected static final WCCMTransformMapping SIB_ENGINES_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sib-engines.xml"), SibEnginesConfig.class);
    protected static final WCCMTransformMapping SIB_SERVICE_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sib-service.xml"), SibServiceConfig.class);
    protected static final WCCMTransformMapping SIBWS_EPL_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sibws-epl.xml"), SibWSEplDocumentProcessor.class);
    protected static final WCCMTransformMapping SIBWS_GATEWAY_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sibws-gateway.xml"), SibWSGatewayDocumentProcessor.class);
    protected static final WCCMTransformMapping SIBWS_INBOUND_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sibws-inbound.xml"), SibWSInboundDocumentProcessor.class);
    protected static final WCCMTransformMapping SIBWS_OUTBOUND_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sibws-outbound.xml"), SibWSOutboundDocumentProcessor.class);
    protected static final WCCMTransformMapping SIBWS_SECURITY_DRAFT13_FILE_MAPPING = new WCCMTransformMapping(new TransformMappingKey("sibws-wssecurity-draft13.xml"), SibWSSecurityDraft13DocumentProcessor.class);
    Scenario _scenario;

    public ConfigTransactionalDocumentTransform(Scenario scenario, DocumentCollection documentCollection, DocumentCollection documentCollection2, DocumentTransform documentTransform, DescriptorEnabledTransform.Descriptor descriptor) throws Exception {
        super(scenario, documentCollection, documentCollection2, documentTransform, descriptor);
        this._scenario = scenario;
    }

    protected void updatePluginCfg() {
        Tr.entry((TraceComponent)_tc, (String)"updatePluginCfg");
        try {
            String string = this.getNewDocumentCollection().getChild("cells").getChildren()[0].getName();
            StringBuffer stringBuffer = new StringBuffer(256).append(FileUtilities.quotedFileName(new File(new File(UpgradeBase.get_installRoot(), "bin"), "GenPluginCfg" + UpgradeBase.get_newOSInfo().fetchExecutableExtension()).getAbsolutePath())).append(" -cell.name ").append(FileUtilities.quotedFileName(string));
            String string2 = stringBuffer.toString();
            string2 = string2 + UpgradeBase.get_newOSInfo().instance();
            Tr.debug((TraceComponent)_tc, (String)"Final string for executable: ", (Object)string2);
            new Invoker(UpgradeBase.get_newOSInfo()).exec(string2, "GenPluginCfg");
            String string3 = null;
            for (int i = 0; i < ServerConfig._wsSets.size(); ++i) {
                string3 = stringBuffer.toString();
                Vector vector = (Vector)ServerConfig._wsSets.get(i);
                String string4 = (String)vector.get(0);
                String string5 = (String)vector.get(1);
                String string6 = (String)vector.get(2);
                string3 = string3 + " -node.name " + string4 + " -webserver.name " + string5;
                new Invoker(UpgradeBase.get_newOSInfo()).exec(string3, "GenPluginCfg for webserver: " + string5);
                this.postWebServerUpdate(string, string4, string5, string6);
            }
        }
        catch (Exception exception) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.update.error", new Object[]{exception}, "Error while updating the plugin-cfg.xml file, caught exception {0}."));
        }
    }

    protected void postWebServerUpdate(String string, String string2, String string3, String string4) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"postWebServerUpdate", (Object)new Object[]{string, string2, string3, string4});
        StringBuffer stringBuffer = new StringBuffer(256).append(FileUtilities.quotedFileName(new File(new File(UpgradeBase.get_userRoot(), "bin"), "wsadmin" + UpgradeBase.get_newOSInfo().fetchExecutableExtension()).getAbsolutePath()));
        stringBuffer.append(UpgradeBase.get_newOSInfo().instance());
        File file = File.createTempFile("createCMSKeyStore", ".jacl", new File(this._scenario.getBackupDirectory().getFile()));
        stringBuffer.append(" -conntype NONE -f ").append(FileUtilities.quotedFileName(file.getAbsolutePath()));
        StringBuffer stringBuffer2 = new StringBuffer(256);
        stringBuffer2.append("$AdminTask createCMSKeyStore { -cmsKeyStoreURI /config/cells/");
        stringBuffer2.append(string);
        stringBuffer2.append("/nodes/");
        stringBuffer2.append(string2);
        stringBuffer2.append("/servers/");
        stringBuffer2.append(string3);
        stringBuffer2.append("/plugin-key.kdb");
        stringBuffer2.append(" -pluginHostName ");
        stringBuffer2.append(string4);
        stringBuffer2.append(" }");
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.println(stringBuffer2);
            printWriter.println("$AdminConfig save");
            printWriter.flush();
            printWriter.close();
            new Invoker(UpgradeBase.get_newOSInfo()).exec(stringBuffer.toString(), "Running $AdminTask createCMSKeyStore task");
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            Tr.debug((TraceComponent)_tc, (String)"Error: failed to run createCMSKeyStore", (Object)iOException);
        }
    }

    public void save() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"save");
        super.save();
        this.performJetStreamPostSteps();
    }

    protected void initCellDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initCellDocumentTransforms", (Object)vector);
        super.initCellDocumentTransforms(vector);
        vector.add(SIBWS_WEBSERVICES_FILE_MAPPING);
        vector.add(SIBWS_WSSECURITY_FILE_MAPPING);
        vector.add(SIBWS_SECURITY_DRAFT13_FILE_MAPPING);
    }

    protected void initServerDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initServerDocumentTransforms", (Object)vector);
        super.initServerDocumentTransforms(vector);
        vector.add(SIB_ENGINES_FILE_MAPPING);
        vector.add(SIB_SERVICE_FILE_MAPPING);
        vector.add(SIBWS_EPL_FILE_MAPPING);
    }

    protected void initBusDocumentTransforms(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"initBusDocumentTransforms", (Object)vector);
        super.initBusDocumentTransforms(vector);
        vector.add(SIB_AUTHORISATIONS_FILE_MAPPING);
        vector.add(SIB_BUS_FILE_MAPPING);
        vector.add(SIB_DESTINATIONS_FILE_MAPPING);
        vector.add(SIB_MEDIATIONS_FILE_MAPPING);
        vector.add(SIBWS_GATEWAY_FILE_MAPPING);
        vector.add(SIBWS_INBOUND_FILE_MAPPING);
        vector.add(SIBWS_OUTBOUND_FILE_MAPPING);
    }
}

