/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.models.base.resources.ConnectionFactory;
import com.ibm.ejs.models.base.resources.ConnectionPool;
import com.ibm.ejs.models.base.resources.J2EEResourceProvider;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.postupgrade.common.BucketProperties;
import com.ibm.ws.migration.postupgrade.common.J2C;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.wsspi.migration.document.CellDocumentCollection;
import com.ibm.wsspi.migration.document.DocumentProcessor;
import com.ibm.wsspi.migration.document.NodeDocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class J2CConfig
implements DocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)J2CConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private J2C _oldJ2C = null;
    private List _newResources = null;
    private WCCMDocument _resourceDocument = null;

    public J2CConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey) throws Exception {
        this._oldJ2C = new J2C(documentTransform);
        NodeDocumentCollection nodeDocumentCollection = (NodeDocumentCollection)((CellDocumentCollection)documentTransform.getNewDocumentCollection().getParent().getChild("config").getChild("cells").getChildren()[0]).getChild("nodes").getChild(((ProfileImpl)documentTransform.getScenario().getNewProductImage().getProfile()).getOwningNodeName());
        this._resourceDocument = (WCCMDocument)nodeDocumentCollection.openDocument("resources.xml", WCCMDocument.class, false, false);
        this._newResources = this._resourceDocument.getList();
    }

    public void migrate() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate");
        this.migrateBucketProperties();
        this.migrateAdvancedConnectionProperties();
        this._resourceDocument.close();
    }

    private void migrateBucketProperties() {
        Tr.entry((TraceComponent)_tc, (String)"migrateBucketProperties");
        Iterator iterator = this._newResources.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof J2CResourceAdapter) && !(e instanceof JDBCProvider)) continue;
            J2EEResourceProvider j2EEResourceProvider = (J2EEResourceProvider)e;
            Vector vector = this._oldJ2C.getBucketProperties();
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                BucketProperties bucketProperties = (BucketProperties)iterator2.next();
                Iterator iterator3 = j2EEResourceProvider.getFactories().iterator();
                while (iterator3.hasNext()) {
                    ConnectionFactory connectionFactory = (ConnectionFactory)iterator3.next();
                    if (!connectionFactory.getJndiName().equals(bucketProperties.getJNDINameAttribute())) continue;
                    ConnectionPool connectionPool = connectionFactory.getConnectionPool();
                    if (bucketProperties.getMaxFreePoolBuckets() != null && !bucketProperties.getMaxFreePoolBuckets().equals("")) {
                        connectionPool.setNumberOfFreePoolPartitions(new Integer(bucketProperties.getMaxFreePoolBuckets()).intValue());
                    }
                    if (bucketProperties.getMaxSharedBuckets() != null && !bucketProperties.getMaxSharedBuckets().equals("")) {
                        connectionPool.setNumberOfSharedPoolPartitions(new Integer(bucketProperties.getMaxSharedBuckets()).intValue());
                    }
                    if (bucketProperties.getMaxUnSharedBuckets() != null && !bucketProperties.getMaxUnSharedBuckets().equals("")) {
                        connectionPool.setNumberOfUnsharedPoolPartitions(new Integer(bucketProperties.getMaxUnSharedBuckets()).intValue());
                    }
                    if (bucketProperties.getMaxFreePoolHashSize() != null && !bucketProperties.getMaxFreePoolHashSize().equals("")) {
                        connectionPool.setFreePoolDistributionTableSize(new Integer(bucketProperties.getMaxFreePoolHashSize()).intValue());
                    }
                    if (bucketProperties.getSurgeTime() != null && !bucketProperties.getSurgeTime().equals("")) {
                        connectionPool.setSurgeCreationInterval(new Integer(bucketProperties.getSurgeTime()).intValue());
                    }
                    if (bucketProperties.getSurgeConnections() == null || bucketProperties.getSurgeConnections().equals("")) continue;
                    connectionPool.setSurgeThreshold(new Integer(bucketProperties.getSurgeConnections()).intValue());
                }
            }
        }
    }

    private void migrateAdvancedConnectionProperties() {
        Tr.entry((TraceComponent)_tc, (String)"migrateAdvancedConnectionProperties");
    }
}

