/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgrInitializer;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.sib.migration.SIBMigrationHelper;
import com.ibm.ws.sib.migration.SIBMigrationHelperException;
import java.util.Properties;

public class JetStreamMigrationHelper {
    private static TraceComponent _tc = Tr.register((Class)JetStreamMigrationHelper.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private ConfigService _configService = null;
    private Session _session = null;
    private SIBMigrationHelper _migrationHelper = null;

    public void init(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"init", (Object)string);
        CommandMgrInitializer.initializeLocalMode();
        this._configService = ConfigServiceFactory.getConfigService();
        System.setProperty("local.cell", string);
        if (this._configService == null) {
            Properties properties = new Properties();
            properties.setProperty("location", "local");
            try {
                this._configService = ConfigServiceFactory.createConfigService((boolean)true, (Properties)properties);
            }
            catch (AdminException adminException) {
                throw new UpgradeException(adminException);
            }
        }
        this._session = new Session();
        this._migrationHelper = new SIBMigrationHelper();
    }

    public void migrateJMSServerToJetStream(JMSServer jMSServer, String string, String string2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"migrateJMSServerToJetStream", (Object)new Object[]{jMSServer, string, string2});
        try {
            this._migrationHelper.createBusFromJmsServer(this._configService, this._session, jMSServer, string, string2);
        }
        catch (SIBMigrationHelperException sIBMigrationHelperException) {
            throw new UpgradeException(sIBMigrationHelperException);
        }
    }

    public void save() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"save");
        try {
            this._configService.save(this._session, true);
        }
        catch (ConfigServiceException configServiceException) {
            throw new UpgradeException(configServiceException);
        }
        catch (ConnectorException connectorException) {
            throw new UpgradeException(connectorException);
        }
    }
}

