/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.models.base.resources.J2EEResourceProperty;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.j2c.J2CResourceAdapter;
import com.ibm.ejs.models.base.resources.jdbc.CMPConnectorFactory;
import com.ibm.ejs.models.base.resources.jdbc.DataSource;
import com.ibm.ejs.models.base.resources.jdbc.JDBCProvider;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.adapter.migration.CloudscapeMigrationUtility;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.BasicDocumentCollection;
import com.ibm.ws.migration.postupgrade.common.ResourceConfigCommon;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class LegacyCloudscapeHelper {
    public static String CloudscapeOldDatabaseDESCRIPTIONPREFIX = "migrated - ";
    public static String CloudscapeOldDatabaseNAME = "CloudscapeOldDatabaseName";
    public static String DatabaseNameDatasourceProperty = "databaseName";
    private TraceComponent _tc = null;
    private static Hashtable _cloudscapeDBMappings2 = new Hashtable();
    WCCMDocument resourcesDocument = null;
    private Properties _oldCurrentLevelVariables;
    private Properties _newCurrentLevelVariables;
    private DocumentTransform _transform = null;
    private Scenario _scenario = null;
    private ResourceConfigCommon _commonConfig = null;

    public LegacyCloudscapeHelper(TraceComponent traceComponent, ResourceConfigCommon resourceConfigCommon, Properties properties, Properties properties2, WCCMDocument wCCMDocument, DocumentTransform documentTransform) {
        this._tc = traceComponent;
        this._oldCurrentLevelVariables = properties;
        this._newCurrentLevelVariables = properties2;
        this.resourcesDocument = wCCMDocument;
        this._transform = documentTransform;
        this._scenario = this._transform.getScenario();
        this._commonConfig = resourceConfigCommon;
    }

    public void prepCloudscapeProviders() throws Exception {
        Tr.entry((TraceComponent)this._tc, (String)"prepCloudscapeProviders");
        List list = this.resourcesDocument.getList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object;
            String string;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            int n;
            Object object8;
            Iterator iterator2;
            Tr.debug((TraceComponent)this._tc, (String)"Found providers");
            Object e = iterator.next();
            if (!(e instanceof JDBCProvider)) continue;
            JDBCProvider jDBCProvider = (JDBCProvider)e;
            String string2 = jDBCProvider.getDescription();
            Tr.debug((TraceComponent)this._tc, (String)("Name of JDBCProvider is: " + jDBCProvider.getName()));
            if (jDBCProvider.getImplementationClassName().equals("com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource") || jDBCProvider.getImplementationClassName().equals("com.ibm.db2j.jdbc.DB2jXADataSource")) {
                jDBCProvider.setDescription(CloudscapeOldDatabaseDESCRIPTIONPREFIX + jDBCProvider.getDescription());
                iterator2 = null;
                if (jDBCProvider.getImplementationClassName().equals("com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource") || jDBCProvider.getImplementationClassName().equals("com.ibm.db2j.jdbc.DB2jXADataSource")) {
                    object8 = jDBCProvider.getClasspath();
                    for (n = 0; n < object8.size(); ++n) {
                        if (!((String)object8.get(n)).equals("${CLOUDSCAPE_JDBC_DRIVER_PATH}/db2j.jar")) continue;
                        object8.add("${DERBY_JDBC_DRIVER_PATH}/derby.jar");
                        iterator2 = ResourcesFactory.eINSTANCE.createJ2EEResourceProperty();
                        iterator2.setName("CloudscapeOldClasspath");
                        iterator2.setValue((String)object8.get(n));
                        object8.remove(n);
                    }
                    if (jDBCProvider.getImplementationClassName().equals("com.ibm.db2j.jdbc.DB2jConnectionPoolDataSource")) {
                        jDBCProvider.setImplementationClassName("org.apache.derby.jdbc.EmbeddedConnectionPoolDataSource");
                    } else if (jDBCProvider.getImplementationClassName().equals("com.ibm.db2j.jdbc.DB2jXADataSource")) {
                        jDBCProvider.setImplementationClassName("org.apache.derby.jdbc.EmbeddedXADataSource");
                    }
                }
                Tr.debug((TraceComponent)this._tc, (String)"Preparing to process JDBCProvider factories.");
                object8 = jDBCProvider.getFactories().iterator();
                while (object8.hasNext()) {
                    Object e2 = object8.next();
                    if (!(e2 instanceof DataSource)) continue;
                    object7 = (DataSource)e2;
                    Tr.debug((TraceComponent)this._tc, (String)("Processing DataSource: " + object7.getName()));
                    if (CloudscapeMigrationUtility.isSampleDS(object7.getName())) {
                        Tr.debug((TraceComponent)this._tc, (String)("Removing datasource: " + object7.getName() + " because it is a sample. "));
                        this.deleteDataSourceReferenceObjects((DataSource)object7, list);
                        object8.remove();
                        continue;
                    }
                    Tr.debug((TraceComponent)this._tc, (String)"Not a Sample Cloudscape DB");
                    object6 = null;
                    object5 = null;
                    object4 = object7.getPropertySet().getResourceProperties().iterator();
                    while (object4.hasNext()) {
                        object3 = (J2EEResourceProperty)object4.next();
                        if (!object3.getName().equals(DatabaseNameDatasourceProperty) || object3.getValue().equals("")) continue;
                        Tr.debug((TraceComponent)this._tc, (String)("Processing databaseName: " + object3.getValue()));
                        object6 = object3.getValue();
                        object5 = this.resolveDerbyDBName((String)object6);
                        object5 = new File(UtilityImpl.resolveEntryPath((String)object5, this._oldCurrentLevelVariables)).getAbsolutePath();
                        object5 = CloudscapeMigrationUtility.mapCloudscapeName((String)object5, this._scenario, FileUtilities.generateTimeStamp());
                        object2 = UtilityImpl.contractRootVariables(new File((String)object5), this._newCurrentLevelVariables);
                        string = this.resolveDerbyDBName((String)object6);
                        object = new File(this.resolveEntryPath(string, this._oldCurrentLevelVariables));
                        String string3 = ((File)object).getAbsolutePath();
                        if (!((File)object).exists()) {
                            Tr.debug((TraceComponent)this._tc, (String)"Did not find an existing Cloudscape DB");
                            string = this._commonConfig.checkDeploymentTargetName((String)object6);
                            if (string == null) {
                                string3 = ((File)object).getAbsolutePath();
                            } else {
                                object = new File(this.resolveEntryPath(string, this._oldCurrentLevelVariables));
                                string3 = ((File)object).getAbsolutePath();
                            }
                        }
                        boolean bl = false;
                        Iterator iterator3 = LegacyCloudscapeHelper.iterator();
                        while (iterator3.hasNext()) {
                            String string4 = (String)iterator3.next();
                            if (!string4.equals(string3)) continue;
                            Object[] objectArray = LegacyCloudscapeHelper.get(string3);
                            String string5 = (String)objectArray[1];
                            bl = true;
                            object3.setValue((String)object2);
                            break;
                        }
                        if (bl) break;
                        if (CloudscapeMigrationUtility.validateDBExistance(string3, this._scenario)) {
                            Tr.debug((TraceComponent)this._tc, (String)("tempOldDBName: " + string3 + " true " + " newDBName: " + (String)object5));
                            LegacyCloudscapeHelper.set(string3, new Object[]{new Boolean(true), object5});
                        } else {
                            Tr.debug((TraceComponent)this._tc, (String)("tempOldDBName: " + string3 + " false " + " newDBName: " + (String)object5));
                            LegacyCloudscapeHelper.set(string3, new Object[]{new Boolean(false), object5});
                        }
                        object3.setValue((String)object2);
                        break;
                    }
                    object3 = ResourcesFactory.eINSTANCE.createJ2EEResourceProperty();
                    object3.setName(CloudscapeOldDatabaseNAME);
                    object3.setValue((String)object6);
                    object7.getPropertySet().getResourceProperties().add(object3);
                    if (iterator2 != null) {
                        object7.getPropertySet().getResourceProperties().add((Object)iterator2);
                    }
                    object7.setDescription(CloudscapeOldDatabaseDESCRIPTIONPREFIX + object7.getDescription());
                    if (object7.getDatasourceHelperClassname().equals("com.ibm.websphere.rsadapter.CloudscapeDataStoreHelper")) {
                        object7.setDatasourceHelperClassname("com.ibm.websphere.rsadapter.DerbyDataStoreHelper");
                        continue;
                    }
                    if (!object7.getDatasourceHelperClassname().equals("com.ibm.websphere.rsadapter.CloudscapeNetworkServerDataStoreHelper")) continue;
                    object7.setDatasourceHelperClassname("com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper");
                }
                continue;
            }
            if (jDBCProvider.getImplementationClassName().equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource") && "Cloudscape Network Server Using Universal JDBC Driver".equals(jDBCProvider.getProviderType())) {
                jDBCProvider.setDescription(CloudscapeOldDatabaseDESCRIPTIONPREFIX + jDBCProvider.getDescription());
                iterator2 = null;
                object8 = jDBCProvider.getClasspath();
                for (n = 0; n < object8.size(); ++n) {
                    if (((String)object8.get(n)).equals("${CLOUDSCAPE_JDBC_DRIVER_PATH}/otherJars/db2jcc.jar")) {
                        object8.set(n, "${WAS_INSTALL_ROOT}/derby/lib/deprecated/db2jcc.jar");
                        continue;
                    }
                    if (!((String)object8.get(n)).equals("${CLOUDSCAPE_JDBC_DRIVER_PATH}/db2j.jar")) continue;
                    object8.remove(n);
                    --n;
                }
                Tr.debug((TraceComponent)this._tc, (String)"Preparing to process JDBCProvider factories.");
                Iterator iterator4 = jDBCProvider.getFactories().iterator();
                while (iterator4.hasNext()) {
                    object7 = iterator4.next();
                    if (!(object7 instanceof DataSource)) continue;
                    object6 = object7;
                    Tr.debug((TraceComponent)this._tc, (String)("Processing DataSource: " + object6.getName()));
                    if (CloudscapeMigrationUtility.isSampleDS(object6.getName())) {
                        Tr.debug((TraceComponent)this._tc, (String)("Removing datasource: " + object6.getName() + " because it is a sample. "));
                        this.deleteDataSourceReferenceObjects((DataSource)object6, list);
                        iterator4.remove();
                        continue;
                    }
                    Tr.debug((TraceComponent)this._tc, (String)"Not a Sample Cloudscape DB");
                    object6.setDescription(CloudscapeOldDatabaseDESCRIPTIONPREFIX + object6.getDescription());
                    if (!object6.getDatasourceHelperClassname().equals("com.ibm.websphere.rsadapter.CloudscapeNetworkServerDataStoreHelper")) continue;
                    object6.setDatasourceHelperClassname("com.ibm.websphere.rsadapter.DerbyNetworkServerDataStoreHelper");
                }
                continue;
            }
            if (string2 == null || !string2.startsWith(CloudscapeOldDatabaseDESCRIPTIONPREFIX)) continue;
            iterator2 = jDBCProvider.getFactories().iterator();
            while (iterator2.hasNext()) {
                object8 = iterator2.next();
                if (!(object8 instanceof DataSource)) continue;
                DataSource dataSource = (DataSource)object8;
                object7 = null;
                object6 = null;
                object5 = dataSource.getPropertySet().getResourceProperties().iterator();
                while (object5.hasNext()) {
                    object4 = object5.next();
                    if (!(object4 instanceof J2EEResourceProperty)) continue;
                    object3 = (J2EEResourceProperty)object4;
                    object2 = object3.getName();
                    if (CloudscapeOldDatabaseNAME.equals(object2)) {
                        object7 = object3.getValue();
                        continue;
                    }
                    if (!DatabaseNameDatasourceProperty.equals(object2)) continue;
                    object6 = object3.getValue();
                }
                if (object7 == null || object6 == null) continue;
                object4 = this.resolveDerbyDBName((String)object6);
                object4 = new File(UtilityImpl.resolveEntryPath(object4, this._newCurrentLevelVariables)).getAbsolutePath();
                object3 = this.resolveDerbyDBName((String)object7);
                object2 = new File(this.resolveEntryPath((String)object3, this._oldCurrentLevelVariables));
                string = ((File)object2).getAbsolutePath();
                if (!((File)object2).exists()) {
                    Tr.debug((TraceComponent)this._tc, (String)"Did not find an existing Cloudscape DB");
                    object3 = this._commonConfig.checkDeploymentTargetName((String)object7);
                    if (object3 == null) {
                        string = ((File)object2).getAbsolutePath();
                    } else {
                        object2 = new File(this.resolveEntryPath((String)object3, this._oldCurrentLevelVariables));
                        string = ((File)object2).getAbsolutePath();
                    }
                }
                if ((object = LegacyCloudscapeHelper.get(string)) != null) continue;
                boolean bl = CloudscapeMigrationUtility.validateDBExistance(string, this._scenario);
                Tr.debug((TraceComponent)this._tc, (String)("tempOldDBName: " + string + " " + bl + " " + " newDBName: " + (String)object4));
                LegacyCloudscapeHelper.set(string, new Object[]{new Boolean(bl), object4});
            }
        }
    }

    protected void deleteDataSourceReferenceObjects(DataSource dataSource, List list) {
        Tr.entry((TraceComponent)this._tc, (String)"deleteDataSourceReferenceObjects", (Object)new Object[]{dataSource, list});
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof J2CResourceAdapter)) continue;
            J2CResourceAdapter j2CResourceAdapter = (J2CResourceAdapter)list.get(i);
            Iterator iterator = j2CResourceAdapter.getFactories().iterator();
            while (iterator.hasNext()) {
                CMPConnectorFactory cMPConnectorFactory;
                Object e = iterator.next();
                if (!(e instanceof CMPConnectorFactory) || (cMPConnectorFactory = (CMPConnectorFactory)e).getCmpDatasource() != dataSource) continue;
                iterator.remove();
            }
        }
    }

    protected String resolveDerbyDBName(String string) throws Exception {
        Tr.entry((TraceComponent)this._tc, (String)"resolveDerbyDBName", (Object)string);
        int n = string.indexOf("${CELL}");
        if (n != -1) {
            string = string.replaceAll("\\Q${CELL}\\E", this._scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getName());
        }
        if ((n = string.indexOf("${NODE}")) != -1) {
            string = string.replaceAll("\\Q${NODE}\\E", ((ProfileImpl)this._scenario.getOldProductImage().getProfile()).getOwningNodeName());
        }
        if ((n = string.indexOf("${SERVER}")) != -1) {
            string = string.replaceAll("\\Q${SERVER}\\E", this._transform.getOldDocumentCollection().getName());
        }
        return string;
    }

    protected String resolveEntryPath(String string, Properties properties) throws Exception {
        Tr.entry((TraceComponent)this._tc, (String)"resolveEntryPath", (Object)new Object[]{string, properties});
        StringTokenizer stringTokenizer = new StringTokenizer(string, "${}()", true);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("$") && ((string2 = stringTokenizer.nextToken()).equals("{") || string2.equals("("))) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (!string2.equals("}") && !string2.equals(")")) {
                        stringBuffer.append(string2);
                    }
                    if (!string2.equals("}") && !string2.equals(")")) continue;
                    String string3 = null;
                    string3 = stringBuffer.toString().equals("USER_INSTALL_ROOT") ? ((BasicDocumentCollection)this._scenario.getOldProductImage().getProfile().getDocumentCollection()).getAliasedUrl().getFile() : (stringBuffer.toString().equals("WAS_INSTALL_ROOT") ? ((BasicDocumentCollection)this._scenario.getOldProductImage().getDocumentCollection()).getAliasedUrl().getPath() : properties.getProperty(stringBuffer.toString()));
                    if (string3 == null) {
                        String string4 = LoggerImpl.get_nls().getFormattedMessage("advise.could.not.resolve.variable", new Object[]{stringBuffer.toString()}, "Could not resolve variable {0}.");
                        UpgradeBase.get_logger().println(string4);
                        throw new Exception(string4);
                    }
                    stringBuffer2.append(string3);
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer2.append(stringTokenizer.nextToken());
                    }
                    return this.resolveEntryPath(stringBuffer2.toString(), properties);
                }
            }
            stringBuffer2.append(string2);
        }
        return stringBuffer2.toString();
    }

    public static Iterator iterator() {
        return _cloudscapeDBMappings2.keySet().iterator();
    }

    private static void set(String string, Object[] objectArray) {
        _cloudscapeDBMappings2.put(string, objectArray);
    }

    public static Object[] get(String string) {
        return (Object[])_cloudscapeDBMappings2.get(string);
    }
}

