/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.libraries.Library;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.preupgrade.LibrariesCopyDocumentProcessor;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.BasicDocument;
import com.ibm.wsspi.migration.document.CellDocumentCollection;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.BasicWCCMDocumentProcessor;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class LibrariesConfig
extends BasicWCCMDocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)LibrariesConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected String _serverName = null;
    protected Properties _oldCurrentLevelVariables = null;
    protected Properties _newCurrentLevelVariables = null;

    public LibrariesConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
        if (this.getTransform().getOldDocumentCollection() instanceof CellDocumentCollection) {
            String string = ((ProfileImpl)this.getTransform().getScenario().getOldProductImage().getProfile()).getOwningNodeName();
            DocumentCollection documentCollection = this.getTransform().getOldDocumentCollection().getChild("nodes").getChild(string);
            this._oldCurrentLevelVariables = UtilityImpl.instantiateVariables(documentCollection);
            String string2 = ((ProfileImpl)this.getTransform().getScenario().getNewProductImage().getProfile()).getOwningNodeName();
            DocumentCollection documentCollection2 = this.getTransform().getNewDocumentCollection().getChild("nodes").getChild(string2);
            this._newCurrentLevelVariables = UtilityImpl.instantiateVariables(documentCollection2);
        } else {
            this._oldCurrentLevelVariables = UtilityImpl.instantiateVariables(this.getTransform().getOldDocumentCollection());
            this._newCurrentLevelVariables = UtilityImpl.instantiateVariables(this.getTransform().getNewDocumentCollection());
        }
        this.getProcessorHelper().addOverride(Library.class, "getClassPath", new Class[0]);
        this.getProcessorHelper().addOverride(Library.class, "getNativePath", new Class[0]);
    }

    public Document getTemplateDocument() {
        Tr.entry((TraceComponent)_tc, (String)"getTemplateDocument");
        return null;
    }

    public List getClassPath(boolean bl, Library library) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getClassPath", (Object)new Object[]{new Boolean(bl), library});
        EList eList = null;
        EList eList2 = library.getClassPath();
        if (bl) {
            eList = new BasicEList();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.processPath(string);
                eList.add(this.fixUpPath(string));
            }
        } else {
            eList = eList2;
        }
        return eList;
    }

    public List getNativePath(boolean bl, Library library) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getNativePath", (Object)new Object[]{new Boolean(bl), library});
        EList eList = null;
        EList eList2 = library.getNativePath();
        if (bl) {
            eList = new BasicEList();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.processPath(string);
                eList.add(this.fixUpPath(string));
            }
        } else {
            eList = eList2;
        }
        return eList;
    }

    protected void processPath(String string) throws Exception {
        String string2;
        Tr.entry((TraceComponent)_tc, (String)"processPath", (Object)string);
        String string3 = this._oldCurrentLevelVariables.getProperty("WAS_INSTALL_ROOT");
        String string4 = this._oldCurrentLevelVariables.getProperty("USER_INSTALL_ROOT");
        string4 = UtilityImpl.resolveEntryPath(string4, this._oldCurrentLevelVariables);
        string = UtilityImpl.resolveEntryPath(string, this._oldCurrentLevelVariables);
        if (string.startsWith("..")) {
            string = new File(string3, string).getAbsolutePath();
        }
        if (!LibrariesCopyDocumentProcessor._listOfLibrariesToNotCopy.contains(string2 = UtilityImpl.makePathCommon(string).substring(UtilityImpl.makePathCommon(string).lastIndexOf("/") + 1))) {
            String string5 = null;
            File file = null;
            try {
                if (UtilityImpl.makePathCommon(string).startsWith(UtilityImpl.makePathCommon(string4))) {
                    string5 = string.length() == string4.length() ? string.substring(string4.length()) : string.substring(string4.length() + 1);
                    file = new File(UpgradeBase.get_newOSInfo().userRoot(), string5);
                    DocumentCollection documentCollection = this.getTransform().getScenario().getOldProductImage().getProfile().getDocumentCollection().getDocumentCollection(new File(string).toURL());
                    DocumentCollection documentCollection2 = this.getTransform().getScenario().getNewProductImage().getProfile().getDocumentCollection();
                    this.copyLibrary(documentCollection, new File(string), file, documentCollection2);
                } else if (UtilityImpl.makePathCommon(string).startsWith(UtilityImpl.makePathCommon(string3))) {
                    string5 = string.length() == string3.length() ? string.substring(string3.length()) : string.substring(string3.length() + 1);
                    file = this.getNewLibraryPathLocation(string5);
                    DocumentCollection documentCollection = this.getTransform().getScenario().getOldProductImage().getDocumentCollection().getDocumentCollection(new File(string).toURL());
                    DocumentCollection documentCollection3 = this.getTransform().getScenario().getOldProductImage().getDocumentCollection();
                    this.copyLibrary(documentCollection, new File(string), file, documentCollection3);
                }
            }
            catch (NotFoundException notFoundException) {
                String string6 = string;
                if (file != null) {
                    string6 = string6 + " : " + file;
                }
                Tr.event((TraceComponent)_tc, (String)("Error copying file: " + string6), (Object)notFoundException);
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.cannot.copy.file.exists", new Object[]{string6}, "Not copying  file or directory {0}."), true);
            }
        }
    }

    protected void copyLibrary(DocumentCollection documentCollection, File file, File file2, DocumentCollection documentCollection2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyLibrary", (Object)new Object[]{documentCollection, file, file2});
        String[] stringArray = documentCollection.getHierarchicalName();
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                documentCollection2 = documentCollection2.getChild(stringArray[i]);
                continue;
            }
            catch (NotFoundException notFoundException) {
                documentCollection2 = documentCollection2.addDocumentCollection(stringArray[i]);
            }
        }
        if (file.isDirectory()) {
            UtilityImpl.copyDocumentCollection(documentCollection, documentCollection2);
        } else if (documentCollection2.documentExists(file2.getName())) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.cannot.copy.file.exists", new Object[]{file2.getName()}, "Not copying  file or directory {0}."));
        } else {
            BasicDocument basicDocument = (BasicDocument)documentCollection.openDocument(file.getName(), BasicDocument.class);
            BasicDocument basicDocument2 = (BasicDocument)documentCollection2.openDocument(file2.getName(), BasicDocument.class, true, false);
            basicDocument2.setInputStream(basicDocument.getInputStream());
            basicDocument2.close();
            basicDocument.close();
        }
    }

    protected File getNewLibraryPathLocation(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getNewLibraryPathLocation", (Object)string);
        if (UpgradeBase.get_oldOSInfo().releaseVersion().isR50() || UpgradeBase.get_oldOSInfo().releaseVersion().isR51()) {
            return new File(UpgradeBase.get_newOSInfo().userRoot(), string);
        }
        return new File(UpgradeBase.get_newOSInfo().installRoot(), string);
    }

    protected String fixUpPath(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"fixUpPath", (Object)string);
        String string2 = this._oldCurrentLevelVariables.getProperty("WAS_INSTALL_ROOT");
        String string3 = this._oldCurrentLevelVariables.getProperty("USER_INSTALL_ROOT");
        String string4 = UtilityImpl.makePathCommon(string).substring(UtilityImpl.makePathCommon(string).lastIndexOf("/") + 1);
        if (!LibrariesCopyDocumentProcessor._listOfLibrariesToNotCopy.contains(string4)) {
            if (string.startsWith("${WAS_INSTALL_ROOT}") && (UpgradeBase.get_oldOSInfo().releaseVersion().isR50() || UpgradeBase.get_oldOSInfo().releaseVersion().isR51())) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.replace(0, "${WAS_INSTALL_ROOT}".length(), "${USER_INSTALL_ROOT}");
                string = stringBuffer.toString();
                return string;
            }
            if (!string.startsWith("$")) {
                if (UtilityImpl.makePathCommon(string).startsWith(UtilityImpl.makePathCommon(string3))) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    stringBuffer.replace(0, string3.length(), "${USER_INSTALL_ROOT}");
                    string = stringBuffer.toString();
                    return string;
                }
                if (UtilityImpl.makePathCommon(string).startsWith(UtilityImpl.makePathCommon(string2))) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    stringBuffer.replace(0, string2.length(), this.getNewInstallRootLocation());
                    string = stringBuffer.toString();
                    return string;
                }
            }
        }
        return string;
    }

    protected String getNewInstallRootLocation() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getNewInstallRootLocation");
        if (UpgradeBase.get_oldOSInfo().releaseVersion().isR50() || UpgradeBase.get_oldOSInfo().releaseVersion().isR51()) {
            return "${USER_INSTALL_ROOT}";
        }
        return "${WAS_INSTALL_ROOT}";
    }
}

