/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroupMember;
import com.ibm.websphere.models.config.topology.nodegroup.NodegroupFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.BasicWCCMDocumentProcessor;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class NodeGroupConfig
extends BasicWCCMDocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)NodeGroupConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");

    public NodeGroupConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
        this.getProcessorHelper().addOverride(NodeGroupMember.class, "setNodeName", new Class[]{String.class});
    }

    public Document getTemplateDocument() {
        Tr.entry((TraceComponent)_tc, (String)"getTemplateDocument");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void migrate() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate");
        if (!((ReleaseVersionImpl)this.getTransform().getScenario().getOldProductImage().getReleaseVersion()).isR60()) {
            DocumentCollection documentCollection = this.getTransform().getNewDocumentCollection();
            if (!documentCollection.getName().equals("DefaultNodeGroup")) {
                super.migrate();
                return;
            } else {
                String string = ((ProfileImpl)this.getTransform().getScenario().getNewProductImage().getProfile()).getOwningNodeName();
                WCCMDocument wCCMDocument = (WCCMDocument)this.getTransform().getNewDocumentCollection().openDocument("nodegroup.xml", WCCMDocument.class, true, false);
                NodeGroup nodeGroup = (NodeGroup)UtilityImpl.locateConfigFileObject(wCCMDocument, NodeGroup.class);
                EList eList = nodeGroup.getMembers();
                if (eList == null) throw new UpgradeException(null);
                Tr.debug((TraceComponent)_tc, (String)"The nodes list is not null - cool");
                Tr.debug((TraceComponent)_tc, (String)("Accessing NodeGroup members list, it's size is: " + eList.size()));
                boolean bl = true;
                Iterator iterator = eList.iterator();
                NodeGroupMember nodeGroupMember = null;
                Tr.debug((TraceComponent)_tc, (String)("Looking for a member named: " + string));
                while (iterator.hasNext() && bl) {
                    nodeGroupMember = (NodeGroupMember)iterator.next();
                    Tr.debug((TraceComponent)_tc, (String)("Found node name: " + nodeGroupMember.getNodeName()));
                    if (!nodeGroupMember.getNodeName().equals(string)) continue;
                    bl = false;
                    Tr.debug((TraceComponent)_tc, (String)("Member already exists: " + string));
                }
                if (!bl) return;
                nodeGroupMember = NodegroupFactory.eINSTANCE.createNodeGroupMember();
                Tr.debug((TraceComponent)_tc, (String)"Set the nodename in the member");
                nodeGroupMember.setNodeName(string);
                Tr.debug((TraceComponent)_tc, (String)"Adding member");
                eList.add((Object)nodeGroupMember);
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.adding.nodegroup.node", new Object[]{nodeGroupMember.getNodeName()}, "Node {0} is added to the default node group."), true);
            }
            return;
        } else {
            super.migrate();
        }
    }

    public boolean arePrimaryKeysEqual(NodeGroupMember nodeGroupMember, NodeGroupMember nodeGroupMember2) {
        Tr.entry((TraceComponent)_tc, (String)"arePrimaryKeysEqual", (Object)new Object[]{nodeGroupMember, nodeGroupMember2});
        String string = ((ProfileImpl)this.getTransform().getScenario().getOldProductImage().getProfile()).getOwningNodeName();
        String string2 = ((ProfileImpl)this.getTransform().getScenario().getNewProductImage().getProfile()).getOwningNodeName();
        if (nodeGroupMember.getNodeName().equals(string)) {
            return nodeGroupMember2.getNodeName().equals(string2);
        }
        return nodeGroupMember.getNodeName().equals(nodeGroupMember2.getNodeName());
    }

    public void setNodeName(NodeGroupMember nodeGroupMember, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setNodeName", (Object)new Object[]{nodeGroupMember, string});
        String string2 = ((ProfileImpl)this.getTransform().getScenario().getOldProductImage().getProfile()).getOwningNodeName();
        String string3 = ((ProfileImpl)this.getTransform().getScenario().getNewProductImage().getProfile()).getOwningNodeName();
        if (string.equals(string2)) {
            nodeGroupMember.setNodeName(string3);
        } else {
            nodeGroupMember.setNodeName(string);
        }
    }
}

