/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.postupgrade.common.GeneralAttribute;
import com.ibm.ws.migration.postupgrade.common.Param;
import com.ibm.ws.migration.postupgrade.common.Perftuner;
import com.ibm.ws.migration.postupgrade.common.Rule;
import com.ibm.ws.migration.postupgrade.common.RuleEngine;
import com.ibm.ws.migration.postupgrade.common.RuntimeAttribute;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.document.BasicDocument;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentProcessor;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.XMLDocument;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.util.Vector;

public class PerftunerConfig
implements DocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)PerftunerConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private Perftuner _oldPerftuner = null;
    private Perftuner _newPerftuner = null;
    private boolean _doesFileExistCurrentRelease = true;

    public PerftunerConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"PerftunerConfig", (Object)new Object[]{documentTransform, transformMappingKey});
        XMLDocument xMLDocument = (XMLDocument)documentTransform.getOldDocumentCollection().openDocument("perftuners.xml", XMLDocument.class);
        try {
            XMLDocument xMLDocument2 = (XMLDocument)documentTransform.getNewDocumentCollection().openDocument("perftuners.xml", XMLDocument.class);
            this._oldPerftuner = new Perftuner(xMLDocument);
            this._newPerftuner = new Perftuner(xMLDocument2);
        }
        catch (NotFoundException notFoundException) {
            Tr.event((TraceComponent)_tc, (String)"Did not find perftuners.xml in current release so just going to copy file forward.");
            Document document = documentTransform.getOldDocumentCollection().openDocument("perftuners.xml", BasicDocument.class);
            Document document2 = documentTransform.getNewDocumentCollection().openDocument("perftuners.xml", BasicDocument.class, true, false);
            document2.setInputStream(document.getInputStream());
            document.close();
            document2.close();
            this._doesFileExistCurrentRelease = false;
        }
    }

    public void migrate() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"migrate");
        if (this._doesFileExistCurrentRelease) {
            this.migrateRuleEngine();
            this.migrateRules();
        }
    }

    private void migrateRuleEngine() {
        Tr.entry((TraceComponent)_tc, (String)"migrateRuleEngine");
        RuleEngine ruleEngine = this._oldPerftuner.getRuleEngine();
        RuleEngine ruleEngine2 = this._newPerftuner.getRuleEngine();
        this.migrateRuntimeAttributes(ruleEngine, ruleEngine2);
        this.migrateGeneralAttributes(ruleEngine, ruleEngine2);
    }

    private void migrateRules() {
        Tr.entry((TraceComponent)_tc, (String)"migrateRules");
        Vector vector = this._oldPerftuner.getRules();
        Vector vector2 = this._newPerftuner.getRules();
        Rule rule = null;
        Rule rule2 = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            rule = (Rule)vector.get(i);
            string = rule.getName();
            boolean bl = true;
            for (int j = 0; j < vector2.size(); ++j) {
                rule2 = (Rule)vector2.get(j);
                if (!rule2.getName().equals(string)) continue;
                rule2.setType(rule.getType());
                rule2.setEnabled(rule.getEnabled());
                rule2.setNlsKeyComponent(rule.getNlsKeyComponent());
                rule2.setNlsKeyName(rule.getNlsKeyName());
                rule2.setClassName(rule.getClassName());
                this.migrateParams(rule, rule2);
                bl = false;
                break;
            }
            if (!bl) continue;
            this._newPerftuner.createRule(rule);
        }
    }

    private void migrateParams(Rule rule, Rule rule2) {
        Tr.entry((TraceComponent)_tc, (String)"migrateParams", (Object)new Object[]{rule, rule2});
        Vector vector = rule.getParams();
        Vector vector2 = rule2.getParams();
        Param param = null;
        Param param2 = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            param = (Param)vector.get(i);
            string = param.getNameAttribute();
            boolean bl = true;
            for (int j = 0; j < vector2.size(); ++j) {
                param2 = (Param)vector2.get(j);
                if (!param2.getNameAttribute().equals(string)) continue;
                param2.setParam(param.getParam());
                bl = false;
                break;
            }
            if (!bl) continue;
            rule2.createParam(param);
        }
    }

    private void migrateRuntimeAttributes(RuleEngine ruleEngine, RuleEngine ruleEngine2) {
        Tr.entry((TraceComponent)_tc, (String)"migateRuntimeAttributes", (Object)new Object[]{ruleEngine, ruleEngine2});
        Vector vector = ruleEngine.getRuntimeAttributes();
        Vector vector2 = ruleEngine2.getRuntimeAttributes();
        RuntimeAttribute runtimeAttribute = null;
        RuntimeAttribute runtimeAttribute2 = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            runtimeAttribute = (RuntimeAttribute)vector.get(i);
            string = runtimeAttribute.getNameAttribute();
            boolean bl = true;
            for (int j = 0; j < vector2.size(); ++j) {
                runtimeAttribute2 = (RuntimeAttribute)vector2.get(j);
                if (!runtimeAttribute2.getNameAttribute().equals(string)) continue;
                runtimeAttribute2.setTypeAttribute(runtimeAttribute.getTypeAttribute());
                runtimeAttribute2.setRuntimeAttribute(runtimeAttribute.getRuntimeAttribute());
                bl = false;
                break;
            }
            if (!bl) continue;
            ruleEngine2.createRuntimeAttribute(runtimeAttribute);
        }
    }

    private void migrateGeneralAttributes(RuleEngine ruleEngine, RuleEngine ruleEngine2) {
        Tr.entry((TraceComponent)_tc, (String)"migateGeneralAttributes", (Object)new Object[]{ruleEngine, ruleEngine2});
        Vector vector = ruleEngine.getGeneralAttributes();
        Vector vector2 = ruleEngine2.getGeneralAttributes();
        GeneralAttribute generalAttribute = null;
        GeneralAttribute generalAttribute2 = null;
        String string = null;
        for (int i = 0; i < vector.size(); ++i) {
            generalAttribute = (GeneralAttribute)vector.get(i);
            string = generalAttribute.getNameAttribute();
            boolean bl = true;
            for (int j = 0; j < vector2.size(); ++j) {
                generalAttribute2 = (GeneralAttribute)vector2.get(j);
                if (!generalAttribute2.getNameAttribute().equals(string)) continue;
                generalAttribute2.setTypeAttribute(generalAttribute.getTypeAttribute());
                generalAttribute2.setGeneralAttribute(generalAttribute.getGeneralAttribute());
                bl = false;
                break;
            }
            if (!bl) continue;
            ruleEngine2.createGeneralAttribute(generalAttribute);
        }
    }
}

