/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.multibroker.MultiBrokerRoutingEntry;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.common.PortMapping;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.CellDocumentCollection;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class PortUsage {
    private static TraceComponent _tc = Tr.register((Class)PortUsage.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static int _portBlock = 0;
    protected static boolean _portBlockSet = false;
    protected HashMap _portMappings = null;
    protected CellDocumentCollection _cellDocumentCollection = null;

    public PortUsage(CellDocumentCollection cellDocumentCollection) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"PortUsage", (Object)cellDocumentCollection);
        this._cellDocumentCollection = cellDocumentCollection;
        this.initializePortUsageMap();
    }

    public static boolean isPortBlockSet() {
        Tr.entry((TraceComponent)_tc, (String)"isPortBlockSet");
        return _portBlockSet;
    }

    public static int getPortBlock() {
        Tr.entry((TraceComponent)_tc, (String)"getPortBlock");
        return _portBlock++;
    }

    public static void setPortBlock(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"setPortBlock", (Object)string);
        try {
            _portBlock = Integer.parseInt(string);
            _portBlockSet = true;
        }
        catch (Exception exception) {
            throw new UpgradeException(LoggerImpl.get_nls().getFormattedMessage("advise.cmd.line.illegal", new Object[]{"com.ibm.websphere.migration.portBlock"}, "Illegal argument {0} specified."), exception, false);
        }
    }

    public HashMap getPortMappings() {
        Tr.entry((TraceComponent)_tc, (String)"getPortMappings");
        return this._portMappings;
    }

    public int checkForUniquePort(String string, File file, boolean bl) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkForUniquePort", (Object)new Object[]{string, file, new Boolean(bl)});
        int n = 0;
        boolean bl2 = false;
        if (string == null || string.trim().equalsIgnoreCase("-1")) {
            n = -1;
        } else if (string.trim().equalsIgnoreCase("0")) {
            n = 0;
        } else if (PortUsage.isPortBlockSet()) {
            int n2;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)"Using portBlock seed");
            }
            if ((n2 = this.mappedPortValue(Integer.parseInt(string))) != -1) {
                return n2;
            }
            while (bl2 = this.checkForPortUsage(new Integer(n = PortUsage.getPortBlock()), Integer.parseInt(string), file, true)) {
            }
        } else {
            n = Integer.parseInt(string);
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("port: " + n));
            }
            this.checkForPortUsage(new Integer(n), file, bl);
        }
        return n;
    }

    public int checkForUniquePort(String string, File file) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkForUniquePort", (Object)new Object[]{string, file});
        return this.checkForUniquePort(string, file, false);
    }

    public int mappedPortValue(int n) {
        Tr.entry((TraceComponent)_tc, (String)"mappedPortValue", (Object)new Object[]{new Integer(n)});
        Set set = this._portMappings.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            PortMapping portMapping = (PortMapping)this._portMappings.get(n2);
            if (portMapping.getOldPortNumber() != n) continue;
            return n2;
        }
        return -1;
    }

    public boolean checkForPortUsage(Integer n, File file, boolean bl) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkForPortUsage", (Object)new Object[]{n, file, new Boolean(bl)});
        return this.checkForPortUsage(n, -1, file, bl);
    }

    public boolean checkForPortUsage(Integer n, int n2, File file, boolean bl) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkForPortUsage", (Object)new Object[]{n, new Integer(n2), file, new Boolean(bl)});
        boolean bl2 = false;
        if (!this._portMappings.containsKey(n)) {
            this._portMappings.put(n, new PortMapping(n2, file.getPath()));
        } else {
            PortMapping portMapping;
            String string;
            if (!bl && !(string = new File((portMapping = (PortMapping)this._portMappings.get(n)).getFileName().toString()).getAbsolutePath()).equals(file.getAbsolutePath())) {
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.port.inuse", new Object[]{n.toString(), file.getAbsolutePath(), ((PortMapping)this._portMappings.get(n)).getFileName()}, "Port {0} in file {1} has been migrated but is already assigned in file {2}, this may result in port conflicts."));
            }
            bl2 = true;
        }
        return bl2;
    }

    public void initializePortUsageMap() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"initializePortUsageMap");
        if (this._portMappings == null) {
            this._portMappings = new HashMap();
            Vector vector = this.createNodeNameList();
            if (vector.size() > 0) {
                Tr.debug((TraceComponent)_tc, (String)("Number of nodes: " + vector.size()));
                for (int i = 0; i < vector.size(); ++i) {
                    WCCMDocument wCCMDocument = (WCCMDocument)((DocumentCollection)vector.get(i)).openDocument("serverindex.xml", class$com$ibm$wsspi$migration$document$wccm$WCCMDocument == null ? PortUsage.class$("com.ibm.wsspi.migration.document.wccm.WCCMDocument") : class$com$ibm$wsspi$migration$document$wccm$WCCMDocument);
                    this.initializeServerIndexEntries(wCCMDocument);
                    this.getAppServerPorts((DocumentCollection)vector.get(i), wCCMDocument);
                    wCCMDocument.close();
                }
            } else {
                Tr.debug((TraceComponent)_tc, (String)"No nodes found in the cell");
            }
            Tr.debug((TraceComponent)_tc, (String)("Number of ports loaded was: " + this._portMappings.size()));
        }
    }

    private Vector createAppServerNameList(DocumentCollection documentCollection, WCCMDocument wCCMDocument) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getAppServerNameList", (Object)wCCMDocument);
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        wCCMDocument.close();
        HashMap hashMap = new HashMap();
        EList eList = serverIndex.getServerEntries();
        Iterator iterator = eList.iterator();
        Vector<WCCMDocument> vector = new Vector<WCCMDocument>();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            if (!serverEntry.getServerType().equals("APPLICATION_SERVER")) continue;
            WCCMDocument wCCMDocument2 = (WCCMDocument)documentCollection.getChild("servers").getChild(serverEntry.getServerName()).openDocument("server.xml", class$com$ibm$wsspi$migration$document$wccm$WCCMDocument == null ? PortUsage.class$("com.ibm.wsspi.migration.document.wccm.WCCMDocument") : class$com$ibm$wsspi$migration$document$wccm$WCCMDocument);
            vector.add(wCCMDocument2);
        }
        return vector;
    }

    protected void getAppServerPorts(DocumentCollection documentCollection, WCCMDocument wCCMDocument) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getAppServerPorts", (Object)wCCMDocument);
        Vector vector = this.createAppServerNameList(documentCollection, wCCMDocument);
        for (int i = 0; i < vector.size(); ++i) {
            this.fillInAppServerPorts((WCCMDocument)vector.get(i));
            ((WCCMDocument)vector.get(i)).close();
        }
    }

    private void fillInAppServerPorts(WCCMDocument wCCMDocument) throws Exception {
        Object object;
        Object object2;
        HTTPTransport hTTPTransport;
        Object object3;
        Tr.entry((TraceComponent)_tc, (String)"fillInAppServerPorts", (Object)wCCMDocument);
        ApplicationServer applicationServer = this.locateServer(wCCMDocument);
        EList eList = applicationServer.getComponents();
        WebContainer webContainer = null;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            if (!(object3 instanceof WebContainer)) continue;
            webContainer = (WebContainer)object3;
            break;
        }
        if (webContainer != null) {
            object3 = webContainer.getTransports().iterator();
            hTTPTransport = null;
            while (object3.hasNext()) {
                hTTPTransport = (HTTPTransport)object3.next();
                if (this._portMappings.containsKey(new Integer(hTTPTransport.getAddress().getPort()))) continue;
                object2 = new Integer(hTTPTransport.getAddress().getPort());
                object = new File(wCCMDocument.getDocumentCollection().getUrl().getPath(), wCCMDocument.getName());
                this._portMappings.put(object2, new PortMapping(((File)object).getPath()));
            }
        }
        this.processDRSPorts(webContainer);
        object3 = applicationServer.getServer().getComponents();
        hTTPTransport = null;
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof JMSServer)) continue;
            hTTPTransport = (JMSServer)object;
            break;
        }
        if (hTTPTransport != null && !this._portMappings.containsKey(object = new Integer(hTTPTransport.getSecurityPort().getPort()))) {
            File file = new File(wCCMDocument.getDocumentCollection().getUrl().getPath(), wCCMDocument.getName());
            this._portMappings.put(object, new PortMapping(0, file.getPath()));
        }
    }

    protected ApplicationServer locateServer(WCCMDocument wCCMDocument) throws Exception {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"locateServer", (Object)new Object[]{wCCMDocument});
        Server server = (Server)UtilityImpl.locateConfigFileObject(wCCMDocument, Server.class);
        if (server == null) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{wCCMDocument.getName()}, "Unable to read configuration file {0}.");
            throw new UpgradeException(string, null, false);
        }
        EList eList = server.getComponents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof ApplicationServer)) continue;
            ApplicationServer applicationServer = (ApplicationServer)object;
            Tr.debug((TraceComponent)_tc, (String)("Found server entry: " + applicationServer.getServer().getName()));
            return (ApplicationServer)object;
        }
        object = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{wCCMDocument.getName()}, "Unable to read configuration file {0}.");
        throw new UpgradeException((String)object, null, false);
    }

    protected void processDRSPorts(WebContainer webContainer) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"processDRSPorts", (Object)new Object[]{webContainer});
        SessionManager sessionManager = null;
        try {
            Object object;
            EList eList = webContainer.getServices();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof SessionManager)) continue;
                sessionManager = (SessionManager)object;
                break;
            }
            if (sessionManager != null && sessionManager.getSessionDRSPersistence() != null) {
                object = sessionManager.getSessionDRSPersistence();
                String string = object.getPreferredLocalDRSBrokerName();
                WCCMDocument wCCMDocument = (WCCMDocument)this._cellDocumentCollection.openDocument("multibroker.xml", WCCMDocument.class);
                List list = wCCMDocument.getList();
                wCCMDocument.close();
                MultiBrokerRoutingEntry multiBrokerRoutingEntry = null;
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Object e = iterator2.next();
                    if (!(e instanceof MultiBrokerRoutingEntry) || !(multiBrokerRoutingEntry = (MultiBrokerRoutingEntry)e).getBrokerName().equals(string)) continue;
                    EndPoint endPoint = multiBrokerRoutingEntry.getBrokerEndPoint();
                    this._portMappings.put(new Integer(endPoint.getPort()), new PortMapping(wCCMDocument.getName()));
                    EndPoint endPoint2 = multiBrokerRoutingEntry.getClientEndPoint();
                    this._portMappings.put(new Integer(endPoint2.getPort()), new PortMapping(wCCMDocument.getName()));
                }
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Could not open or find multibroker.xml, not all ports from this file will be inititialized in our port list.");
            Tr.debug((TraceComponent)_tc, (String)exception.toString());
        }
    }

    protected void initializeServerIndexEntries(WCCMDocument wCCMDocument) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"initializeServerIndexEntries", (Object)wCCMDocument);
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        wCCMDocument.close();
        EList eList = serverIndex.getServerEntries();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            Tr.debug((TraceComponent)_tc, (String)("Now checking server entry: " + serverEntry.getServerName()));
            EList eList2 = serverEntry.getSpecialEndpoints();
            Iterator iterator2 = eList2.iterator();
            while (iterator2.hasNext()) {
                NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                Tr.debug((TraceComponent)_tc, (String)("  Now checking endpoint: " + namedEndPoint.getEndPointName()));
                EndPoint endPoint = namedEndPoint.getEndPoint();
                File file = new File(wCCMDocument.getDocumentCollection().getUrl().getPath(), wCCMDocument.getName());
                this._portMappings.put(new Integer(endPoint.getPort()), new PortMapping(file.getPath()));
            }
        }
    }

    protected int createUniquePort(WCCMDocument wCCMDocument, int n) {
        Tr.entry((TraceComponent)_tc, (String)"createUniquePort", (Object)new Object[]{wCCMDocument, new Integer(n)});
        int n2 = n;
        if (PortUsage.isPortBlockSet()) {
            n2 = PortUsage.getPortBlock();
        } else {
            while (this._portMappings.containsKey(new Integer(n2))) {
                ++n2;
            }
        }
        File file = new File(wCCMDocument.getDocumentCollection().getUrl().getPath(), wCCMDocument.getName());
        this._portMappings.put(new Integer(n2), new PortMapping(file.getPath()));
        return n2;
    }

    private Vector createNodeNameList() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getNodeNameList");
        DocumentCollection documentCollection = this._cellDocumentCollection.getChild("nodes");
        Tr.debug((TraceComponent)_tc, (String)("Nodes path" + documentCollection.getName()));
        Vector<DocumentCollection> vector = new Vector<DocumentCollection>();
        DocumentCollection[] documentCollectionArray = documentCollection.getChildren();
        for (int i = 0; i < documentCollectionArray.length; ++i) {
            vector.add(documentCollectionArray[i]);
        }
        return vector;
    }
}

