/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.rolebasedauthz.AllAuthenticatedUsersExt;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.EveryoneExt;
import com.ibm.websphere.models.config.rolebasedauthz.GroupExt;
import com.ibm.websphere.models.config.rolebasedauthz.PrimaryAdminExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzPackage;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.ServerExt;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.BasicWCCMDocumentProcessor;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class RoleBasedAuthzConfig
extends BasicWCCMDocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)RoleBasedAuthzConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected ArrayList _oldAdminGroupList = new ArrayList();
    protected ArrayList _oldAdminUserList = new ArrayList();

    public RoleBasedAuthzConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
        this.getProcessorHelper().addOverride(AuthorizationTableExt.class, "getAuthorizations", new Class[0]);
    }

    public void logProgressMessage(UserExt userExt, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{userExt, bl});
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"User", userExt.getName()}, "Adding {0} entry {1} to the model."), true);
        }
    }

    public Document getTemplateDocument() {
        Tr.entry((TraceComponent)_tc, (String)"getTemplateDocument");
        return null;
    }

    public void logProgressMessage(GroupExt groupExt, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{groupExt, bl});
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"Group", groupExt.getName()}, "Adding {0} entry {1} to the model."), true);
        }
    }

    public void logProgressMessage(EveryoneExt everyoneExt, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{everyoneExt, bl});
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"SpecialSubject", everyoneExt.getName()}, "Adding {0} entry {1} to the model."), true);
        }
    }

    public void logProgressMessage(AllAuthenticatedUsersExt allAuthenticatedUsersExt, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{allAuthenticatedUsersExt, bl});
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"SpecialSubject", allAuthenticatedUsersExt.getName()}, "Adding {0} entry {1} to the model."), true);
        }
    }

    public List getAuthorizations(boolean bl, AuthorizationTableExt authorizationTableExt) {
        Tr.entry((TraceComponent)_tc, (String)"getAuthorizations", (Object)authorizationTableExt);
        EList eList = authorizationTableExt.getAuthorizations();
        if (bl) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)iterator.next();
                SecurityRoleExt securityRoleExt = roleAssignmentExt.getRole();
                if (!securityRoleExt.getRoleName().equalsIgnoreCase("administrator")) continue;
                this.populateAdminGroupList(roleAssignmentExt);
                this.populateAdminUserList(roleAssignmentExt);
                break;
            }
        } else {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                RoleAssignmentExt roleAssignmentExt = (RoleAssignmentExt)iterator.next();
                SecurityRoleExt securityRoleExt = roleAssignmentExt.getRole();
                if (!securityRoleExt.getRoleName().equalsIgnoreCase("adminsecuritymanager")) continue;
                EList eList2 = roleAssignmentExt.getGroups();
                EList eList3 = roleAssignmentExt.getUsers();
                this.addAdminGroups((List)eList2);
                this.addAdminUsers((List)eList3);
            }
        }
        return authorizationTableExt.getAuthorizations();
    }

    protected void populateAdminGroupList(RoleAssignmentExt roleAssignmentExt) {
        Tr.entry((TraceComponent)_tc, (String)"populateAdminGroupList", (Object)roleAssignmentExt);
        EList eList = roleAssignmentExt.getGroups();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            GroupExt groupExt = (GroupExt)iterator.next();
            String string = groupExt.getName();
            this._oldAdminGroupList.add(string);
        }
    }

    protected void populateAdminUserList(RoleAssignmentExt roleAssignmentExt) {
        Tr.entry((TraceComponent)_tc, (String)"populateAdminUserList", (Object)roleAssignmentExt);
        EList eList = roleAssignmentExt.getUsers();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            UserExt userExt = (UserExt)iterator.next();
            String string = userExt.getName();
            this._oldAdminUserList.add(string);
        }
    }

    protected void addAdminGroups(List list) {
        Tr.entry((TraceComponent)_tc, (String)"addAdminGroups", (Object)list);
        Iterator iterator = this._oldAdminGroupList.iterator();
        while (iterator.hasNext()) {
            GroupExt groupExt;
            String string = (String)iterator.next();
            boolean bl = false;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                groupExt = (GroupExt)iterator2.next();
                if (!groupExt.getName().equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            groupExt = RolebasedauthzPackage.eINSTANCE.getRolebasedauthzFactory();
            GroupExt groupExt2 = groupExt.createGroupExt();
            groupExt2.setName(string);
            list.add(groupExt2);
        }
    }

    protected void addAdminUsers(List list) {
        Tr.entry((TraceComponent)_tc, (String)"addAdminUsers", (Object)list);
        Iterator iterator = this._oldAdminUserList.iterator();
        while (iterator.hasNext()) {
            UserExt userExt;
            String string = (String)iterator.next();
            boolean bl = false;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                userExt = (UserExt)iterator2.next();
                if (!userExt.getName().equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            userExt = RolebasedauthzPackage.eINSTANCE.getRolebasedauthzFactory();
            UserExt userExt2 = userExt.createUserExt();
            userExt2.setName(string);
            list.add(userExt2);
        }
    }

    public boolean arePrimaryKeysEqual(AuthorizationTableExt authorizationTableExt, AuthorizationTableExt authorizationTableExt2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + authorizationTableExt.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(SecurityRoleExt securityRoleExt, SecurityRoleExt securityRoleExt2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + securityRoleExt.getClass().getName()));
        boolean bl = false;
        String string = securityRoleExt.getRoleName();
        if (string != null) {
            bl = string.equals(securityRoleExt2.getRoleName());
        } else if (securityRoleExt2.getRoleName() == null) {
            bl = true;
        }
        return bl;
    }

    public boolean arePrimaryKeysEqual(RoleAssignmentExt roleAssignmentExt, RoleAssignmentExt roleAssignmentExt2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + roleAssignmentExt.getClass().getName()));
        boolean bl = false;
        SecurityRoleExt securityRoleExt = roleAssignmentExt.getRole();
        SecurityRoleExt securityRoleExt2 = roleAssignmentExt2.getRole();
        if (securityRoleExt != null && securityRoleExt2 != null) {
            bl = this.arePrimaryKeysEqual(securityRoleExt, securityRoleExt2);
        } else if (securityRoleExt == null && securityRoleExt2 == null) {
            bl = true;
        }
        return bl;
    }

    public boolean arePrimaryKeysEqual(ServerExt serverExt, ServerExt serverExt2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + serverExt.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(EveryoneExt everyoneExt, EveryoneExt everyoneExt2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + everyoneExt.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(AllAuthenticatedUsersExt allAuthenticatedUsersExt, AllAuthenticatedUsersExt allAuthenticatedUsersExt2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + allAuthenticatedUsersExt.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(PrimaryAdminExt primaryAdminExt, PrimaryAdminExt primaryAdminExt2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + primaryAdminExt.getClass().getName()));
        return true;
    }
}

