/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.ssl.CryptoHardwareToken;
import com.ibm.websphere.models.config.ipc.ssl.KeyFileFormatKind;
import com.ibm.websphere.models.config.ipc.ssl.KeyManager;
import com.ibm.websphere.models.config.ipc.ssl.KeyReference;
import com.ibm.websphere.models.config.ipc.ssl.KeyStore;
import com.ibm.websphere.models.config.ipc.ssl.ManagementScope;
import com.ibm.websphere.models.config.ipc.ssl.SecureSocketLayer;
import com.ibm.websphere.models.config.ipc.ssl.SslFactory;
import com.ibm.websphere.models.config.ipc.ssl.SslPackage;
import com.ibm.websphere.models.config.ipc.ssl.TrustManager;
import com.ibm.websphere.models.config.jaaslogin.JAASAuthData;
import com.ibm.websphere.models.config.jaaslogin.JAASConfigurationEntry;
import com.ibm.websphere.models.config.jaaslogin.JAASLoginModule;
import com.ibm.websphere.models.config.orb.securityprotocol.IIOPTransport;
import com.ibm.websphere.models.config.orb.securityprotocol.IdentityAssertionLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.MessageLayer;
import com.ibm.websphere.models.config.orb.securityprotocol.ServerIdentity;
import com.ibm.websphere.models.config.orb.securityprotocol.TransportLayer;
import com.ibm.websphere.models.config.properties.PropertiesFactory;
import com.ibm.websphere.models.config.properties.PropertiesPackage;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.AuthMechanism;
import com.ibm.websphere.models.config.security.CustomAuthMechanism;
import com.ibm.websphere.models.config.security.CustomUserRegistry;
import com.ibm.websphere.models.config.security.LDAPUserRegistry;
import com.ibm.websphere.models.config.security.LTPA;
import com.ibm.websphere.models.config.security.LocalOSUserRegistry;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.SSLConfigGroup;
import com.ibm.websphere.models.config.security.SSLType;
import com.ibm.websphere.models.config.security.SWAMAuthentication;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.TAInterceptor;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.models.config.security.WIMUserRegistry;
import com.ibm.websphere.models.config.topology.nodegroup.NodeGroup;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.common.WCCMDocumentReflector;
import com.ibm.ws.migration.document.TextDocument;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.BasicDocument;
import com.ibm.wsspi.migration.document.CellDocumentCollection;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.BasicWCCMDocumentProcessor;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public class SecurityConfig
extends BasicWCCMDocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)SecurityConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected Properties _oldCurrentLevelVariables = null;
    protected Properties _newCurrentLevelVariables = null;
    protected Configuration _oldConfiguration = null;
    protected String _authConfig = null;
    protected boolean _systemSSL = false;
    protected boolean _daemonConfig = false;
    protected SSLConfig[] _sslConfigList = new SSLConfig[100];
    protected int _sslConfigCount = 0;
    public SSLConfig _defaultSSLConfig = null;
    protected static ManagementScope _managementScope = null;
    protected static KeyManager _keyManager = null;
    protected static TrustManager _trustManager = null;
    protected static EList _keyStoreList = null;
    protected static Scenario _scenario = null;
    protected static EList _customProperties = null;
    protected static String _keyStoreName = "SSLConfigAlias_key";
    protected static String _trustStoreName = "SSLConfigAlias_trust";
    protected static int _keyStoreCount = 0;
    protected static int _trustStoreCount = 0;
    protected static Security _oldSecurityObject = null;
    protected static Security _newSecurityObject = null;
    protected static boolean _isMixedZOSAndDist = false;
    private static String prefix = "safkeyring:///";
    static /* synthetic */ Class class$com$ibm$ws$migration$document$TextDocument;

    public SecurityConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
        this.instantiateVariables();
        _scenario = documentTransform.getScenario();
        this.getProcessorHelper().addOverride(SecureSocketLayer.class, "getKeyFileName", new Class[0]);
        this.getProcessorHelper().addOverride(SecureSocketLayer.class, "getTrustFileName", new Class[0]);
        this.getProcessorHelper().addOverride(LDAPUserRegistry.class, "setSslConfig", new Class[]{String.class});
        this.getProcessorHelper().addOverride(IIOPTransport.class, "setSslConfig", new Class[]{String.class});
        this.getProcessorHelper().addOverride(Property.class, "setName", new Class[]{String.class});
        this.getProcessorHelper().addOverride(Security.class, "setEnabled", new Class[]{Boolean.TYPE});
        this.getProcessorHelper().addOverride(AuthMechanism.class, "getAuthConfig", new Class[0]);
        this.getProcessorHelper().addOverride(AuthMechanism.class, "setAuthContextImplClass", new Class[]{String.class});
        this.getProcessorHelper().addOverride(UserRegistry.class, "setUseRegistryServerId", new Class[]{Boolean.TYPE});
        this.getProcessorHelper().addOverride(LTPA.class, "getPassword", new Class[0]);
        this.getProcessorHelper().addOverride(LTPA.class, "getPrivate", new Class[0]);
        this.getProcessorHelper().addOverride(LTPA.class, "getPublic", new Class[0]);
        this.getProcessorHelper().addOverride(LTPA.class, "getShared", new Class[0]);
        this.getProcessorHelper().addOverride(Security.class, "getRepertoire", new Class[0]);
        ((WCCMDocumentReflector)this.getProcessorHelper()).addMultipleCrossReferenceMethod(SecureSocketLayer.class, "getTrustManager");
        if (!WASPostUpgrade.is_scriptCompatibility()) {
            this.getProcessorHelper().addOverride(SSLConfig.class, "getManagementScope", new Class[0]);
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "getSslProtocol", new Class[0]);
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "getJsseProvider", new Class[0]);
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "getEnabledCiphers", new Class[0]);
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "getKeyStore", new Class[0]);
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "setKeyStore", new Class[]{KeyStore.class});
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "getTrustStore", new Class[0]);
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "setTrustStore", new Class[]{KeyStore.class});
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "setKeyFileName", new Class[]{String.class});
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "setKeyFilePassword", new Class[]{String.class});
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "setTrustFileName", new Class[]{String.class});
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "setTrustFilePassword", new Class[]{String.class});
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "setCryptoHardware", new Class[]{CryptoHardwareToken.class});
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "setKeyFileFormat", new Class[]{KeyFileFormatKind.class});
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "getKeyFileFormat", new Class[0]);
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "getTrustFileFormat", new Class[0]);
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "getKeyManager", new Class[0]);
            this.getProcessorHelper().addOverride(SSLConfig.class, "getType", new Class[0]);
            this.getProcessorHelper().addOverride(SecureSocketLayer.class, "setEnableCryptoHardwareSupport", new Class[]{Boolean.TYPE});
        }
    }

    protected void instantiateVariables() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"instantiateVariables");
        if (this.getTransform().getOldDocumentCollection() instanceof CellDocumentCollection) {
            String string = ((ProfileImpl)this.getTransform().getScenario().getOldProductImage().getProfile()).getOwningNodeName();
            DocumentCollection documentCollection = this.getTransform().getOldDocumentCollection().getChild("nodes").getChild(string);
            DocumentCollection[] documentCollectionArray = this.getTransform().getOldDocumentCollection().getChild("nodes").getChildren();
            try {
                this.checkMixedZOSAndDist(documentCollectionArray);
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Failed to checkMixedzOSAndDist: ", (Object)exception);
            }
            this._oldCurrentLevelVariables = UtilityImpl.instantiateVariables(documentCollection);
            String string2 = ((ProfileImpl)this.getTransform().getScenario().getNewProductImage().getProfile()).getOwningNodeName();
            DocumentCollection documentCollection2 = this.getTransform().getNewDocumentCollection().getChild("nodes").getChild(string2);
            this._newCurrentLevelVariables = UtilityImpl.instantiateVariables(documentCollection2);
        } else {
            this._oldCurrentLevelVariables = UtilityImpl.instantiateVariables(this.getTransform().getOldDocumentCollection());
            this._newCurrentLevelVariables = UtilityImpl.instantiateVariables(this.getTransform().getNewDocumentCollection());
        }
    }

    protected void checkMixedZOSAndDist(DocumentCollection[] documentCollectionArray) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"checkMixedZOSAndDist", (Object)documentCollectionArray);
        String string = "com.ibm.websphere.nodeOperatingSystem";
        for (int i = 0; i < documentCollectionArray.length; ++i) {
            if (!documentCollectionArray[i].documentExists("node-metadata.properties")) continue;
            TextDocument textDocument = (TextDocument)documentCollectionArray[i].openDocument("node-metadata.properties", class$com$ibm$ws$migration$document$TextDocument == null ? SecurityConfig.class$("com.ibm.ws.migration.document.TextDocument") : class$com$ibm$ws$migration$document$TextDocument, false, true);
            if (textDocument != null) {
                Properties properties = new Properties();
                properties.load(textDocument.getInputStream());
                String string2 = (String)properties.get(string);
                if (string2 != null && !string2.equalsIgnoreCase("os390") && OSInfoFactory.isZSeries()) {
                    _isMixedZOSAndDist = true;
                    Tr.debug((TraceComponent)_tc, (String)"We are running a mixed OS scenario where Dmgr is on zOS ");
                }
            }
            textDocument.close();
        }
    }

    public Document getTemplateDocument() {
        return null;
    }

    public void setAuthContextImplClass(AuthMechanism authMechanism, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setAuthContextImplClass", (Object)string);
        if (this._authConfig != null && this._authConfig.equals("system.ICSF")) {
            if (string.equals("null")) {
                authMechanism.setAuthContextImplClass("com.ibm.ISecurityLocalObjectTokenBaseImpl.WSSecurityContextICSFImpl");
            } else {
                authMechanism.setAuthContextImplClass(string);
            }
        } else {
            authMechanism.setAuthContextImplClass(string);
        }
        this._authConfig = null;
    }

    public String getAuthConfig(boolean bl, AuthMechanism authMechanism) {
        Tr.entry((TraceComponent)_tc, (String)"getAuthConfig", (Object)authMechanism);
        if (bl) {
            this._authConfig = authMechanism.getAuthConfig();
        }
        return authMechanism.getAuthConfig();
    }

    public void setName(Property property, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setName", (Object)string);
        if (!OSInfoFactory.isZSeries() && string != null && string.equals("com.ibm.ssl.contextProvider")) {
            property.setValue("IBMJSSE2");
        }
        property.setName(string);
    }

    public void setEnabled(Security security, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"setEnabled", (Object)new Object[]{security, new Boolean(bl)});
        security.setEnabled(bl);
        security.setAppEnabled(bl);
        this.initializeSSLVariables(security);
    }

    public void setCryptoHardware(SecureSocketLayer secureSocketLayer, CryptoHardwareToken cryptoHardwareToken) {
        Tr.entry((TraceComponent)_tc, (String)"setCryptoHardware", (Object)new Object[]{cryptoHardwareToken, secureSocketLayer});
        secureSocketLayer.setCryptoHardware(null);
    }

    public void setKeyFileName(SecureSocketLayer secureSocketLayer, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setKeyFileName", (Object)new Object[]{string, secureSocketLayer});
        secureSocketLayer.setKeyFileName(null);
    }

    public KeyFileFormatKind getKeyFileFormat(boolean bl, SecureSocketLayer secureSocketLayer) {
        Tr.entry((TraceComponent)_tc, (String)"getKeyFileFormat", (Object)new Object[]{new Boolean(bl), secureSocketLayer});
        return null;
    }

    public void setKeyFileFormat(SecureSocketLayer secureSocketLayer, KeyFileFormatKind keyFileFormatKind) {
        secureSocketLayer.setKeyFileFormat(null);
    }

    public KeyFileFormatKind getTrustFileFormat(boolean bl, SecureSocketLayer secureSocketLayer) {
        Tr.entry((TraceComponent)_tc, (String)"getTrustFileFormat", (Object)new Object[]{new Boolean(bl), secureSocketLayer});
        return null;
    }

    public String getPublic(boolean bl, LTPA lTPA) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getPublic", (Object)new Object[]{new Boolean(bl), lTPA});
        return null;
    }

    public String getPrivate(boolean bl, LTPA lTPA) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getPrivate", (Object)new Object[]{new Boolean(bl), lTPA});
        return null;
    }

    public String getPassword(boolean bl, LTPA lTPA) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getPassword", (Object)new Object[]{new Boolean(bl), lTPA});
        return null;
    }

    public String getShared(boolean bl, LTPA lTPA) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getShared", (Object)new Object[]{new Boolean(bl), lTPA});
        return null;
    }

    public void setKeyFilePassword(SecureSocketLayer secureSocketLayer, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setKeyFilePassword", (Object)new Object[]{string, secureSocketLayer});
        secureSocketLayer.setKeyFilePassword(null);
    }

    public void setTrustFileName(SecureSocketLayer secureSocketLayer, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setTrustFileName", (Object)new Object[]{string, secureSocketLayer});
        secureSocketLayer.setTrustFileName(null);
    }

    public void setTrustFilePassword(SecureSocketLayer secureSocketLayer, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setTrustFilePassword", (Object)new Object[]{string, secureSocketLayer});
        secureSocketLayer.setTrustFilePassword(null);
    }

    public void setKeyStore(SecureSocketLayer secureSocketLayer, KeyStore keyStore) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setKeyStore", (Object)new Object[]{keyStore, secureSocketLayer});
        _keyStoreList.add((Object)keyStore);
        secureSocketLayer.setKeyStore(keyStore);
    }

    public void setTrustStore(SecureSocketLayer secureSocketLayer, KeyStore keyStore) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setTrustStore", (Object)new Object[]{keyStore, secureSocketLayer});
        _keyStoreList.add((Object)keyStore);
        secureSocketLayer.setTrustStore(keyStore);
        secureSocketLayer.getTrustManager().add((Object)_trustManager);
    }

    public String getSslProtocol(boolean bl, SecureSocketLayer secureSocketLayer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getSslProtocol", (Object)new Object[]{new Boolean(bl), secureSocketLayer});
        String string = null;
        Property property = null;
        if (bl) {
            EList eList = secureSocketLayer.getProperties();
            for (int i = 0; i < eList.size(); ++i) {
                property = (Property)eList.get(i);
                if (!property.getName().equals("com.ibm.ssl.protocol")) continue;
                string = property.getValue();
                eList.remove(i);
                --i;
            }
        }
        return string;
    }

    public String getJsseProvider(boolean bl, SecureSocketLayer secureSocketLayer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getJsseProvider", (Object)new Object[]{new Boolean(bl), secureSocketLayer});
        String string = null;
        Property property = null;
        if (bl) {
            EList eList = secureSocketLayer.getProperties();
            for (int i = 0; i < eList.size(); ++i) {
                property = (Property)eList.get(i);
                if (!property.getName().equals("com.ibm.ssl.contextProvider")) continue;
                string = property.getValue();
                eList.remove(i);
                --i;
            }
        }
        return string;
    }

    public String getEnabledCiphers(boolean bl, SecureSocketLayer secureSocketLayer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getEnabledCiphers", (Object)new Object[]{new Boolean(bl), secureSocketLayer});
        String string = null;
        Property property = null;
        if (bl) {
            EList eList = secureSocketLayer.getProperties();
            for (int i = 0; i < eList.size(); ++i) {
                property = (Property)eList.get(i);
                if (!property.getName().equals("com.ibm.ssl.enabledCipherSuites")) continue;
                string = property.getValue();
                eList.remove(i);
                --i;
            }
        }
        return string;
    }

    public KeyStore getKeyStore(boolean bl, SecureSocketLayer secureSocketLayer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getKeyStore", (Object)new Object[]{new Boolean(bl), secureSocketLayer});
        KeyStore keyStore = null;
        SslFactory sslFactory = SslPackage.eINSTANCE.getSslFactory();
        if (bl) {
            String string = secureSocketLayer.getKeyFileName();
            boolean bl2 = secureSocketLayer.isEnableCryptoHardwareSupport();
            if (bl2) {
                keyStore = this.convertCryptoHardwareToken(secureSocketLayer);
            } else if (string != null) {
                keyStore = sslFactory.createKeyStore();
                ++_keyStoreCount;
                if (this.getSystemSSL() && !this.getDaemonConfig()) {
                    string = SecurityConfig.updateRACFlocation(string);
                    secureSocketLayer.setKeyFilePassword("password");
                    secureSocketLayer.setKeyFileFormat(KeyFileFormatKind.JCERACFKS_LITERAL);
                }
                boolean bl3 = true;
                String string2 = secureSocketLayer.getKeyFileFormat().getName();
                if (string2.equals("JCERACFKS") || string2.equals("JCE4758KS")) {
                    bl3 = false;
                }
                keyStore.setLocation(string);
                keyStore.setPassword(secureSocketLayer.getKeyFilePassword());
                keyStore.setType(string2);
                keyStore.setFileBased(bl3);
                keyStore.setInitializeAtStartup(false);
                keyStore.setManagementScope(_managementScope);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(_keyStoreName);
                stringBuffer.append("_");
                stringBuffer.append(_keyStoreCount);
                keyStore.setName(stringBuffer.toString());
            }
        }
        return keyStore;
    }

    public KeyStore getTrustStore(boolean bl, SecureSocketLayer secureSocketLayer) throws Exception {
        String string;
        Tr.entry((TraceComponent)_tc, (String)"getTrustStore", (Object)new Object[]{new Boolean(bl), secureSocketLayer});
        KeyStore keyStore = null;
        SslFactory sslFactory = SslPackage.eINSTANCE.getSslFactory();
        if (bl && (string = secureSocketLayer.getTrustFileName()) != null) {
            keyStore = sslFactory.createKeyStore();
            ++_trustStoreCount;
            if (this.getSystemSSL() && !this.getDaemonConfig()) {
                string = SecurityConfig.updateRACFlocation(string);
                secureSocketLayer.setKeyFilePassword("password");
                secureSocketLayer.setKeyFileFormat(KeyFileFormatKind.JCERACFKS_LITERAL);
            }
            boolean bl2 = secureSocketLayer.isEnableCryptoHardwareSupport();
            boolean bl3 = true;
            String string2 = secureSocketLayer.getKeyFileFormat().getName();
            if (bl2 || string2.equals("JCERACFKS") || string2.equals("JCE4758KS")) {
                bl3 = false;
            }
            keyStore.setLocation(string);
            keyStore.setPassword(secureSocketLayer.getKeyFilePassword());
            keyStore.setType(string2);
            keyStore.setFileBased(bl3);
            keyStore.setInitializeAtStartup(false);
            keyStore.setManagementScope(_managementScope);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(_trustStoreName);
            stringBuffer.append("_");
            stringBuffer.append(_trustStoreCount);
            keyStore.setName(stringBuffer.toString());
        }
        return keyStore;
    }

    public ManagementScope getManagementScope(boolean bl, SSLConfig sSLConfig) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getManagementScope", (Object)new Object[]{new Boolean(bl), sSLConfig});
        if (bl) {
            this._systemSSL = false;
            this._daemonConfig = false;
            if (sSLConfig.getType().equals(SSLType.SSSL_LITERAL)) {
                this._systemSSL = true;
                this._daemonConfig = this.checkDaemonSSLConfig(sSLConfig);
            }
        }
        return _managementScope;
    }

    public SSLType getType(boolean bl, SSLConfig sSLConfig) {
        Tr.entry((TraceComponent)_tc, (String)"getType", (Object)new Object[]{new Boolean(bl), sSLConfig});
        SSLType sSLType = sSLConfig.getType();
        if (bl && this.getSystemSSL() && !this.getDaemonConfig()) {
            sSLType = SSLType.JSSE_LITERAL;
        }
        return sSLType;
    }

    public void setEnableCryptoHardwareSupport(SecureSocketLayer secureSocketLayer, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"setEnableCryptoHardwareSupport", (Object)new Object[]{secureSocketLayer});
        secureSocketLayer.setEnableCryptoHardwareSupport(false);
    }

    public KeyManager getKeyManager(boolean bl, SecureSocketLayer secureSocketLayer) {
        Tr.entry((TraceComponent)_tc, (String)"getKeyManager", (Object)new Object[]{new Boolean(bl), secureSocketLayer});
        return _keyManager;
    }

    public List getRepertoire(boolean bl, Security security) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getRepertoire", (Object)new Object[]{new Boolean(bl), security});
        Object object = security.getRepertoire();
        Configuration configuration = new Configuration(new File(this.getTransform().getScenario().getOldProductImage().getProfile().getDirectory(), "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
        if (bl) {
            if (OSInfoFactory.isZSeries()) {
                object = this.updateRepertoireList((List)object);
            }
            String string = ((ProfileImpl)_scenario.getOldProductImage().getProfile()).getOwningNodeName();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SSLConfig sSLConfig = (SSLConfig)iterator.next();
                String string2 = sSLConfig.getAlias();
                String string3 = null;
                if (this.checkDaemonConfig(sSLConfig) || this.isBacklevelNodeSSSL(security, sSLConfig, configuration, string, string2)) {
                    iterator.remove();
                    if (configuration.isFederatedNode() || !WASPostUpgrade.is_wasPostUpgrade()) continue;
                    this._sslConfigList[this._sslConfigCount] = sSLConfig;
                    ++this._sslConfigCount;
                    continue;
                }
                int n = string2.indexOf("/");
                string3 = n != -1 ? string2.substring(0, n) : string2;
                if (!string3.equals(string)) continue;
                if (!OSInfoFactory.isZSeries() && string2.equals(string + "/DefaultSSLSettings")) {
                    this._defaultSSLConfig = sSLConfig;
                    continue;
                }
                if (OSInfoFactory.isZSeries() && string2.equals(string + "/RACFJSSESettings")) {
                    this._defaultSSLConfig = sSLConfig;
                    continue;
                }
                if (this._defaultSSLConfig != null) continue;
                this._defaultSSLConfig = sSLConfig;
            }
        } else {
            for (int i = 0; i < this._sslConfigCount; ++i) {
                object.add(this._sslConfigList[i]);
            }
        }
        return object;
    }

    public List updateRepertoireList(List list) {
        Tr.entry((TraceComponent)_tc, (String)"getRepertoire", (Object)list);
        SSLConfig sSLConfig = null;
        SecureSocketLayer secureSocketLayer = null;
        String string = null;
        String string2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Property property;
            sSLConfig = (SSLConfig)iterator.next();
            secureSocketLayer = sSLConfig.getSetting();
            if (!sSLConfig.getType().equals(SSLType.JSSE_LITERAL) || !secureSocketLayer.isEnableCryptoHardwareSupport()) continue;
            string = secureSocketLayer.getKeyFileName();
            string2 = secureSocketLayer.getTrustFileName();
            EList eList = secureSocketLayer.getProperties();
            PropertiesFactory propertiesFactory = PropertiesPackage.eINSTANCE.getPropertiesFactory();
            if (string != null && string.startsWith("safkeyring:///")) {
                string = string.replaceFirst("safkeyring", "safkeyringhw");
                secureSocketLayer.setKeyFileName(string);
                secureSocketLayer.setEnableCryptoHardwareSupport(false);
                property = propertiesFactory.createProperty();
                property.setName("com.ibm.ssl.keyStoreType");
                property.setValue("JCE4758RACFKS");
                eList.add(property);
            }
            if (string2 == null || !string2.startsWith("safkeyring:///")) continue;
            string2 = string2.replaceFirst("safkeyring", "safkeyringhw");
            secureSocketLayer.setTrustFileName(string2);
            secureSocketLayer.setEnableCryptoHardwareSupport(false);
            property = propertiesFactory.createProperty();
            property.setName("com.ibm.ssl.trustStoreType");
            property.setValue("JCE4758RACFKS");
            eList.add(property);
        }
        return list;
    }

    protected boolean checkDaemonConfig(SSLConfig sSLConfig) throws Exception {
        boolean bl = false;
        if (sSLConfig.getType().equals(SSLType.SSSL_LITERAL)) {
            bl = this.checkDaemonSSLConfig(sSLConfig);
        }
        return bl;
    }

    public void logProgressMessage(Security security, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{security});
        if (!bl.booleanValue()) {
            Tr.debug((TraceComponent)_tc, (String)("The Security Attribute isEnabled is set to: " + security.isEnabled()));
            if (security.isEnabled()) {
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.updating.authmech", new Object[]{"Active"}, "Updating attributes of the {0} AuthMechanism."));
                if (security != null && security.getActiveUserRegistry() != null && security.getActiveUserRegistry().getServerId() != null) {
                    UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.updating.userreg", new Object[]{"Active", security.getActiveUserRegistry().getServerId()}, "Updating attributes of the {0} UserRegistry to reflect the information for serverId {1}."));
                }
            }
        }
    }

    public void logProgressMessage(SSLConfig sSLConfig, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{sSLConfig});
        String string = sSLConfig.getAlias();
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"SSLConfig", string}, "Adding {0} entry {1} to the model."));
        } else {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.updating.entry", new Object[]{"SSLConfig", string}, "Updating attributes of {0} entry {1}, it is already defined in the existing model."));
        }
    }

    public void logProgressMessage(JAASAuthData jAASAuthData, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{jAASAuthData});
        String string = jAASAuthData.getAlias();
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"JAASAuthData", string}, "Adding {0} entry {1} to the model."));
        } else {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.updating.entry", new Object[]{"JAASAuthData", string}, "Updating attributes of {0} entry {1}, it is already defined in the existing model."));
        }
    }

    public void setSslConfig(IIOPTransport iIOPTransport, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setSslConfig", (Object)new Object[]{iIOPTransport, string});
        iIOPTransport.setSslConfig(string);
    }

    public void setSslConfig(LDAPUserRegistry lDAPUserRegistry, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setSslConfig", (Object)new Object[]{lDAPUserRegistry, string});
        lDAPUserRegistry.setSslConfig(string);
    }

    public void setUseRegistryServerId(UserRegistry userRegistry, boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"setUseRegistryServerId", (Object)new Object[]{userRegistry, new Boolean(bl)});
        userRegistry.setUseRegistryServerId(true);
    }

    public boolean arePrimaryKeysEqual(Security security, Security security2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + security.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(SSLConfig sSLConfig, SSLConfig sSLConfig2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + sSLConfig.getClass().getName()));
        return sSLConfig.getAlias().equals(sSLConfig2.getAlias());
    }

    public boolean arePrimaryKeysEqual(LocalOSUserRegistry localOSUserRegistry, LocalOSUserRegistry localOSUserRegistry2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + localOSUserRegistry.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(CustomUserRegistry customUserRegistry, CustomUserRegistry customUserRegistry2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + customUserRegistry.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(LDAPUserRegistry lDAPUserRegistry, LDAPUserRegistry lDAPUserRegistry2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + lDAPUserRegistry.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(EndPoint endPoint, EndPoint endPoint2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + endPoint.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(SWAMAuthentication sWAMAuthentication, SWAMAuthentication sWAMAuthentication2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + sWAMAuthentication.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(LTPA lTPA, LTPA lTPA2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + lTPA.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(CustomAuthMechanism customAuthMechanism, CustomAuthMechanism customAuthMechanism2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + customAuthMechanism.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(TAInterceptor tAInterceptor, TAInterceptor tAInterceptor2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + tAInterceptor.getClass().getName()));
        if (tAInterceptor.getInterceptorClassName() == null) {
            return true;
        }
        return tAInterceptor.getInterceptorClassName().equals(tAInterceptor2.getInterceptorClassName());
    }

    public boolean arePrimaryKeysEqual(JAASConfigurationEntry jAASConfigurationEntry, JAASConfigurationEntry jAASConfigurationEntry2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + jAASConfigurationEntry.getClass().getName()));
        return jAASConfigurationEntry.getAlias().equals(jAASConfigurationEntry2.getAlias());
    }

    public boolean arePrimaryKeysEqual(JAASLoginModule jAASLoginModule, JAASLoginModule jAASLoginModule2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + jAASLoginModule.getClass().getName()));
        String string = jAASLoginModule.getModuleClassName();
        String string2 = jAASLoginModule2.getModuleClassName();
        if (string.equals("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy")) {
            Iterator iterator = jAASLoginModule.getOptions().iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (!property.getName().equals("delegate")) continue;
                string = property.getValue();
                if (string2.equals("com.ibm.ws.security.common.auth.module.proxy.WSLoginModuleProxy")) {
                    Iterator iterator2 = jAASLoginModule2.getOptions().iterator();
                    while (iterator2.hasNext()) {
                        Property property2 = (Property)iterator2.next();
                        if (!property2.getName().equals("delegate")) continue;
                        return string.equals(property2.getValue());
                    }
                    continue;
                }
                return string.equals(string2);
            }
        }
        return string.equals(jAASLoginModule2.getModuleClassName());
    }

    public boolean arePrimaryKeysEqual(IdentityAssertionLayer identityAssertionLayer, IdentityAssertionLayer identityAssertionLayer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + identityAssertionLayer.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(MessageLayer messageLayer, MessageLayer messageLayer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + messageLayer.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(TransportLayer transportLayer, TransportLayer transportLayer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + transportLayer.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(ServerIdentity serverIdentity, ServerIdentity serverIdentity2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + serverIdentity.getClass().getName()));
        return serverIdentity.getServerId().equals(serverIdentity2.getServerId());
    }

    public boolean arePrimaryKeysEqual(JAASAuthData jAASAuthData, JAASAuthData jAASAuthData2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + jAASAuthData.getClass().getName()));
        return jAASAuthData.getAlias().equals(jAASAuthData2.getAlias());
    }

    public boolean arePrimaryKeysEqual(WIMUserRegistry wIMUserRegistry, WIMUserRegistry wIMUserRegistry2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + wIMUserRegistry.getClass().getName()));
        return wIMUserRegistry.getServerId().equals(wIMUserRegistry2.getServerId());
    }

    public boolean arePrimaryKeysEqual(ManagementScope managementScope, ManagementScope managementScope2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + managementScope.getClass().getName()));
        return managementScope.getScopeName().equals(managementScope2.getScopeName());
    }

    public boolean arePrimaryKeysEqual(SSLConfigGroup sSLConfigGroup, SSLConfigGroup sSLConfigGroup2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + sSLConfigGroup.getClass().getName()));
        if (sSLConfigGroup.getName().equals(sSLConfigGroup2.getName())) {
            return sSLConfigGroup.getDirection().equals(sSLConfigGroup2.getDirection());
        }
        return sSLConfigGroup.getName().equals(sSLConfigGroup2.getName());
    }

    public boolean arePrimaryKeysEqual(KeyReference keyReference, KeyReference keyReference2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + keyReference.getClass().getName()));
        return keyReference.getKeyAlias().equals(keyReference2.getKeyAlias());
    }

    protected KeyStore convertCryptoHardwareToken(SecureSocketLayer secureSocketLayer) {
        Tr.entry((TraceComponent)_tc, (String)"convertCryptoHardwareToken", (Object)secureSocketLayer);
        CryptoHardwareToken cryptoHardwareToken = secureSocketLayer.getCryptoHardware();
        SslFactory sslFactory = SslPackage.eINSTANCE.getSslFactory();
        String string = cryptoHardwareToken.getLibraryFile();
        Property property = null;
        String string2 = null;
        String string3 = null;
        KeyStore keyStore = sslFactory.createKeyStore();
        ++_keyStoreCount;
        for (int i = 0; i < _customProperties.size(); ++i) {
            property = (Property)_customProperties.get(i);
            if (!property.getName().equals("com.ibm.ssl.tokenSlot")) continue;
            string2 = property.getValue();
            _customProperties.remove(i);
            string = string + ":" + string2;
            --i;
        }
        string3 = !OSInfoFactory.isZSeries() ? "IBMPKCS11Impl" : "JCE4758KS";
        keyStore.setLocation(string);
        keyStore.setPassword(cryptoHardwareToken.getPassword());
        keyStore.setType(cryptoHardwareToken.getTokenType());
        keyStore.setProvider(string3);
        keyStore.setFileBased(false);
        keyStore.setInitializeAtStartup(false);
        keyStore.setManagementScope(_managementScope);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(_keyStoreName);
        stringBuffer.append("_");
        stringBuffer.append(_keyStoreCount);
        keyStore.setName(stringBuffer.toString());
        return keyStore;
    }

    protected void initializeSSLVariables(Security security) {
        int n;
        Tr.entry((TraceComponent)_tc, (String)"initializeSecurityVariables", (Object)security);
        EList eList = security.getManagementScopes();
        if (eList.size() > 0) {
            _managementScope = (ManagementScope)eList.get(0);
        }
        _keyStoreList = security.getKeyStores();
        EList eList2 = security.getKeyManagers();
        EList eList3 = security.getTrustManagers();
        for (n = 0; n < eList2.size() && !(_keyManager = (KeyManager)eList2.get(n)).getName().equals("IbmX509"); ++n) {
        }
        for (n = 0; n < eList3.size() && !(_trustManager = (TrustManager)eList3.get(n)).getName().equals("IbmX509"); ++n) {
        }
        _customProperties = security.getProperties();
    }

    protected boolean getSystemSSL() {
        Tr.entry((TraceComponent)_tc, (String)"getSystemSSL");
        return this._systemSSL;
    }

    protected boolean getDaemonConfig() {
        Tr.entry((TraceComponent)_tc, (String)"getDaemonConfig");
        return this._daemonConfig;
    }

    protected boolean checkDaemonSSLConfig(SSLConfig sSLConfig) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"checkDaemonSSLConfig", (Object)sSLConfig);
        boolean bl = false;
        String string = sSLConfig.getAlias();
        if (((ReleaseVersionImpl)_scenario.getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)_scenario.getOldProductImage().getReleaseVersion()).isR51()) {
            WCCMDocument wCCMDocument = (WCCMDocument)_scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].openDocument("variables.xml", WCCMDocument.class, false, true);
            VariableMap variableMap = (VariableMap)UtilityImpl.locateConfigFileObject(wCCMDocument, VariableMap.class);
            Iterator iterator = variableMap.getEntries().iterator();
            while (iterator.hasNext()) {
                VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)iterator.next();
                if (!variableSubstitutionEntry.getSymbolicName().contains("DAEMON") || variableSubstitutionEntry.getValue() == null || !variableSubstitutionEntry.getValue().equals(string)) continue;
                bl = true;
                break;
            }
            wCCMDocument.close();
        } else {
            WCCMDocument wCCMDocument = (WCCMDocument)_scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getChild("nodegroups").getChild("DefaultNodeGroup").openDocument("nodegroup.xml", WCCMDocument.class, false, true);
            NodeGroup nodeGroup = (NodeGroup)UtilityImpl.locateConfigFileObject(wCCMDocument, NodeGroup.class);
            Iterator iterator = nodeGroup.getProperties().iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (!property.getName().contains("DAEMON") || property.getValue() == null || !property.getValue().equals(string)) continue;
                bl = true;
                break;
            }
            wCCMDocument.close();
        }
        return bl;
    }

    protected String fixUpPath(String string) {
        Tr.entry((TraceComponent)_tc, (String)"fixUpPath", (Object)string);
        String string2 = _scenario.getNewProductImage().getProfile().getDirectory().getAbsolutePath();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.replace(0, string2.length(), "${USER_INSTALL_ROOT}");
        string = stringBuffer.toString();
        return string.replace('\\', '/');
    }

    protected void processPath(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processPath", (Object)string);
        String string2 = this._oldCurrentLevelVariables.getProperty("WAS_INSTALL_ROOT");
        String string3 = this._oldCurrentLevelVariables.getProperty("USER_INSTALL_ROOT");
        string3 = UtilityImpl.resolveEntryPath(string3, this._oldCurrentLevelVariables);
        string = UtilityImpl.resolveEntryPath(string, this._oldCurrentLevelVariables);
        if (string.startsWith("..")) {
            string = new File(string2, string).getAbsolutePath();
        }
        String string4 = UtilityImpl.makePathCommon(string).substring(UtilityImpl.makePathCommon(string).lastIndexOf("/") + 1);
        String string5 = null;
        File file = null;
        if (UtilityImpl.makePathCommon(string).startsWith(UtilityImpl.makePathCommon(string3))) {
            string5 = string.substring(string3.length() + 1);
            file = new File(UpgradeBase.get_newOSInfo().userRoot(), string5);
            DocumentCollection documentCollection = this.getTransform().getScenario().getOldProductImage().getProfile().getDocumentCollection().getDocumentCollection(new File(string).toURL());
            this.copyDummy(documentCollection, new File(string), file);
        } else if (UtilityImpl.makePathCommon(string).startsWith(UtilityImpl.makePathCommon(string2))) {
            string5 = string.substring(string2.length() + 1);
            file = new File(UpgradeBase.get_userRoot(), string5);
            DocumentCollection documentCollection = this.getTransform().getScenario().getOldProductImage().getDocumentCollection().getDocumentCollection(new File(string).toURL());
            this.copyDummy(documentCollection, new File(string), file);
        }
    }

    public static Security getOldSecurityObject() {
        return _oldSecurityObject;
    }

    public static Security getNewSecurityObject() {
        return _newSecurityObject;
    }

    public void processContents(List list, List list2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processContents");
        super.processContents(list, list2);
        this.processSecurityUpdates(list, list2);
    }

    protected void processSecurityUpdates(List list, List list2) throws Exception {
        Security security;
        Tr.entry((TraceComponent)_tc, (String)"processSecurityUpdates", (Object)new Object[]{list, list2});
        this._oldConfiguration = new Configuration(new File(this.getTransform().getScenario().getOldProductImage().getProfile().getDirectory(), "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
        Security security2 = (Security)list2.get(0);
        if ("servers".equals(this.getTransform().getParent().getName())) {
            security = (Security)list.get(0);
            if (!security.isSetEnabled()) {
                security2.unsetEnabled();
            }
            if (!security.isSetAppEnabled()) {
                if (security.isSetEnabled()) {
                    security2.setAppEnabled(security.isEnabled());
                } else {
                    security2.unsetAppEnabled();
                }
            }
            if (!security.isSetUseLocalSecurityServer()) {
                security2.unsetUseLocalSecurityServer();
            }
            if (!security.isSetUseDomainQualifiedUserNames()) {
                security2.unsetUseDomainQualifiedUserNames();
            }
            if (!security.isSetCacheTimeout()) {
                security2.unsetCacheTimeout();
            }
            if (!security.isSetIssuePermissionWarning()) {
                security2.unsetIssuePermissionWarning();
            }
            if (!security.isSetAllowAllPermissionForApplication()) {
                security2.unsetAllowAllPermissionForApplication();
            }
            if (!security.isSetActiveProtocol()) {
                security2.unsetActiveProtocol();
            }
            if (!security.isSetEnforceJava2Security()) {
                security2.unsetEnforceJava2Security();
            }
            if (!security.isSetEnableJava2SecRuntimeFiltering()) {
                security2.unsetEnableJava2SecRuntimeFiltering();
            }
            if (!security.isSetEnforceFineGrainedJCASecurity()) {
                security2.unsetEnforceFineGrainedJCASecurity();
            }
        }
        if (!this._oldConfiguration.isFederatedNode() && WASPostUpgrade.is_wasPostUpgrade() && this.getTransform().getNewDocumentCollection().getParent().getName().equals("cells")) {
            Tr.debug((TraceComponent)_tc, (String)"Replacing P12 KeyStores");
            this.replaceNewKeyStores(security2);
        }
        if (this._oldConfiguration.isDeploymentManagerConfiguration() && (((ReleaseVersionImpl)_scenario.getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)_scenario.getOldProductImage().getReleaseVersion()).isR51())) {
            security = null;
            for (int i = 0; i < _customProperties.size(); ++i) {
                security = (Property)_customProperties.get(i);
                if (!security.getName().equals("com.ibm.ws.security.webInboundPropagationEnabled") || !security.getValue().equals("true")) continue;
                Tr.debug((TraceComponent)_tc, (String)"Update com.ibm.ws.security.webInboundPropagationEnabled with value false");
                security.setValue("false");
            }
        }
        if (!WASPostUpgrade.is_wasPostUpgrade()) {
            this.removeOldSSLProperties(security2);
        }
        if (!this._oldConfiguration.isFederatedNode()) {
            if (!WASPostUpgrade.is_scriptCompatibility()) {
                Tr.debug((TraceComponent)_tc, (String)"Adding TrustStores to JSSE SSLConfigs");
                this.addTrustStores(security2);
            }
            if (this.getTransform().getNewDocumentCollection().getParent().getName().equals("cells")) {
                _oldSecurityObject = (Security)list.get(0);
                _newSecurityObject = (Security)list2.get(0);
            }
            this.moveSAFPropertiesTop(security2);
        }
    }

    protected void addTrustStores(Security security) {
        Tr.entry((TraceComponent)_tc, (String)"addTrustStores", (Object)security);
        EList eList = security.getRepertoire();
        SSLConfig sSLConfig = null;
        SecureSocketLayer secureSocketLayer = null;
        Object var5_5 = null;
        Object var6_6 = null;
        for (int i = 0; i < eList.size(); ++i) {
            sSLConfig = (SSLConfig)eList.get(i);
            secureSocketLayer = sSLConfig.getSetting();
            if (secureSocketLayer.getTrustStore() != null) continue;
            secureSocketLayer.setTrustStore(secureSocketLayer.getKeyStore());
            secureSocketLayer.getTrustManager().add((Object)_trustManager);
        }
    }

    protected void removeOldSSLProperties(Security security) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"removeOldSSLProperties", (Object)security);
        EList eList = security.getRepertoire();
        SSLConfig sSLConfig = null;
        SecureSocketLayer secureSocketLayer = null;
        EList eList2 = null;
        Property property = null;
        for (int i = 0; i < eList.size(); ++i) {
            sSLConfig = (SSLConfig)eList.get(i);
            secureSocketLayer = sSLConfig.getSetting();
            secureSocketLayer.setKeyFileFormat(null);
            secureSocketLayer.setTrustFileFormat(null);
            eList2 = secureSocketLayer.getProperties();
            for (int j = 0; j < eList2.size(); ++j) {
                property = (Property)eList2.get(j);
                if (!property.getName().equals("com.ibm.ssl.protocol") && !property.getName().equals("com.ibm.ssl.contextProvider") && !property.getName().equals("com.ibm.ssl.enabledCipherSuites")) continue;
                eList2.remove(j);
                --j;
            }
        }
    }

    protected void moveSAFPropertiesTop(Security security) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"moveSAFPropertiesTop", (Object)security);
        String string = "com.ibm.security.SAF.unauthenticated";
        String string2 = "com.ibm.security.SAF.authorization";
        String string3 = "com.ibm.security.SAF.delegation";
        String string4 = "com.ibm.security.SAF.EJBROLE.Audit.Messages.Suppress";
        String string5 = "";
        if (security != null && security.getActiveUserRegistry() != null) {
            EList eList = security.getActiveUserRegistry().getProperties();
            EList eList2 = security.getProperties();
            Property property = null;
            for (int i = 0; i < eList.size(); ++i) {
                property = (Property)eList.get(i);
                string5 = property.getName();
                if (!string5.equals(string) && !string5.equals(string2) && !string5.equals(string3) && !string5.equals(string4)) continue;
                eList2.add(property);
                Tr.debug((TraceComponent)_tc, (String)("Moved property " + string5 + " from active UserRegistry " + " to top level."));
                --i;
            }
        }
    }

    protected boolean isBacklevelNodeSSSL(Security security, SSLConfig sSLConfig, Configuration configuration, String string, String string2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"isBacklevelNodeSSSL", (Object)new Object[]{security, sSLConfig, configuration, string, string2});
        boolean bl = false;
        if (sSLConfig.getType().equals(SSLType.SSSL_LITERAL) && configuration.isDeploymentManagerConfiguration()) {
            String string3 = null;
            int n = string2.indexOf("/");
            string3 = n != -1 ? string2.substring(0, n) : string2;
            if (!string3.equals(string) && (string2.endsWith("DefaultIIOPSSL") || string2.endsWith("DefaultHTTPS") || this.isZOSTransportSSLconfig(security, string2))) {
                bl = true;
                Tr.debug((TraceComponent)_tc, (String)("The repertoire with alias name: " + string2 + " will not be convert from SSSL to JSSE."));
            }
        }
        return bl;
    }

    protected boolean isZOSTransportSSLconfig(Security security, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"isZOSTransportSSLconfig", (Object)new Object[]{security, string});
        boolean bl = false;
        String string2 = "was.com.ibm.websphere.security.zos.csiv2.inbound.transport.sslconfig";
        String string3 = "was.com.ibm.websphere.security.zos.csiv2.outbound.transport.sslconfig";
        String string4 = "";
        EList eList = security.getProperties();
        Property property = null;
        for (int i = 0; i < eList.size(); ++i) {
            property = (Property)eList.get(i);
            string4 = property.getName();
            if (!string4.equals(string2) && !string4.equals(string3) || !string.equals(property.getValue())) continue;
            Tr.debug((TraceComponent)_tc, (String)("repertoire's alias name " + string + " is referenced by: " + string4 + " will not be converted to JSSE"));
            return true;
        }
        return bl;
    }

    protected void replaceNewKeyStores(Security security) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"replaceNewKeyStores", (Object)security);
        EList eList = security.getKeyStores();
        KeyStore keyStore = null;
        for (int i = 0; i < eList.size(); ++i) {
            Object object;
            boolean bl;
            String string;
            SecureSocketLayer secureSocketLayer;
            keyStore = (KeyStore)eList.get(i);
            if (!(!keyStore.getLocation().endsWith("key.p12") || this.isCellDefaultSSLSettingsKeyStore(security, keyStore) && _isMixedZOSAndDist)) {
                Tr.debug((TraceComponent)_tc, (String)"found key.p12, will replace with old KeyStore values");
                secureSocketLayer = this._defaultSSLConfig.getSetting();
                string = UtilityImpl.fixUpPath(secureSocketLayer.getKeyFileName(), this._oldCurrentLevelVariables, this._newCurrentLevelVariables);
                if (this._defaultSSLConfig.getType().equals(SSLType.SSSL_LITERAL)) {
                    this._systemSSL = true;
                    this._daemonConfig = this.checkDaemonSSLConfig(this._defaultSSLConfig);
                }
                if (bl = secureSocketLayer.isEnableCryptoHardwareSupport()) {
                    object = this.convertCryptoHardwareToken(secureSocketLayer);
                    keyStore.setLocation(object.getLocation());
                    keyStore.setPassword(object.getPassword());
                    keyStore.setType(object.getType());
                    keyStore.setFileBased(false);
                    keyStore.setInitializeAtStartup(false);
                    keyStore.setManagementScope(_managementScope);
                } else if (string != null) {
                    if (this.getSystemSSL() && !this.getDaemonConfig()) {
                        string = SecurityConfig.updateRACFlocation(string);
                        secureSocketLayer.setKeyFilePassword("password");
                        secureSocketLayer.setKeyFileFormat(KeyFileFormatKind.JCERACFKS_LITERAL);
                    }
                    boolean bl2 = true;
                    String string2 = secureSocketLayer.getKeyFileFormat().getName();
                    if (string2.equals("JCERACFKS") || string2.equals("JCE4758KS")) {
                        bl2 = false;
                    }
                    keyStore.setLocation(string);
                    keyStore.setPassword(secureSocketLayer.getKeyFilePassword());
                    keyStore.setType(string2);
                    keyStore.setFileBased(bl2);
                    keyStore.setInitializeAtStartup(false);
                    keyStore.setManagementScope(_managementScope);
                }
            } else if (!(!keyStore.getLocation().endsWith("trust.p12") || this.isCellDefaultSSLSettingsKeyStore(security, keyStore) && _isMixedZOSAndDist)) {
                Tr.debug((TraceComponent)_tc, (String)"found trust.p12, will replace with old TrustStore values");
                secureSocketLayer = this._defaultSSLConfig.getSetting();
                string = UtilityImpl.fixUpPath(secureSocketLayer.getTrustFileName(), this._oldCurrentLevelVariables, this._newCurrentLevelVariables);
                if (this._defaultSSLConfig.getType().equals(SSLType.SSSL_LITERAL)) {
                    this._systemSSL = true;
                    this._daemonConfig = this.checkDaemonSSLConfig(this._defaultSSLConfig);
                }
                if (string != null) {
                    if (this.getSystemSSL() && !this.getDaemonConfig()) {
                        string = SecurityConfig.updateRACFlocation(string);
                        secureSocketLayer.setTrustFilePassword("password");
                        secureSocketLayer.setTrustFileFormat(KeyFileFormatKind.JCERACFKS_LITERAL);
                    }
                    bl = true;
                    object = secureSocketLayer.getTrustFileFormat().getName();
                    if (((String)object).equals("JCERACFKS") || ((String)object).equals("JCE4758KS")) {
                        bl = false;
                    }
                    keyStore.setLocation(string);
                    keyStore.setPassword(secureSocketLayer.getTrustFilePassword());
                    keyStore.setType((String)object);
                    keyStore.setFileBased(bl);
                    keyStore.setInitializeAtStartup(false);
                    keyStore.setManagementScope(_managementScope);
                }
            }
            Tr.event((TraceComponent)_tc, (String)"update keyfiles processing: ", (Object)new Object[]{keyStore.getLocation()});
            if (keyStore.getLocation() == null || !keyStore.getLocation().startsWith("safkeyring:")) continue;
            keyStore.setFileBased(false);
            keyStore.setType(KeyFileFormatKind.JCERACFKS_LITERAL.getName());
            Tr.event((TraceComponent)_tc, (String)("-changing file format and type for : " + keyStore.getLocation()), (Object)new Object[]{keyStore.isFileBased(), keyStore.getType()});
        }
    }

    protected boolean isCellDefaultSSLSettingsKeyStore(Security security, KeyStore keyStore) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"isCellDefaultSSLSettingsKeyStore", (Object)new Object[]{security, keyStore});
        boolean bl = false;
        EList eList = security.getRepertoire();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            SSLConfig sSLConfig = (SSLConfig)iterator.next();
            String string = sSLConfig.getAlias();
            if (!string.equals("CellDefaultSSLSettings") || sSLConfig.getSetting().getKeyStore() != keyStore && sSLConfig.getSetting().getTrustStore() != keyStore) continue;
            Tr.debug((TraceComponent)_tc, (String)"found CellDefaultSSLSettings KeyStore ", (Object)keyStore.getName());
            return true;
        }
        return bl;
    }

    protected void updateSSLConfigGroups(List list) {
        Tr.entry((TraceComponent)_tc, (String)"updateSSLConfigGroups", (Object)list);
        for (int i = 0; i < list.size(); ++i) {
            SSLConfigGroup sSLConfigGroup = (SSLConfigGroup)list.get(i);
            if (this._defaultSSLConfig != null) {
                String string = this._defaultSSLConfig.getSetting().getClientKeyAlias();
                if (string == null) {
                    String string2 = this._defaultSSLConfig.getSetting().getServerKeyAlias();
                    sSLConfigGroup.setCertificateAlias(string2);
                    continue;
                }
                sSLConfigGroup.setCertificateAlias(string);
                continue;
            }
            sSLConfigGroup.setCertificateAlias(null);
        }
    }

    protected void copyDummy(DocumentCollection documentCollection, File file, File file2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyDummy", (Object)new Object[]{documentCollection, file, file2});
        String string = this._newCurrentLevelVariables.getProperty("WAS_INSTALL_ROOT");
        String string2 = this._newCurrentLevelVariables.getProperty("USER_INSTALL_ROOT");
        string2 = UtilityImpl.resolveEntryPath(string2, this._oldCurrentLevelVariables);
        String[] stringArray = documentCollection.getHierarchicalName();
        BasicDocument basicDocument = (BasicDocument)documentCollection.openDocument(file.getName(), BasicDocument.class);
        DocumentCollection documentCollection2 = null;
        if (UtilityImpl.makePathCommon(file2.getAbsolutePath()).startsWith(UtilityImpl.makePathCommon(string2))) {
            documentCollection2 = this.getTransform().getScenario().getNewProductImage().getProfile().getDocumentCollection();
        } else if (UtilityImpl.makePathCommon(file2.getAbsolutePath()).startsWith(UtilityImpl.makePathCommon(string))) {
            documentCollection2 = this.getTransform().getScenario().getNewProductImage().getDocumentCollection();
        }
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                documentCollection2 = documentCollection2.getChild(stringArray[i]);
                continue;
            }
            catch (NotFoundException notFoundException) {
                documentCollection2 = documentCollection2.addDocumentCollection(stringArray[i]);
            }
        }
        if (!documentCollection2.documentExists(file2.getName())) {
            BasicDocument basicDocument2 = (BasicDocument)documentCollection2.openDocument(file2.getName(), BasicDocument.class, true, false);
            basicDocument2.setInputStream(basicDocument.getInputStream());
            basicDocument2.close();
        }
        basicDocument.close();
    }

    public String getKeyFileName(boolean bl, SecureSocketLayer secureSocketLayer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getKeyFileName", (Object)secureSocketLayer);
        String string = secureSocketLayer.getKeyFileName();
        if (bl && string != null) {
            this.processPath(string);
        }
        return string;
    }

    public String getTrustFileName(boolean bl, SecureSocketLayer secureSocketLayer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getTrustFileName", (Object)secureSocketLayer);
        String string = secureSocketLayer.getTrustFileName();
        if (bl && string != null) {
            this.processPath(string);
        }
        return string;
    }

    public static String updateRACFlocation(String string) {
        String string2 = string;
        if (!string.startsWith(prefix)) {
            string2 = prefix + string;
        }
        return string2;
    }
}

