/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBContainer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.SSLOutboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.loggingservice.ras.ServiceLog;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.orb.Interceptor;
import com.ibm.websphere.models.config.orb.ORBPlugin;
import com.ibm.websphere.models.config.orb.ObjectRequestBroker;
import com.ibm.websphere.models.config.pmirm.PMIRMArmType;
import com.ibm.websphere.models.config.pmirm.PMIRequestMetrics;
import com.ibm.websphere.models.config.pmiservice.PMIService;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.StreamRedirect;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.JavaVirtualMachine;
import com.ibm.websphere.models.config.processexec.OutputRedirect;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.processexec.ProcessexecFactory;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.traceservice.TraceLog;
import com.ibm.websphere.models.config.webserver.PluginProperties;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.ServerDocumentCollectionPostImpl;
import com.ibm.ws.migration.document.TextDocument;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.postupgrade.common.ServerConfigCommon;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.ws.pmi.migration.PmiConfigMigrator;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.ServerDocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class ServerConfig
extends ServerConfigCommon {
    private static TraceComponent _tc = Tr.register((Class)ServerConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected String _serverType = null;
    public static Vector _jmsSets = new Vector();
    public static Vector _wsSets = new Vector();
    public ProcessDef _oldJavaProcessDef = null;
    protected String _oldPropName = null;
    protected String _oldPluginInstallRoot = null;
    protected static Scenario _scenario = null;
    static /* synthetic */ Class class$com$ibm$ws$migration$document$TextDocument;

    public ServerConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
        _scenario = documentTransform.getScenario();
        this.getProcessorHelper().addOverride(Server.class, "getServices", new Class[0]);
        this.getProcessorHelper().addOverride(Server.class, "getComponents", new Class[0]);
        this.getProcessorHelper().addOverride(ApplicationServer.class, "getComponents", new Class[0]);
        this.getProcessorHelper().addOverride(ApplicationServer.class, "getServices", new Class[0]);
        this.getProcessorHelper().addOverride(Transport.class, "setSslConfig", new Class[]{String.class});
        this.getProcessorHelper().addOverride(EndPoint.class, "setPort", new Class[]{Integer.TYPE});
        this.getProcessorHelper().addOverride(Property.class, "getValue", new Class[0]);
        this.getProcessorHelper().addOverride(Property.class, "setValue", new Class[]{String.class});
        this.getProcessorHelper().addOverride(JavaProcessDef.class, "setStartCommand", new Class[]{String.class});
        this.getProcessorHelper().addOverride(TraceLog.class, "setFileName", new Class[]{String.class});
        this.getProcessorHelper().addOverride(ServiceLog.class, "setName", new Class[]{String.class});
        this.getProcessorHelper().addOverride(EJBContainer.class, "setPassivationDirectory", new Class[]{String.class});
        this.getProcessorHelper().addOverride(JavaProcessDef.class, "setExecutableName", new Class[]{String.class});
        this.getProcessorHelper().addOverride(JavaProcessDef.class, "setWorkingDirectory", new Class[]{String.class});
        this.getProcessorHelper().addOverride(OutputRedirect.class, "setStderrFilename", new Class[]{String.class});
        this.getProcessorHelper().addOverride(OutputRedirect.class, "setStdoutFilename", new Class[]{String.class});
        this.getProcessorHelper().addOverride(OutputRedirect.class, "setStdinFilename", new Class[]{String.class});
        this.getProcessorHelper().addOverride(StreamRedirect.class, "setFileName", new Class[]{String.class});
        this.getProcessorHelper().addOverride(JavaVirtualMachine.class, "getSystemProperties", new Class[0]);
        this.getProcessorHelper().addOverride(WebContainer.class, "getProperties", new Class[0]);
        this.getProcessorHelper().addOverride(PMIService.class, "getInitialSpecLevel", new Class[0]);
        this.getProcessorHelper().addOverride(JavaProcessDef.class, "getStartCommandArgs", new Class[0]);
        this.getProcessorHelper().addOverride(JavaProcessDef.class, "getStartCommand", new Class[0]);
        this.getProcessorHelper().addOverride(JavaVirtualMachine.class, "setInitialHeapSize", new Class[]{Integer.TYPE});
        this.getProcessorHelper().addOverride(JavaVirtualMachine.class, "setMaximumHeapSize", new Class[]{Integer.TYPE});
        this.getProcessorHelper().addOverride(ObjectRequestBroker.class, "getInterceptors", new Class[0]);
        this.getProcessorHelper().addOverride(ObjectRequestBroker.class, "getPlugins", new Class[0]);
        this.getProcessorHelper().addOverride(TransactionService.class, "setTransactionLogDirectory", new Class[]{String.class});
        this.getProcessorHelper().addOverride(Server.class, "getProcessDefinition", new Class[0]);
        this.getProcessorHelper().addOverride(PluginProperties.class, "getPluginInstallRoot", new Class[0]);
        this._serverType = ((ServerDocumentCollectionPostImpl)this.getTransform().getNewDocumentCollection()).getServerType();
        if (this._serverType == null) {
            this._serverType = "WEB_SERVER";
        }
        if ("WEB_SERVER".equals(this._serverType)) {
            Vector<String> vector = new Vector<String>();
            vector.add(((ProfileImpl)this.getTransform().getScenario().getNewProductImage().getProfile()).getOwningNodeName());
            vector.add(this._serverName);
            vector.add(this.getHostName());
            _wsSets.add(vector);
        }
    }

    public String getPluginInstallRoot(boolean bl, PluginProperties pluginProperties) throws Exception {
        if (bl) {
            this._oldPluginInstallRoot = pluginProperties.getPluginInstallRoot();
        }
        return pluginProperties.getPluginInstallRoot();
    }

    protected String getHostName() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getHostName");
        WCCMDocument wCCMDocument = (WCCMDocument)this.getTransform().getOldDocumentCollection().getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class, false, true);
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        wCCMDocument.close();
        return serverIndex.getHostName();
    }

    public void processContents(List list, List list2) throws Exception {
        if (!this._serverName.equals("nodeagent") && (this._serverType != null && this._serverType != "WEB_SERVER" || !((ProfileImpl)this.getTransform().getScenario().getOldProductImage().getProfile()).isApplicationServer())) {
            this.cleanUpChannelsTransports();
        }
        try {
            if (this.checkMixedZOSAndDist()) {
                this.updateTransportChannelsSSLConfigAlias(list, list2);
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Failed to checkMixedzOSAndDist and updateTransportChannelsSSLConfigAlias: ", (Object)exception);
        }
        super.processContents(list, list2);
        if (this._serverType.equals("WEB_SERVER")) {
            this.updateWebServerConfigAndPluginFileNames((Server)list2.get(0));
        }
        this.convertObjectRequestBroker(list2);
        if (OSInfoFactory.isZSeries()) {
            this.disableSIPChains(list2);
            this.updateAdminChains(list2);
        }
        try {
            if (this.checkMixedZOSAndDist()) {
                this.updateORBSSLListenerConfigAlias(list2);
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Failed to checkMixedzOSAndDist and updateORSSLListenerConfigAlias: ", (Object)exception);
        }
    }

    protected void updateTransportChannelsSSLConfigAlias(List list, List list2) {
        Object object;
        Iterator iterator;
        Object object2;
        Object object3;
        Tr.entry((TraceComponent)_tc, (String)"updateTransportChannelsSSLConfigAlias");
        String string = null;
        String string2 = ((ProfileImpl)_scenario.getOldProductImage().getProfile()).getOwningNodeName();
        String string3 = string2 + "/DefaultSSLSettings";
        String string4 = string2 + "/DefaultHTTPS";
        Server server = (Server)list.get(0);
        WebContainer webContainer = null;
        Iterator iterator2 = server.getComponents().iterator();
        block0: while (iterator2.hasNext()) {
            object3 = iterator2.next();
            if (!(object3 instanceof ApplicationServer)) continue;
            object2 = (ApplicationServer)object3;
            iterator = object2.getComponents().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof WebContainer)) continue;
                webContainer = (WebContainer)object;
                continue block0;
            }
        }
        if (webContainer != null) {
            object3 = webContainer.getTransports().iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                if (!(object2 instanceof Transport) || !(iterator = (Transport)object2).isSslEnabled()) continue;
                string = iterator.getSslConfig();
                object = null;
                int n = string.indexOf("/");
                if (n == -1 || (object = string.substring(0, n)) == string2) continue;
                Tr.debug((TraceComponent)_tc, (String)" sslEnabledTransportAlias alias NodeName don't match the corresponding node name, change it to use the correct one ", (Object)string);
                string = string2 + string.substring(n, string.length());
                iterator.setSslConfig(string);
            }
        }
        object3 = (Server)list2.get(0);
        object2 = object3.getServices().iterator();
        while (object2.hasNext()) {
            iterator = object2.next();
            if (!(iterator instanceof TransportChannelService)) continue;
            object = (TransportChannelService)iterator;
            Iterator iterator3 = object.getTransportChannels().iterator();
            while (iterator3.hasNext()) {
                SSLInboundChannel sSLInboundChannel;
                TransportChannel transportChannel = (TransportChannel)iterator3.next();
                if (transportChannel instanceof SSLInboundChannel && (sSLInboundChannel = (SSLInboundChannel)transportChannel).getSslConfigAlias() == null) {
                    if (string != null) {
                        sSLInboundChannel.setSslConfigAlias(string);
                        Tr.debug((TraceComponent)_tc, (String)("set sslInboundChannel : " + sSLInboundChannel.getName() + " to " + string));
                    } else if (OSInfoFactory.isZSeries()) {
                        sSLInboundChannel.setSslConfigAlias(string4);
                        Tr.debug((TraceComponent)_tc, (String)("set sslInboundChannel : " + sSLInboundChannel.getName() + " to " + string4));
                    } else {
                        sSLInboundChannel.setSslConfigAlias(string3);
                        Tr.debug((TraceComponent)_tc, (String)("set sslInboundChannel : " + sSLInboundChannel.getName() + " to " + string3));
                    }
                }
                if (!(transportChannel instanceof SSLOutboundChannel) || (sSLInboundChannel = (SSLOutboundChannel)transportChannel).getSslConfigAlias() != null) continue;
                if (string != null) {
                    sSLInboundChannel.setSslConfigAlias(string);
                    Tr.debug((TraceComponent)_tc, (String)("set sslOutboundChannel : " + sSLInboundChannel.getName() + " to " + string));
                    continue;
                }
                if (OSInfoFactory.isZSeries()) {
                    sSLInboundChannel.setSslConfigAlias(string4);
                    Tr.debug((TraceComponent)_tc, (String)("set sslOutboundChannel : " + sSLInboundChannel.getName() + " to " + string4));
                    continue;
                }
                sSLInboundChannel.setSslConfigAlias(string3);
                Tr.debug((TraceComponent)_tc, (String)("set sslOutboundChannel : " + sSLInboundChannel.getName() + " to " + string3));
            }
        }
    }

    protected void updateORBSSLListenerConfigAlias(List list) {
        Tr.entry((TraceComponent)_tc, (String)"updateORBSSLListenerConfigAlias", (Object)new Object[]{list});
        String string = ((ProfileImpl)_scenario.getOldProductImage().getProfile()).getOwningNodeName();
        String string2 = string + "/DefaultIIOPSSL";
        Server server = (Server)list.get(0);
        Iterator iterator = server.getServices().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TransportChannelService)) continue;
            TransportChannelService transportChannelService = (TransportChannelService)e;
            Iterator iterator2 = transportChannelService.getTransportChannels().iterator();
            while (iterator2.hasNext()) {
                SSLInboundChannel sSLInboundChannel;
                TransportChannel transportChannel = (TransportChannel)iterator2.next();
                if (!(transportChannel instanceof SSLInboundChannel) || !(sSLInboundChannel = (SSLInboundChannel)transportChannel).getName().equals("ORB_SSL_LISTENER") || !OSInfoFactory.isZSeries()) continue;
                sSLInboundChannel.setSslConfigAlias(string2);
                Tr.debug((TraceComponent)_tc, (String)("set sslInboundChannel : " + sSLInboundChannel.getName() + " to " + string2));
            }
        }
    }

    protected boolean checkMixedZOSAndDist() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"checkMixedZOSAndDist");
        DocumentCollection[] documentCollectionArray = this.getTransform().getOldDocumentCollection().getParent().getParent().getParent().getChildren();
        if (!this.isDmgrOnZOS(documentCollectionArray)) {
            return false;
        }
        String string = "com.ibm.websphere.nodeOperatingSystem";
        for (int i = 0; i < documentCollectionArray.length; ++i) {
            if (!documentCollectionArray[i].documentExists("node-metadata.properties")) continue;
            TextDocument textDocument = (TextDocument)documentCollectionArray[i].openDocument("node-metadata.properties", class$com$ibm$ws$migration$document$TextDocument == null ? ServerConfig.class$("com.ibm.ws.migration.document.TextDocument") : class$com$ibm$ws$migration$document$TextDocument, false, true);
            if (textDocument != null) {
                Properties properties = new Properties();
                properties.load(textDocument.getInputStream());
                String string2 = (String)properties.get(string);
                if (string2 != null && !string2.equalsIgnoreCase("os390")) {
                    Tr.debug((TraceComponent)_tc, (String)"This is a mixed OS scenario where Dmgr is on zOS ");
                    return true;
                }
            }
            textDocument.close();
        }
        return false;
    }

    private boolean isDmgrOnZOS(DocumentCollection[] documentCollectionArray) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"isDmgrOnZOS", (Object)new Object[]{documentCollectionArray});
        boolean bl = false;
        for (int i = 0; i < documentCollectionArray.length; ++i) {
            WCCMDocument wCCMDocument = (WCCMDocument)documentCollectionArray[i].openDocument("serverindex.xml", class$com$ibm$wsspi$migration$document$wccm$WCCMDocument == null ? ServerConfig.class$("com.ibm.wsspi.migration.document.wccm.WCCMDocument") : class$com$ibm$wsspi$migration$document$wccm$WCCMDocument, false, true);
            ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, class$com$ibm$websphere$models$config$serverindex$ServerIndex == null ? ServerConfig.class$("com.ibm.websphere.models.config.serverindex.ServerIndex") : class$com$ibm$websphere$models$config$serverindex$ServerIndex);
            EList eList = serverIndex.getServerEntries();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry = (ServerEntry)iterator.next();
                if (!serverEntry.getServerType().equals("DEPLOYMENT_MANAGER") || !documentCollectionArray[i].documentExists("node-metadata.properties")) continue;
                TextDocument textDocument = (TextDocument)documentCollectionArray[i].openDocument("node-metadata.properties", class$com$ibm$ws$migration$document$TextDocument == null ? ServerConfig.class$("com.ibm.ws.migration.document.TextDocument") : class$com$ibm$ws$migration$document$TextDocument, false, true);
                if (textDocument != null) {
                    Properties properties = new Properties();
                    properties.load(textDocument.getInputStream());
                    String string = (String)properties.get("com.ibm.websphere.nodeOperatingSystem");
                    if (string != null && string.equalsIgnoreCase("os390")) {
                        Tr.debug((TraceComponent)_tc, (String)"Dmgr is on zOS");
                        bl = true;
                    }
                }
                textDocument.close();
            }
            wCCMDocument.close();
        }
        return bl;
    }

    protected void disableSIPChains(List list) {
        Tr.entry((TraceComponent)_tc, (String)"disableSIPChains", (Object)new Object[]{list});
        Server server = (Server)list.get(0);
        Iterator iterator = server.getServices().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TransportChannelService)) continue;
            TransportChannelService transportChannelService = (TransportChannelService)e;
            Iterator iterator2 = transportChannelService.getChains().iterator();
            while (iterator2.hasNext()) {
                Chain chain = (Chain)iterator2.next();
                if (!chain.getName().startsWith("SIP")) continue;
                chain.setEnable(false);
            }
        }
    }

    protected void updateAdminChains(List list) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"updateAdminChains", (Object)new Object[]{list});
        Configuration configuration = new Configuration(new File(this.getTransform().getScenario().getOldProductImage().getProfile().getDirectory(), "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
        if (!configuration.isDeploymentManagerConfiguration()) {
            this.disableAdminChains(list);
        } else if (WASPostUpgrade.is_scriptCompatibility()) {
            this.disableAdminChains(list);
        } else if (!WASPostUpgrade.is_wasPostUpgrade()) {
            this.enableAdminChains(list);
        }
    }

    protected void disableAdminChains(List list) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"disableAdminChains", (Object)new Object[]{list});
        Server server = (Server)list.get(0);
        Iterator iterator = server.getServices().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TransportChannelService)) continue;
            TransportChannelService transportChannelService = (TransportChannelService)e;
            Iterator iterator2 = transportChannelService.getChains().iterator();
            while (iterator2.hasNext()) {
                Chain chain = (Chain)iterator2.next();
                if (!chain.getName().equals("WCInboundAdmin") && !chain.getName().equals("WCInboundAdminSecure")) continue;
                chain.setEnable(false);
            }
        }
    }

    protected EList getWCInboundAdminChannels(TransportChannelService transportChannelService) {
        Tr.entry((TraceComponent)_tc, (String)"getWCInboundAdminChannels", (Object)new Object[]{transportChannelService});
        Iterator iterator = transportChannelService.getChains().iterator();
        while (iterator.hasNext()) {
            Chain chain = (Chain)iterator.next();
            if (!chain.getName().equals("WCInboundAdmin")) continue;
            return chain.getTransportChannels();
        }
        Tr.warning((TraceComponent)_tc, (String)"WCInboundAdmin was not found");
        return null;
    }

    protected EList getWCInboundAdminSecureChannels(TransportChannelService transportChannelService) {
        Tr.entry((TraceComponent)_tc, (String)"getWCInboundAdminSecureChannels", (Object)new Object[]{transportChannelService});
        Iterator iterator = transportChannelService.getChains().iterator();
        while (iterator.hasNext()) {
            Chain chain = (Chain)iterator.next();
            if (!chain.getName().equals("WCInboundAdminSecure")) continue;
            return chain.getTransportChannels();
        }
        Tr.warning((TraceComponent)_tc, (String)"WCInboundAdminSecure was not found");
        return null;
    }

    protected void enableAdminChains(List list) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"enableAdminChains", (Object)new Object[]{list});
        Tr.entry((TraceComponent)_tc, (String)"disableAdminChains", (Object)new Object[]{list});
        Server server = (Server)list.get(0);
        Iterator iterator = server.getServices().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TransportChannelService)) continue;
            TransportChannelService transportChannelService = (TransportChannelService)e;
            Iterator iterator2 = transportChannelService.getChains().iterator();
            while (iterator2.hasNext()) {
                Chain chain = (Chain)iterator2.next();
                if (!chain.getName().equals("WCInboundAdmin") && !chain.getName().equals("WCInboundAdminSecure")) continue;
                chain.setEnable(true);
            }
        }
    }

    public Document getTemplateDocument() {
        Tr.entry((TraceComponent)_tc, (String)"getTemplateDocument");
        return null;
    }

    protected void updateWebServerConfigAndPluginFileNames(Server server) {
        Tr.entry((TraceComponent)_tc, (String)"updateWebServerConfigAndPluginFileNames", (Object)server);
        Iterator iterator = server.getComponents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof WebServer)) continue;
            WebServer webServer = (WebServer)e;
            Iterator iterator2 = webServer.getPluginProperties().iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (!(e2 instanceof PluginProperties)) continue;
                PluginProperties pluginProperties = (PluginProperties)e2;
                String string = this._oldPluginInstallRoot + "/config/" + this._serverName + "/";
                String string2 = "plugin-cfg.xml";
                pluginProperties.setRemoteConfigFilename(string + string2);
                String string3 = "plugin-key.kdb";
                pluginProperties.setRemoteKeyRingFilename(string + string3);
            }
        }
    }

    public String getStartCommand(boolean bl, JavaProcessDef javaProcessDef) throws UpgradeException {
        String string;
        Tr.entry((TraceComponent)_tc, (String)"getStartCommand", (Object)new Object[]{new Boolean(bl), javaProcessDef});
        String string2 = javaProcessDef.getStartCommand();
        if (bl && (string = javaProcessDef.getProcessType()) != null) {
            if (string.equals("Control")) {
                if (WASPostUpgrade.get_controller() != null) {
                    string2 = "START " + WASPostUpgrade.get_controller();
                }
            } else if (string.equals("Servant")) {
                if (WASPostUpgrade.get_servant() != null) {
                    string2 = WASPostUpgrade.get_servant();
                }
            } else if (string.equals("Adjunct") && WASPostUpgrade.get_adjunct() != null) {
                string2 = WASPostUpgrade.get_adjunct();
            }
        }
        return string2;
    }

    public ProcessDef getProcessDefinition(boolean bl, Server server) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getProcessDefinition", (Object)new Object[]{new Boolean(bl), server});
        if (bl) {
            this._oldJavaProcessDef = server.getProcessDefinition();
        } else if (WASPostUpgrade.is_scriptCompatibility()) {
            server.getProcessDefinitions().clear();
        } else {
            JavaProcessDef javaProcessDef;
            Iterator iterator = server.getProcessDefinitions().iterator();
            boolean bl2 = false;
            while (iterator.hasNext()) {
                javaProcessDef = (ProcessDef)iterator.next();
                String string = javaProcessDef.getProcessType();
                String string2 = this._oldJavaProcessDef.getProcessType();
                if (string2 != null && string != null && !string2.equals(string)) continue;
                return javaProcessDef;
            }
            javaProcessDef = ProcessexecFactory.eINSTANCE.createJavaProcessDef();
            server.getProcessDefinitions().add((Object)javaProcessDef);
            return javaProcessDef;
        }
        return server.getProcessDefinition();
    }

    public void setProcessDefinition(Server server, ProcessDef processDef) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"setProcessDefinition", (Object)new Object[]{server, processDef});
        if (WASPostUpgrade.is_scriptCompatibility()) {
            server.setProcessDefinition(processDef);
        }
    }

    public List getTransports(boolean bl, WebContainer webContainer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getTransports", (Object)new Object[]{new Boolean(bl), webContainer});
        super.saveOldTransports(bl, webContainer);
        if (WASPostUpgrade.is_scriptCompatibility()) {
            return this.createTransports(bl, webContainer);
        }
        return this.createChannels(bl, webContainer);
    }

    public void setTransactionLogDirectory(TransactionService transactionService, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setTransactionLogDirectory()", (Object)new Object[]{transactionService, string});
        UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.deprecated.attribute", new Object[]{"transactionLogDirectory", "server.xml"}, "The {0} setting in file {1} has been deprecated, see infocenter for further information."));
        transactionService.setTransactionLogDirectory(string);
    }

    protected void cleanUpChannelsTransports() throws Exception {
        Iterator iterator;
        ApplicationServer applicationServer;
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"cleanUpChannelsTransports");
        WebContainer webContainer = null;
        WCCMDocument wCCMDocument = (WCCMDocument)this.getProcessorHelper().getNewDocument();
        Server server = (Server)UtilityImpl.locateConfigFileObject(wCCMDocument, Server.class);
        Iterator iterator2 = server.getComponents().iterator();
        while (iterator2.hasNext()) {
            object = iterator2.next();
            if (!(object instanceof ApplicationServer)) continue;
            applicationServer = (ApplicationServer)object;
            iterator = applicationServer.getComponents().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof WebContainer)) continue;
                webContainer = (WebContainer)e;
            }
        }
        object = this._cFrameworkHelper.getTransportChannelService(webContainer);
        if (object != null) {
            applicationServer = object.getTransportChannels();
            iterator = object.getChains();
            Tr.debug((TraceComponent)_tc, (String)("CommonDeclares._replacePorts=" + WASPostUpgrade.is_replacePorts()));
            if (WASPostUpgrade.is_replacePorts()) {
                this._cFrameworkHelper.clearTransportsAndTCPChannels((List)webContainer.getTransports(), (EList)applicationServer, (EList)iterator, this._serverName);
            }
        }
    }

    public List createTransports(boolean bl, WebContainer webContainer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createTransports", (Object)new Object[]{new Boolean(bl), webContainer});
        EList eList = webContainer.getTransports();
        if (!bl) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.deprecated.attribute", new Object[]{"Transports", "server.xml"}, "The {0} setting in file {1} has been deprecated, see infocenter for further information."));
            WCCMDocument wCCMDocument = (WCCMDocument)((ServerDocumentCollection)this.getTransform().getNewDocumentCollection()).getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class, false, false);
            EList eList2 = this._cFrameworkHelper.getServerIndexEndPoints(wCCMDocument, this._serverName);
            TransportChannelService transportChannelService = this._cFrameworkHelper.getTransportChannelService(webContainer);
            if (transportChannelService != null) {
                EList eList3 = transportChannelService.getTransportChannels();
                EList eList4 = transportChannelService.getChains();
                EList eList5 = this.getWCInboundAdminChannels(transportChannelService);
                EList eList6 = this.getWCInboundAdminSecureChannels(transportChannelService);
                Configuration configuration = new Configuration(new File(this.getTransform().getScenario().getOldProductImage().getProfile().getDirectory(), "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
                Iterator iterator = this._oldTransports.iterator();
                while (iterator.hasNext()) {
                    Transport transport = (Transport)iterator.next();
                    Iterator iterator2 = eList3.iterator();
                    while (iterator2.hasNext()) {
                        Object e = iterator2.next();
                        if (!(e instanceof TCPInboundChannel)) continue;
                        TCPInboundChannel tCPInboundChannel = (TCPInboundChannel)e;
                        Iterator iterator3 = eList2.iterator();
                        while (iterator3.hasNext()) {
                            NamedEndPoint namedEndPoint = (NamedEndPoint)iterator3.next();
                            if (!namedEndPoint.getEndPointName().equals(tCPInboundChannel.getEndPointName()) || namedEndPoint.getEndPoint().getPort() != transport.getAddress().getPort()) continue;
                            if (OSInfoFactory.isZSeries() && WASPostUpgrade.is_scriptCompatibility() && configuration.isDeploymentManagerConfiguration() && (eList5 != null && eList5.contains(e) || eList6 != null && eList6.contains(e))) {
                                Tr.event((TraceComponent)_tc, (String)("Channel '" + e + "' is part of the admin chain, and will not be deleted"));
                                continue;
                            }
                            iterator3.remove();
                            iterator2.remove();
                            this._cFrameworkHelper.removeTCPInboundChain(eList4, tCPInboundChannel);
                        }
                    }
                }
            }
            wCCMDocument.close();
        }
        return eList;
    }

    public List getInterceptors(boolean bl, ObjectRequestBroker objectRequestBroker) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getInterceptors", (Object)new Object[]{new Boolean(bl), objectRequestBroker});
        EList eList = null;
        EList eList2 = objectRequestBroker.getInterceptors();
        if (bl) {
            if (OSInfoFactory.isZSeries()) {
                eList = new BasicEList();
            } else {
                eList = new BasicEList();
                Iterator iterator = eList2.iterator();
                while (iterator.hasNext()) {
                    Interceptor interceptor = (Interceptor)iterator.next();
                    if (interceptor.getName().equals("com.ibm.ws.activity.ActivityIORInterceptor")) continue;
                    eList.add(interceptor);
                }
            }
        } else {
            eList = eList2;
        }
        return eList;
    }

    public List getPlugins(boolean bl, ObjectRequestBroker objectRequestBroker) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getPlugins", (Object)new Object[]{new Boolean(bl), objectRequestBroker});
        EList eList = objectRequestBroker.getPlugins();
        if (bl && OSInfoFactory.isZSeries()) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ORBPlugin oRBPlugin = (ORBPlugin)iterator.next();
                if (oRBPlugin.getName().equals("com.ibm.ISecurityUtilityImpl.SecurityPropertyManager") || oRBPlugin.getName().equals("com.ibm.ws.csi.CORBAORBMethodAccessControl") || oRBPlugin.getName().equals("com.ibm.ws390.orb.ClientSubcontractInit")) continue;
                iterator.remove();
            }
        }
        return eList;
    }

    public List getStartCommandArgs(boolean bl, JavaProcessDef javaProcessDef) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getStartCommandArgs", (Object)new Object[]{new Boolean(bl), javaProcessDef});
        try {
            Method method = javaProcessDef.getClass().getMethod("getStartCommandArgs", new Class[0]);
            List list = (List)method.invoke((Object)javaProcessDef, new Object[0]);
            if (list != null && !bl) {
                list.clear();
            }
            return list;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UpgradeException(illegalArgumentException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UpgradeException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UpgradeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UpgradeException(new Exception(invocationTargetException.getCause()));
        }
    }

    public List getProperties(boolean bl, WebContainer webContainer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getProperties", (Object)new Object[]{webContainer});
        Object var3_3 = null;
        EList eList = webContainer.getProperties();
        if (bl) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (!property.getName().equals("was.ConfiguredSystemName")) continue;
                iterator.remove();
            }
        }
        return eList;
    }

    public List getSystemProperties(boolean bl, JavaVirtualMachine javaVirtualMachine) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getSystemProperties", (Object)new Object[]{javaVirtualMachine});
        Object var3_3 = null;
        EList eList = javaVirtualMachine.getSystemProperties();
        if (bl) {
            Object object;
            String string = null;
            String string2 = null;
            String string3 = null;
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                object = (Property)iterator.next();
                if (object.getName().equals("com.ibm.websphere.pmi.reqmetrics.ARMIMPL")) {
                    string = object.getValue();
                    iterator.remove();
                }
                if (object.getName().equals("com.ibm.websphere.pmi.reqmetrics.loggingEnabled")) {
                    string2 = object.getValue();
                    iterator.remove();
                }
                if (!object.getName().equals("ArmTransactionFactory")) continue;
                string3 = object.getValue();
                iterator.remove();
            }
            object = (WCCMDocument)this.getTransform().getNewDocumentCollection().getParent().getParent().getParent().getParent().openDocument("pmirm.xml", WCCMDocument.class);
            List list = ((WCCMDocument)object).getList();
            PMIRequestMetrics pMIRequestMetrics = (PMIRequestMetrics)list.get(0);
            if (string == null) {
                pMIRequestMetrics.setArmType(PMIRMArmType.ARM40_LITERAL);
            } else if (string.equals("arm4")) {
                pMIRequestMetrics.setArmType(PMIRMArmType.ARM40_LITERAL);
            } else if (string.equals("eWlm")) {
                pMIRequestMetrics.setArmType(PMIRMArmType.EWLM_ARM_LITERAL);
            } else if (string.equals("tivoli")) {
                pMIRequestMetrics.setArmType(PMIRMArmType.TIVOLI_ARM_LITERAL);
            }
            if (string2 != null) {
                pMIRequestMetrics.setEnableLog(new Boolean(string2).booleanValue());
            }
            if (string3 != null) {
                pMIRequestMetrics.setArmTransactionFactory(string3);
            }
            ((WCCMDocument)object).close();
        }
        return eList;
    }

    public String getInitialSpecLevel(boolean bl, PMIService pMIService) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getIntialSpecLevel", (Object)new Object[]{new Boolean(bl), pMIService});
        if (bl) {
            Object object;
            Object object2;
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.deprecated.attribute", new Object[]{"PMIService:initialSpecLevel", "server.xml"}, "The {0} setting in file {1} has been deprecated, see infocenter for further information."));
            String string = pMIService.getInitialSpecLevel();
            boolean bl2 = false;
            if (this.getTransform().getNewDocumentCollection().documentExists("pmi-config.xml")) {
                bl2 = true;
            }
            WCCMDocument wCCMDocument = (WCCMDocument)this.getTransform().getNewDocumentCollection().openDocument("pmi-config.xml", WCCMDocument.class, true, false);
            if (!bl2) {
                object2 = this.getTransform().getNewDocumentCollection().getName();
                object = this.getTransform().getNewDocumentCollection().getParent().getParent().getParent().getParent().getParent().getParent().getChild("templates");
                WCCMDocument wCCMDocument2 = null;
                wCCMDocument2 = ((String)object2).endsWith("nodeagent") ? (WCCMDocument)object.getChild("system").getChild("nodes").getChild("servers").getChild("nodeagent").openDocument("pmi-config.xml", WCCMDocument.class) : (WCCMDocument)object.getChild("servertypes").getChild("APPLICATION_SERVER").getChild("servers").getChild("default").openDocument("pmi-config.xml", WCCMDocument.class);
                wCCMDocument.setInputStream(wCCMDocument2.getInputStream());
                wCCMDocument2.close();
            }
            object2 = wCCMDocument.getResource();
            if (string != null && !string.equals("")) {
                object = PmiConfigMigrator.getWAS60PMIConfigObject((Resource)object2, (String)string);
            }
            wCCMDocument.close();
        }
        return pMIService.getInitialSpecLevel();
    }

    public String getValue(boolean bl, Property property) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getValue", (Object)new Object[]{property});
        if (bl) {
            this._oldPropName = property.getName();
            if (property.getName().equals("com.ibm.ws.orb.services.lsd.StoreActiveServerList")) {
                return this.fixUpPath(property.getValue());
            }
        }
        return property.getValue();
    }

    protected String fixUpPath(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"fixUpPath", (Object)string);
        if (!string.startsWith("$")) {
            String string2 = this._oldCurrentLevelVariables.getProperty("WAS_INSTALL_ROOT");
            String string3 = this._oldCurrentLevelVariables.getProperty("USER_INSTALL_ROOT");
            if (string3 != null) {
                string3 = UtilityImpl.resolveEntryPath(string3, this._oldCurrentLevelVariables);
                if (UtilityImpl.makePathCommon(string).startsWith(UtilityImpl.makePathCommon(string3))) {
                    StringBuffer stringBuffer = new StringBuffer(string);
                    stringBuffer.replace(0, string3.length(), "${USER_INSTALL_ROOT}");
                    string = stringBuffer.toString();
                    return string;
                }
            }
            if (string2 != null && UtilityImpl.makePathCommon(string).startsWith(UtilityImpl.makePathCommon(string2))) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.replace(0, string2.length(), "${WAS_INSTALL_ROOT}");
                string = stringBuffer.toString();
                return string;
            }
        }
        return string;
    }

    public void setStderrFilename(OutputRedirect outputRedirect, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setStdErrFileName", (Object)new Object[]{outputRedirect, string});
        outputRedirect.setStderrFilename(this.fixUpPath(string));
    }

    public void setStdoutFilename(OutputRedirect outputRedirect, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setStdoutFileName", (Object)new Object[]{outputRedirect, string});
        outputRedirect.setStdoutFilename(this.fixUpPath(string));
    }

    public void setStdinFilename(OutputRedirect outputRedirect, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setStdinFileName", (Object)new Object[]{outputRedirect, string});
        outputRedirect.setStderrFilename(this.fixUpPath(string));
    }

    public void setFileName(TraceLog traceLog, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setFileName", (Object)new Object[]{traceLog, string});
        traceLog.setFileName(this.fixUpPath(string));
    }

    public void setFileName(StreamRedirect streamRedirect, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setFileName", (Object)new Object[]{streamRedirect, string});
        streamRedirect.setFileName(this.fixUpPath(string));
    }

    public void setStartCommand(JavaProcessDef javaProcessDef, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setStartCommand", (Object)new Object[]{javaProcessDef, string});
        javaProcessDef.setStartCommand(string);
        if (WASPostUpgrade.get_adjunct() != null) {
            if (javaProcessDef.getProcessType() != null && javaProcessDef.getProcessType().equals("Adjunct")) {
                javaProcessDef.setStartCommand(WASPostUpgrade.get_adjunct());
            } else {
                Iterator iterator = ((Server)javaProcessDef.eContainer()).getProcessDefinitions().iterator();
                while (iterator.hasNext()) {
                    JavaProcessDef javaProcessDef2;
                    Object e = iterator.next();
                    if (!(e instanceof JavaProcessDef) || (javaProcessDef2 = (JavaProcessDef)e).getProcessType() == null || !javaProcessDef2.getProcessType().equals("Adjunct")) continue;
                    javaProcessDef2.setStartCommand(WASPostUpgrade.get_adjunct());
                }
            }
        }
    }

    public void setName(ServiceLog serviceLog, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setName", (Object)new Object[]{serviceLog, string});
        serviceLog.setName(this.fixUpPath(string));
    }

    public void setPassivationDirectory(EJBContainer eJBContainer, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setPassivationDirectory", (Object)new Object[]{eJBContainer, string});
        eJBContainer.setPassivationDirectory(this.fixUpPath(string));
    }

    public void setExecutableName(JavaProcessDef javaProcessDef, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setExecutableName", (Object)new Object[]{javaProcessDef, string});
        if (OSInfoFactory.isISeries()) {
            if (string.indexOf("/QSYS.LIB/QEJBAS5.LIB/QEJBSVR.PGM") < 0 && string.indexOf("/QSYS.LIB/QASE5.LIB/QASESRV.PGM") < 0) {
                javaProcessDef.setExecutableName(this.fixUpPath(string));
            }
        } else {
            javaProcessDef.setExecutableName(this.fixUpPath(string));
        }
    }

    public void setWorkingDirectory(JavaProcessDef javaProcessDef, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setWorkingDirectory", (Object)new Object[]{javaProcessDef, string});
        javaProcessDef.setWorkingDirectory(this.fixUpPath(string));
    }

    public void setPort(EndPoint endPoint, int n) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setPort", (Object)new Object[]{endPoint, new Integer(n).toString()});
        File file = new File(this.getTransform().getNewDocumentCollection().getUrl().getPath(), "server.xml");
        endPoint.setPort(this._cellDocumentCollectionPostImpl.getPortUsage().checkForUniquePort(Integer.toString(n), file));
    }

    public void setInitialHeapSize(JavaVirtualMachine javaVirtualMachine, int n) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"setInitialHeapSize", (Object)new Object[]{javaVirtualMachine, new Integer(n).toString()});
        String string = ((JavaProcessDef)javaVirtualMachine.eContainer()).getProcessType();
        if (string != null && string.equals("Control")) {
            if (n < 48) {
                javaVirtualMachine.setInitialHeapSize(48);
            } else {
                javaVirtualMachine.setInitialHeapSize(n);
            }
        } else if (string != null && string.equals("Servant")) {
            if (n < 256) {
                javaVirtualMachine.setInitialHeapSize(256);
            } else {
                javaVirtualMachine.setInitialHeapSize(n);
            }
        } else {
            javaVirtualMachine.setInitialHeapSize(n);
        }
    }

    public void setMaximumHeapSize(JavaVirtualMachine javaVirtualMachine, int n) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"setMaximumHeapSize", (Object)new Object[]{javaVirtualMachine, new Integer(n).toString()});
        String string = ((JavaProcessDef)javaVirtualMachine.eContainer()).getProcessType();
        if (string != null && string.equals("Control")) {
            if (n < 256) {
                javaVirtualMachine.setMaximumHeapSize(256);
            } else {
                javaVirtualMachine.setMaximumHeapSize(n);
            }
        } else if (string != null && string.equals("Servant")) {
            if (n < 512) {
                javaVirtualMachine.setMaximumHeapSize(512);
            } else {
                javaVirtualMachine.setMaximumHeapSize(n);
            }
        } else {
            javaVirtualMachine.setMaximumHeapSize(n);
        }
    }

    public void setSslConfig(Transport transport, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setSslConfig", (Object)new Object[]{transport, string});
        if (string != null && !string.equals("")) {
            transport.setSslConfig(string);
        }
    }

    public void setValue(Property property, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setValue", (Object)new Object[]{property, string});
        if (this._oldPropName != null && this._oldPropName.equals("sslConfig")) {
            property.setValue(string);
        } else if (this._oldPropName != null && this._oldPropName.equals("DISABLE_FILE_LOCKING")) {
            if (property.eContainer() instanceof TransactionService) {
                ((TransactionService)property.eContainer()).setEnableFileLocking(new Boolean(string).booleanValue());
            } else {
                property.setValue(string);
            }
        } else if (this._oldPropName != null && this._oldPropName.equals("DISABLE_PROTOCOL_SECURITY")) {
            if (property.eContainer() instanceof TransactionService) {
                ((TransactionService)property.eContainer()).setEnableProtocolSecurity(new Boolean(string).booleanValue());
            } else {
                property.setValue(string);
            }
        } else if (this._oldPropName != null && this._oldPropName.equals("ASYNC_RESPONSE_TIMEOT")) {
            if (property.eContainer() instanceof TransactionService) {
                int n = (int)Math.ceil(new Integer(string) / 1000);
                ((TransactionService)property.eContainer()).setAsyncResponseTimeout(n);
            } else {
                property.setValue(string);
            }
        } else if (this._oldPropName != null && this._oldPropName.equals("com.ibm.CORBA.ListenerPort")) {
            if (((ReleaseVersionImpl)this.getTransform().getScenario().getOldProductImage().getReleaseVersion()).isR50() || ((ReleaseVersionImpl)this.getTransform().getScenario().getOldProductImage().getReleaseVersion()).isR51()) {
                WCCMDocument wCCMDocument = (WCCMDocument)this.getTransform().getNewDocumentCollection().getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class, false, false);
                Iterator iterator = ((ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class)).getServerEntries().iterator();
                while (iterator.hasNext()) {
                    ServerEntry serverEntry = (ServerEntry)iterator.next();
                    if (!serverEntry.getServerName().equals(this._serverName)) continue;
                    Iterator iterator2 = serverEntry.getSpecialEndpoints().iterator();
                    while (iterator2.hasNext()) {
                        NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                        if (!namedEndPoint.getEndPointName().equals("ORB_LISTENER_ADDRESS")) continue;
                        namedEndPoint.getEndPoint().setPort(Integer.valueOf(string).intValue());
                    }
                }
                wCCMDocument.close();
            }
        } else {
            property.setValue(string);
        }
        this._oldPropName = null;
    }

    public List getComponents(boolean bl, ApplicationServer applicationServer) {
        Tr.entry((TraceComponent)_tc, (String)"getComponents", (Object)new Object[]{new Boolean(bl), applicationServer});
        EList eList = null;
        EList eList2 = applicationServer.getComponents();
        if (bl) {
            eList = new BasicEList();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Class clazz = this.getProcessorHelper().getInterfaceClass(e);
                this.getComponents(clazz, (List)eList, e);
            }
        } else {
            eList = eList2;
        }
        return eList;
    }

    protected void getComponents(Class clazz, List list, Object object) {
        Tr.entry((TraceComponent)_tc, (String)"getComponents", (Object)new Object[]{clazz, list, object});
        if (clazz.equals(JMSServer.class)) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(object);
            vector.add(((ProfileImpl)this.getTransform().getScenario().getNewProductImage().getProfile()).getOwningNodeName());
            vector.add(this._serverName);
            _jmsSets.add(vector);
        } else {
            list.add(object);
        }
    }

    public List getComponents(boolean bl, Server server) {
        Tr.entry((TraceComponent)_tc, (String)"getComponents", (Object)new Object[]{new Boolean(bl), server});
        EList eList = null;
        EList eList2 = server.getComponents();
        if (bl) {
            eList = new BasicEList();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Class clazz = this.getProcessorHelper().getInterfaceClass(e);
                this.getComponents(clazz, (List)eList, e);
            }
        } else {
            eList = eList2;
        }
        return eList;
    }

    public List getServices(boolean bl, ApplicationServer applicationServer) {
        Tr.entry((TraceComponent)_tc, (String)"getServices", (Object)new Object[]{new Boolean(bl), applicationServer});
        EList eList = null;
        EList eList2 = applicationServer.getServices();
        if (bl) {
            eList = new BasicEList();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Class clazz = this.getProcessorHelper().getInterfaceClass(e);
                this.getServices(clazz, (List)eList, e);
            }
        } else {
            eList = eList2;
        }
        return eList;
    }

    public boolean arePrimaryKeysEqual(Property property, Property property2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + property.getClass().getName()));
        if (property.eContainer() instanceof JavaVirtualMachine) {
            Vector<String> vector = new Vector<String>();
            vector.add("java.library.path");
            vector.add("classpath");
            vector.add("ws.ext.dirs");
            vector.add("bootclasspath");
            vector.add("cp");
            if (vector.contains(property.getName())) {
                return property.getName().equals(property2.getName()) && property.getValue().equals(property2.getValue());
            }
        }
        return property.getName().equals(property2.getName());
    }
}

