/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.migration.common.OSInfoFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.ExtensionMBean;
import com.ibm.websphere.models.config.adminservice.ExtensionMBeanProvider;
import com.ibm.websphere.models.config.adminservice.JMSConnector;
import com.ibm.websphere.models.config.adminservice.RMIConnector;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.DynamicCache;
import com.ibm.websphere.models.config.applicationserver.ExternalCacheGroup;
import com.ibm.websphere.models.config.applicationserver.ExternalCacheGroupMember;
import com.ibm.websphere.models.config.applicationserver.TransactionService;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.EJBContainer;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.ListenerPort;
import com.ibm.websphere.models.config.applicationserver.ejbcontainer.messagelistener.MessageListenerService;
import com.ibm.websphere.models.config.applicationserver.webcontainer.HTTPTransport;
import com.ibm.websphere.models.config.applicationserver.webcontainer.SessionManager;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.cellmanager.CellManager;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.ChannelserviceFactory;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.DCSInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.HTTPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.WebContainerInboundChannel;
import com.ibm.websphere.models.config.classloader.Classloader;
import com.ibm.websphere.models.config.classloader.LibraryRef;
import com.ibm.websphere.models.config.coregroupbridgeservice.CoreGroupBridgeService;
import com.ibm.websphere.models.config.datareplicationserver.SystemMessageServer;
import com.ibm.websphere.models.config.debugservice.DebugService;
import com.ibm.websphere.models.config.diagnosticproviderservice.DiagnosticProviderService;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.loggingservice.http.HTTPAccessLoggingService;
import com.ibm.websphere.models.config.loggingservice.ras.RASLoggingService;
import com.ibm.websphere.models.config.messagingserver.JMSServer;
import com.ibm.websphere.models.config.namingserver.NameServer;
import com.ibm.websphere.models.config.nodeagent.NodeAgent;
import com.ibm.websphere.models.config.orb.Interceptor;
import com.ibm.websphere.models.config.orb.ORBPlugin;
import com.ibm.websphere.models.config.orb.ObjectRequestBroker;
import com.ibm.websphere.models.config.pmiservice.PMIService;
import com.ibm.websphere.models.config.portletcontainer.PortletContainer;
import com.ibm.websphere.models.config.process.CustomService;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.ThreadPool;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.JavaVirtualMachine;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.threadpoolmanager.ThreadPoolManager;
import com.ibm.websphere.models.config.tperfviewer.TPVService;
import com.ibm.websphere.models.config.traceservice.TraceService;
import com.ibm.websphere.models.config.webserver.PluginProperties;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.websphere.models.config.wlmserver.WorkloadManagementServer;
import com.ibm.websphere.models.config.wsbytebufferservice.WSByteBufferService;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.CellDocumentCollectionPostImpl;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.postupgrade.common.ChannelFrameworkHelper;
import com.ibm.ws.migration.postupgrade.common.ServerCreationHelper;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.ServerDocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.BasicWCCMDocumentProcessor;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public abstract class ServerConfigCommon
extends BasicWCCMDocumentProcessor {
    protected static Vector CustomServicesToRemove = new Vector();
    protected static Vector ComponentsToRemove = new Vector();
    private static TraceComponent _tc;
    protected ServerCreationHelper _serverHelper = null;
    protected String _serverName = null;
    protected List _oldTransports = null;
    protected TransportChannelService _oldChannelService = null;
    protected TransportChannelService _newChannelService = null;
    protected ChannelFrameworkHelper _cFrameworkHelper = null;
    protected Properties _oldCurrentLevelVariables = null;
    protected Properties _newCurrentLevelVariables = null;
    protected CellDocumentCollectionPostImpl _cellDocumentCollectionPostImpl = null;

    public ServerConfigCommon(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
        this._cellDocumentCollectionPostImpl = (CellDocumentCollectionPostImpl)documentTransform.getNewDocumentCollection().getParent().getParent().getParent().getParent();
        this._cFrameworkHelper = ChannelFrameworkHelper.getInstance(documentTransform);
        this._serverName = documentTransform.getNewDocumentCollection().getName();
        this.instantiateVariables();
        this.getProcessorHelper().addOverride(WebContainer.class, "getTransports", new Class[0]);
        this.getProcessorHelper().addOverride(Server.class, "setProcessDefinition", new Class[]{ProcessDef.class});
        this.getProcessorHelper().addOverride(Server.class, "getCustomServices", new Class[0]);
    }

    public List getCustomServices(boolean bl, Server server) {
        Tr.entry((TraceComponent)_tc, (String)"getCustomServices", (Object)new Object[]{new Boolean(bl), server});
        EList eList = null;
        EList eList2 = server.getCustomServices();
        if (bl) {
            eList = new BasicEList();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                CustomService customService;
                Object e = iterator.next();
                if (!(e instanceof CustomService) || CustomServicesToRemove.contains((customService = (CustomService)e).getClassname())) continue;
                eList.add(customService);
            }
        } else {
            eList = eList2;
        }
        return eList;
    }

    protected void instantiateVariables() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"instantiateVariables");
        this._oldCurrentLevelVariables = UtilityImpl.instantiateVariables(this.getTransform().getOldDocumentCollection());
        this._newCurrentLevelVariables = UtilityImpl.instantiateVariables(this.getTransform().getNewDocumentCollection());
    }

    public Document getTemplateDocument() {
        Tr.entry((TraceComponent)_tc, (String)"getTemplateDocument");
        return null;
    }

    protected void convertObjectRequestBroker(List list) {
        Tr.entry((TraceComponent)_tc, (String)"convertObjectRequestBroker", (Object)list);
        if (!WASPostUpgrade.is_scriptCompatibility()) {
            Server server = (Server)list.get(0);
            ThreadPool threadPool = this.getORBThreadPool(server);
            ObjectRequestBroker objectRequestBroker = this.getObjectRequestBroker(server);
            if (threadPool != null && objectRequestBroker != null) {
                objectRequestBroker.setUseServerThreadPool(true);
                objectRequestBroker.setThreadPool(null);
            } else {
                Tr.entry((TraceComponent)_tc, (String)"null condition met when trying to convert ThreadPool on ObjectRequestBroker");
                Tr.entry((TraceComponent)_tc, (String)("ThreadPool: " + threadPool));
                Tr.entry((TraceComponent)_tc, (String)("ObjectRequestBroker: " + objectRequestBroker));
            }
        } else {
            Server server = (Server)list.get(0);
            ThreadPool threadPool = this.getORBThreadPool(server);
            ObjectRequestBroker objectRequestBroker = this.getObjectRequestBroker(server);
            if (objectRequestBroker != null) {
                objectRequestBroker.setUseServerThreadPool(false);
            }
        }
    }

    protected ObjectRequestBroker getObjectRequestBroker(Server server) {
        Tr.entry((TraceComponent)_tc, (String)"getObjectReqestBroker", (Object)server);
        Iterator iterator = server.getServices().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ObjectRequestBroker)) continue;
            return (ObjectRequestBroker)e;
        }
        return null;
    }

    protected ThreadPool getORBThreadPool(Server server) {
        Tr.entry((TraceComponent)_tc, (String)"getORBThreadPool", (Object)server);
        Iterator iterator = server.getServices().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ThreadPoolManager)) continue;
            ThreadPoolManager threadPoolManager = (ThreadPoolManager)e;
            Iterator iterator2 = threadPoolManager.getThreadPools().iterator();
            while (iterator2.hasNext()) {
                ThreadPool threadPool = (ThreadPool)iterator2.next();
                if (!threadPool.getName().equals("ORB.thread.pool")) continue;
                return threadPool;
            }
        }
        return null;
    }

    public void migrate(WCCMDocument wCCMDocument, WCCMDocument wCCMDocument2) throws IllegalArgumentException, Exception {
        this.filterComponents((Server)wCCMDocument.getList().get(0));
        super.migrate(wCCMDocument, wCCMDocument2);
    }

    public void filterComponents(Server server) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"filterComponents", (Object)new Object[]{server});
        EList eList = server.getComponents();
        for (int i = 0; i < eList.size(); ++i) {
            Object object = eList.get(i);
            Class clazz = this.getProcessorHelper().getInterfaceClass(object);
            if (!ComponentsToRemove.contains(clazz.getName()) && !ComponentsToRemove.contains(object.getClass().getName())) continue;
            eList.remove(i);
            --i;
        }
    }

    public List getServices(boolean bl, Server server) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getServices", (Object)new Object[]{new Boolean(bl), server});
        BasicEList basicEList = null;
        EList eList = server.getServices();
        if (bl) {
            basicEList = new BasicEList();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Class clazz = this.getProcessorHelper().getInterfaceClass(e);
                if (e instanceof TransportChannelService) {
                    this._oldChannelService = (TransportChannelService)e;
                    continue;
                }
                this.getServices(clazz, (List)basicEList, e);
            }
        } else {
            basicEList = new BasicEList();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                Class clazz = this.getProcessorHelper().getInterfaceClass(e);
                if (e instanceof TransportChannelService) {
                    this._newChannelService = (TransportChannelService)e;
                    this.migrateTransportChannelServiceOverride();
                    continue;
                }
                basicEList.add(e);
            }
        }
        return basicEList;
    }

    protected void getServices(Class clazz, List list, Object object) {
        Tr.entry((TraceComponent)_tc, (String)"getServices", (Object)new Object[]{clazz, list, object});
        list.add(object);
    }

    protected void migrateTransportChannelServiceOverride() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrateTransportChannelServiceOverride");
        if (this._oldChannelService != null) {
            EList eList = this._newChannelService.getTransportChannels();
            EList eList2 = this._oldChannelService.getTransportChannels();
            super.processContents((List)eList2, (List)eList);
            EList eList3 = this._newChannelService.getChains();
            EList eList4 = this._oldChannelService.getChains();
            Iterator iterator = eList4.iterator();
            while (iterator.hasNext()) {
                TransportChannel transportChannel;
                Chain chain = (Chain)iterator.next();
                boolean bl = false;
                for (int i = 0; i < eList3.size(); ++i) {
                    if (!chain.getName().equals(((Chain)eList3.get(i)).getName())) continue;
                    bl = true;
                    break;
                }
                Vector<String> vector = new Vector<String>();
                EList eList5 = chain.getTransportChannels();
                Iterator iterator2 = eList5.iterator();
                while (iterator2.hasNext()) {
                    transportChannel = (TransportChannel)iterator2.next();
                    vector.add(transportChannel.getName());
                }
                eList5.clear();
                transportChannel = new BasicEList();
                transportChannel.add((Object)chain);
                super.processContents((List)transportChannel, (List)eList3);
                Chain chain2 = null;
                Iterator iterator3 = eList3.iterator();
                while (iterator3.hasNext()) {
                    chain2 = (Chain)iterator3.next();
                    if (!chain.getName().equals(chain2.getName())) continue;
                    chain2.getTransportChannels().clear();
                    break;
                }
                Iterator iterator4 = vector.iterator();
                block4: while (iterator4.hasNext()) {
                    String string = (String)iterator4.next();
                    Iterator iterator5 = eList.iterator();
                    while (iterator5.hasNext()) {
                        TransportChannel transportChannel2 = (TransportChannel)iterator5.next();
                        String string2 = transportChannel2.getName();
                        if (!string.equals(string2)) continue;
                        chain2.getTransportChannels().add((Object)transportChannel2);
                        continue block4;
                    }
                }
            }
        }
    }

    protected ThreadPool getThreadPoolByName(WebContainer webContainer, String string) {
        Tr.entry((TraceComponent)_tc, (String)"getThreadPoolByName", (Object)new Object[]{webContainer, string});
        ThreadPoolManager threadPoolManager = this._cFrameworkHelper.getThreadPoolManager(webContainer);
        if (threadPoolManager != null) {
            Iterator iterator = threadPoolManager.getThreadPools().iterator();
            while (iterator.hasNext()) {
                ThreadPool threadPool = (ThreadPool)iterator.next();
                if (!threadPool.getName().equals(string)) continue;
                return threadPool;
            }
        }
        return null;
    }

    protected void createServerIndexEndpoint(TCPInboundChannel tCPInboundChannel) throws Exception {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"createServerIndexEndpoint", (Object)tCPInboundChannel);
        WCCMDocument wCCMDocument = (WCCMDocument)((ServerDocumentCollection)this.getTransform().getNewDocumentCollection()).getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class, false, false);
        EList eList = this._cFrameworkHelper.getServerIndexEndPoints(wCCMDocument, this._serverName);
        boolean bl = false;
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            object = (NamedEndPoint)iterator.next();
            if (!object.getEndPointName().equals(tCPInboundChannel.getEndPointName())) continue;
            bl = true;
            break;
        }
        wCCMDocument.close();
        if (!bl) {
            object = (WCCMDocument)((ServerDocumentCollection)this.getTransform().getOldDocumentCollection()).getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class);
            NamedEndPoint namedEndPoint = this.getSpecialEndPoint((WCCMDocument)object, this._serverName, tCPInboundChannel);
            File file = new File(this.getTransform().getNewDocumentCollection().getParent().getParent().getUrl().getPath(), "serverindex.xml");
            int n = this._cellDocumentCollectionPostImpl.getPortUsage().checkForUniquePort(new Integer(namedEndPoint.getEndPoint().getPort()).toString(), file, true);
            namedEndPoint.getEndPoint().setPort(n);
            eList.add((Object)this.getSpecialEndPoint((WCCMDocument)object, this._serverName, tCPInboundChannel));
            ((WCCMDocument)object).close();
        }
    }

    protected NamedEndPoint getSpecialEndPoint(WCCMDocument wCCMDocument, String string, TCPInboundChannel tCPInboundChannel) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getSpecialEndPoint", (Object)new Object[]{wCCMDocument, string, tCPInboundChannel});
        EList eList = this._cFrameworkHelper.getServerIndexEndPoints(wCCMDocument, this._serverName);
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            NamedEndPoint namedEndPoint = (NamedEndPoint)iterator.next();
            if (!namedEndPoint.getEndPointName().equals(tCPInboundChannel.getEndPointName())) continue;
            return namedEndPoint;
        }
        return null;
    }

    protected Iterator getTransportIterator(List list) {
        Tr.entry((TraceComponent)_tc, (String)"getTransportIterator", (Object)list);
        return this._oldTransports.iterator();
    }

    public List createChannels(boolean bl, WebContainer webContainer) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createChannels", (Object)new Object[]{new Boolean(bl), webContainer});
        EList eList = webContainer.getTransports();
        if (!bl && this._oldTransports != null && this._oldTransports.size() > 0) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getString("advise.transports.to.channels", "Existing Transports are being migrated into the TransportChannelService, see infocenter for further information."));
            ThreadPool threadPool = this._cFrameworkHelper.createDefaultThreadPoolForChannels(webContainer);
            WCCMDocument wCCMDocument = (WCCMDocument)((ServerDocumentCollection)this.getTransform().getNewDocumentCollection()).getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class, false, false);
            EList eList2 = this._cFrameworkHelper.getServerIndexEndPoints(wCCMDocument, this._serverName);
            TransportChannelService transportChannelService = this._cFrameworkHelper.getTransportChannelService(webContainer);
            if (transportChannelService != null) {
                EList eList3 = transportChannelService.getTransportChannels();
                EList eList4 = transportChannelService.getChains();
                Iterator iterator = this.getTransportIterator(this._oldTransports);
                while (iterator.hasNext()) {
                    SSLInboundChannel sSLInboundChannel;
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Chain chain;
                    Iterator iterator2;
                    Transport transport = (Transport)iterator.next();
                    TCPInboundChannel tCPInboundChannel = this._cFrameworkHelper.doesTCPChannelTransportExist(eList3, eList2, (List)eList, transport.getAddress().getPort());
                    boolean bl2 = false;
                    if (tCPInboundChannel != null) {
                        bl2 = true;
                    }
                    if (bl2 && transport.isSslEnabled()) {
                        iterator2 = eList4.iterator();
                        while (iterator2.hasNext()) {
                            chain = (Chain)iterator2.next();
                            object5 = chain.getTransportChannels().iterator();
                            block2: while (object5.hasNext()) {
                                object4 = object5.next();
                                if (!(object4 instanceof TCPInboundChannel) || !(object3 = (TCPInboundChannel)object4).getName().equals(tCPInboundChannel.getName())) continue;
                                object2 = chain.getTransportChannels().iterator();
                                while (object2.hasNext()) {
                                    object = object2.next();
                                    if (!(object instanceof SSLInboundChannel)) continue;
                                    sSLInboundChannel = (SSLInboundChannel)object;
                                    sSLInboundChannel.setSslConfigAlias(transport.getSslConfig());
                                    continue block2;
                                }
                            }
                        }
                        continue;
                    }
                    if (bl2) continue;
                    iterator2 = this._cFrameworkHelper.createTCPChannelTransport(eList3, eList2, transport.getAddress().getHost(), transport.getAddress().getPort());
                    iterator2.setThreadPool(threadPool);
                    UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.transport.to.become.channel", new Object[]{new Integer(transport.getAddress().getPort()).toString(), iterator2.getName(), threadPool.getName()}, "Transport with port address of {0} is being migrated to channel {1} and will belong to the {2} ThreadPool."));
                    chain = ChannelserviceFactory.eINSTANCE.createChain();
                    chain.setName("WCInbound" + transport.getAddress().getPort());
                    object5 = new Configuration(new File(this.getTransform().getScenario().getOldProductImage().getProfile().getDirectory(), "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
                    object4 = new Configuration(new File(this.getTransform().getScenario().getNewProductImage().getProfile().getDirectory(), "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
                    object3 = ((Configuration)object4).getOwningNodeName();
                    if (OSInfoFactory.isZSeries() && ((Configuration)object5).isDeploymentManagerConfiguration()) {
                        object2 = this.getTransform().getNewDocumentCollection().getParent().getParent().getName();
                        if (((String)object2).equals(object3)) {
                            Tr.debug((TraceComponent)_tc, (String)"Disable chains on z/OS DMgr");
                            chain.setEnable(false);
                        } else {
                            chain.setEnable(true);
                        }
                    } else {
                        chain.setEnable(true);
                    }
                    object2 = chain.getTransportChannels();
                    object2.add((Object)iterator2);
                    if (transport.isSslEnabled()) {
                        this._cFrameworkHelper.createSSLChannelTransport(eList3, (EList)object2, transport.getSslConfig(), transport.getAddress().getPort());
                    }
                    object = this._cFrameworkHelper.createHTTPChannelTransport(eList3, (EList)object2, transport.getAddress().getPort());
                    sSLInboundChannel = this._cFrameworkHelper.createWebContainerChannelTransport(eList3, (EList)object2, transport.getAddress().getPort());
                    this.addInboundChannelProperties((HTTPInboundChannel)object, (TCPInboundChannel)iterator2, (WebContainerInboundChannel)sSLInboundChannel, transport);
                    eList4.add((Object)chain);
                }
            }
            this._oldTransports.clear();
            eList.clear();
            wCCMDocument.close();
        }
        return eList;
    }

    protected void addInboundChannelProperties(HTTPInboundChannel hTTPInboundChannel, TCPInboundChannel tCPInboundChannel, WebContainerInboundChannel webContainerInboundChannel, Transport transport) {
        Tr.entry((TraceComponent)_tc, (String)"addInboundChannelProperties", (Object)new Object[]{hTTPInboundChannel, tCPInboundChannel, transport});
        EList eList = transport.getProperties();
        for (int i = 0; i < eList.size(); ++i) {
            Property property = (Property)eList.get(i);
            if (property.getName().equals("MaxKeepAliveRequests")) {
                hTTPInboundChannel.setMaximumPersistentRequests(new Integer(property.getValue()).intValue());
                continue;
            }
            if (property.getName().equals("KeepAliveEnabled")) {
                hTTPInboundChannel.setKeepAlive(new Boolean(property.getValue()).booleanValue());
                continue;
            }
            if (property.getName().equals("ConnectionResponseTimeout")) {
                hTTPInboundChannel.setWriteTimeout(new Integer(property.getValue()).intValue());
                continue;
            }
            if (property.getName().equals("ConnectionKeepAliveTimeout")) {
                hTTPInboundChannel.setPersistentTimeout(new Integer(property.getValue()).intValue());
                continue;
            }
            if (property.getName().equals("MaxKeepAliveConnections")) {
                if (new Integer(property.getValue()) <= 0) continue;
                tCPInboundChannel.setMaxOpenConnections(new Integer(property.getValue()).intValue());
                continue;
            }
            if (property.getName().equals("serverSocketBacklog")) {
                property.setName("listenBacklog");
                tCPInboundChannel.getProperties().add((Object)property);
                --i;
                continue;
            }
            if (property.getName().equals("TrustedProxy")) {
                webContainerInboundChannel.getProperties().add((Object)property);
                --i;
                continue;
            }
            if (!property.getName().equals("ConnectionIOTimeout")) continue;
            hTTPInboundChannel.setReadTimeout(new Integer(property.getValue()).intValue());
            tCPInboundChannel.setInactivityTimeout(new Integer(property.getValue()).intValue());
        }
    }

    protected void saveOldTransports(boolean bl, WebContainer webContainer) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"saveOldTransports", (Object)new Object[]{new Boolean(bl), webContainer});
        if (bl) {
            this._oldTransports = webContainer.getTransports();
        }
    }

    public boolean arePrimaryKeysEqual(Property property, Property property2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + property.getClass().getName()));
        return property.getName().equals(property2.getName());
    }

    public boolean arePrimaryKeysEqual(ListenerPort listenerPort, ListenerPort listenerPort2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + listenerPort.getClass().getName()));
        return listenerPort.getName().equals(listenerPort2.getName());
    }

    public boolean arePrimaryKeysEqual(NodeAgent nodeAgent, NodeAgent nodeAgent2) {
        Tr.entry((TraceComponent)_tc, (String)("ServerConfigCommon.arePrimaryKeysEqual.NodeAgent -- oldTag.name " + nodeAgent.getName() + " newTag.name: " + nodeAgent2.getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(CellManager cellManager, CellManager cellManager2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + cellManager.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(WorkloadManagementServer workloadManagementServer, WorkloadManagementServer workloadManagementServer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + workloadManagementServer.getClass().getName()));
        return workloadManagementServer.getName().equals(workloadManagementServer2.getName());
    }

    public boolean arePrimaryKeysEqual(ExtensionMBeanProvider extensionMBeanProvider, ExtensionMBeanProvider extensionMBeanProvider2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + extensionMBeanProvider.getClass().getName()));
        return extensionMBeanProvider.getName().equals(extensionMBeanProvider2.getName());
    }

    public boolean arePrimaryKeysEqual(ExtensionMBean extensionMBean, ExtensionMBean extensionMBean2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + extensionMBean.getClass().getName()));
        return extensionMBean.getClass().equals(extensionMBean2.getClass());
    }

    public boolean arePrimaryKeysEqual(LibraryRef libraryRef, LibraryRef libraryRef2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + libraryRef.getClass().getName()));
        return libraryRef.getLibraryName().equals(libraryRef2.getLibraryName());
    }

    public boolean arePrimaryKeysEqual(Classloader classloader, Classloader classloader2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + classloader.getClass().getName()));
        return classloader.getClass().equals(classloader2.getClass());
    }

    public boolean arePrimaryKeysEqual(SystemMessageServer systemMessageServer, SystemMessageServer systemMessageServer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + systemMessageServer.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(CustomService customService, CustomService customService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + customService.getClass().getName()));
        return customService.getClassname().equals(customService2.getClassname());
    }

    public boolean arePrimaryKeysEqual(ThreadPoolManager threadPoolManager, ThreadPoolManager threadPoolManager2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + threadPoolManager.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(TPVService tPVService, TPVService tPVService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + tPVService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(TransportChannelService transportChannelService, TransportChannelService transportChannelService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + transportChannelService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(TCPInboundChannel tCPInboundChannel, TCPInboundChannel tCPInboundChannel2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + tCPInboundChannel.getClass().getName()));
        return tCPInboundChannel.getName().equals(tCPInboundChannel2.getName());
    }

    public boolean arePrimaryKeysEqual(HTTPInboundChannel hTTPInboundChannel, HTTPInboundChannel hTTPInboundChannel2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + hTTPInboundChannel.getClass().getName()));
        return hTTPInboundChannel.getName().equals(hTTPInboundChannel2.getName());
    }

    public boolean arePrimaryKeysEqual(DCSInboundChannel dCSInboundChannel, DCSInboundChannel dCSInboundChannel2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + dCSInboundChannel.getClass().getName()));
        return dCSInboundChannel.getName().equals(dCSInboundChannel2.getName());
    }

    public boolean arePrimaryKeysEqual(SSLInboundChannel sSLInboundChannel, SSLInboundChannel sSLInboundChannel2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + sSLInboundChannel.getClass().getName()));
        return sSLInboundChannel.getName().equals(sSLInboundChannel2.getName());
    }

    public boolean arePrimaryKeysEqual(WebContainerInboundChannel webContainerInboundChannel, WebContainerInboundChannel webContainerInboundChannel2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + webContainerInboundChannel.getClass().getName()));
        return webContainerInboundChannel.getName().equals(webContainerInboundChannel2.getName());
    }

    public boolean arePrimaryKeysEqual(Chain chain, Chain chain2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + chain.getClass().getName()));
        return chain.getName().equals(chain2.getName());
    }

    public boolean arePrimaryKeysEqual(ThreadPool threadPool, ThreadPool threadPool2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + threadPool.getClass().getName()));
        return threadPool.getName().equals(threadPool2.getName());
    }

    public boolean arePrimaryKeysEqual(Server server, Server server2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + server.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(PMIService pMIService, PMIService pMIService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + pMIService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(AdminService adminService, AdminService adminService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + adminService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(SOAPConnector sOAPConnector, SOAPConnector sOAPConnector2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + sOAPConnector.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(RMIConnector rMIConnector, RMIConnector rMIConnector2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + rMIConnector.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(TraceService traceService, TraceService traceService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + traceService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(RASLoggingService rASLoggingService, RASLoggingService rASLoggingService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + rASLoggingService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(ObjectRequestBroker objectRequestBroker, ObjectRequestBroker objectRequestBroker2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + objectRequestBroker.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(ORBPlugin oRBPlugin, ORBPlugin oRBPlugin2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + oRBPlugin.getClass().getName()));
        return oRBPlugin.getName().equals(oRBPlugin2.getName());
    }

    public boolean arePrimaryKeysEqual(Interceptor interceptor, Interceptor interceptor2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + interceptor.getClass().getName()));
        return interceptor.getName().equals(interceptor2.getName());
    }

    public boolean arePrimaryKeysEqual(NameServer nameServer, NameServer nameServer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + nameServer.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(ApplicationServer applicationServer, ApplicationServer applicationServer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + applicationServer.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(TransactionService transactionService, TransactionService transactionService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + transactionService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(DynamicCache dynamicCache, DynamicCache dynamicCache2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + dynamicCache.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(DebugService debugService, DebugService debugService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + debugService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(ExternalCacheGroup externalCacheGroup, ExternalCacheGroup externalCacheGroup2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + externalCacheGroup.getClass().getName()));
        return externalCacheGroup.getName().equals(externalCacheGroup2.getName());
    }

    public boolean arePrimaryKeysEqual(ExternalCacheGroupMember externalCacheGroupMember, ExternalCacheGroupMember externalCacheGroupMember2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + externalCacheGroupMember.getClass().getName()));
        return externalCacheGroupMember.getAdapterBeanName().equals(externalCacheGroupMember2.getAdapterBeanName()) && externalCacheGroupMember.getAddress().equals(externalCacheGroupMember2.getAddress());
    }

    public boolean arePrimaryKeysEqual(WebContainer webContainer, WebContainer webContainer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + webContainer.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(SessionManager sessionManager, SessionManager sessionManager2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + sessionManager.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(HTTPTransport hTTPTransport, HTTPTransport hTTPTransport2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + hTTPTransport.getClass().getName()));
        return hTTPTransport.getAddress().getPort() == hTTPTransport2.getAddress().getPort();
    }

    public boolean arePrimaryKeysEqual(EJBContainer eJBContainer, EJBContainer eJBContainer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + eJBContainer.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(MessageListenerService messageListenerService, MessageListenerService messageListenerService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + messageListenerService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(JMSServer jMSServer, JMSServer jMSServer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + jMSServer.getClass().getName()));
        return jMSServer.getName().equals(jMSServer2.getName());
    }

    public boolean arePrimaryKeysEqual(JavaVirtualMachine javaVirtualMachine, JavaVirtualMachine javaVirtualMachine2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + javaVirtualMachine.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(JavaProcessDef javaProcessDef, JavaProcessDef javaProcessDef2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + javaProcessDef.getClass().getName()));
        if (OSInfoFactory.isZSeries()) {
            if (javaProcessDef.getProcessType() != null && javaProcessDef2.getProcessType() != null) {
                return javaProcessDef.getProcessType().equals(javaProcessDef2.getProcessType());
            }
            if (javaProcessDef.getExecutableTarget() == null) {
                return javaProcessDef2.getExecutableTarget() == null;
            }
            return false;
        }
        if (javaProcessDef.getProcessType() != null && javaProcessDef2.getProcessType() != null) {
            return javaProcessDef.getProcessType().equals(javaProcessDef2.getProcessType());
        }
        if (javaProcessDef.getExecutableTargetKind() == null || javaProcessDef.getExecutableTarget() == null) {
            return true;
        }
        return javaProcessDef.getExecutableTargetKind().equals(javaProcessDef2.getExecutableTargetKind()) && javaProcessDef.getExecutableTarget().equals(javaProcessDef2.getExecutableTarget());
    }

    public boolean arePrimaryKeysEqual(CoreGroupBridgeService coreGroupBridgeService, CoreGroupBridgeService coreGroupBridgeService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + coreGroupBridgeService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(HTTPAccessLoggingService hTTPAccessLoggingService, HTTPAccessLoggingService hTTPAccessLoggingService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + hTTPAccessLoggingService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(PluginProperties pluginProperties, PluginProperties pluginProperties2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + pluginProperties.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(PortletContainer portletContainer, PortletContainer portletContainer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + portletContainer.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(WebServer webServer, WebServer webServer2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + webServer.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(WSByteBufferService wSByteBufferService, WSByteBufferService wSByteBufferService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + wSByteBufferService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(DiagnosticProviderService diagnosticProviderService, DiagnosticProviderService diagnosticProviderService2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + diagnosticProviderService.getClass().getName()));
        return true;
    }

    public boolean arePrimaryKeysEqual(JMSConnector jMSConnector, JMSConnector jMSConnector2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + jMSConnector.getClass().getName()));
        return true;
    }

    public void logProgressMessage(Server server, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{server, bl});
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"Server", server.getName()}, "Adding {0} entry {1} to the model."), true);
        } else {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.updating.entry", new Object[]{"Server", server.getName()}, "Updating attributes of {0} entry {1}, it is already defined in the existing model."), true);
        }
    }

    public void logProgressMessage(EJBContainer eJBContainer, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{eJBContainer, bl});
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"EJBContainer", ""}, "Adding {0} entry {1} to the model."), true);
        } else {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.updating.entry", new Object[]{"EJBContainer", ""}, "Updating attributes of {0} entry {1}, it is already defined in the existing model."), true);
        }
    }

    public void logProgressMessage(WebContainer webContainer, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{webContainer, bl});
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"WebContainer", ""}, "Adding {0} entry {1} to the model."), true);
        } else {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.updating.entry", new Object[]{"WebContainer", ""}, "Updating attributes of {0} entry {1}, it is already defined in the existing model."), true);
        }
    }

    static {
        CustomServicesToRemove.add("com.ibm.ws.os400.custom.Custom400Service");
        ComponentsToRemove.add("com.ibm.ws.runtime.component.SystemMessageServerImpl");
        ComponentsToRemove.add("com.ibm.websphere.models.config.datareplicationserver.impl.SystemMessageServerImpl");
        ComponentsToRemove.add("com.ibm.websphere.models.config.datareplicationserver.SystemMessageServer");
        _tc = Tr.register((Class)ServerConfigCommon.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    }
}

