/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.migration.exceptions.WASUpgradeException;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.adminservice.SOAPConnector;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.StreamRedirect;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.websphere.models.config.webserver.WebServer;
import com.ibm.ws.management.tools.NodeAgentConfigBuilder;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.CellDocumentCollectionPostImpl;
import com.ibm.ws.migration.postupgrade.ConfigHelperFactory;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.postupgrade.common.ConfigHelper;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.NodeDocumentCollection;
import com.ibm.wsspi.migration.document.ServerDocumentCollection;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class ServerCreationHelper {
    private static TraceComponent _tc = Tr.register((Class)ServerCreationHelper.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static ServerCreationHelper _sCHelper = null;
    protected final String LOG_ROOT_ENTRY = "${LOG_ROOT}/";
    protected final String NODE_NAME_VARIABLE = "$(node.name)";
    protected static final String TEMPLATES = "templates";
    protected static final String SERVERTYPES = "servertypes";
    protected static final String SERVERS = "servers";
    protected static final String DEFAULT = "default";
    protected static final String DEFAULTZOS = "defaultZOS";
    protected DocumentCollection _templatesDocumentCollection = null;
    protected DocumentCollection _appServer_templates_documentCollection = null;
    protected DocumentCollection _proxyServer_templates_documentCollection = null;
    protected DocumentCollection _genericServer_templates_documentCollection = null;
    protected DocumentCollection _webServer_templates_documentCollection = null;
    protected ConfigHelper _configHelper = null;
    protected ServerDocumentCollection _oldServerDocumentCollection = null;
    protected ServerDocumentCollection _newServerDocumentCollection = null;
    static /* synthetic */ Class class$com$ibm$websphere$models$config$host$HostAlias;

    public static boolean isSupportedServerType(String string) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"isSupportedServerType", (Object)string);
        Vector<String> vector = new Vector<String>();
        vector.add("APPLICATION_SERVER");
        vector.add("DEPLOYMENT_MANAGER");
        vector.add("GENERIC_SERVER");
        vector.add("MESSAGE_BROKER");
        vector.add("NODE_AGENT");
        vector.add("WEB_SERVER");
        vector.add("PROXY_SERVER");
        return vector.contains(string);
    }

    public static ServerCreationHelper getInstance(ServerDocumentCollection serverDocumentCollection, ServerDocumentCollection serverDocumentCollection2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getInstance", (Object)new Object[]{serverDocumentCollection, serverDocumentCollection2});
        _sCHelper = new ServerCreationHelper(serverDocumentCollection, serverDocumentCollection2);
        return _sCHelper;
    }

    private ServerCreationHelper(ServerDocumentCollection serverDocumentCollection, ServerDocumentCollection serverDocumentCollection2) throws Exception {
        this._oldServerDocumentCollection = serverDocumentCollection;
        this._newServerDocumentCollection = serverDocumentCollection2;
        this._configHelper = ConfigHelperFactory.createConfigHelper((NodeDocumentCollection)this._newServerDocumentCollection.getParent().getParent(), (NodeDocumentCollection)this._oldServerDocumentCollection.getParent().getParent());
        this._templatesDocumentCollection = this._newServerDocumentCollection.getParent().getParent().getParent().getParent().getParent().getParent().getChild(TEMPLATES);
        this._appServer_templates_documentCollection = this._templatesDocumentCollection.getChild(SERVERTYPES).getChild("APPLICATION_SERVER");
        try {
            this._proxyServer_templates_documentCollection = this._templatesDocumentCollection.getChild(SERVERTYPES).getChild("PROXY_SERVER");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._genericServer_templates_documentCollection = this._templatesDocumentCollection.getChild(SERVERTYPES).getChild("GENERIC_SERVER");
        this._webServer_templates_documentCollection = this._templatesDocumentCollection.getChild(SERVERTYPES).getChild("WEB_SERVER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createServer(String string) throws Exception {
        String string2;
        block21: {
            Tr.entry((TraceComponent)_tc, (String)"createServer", (Object)string);
            boolean bl = false;
            if (this._newServerDocumentCollection.documentExists("server.xml")) {
                bl = true;
            }
            WCCMDocument wCCMDocument = null;
            string2 = null;
            try {
                wCCMDocument = (WCCMDocument)this._oldServerDocumentCollection.openDocument("server.xml", WCCMDocument.class);
                Server server = (Server)UtilityImpl.locateConfigFileObject(wCCMDocument, Server.class);
                string2 = this.getServerType(server);
                if (!ServerCreationHelper.isSupportedServerType(string2) || bl && !string2.equals("NODE_AGENT")) break block21;
                this.copyCommonServerTemplates(this._newServerDocumentCollection, string2, server);
                WCCMDocument wCCMDocument2 = null;
                WCCMDocument wCCMDocument3 = null;
                try {
                    wCCMDocument2 = (WCCMDocument)this._newServerDocumentCollection.openDocument("server.xml", WCCMDocument.class, true, false);
                    wCCMDocument3 = (WCCMDocument)this._newServerDocumentCollection.getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class, false, false);
                    if (string2.equals("APPLICATION_SERVER") || string2.equals("MESSAGE_BROKER")) {
                        Server server2 = this.fixupConflicts(wCCMDocument2, string);
                        this.enrollServer(wCCMDocument3, server2, string2, string, server);
                        this._configHelper.addHAManagerSettings(this._newServerDocumentCollection, wCCMDocument3, string);
                    } else if (string2.equals("NODE_AGENT")) {
                        Server server3 = this.fixupConflicts(wCCMDocument2, string);
                        this.enrollServer(wCCMDocument3, server3, string2, string, server);
                        this._configHelper.addHAManagerSettings(this._newServerDocumentCollection, wCCMDocument3, string);
                    } else if (string2.equals("DEPLOYMENT_MANAGER")) {
                        Server server4 = this.fixupConflicts(wCCMDocument2, string);
                        this.enrollServer(wCCMDocument3, server4, string2, string, server);
                        this._configHelper.addHAManagerSettings(this._newServerDocumentCollection, wCCMDocument3, string);
                    } else if (string2.equals("GENERIC_SERVER")) {
                        Server server5 = this.fixupConflicts(wCCMDocument2, string);
                        this.enrollServer(wCCMDocument3, server5, string2, string, server);
                    } else if (string2.equals("PROXY_SERVER")) {
                        Server server6 = this.fixupConflicts(wCCMDocument2, string);
                        this.enrollServer(wCCMDocument3, server6, string2, string, server);
                    } else if (string2.equals("WEB_SERVER")) {
                        Server server7 = this.fixupConflicts(wCCMDocument2, string);
                        this.enrollServer(wCCMDocument3, server7, string2, string, server);
                    }
                }
                finally {
                    if (wCCMDocument3 != null) {
                        wCCMDocument3.close();
                    }
                    if (wCCMDocument2 != null) {
                        wCCMDocument2.close();
                    }
                }
            }
            finally {
                if (wCCMDocument != null) {
                    wCCMDocument.close();
                }
            }
        }
        return string2;
    }

    protected Server fixupConflicts(WCCMDocument wCCMDocument, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"fixupConflicts", (Object)new Object[]{wCCMDocument, string});
        Server server = (Server)UtilityImpl.locateConfigFileObject(wCCMDocument, Server.class);
        if (server != null) {
            WebContainer webContainer;
            ApplicationServer applicationServer;
            StreamRedirect streamRedirect;
            server.setName(string);
            StreamRedirect streamRedirect2 = server.getErrorStreamRedirect();
            if (streamRedirect2 != null) {
                streamRedirect2.setFileName("${LOG_ROOT}/" + string + "/SystemErr.log");
            }
            if ((streamRedirect = server.getOutputStreamRedirect()) != null) {
                streamRedirect.setFileName("${LOG_ROOT}/" + string + "/SystemOut.log");
            }
            if ((applicationServer = this.locateApplicationServer(wCCMDocument)) != null && (webContainer = this.locateWebContainer(applicationServer)) != null) {
                EList eList = webContainer.getTransports();
                eList.clear();
            }
            this.fixupNodeNameSetting(server);
        }
        return server;
    }

    protected ApplicationServer locateApplicationServer(WCCMDocument wCCMDocument) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"locateServer", (Object)new Object[]{wCCMDocument});
        Server server = (Server)UtilityImpl.locateConfigFileObject(wCCMDocument, Server.class);
        EList eList = server.getComponents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ApplicationServer)) continue;
            ApplicationServer applicationServer = (ApplicationServer)e;
            Tr.debug((TraceComponent)_tc, (String)("Found server entry: " + applicationServer.getServer().getName()));
            return applicationServer;
        }
        return null;
    }

    public void copyProxySettingsTemplate(ServerDocumentCollection serverDocumentCollection, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyProxySettingsTemplate", (Object)new Object[]{serverDocumentCollection, string});
        String string2 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
        string2 = string2.equals(DEFAULT) ? "proxy_server" : "proxy_server_zos";
        DocumentCollection documentCollection = this._proxyServer_templates_documentCollection;
        WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.getChild(SERVERS).getChild(string2).openDocument("resources.xml", WCCMDocument.class);
        boolean bl = false;
        if (serverDocumentCollection.documentExists("proxy-settings.xml")) {
            bl = true;
        }
        WCCMDocument wCCMDocument2 = (WCCMDocument)serverDocumentCollection.openDocument("proxy-settings.xml", WCCMDocument.class, true, false);
        if (!bl) {
            wCCMDocument2.setInputStream(wCCMDocument.getInputStream());
        }
        wCCMDocument.close();
        wCCMDocument2.close();
    }

    public void copyResourceTemplate(ServerDocumentCollection serverDocumentCollection, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyResourceTemplate", (Object)new Object[]{serverDocumentCollection, string});
        String string2 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
        DocumentCollection documentCollection = this._appServer_templates_documentCollection;
        if (string.equals("PROXY_SERVER")) {
            // empty if block
        }
        WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.getChild(SERVERS).getChild(string2).openDocument("resources.xml", WCCMDocument.class);
        boolean bl = false;
        if (serverDocumentCollection.documentExists("resources.xml")) {
            bl = true;
        }
        WCCMDocument wCCMDocument2 = (WCCMDocument)serverDocumentCollection.openDocument("resources.xml", WCCMDocument.class, true, false);
        if (!bl) {
            wCCMDocument2.setInputStream(wCCMDocument.getInputStream());
        }
        wCCMDocument.close();
        wCCMDocument2.close();
    }

    public void copyResourcePMETemplate(ServerDocumentCollection serverDocumentCollection, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyResourcePMETemplate", (Object)new Object[]{serverDocumentCollection, string});
        String string2 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
        DocumentCollection documentCollection = this._appServer_templates_documentCollection;
        if (string.equals("PROXY_SERVER")) {
            // empty if block
        }
        WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.getChild(SERVERS).getChild(string2).openDocument("resources-pme502.xml", WCCMDocument.class);
        WCCMDocument wCCMDocument2 = (WCCMDocument)documentCollection.getChild(SERVERS).getChild(string2).openDocument("resources-pme.xml", WCCMDocument.class);
        boolean bl = false;
        if (serverDocumentCollection.documentExists("resources-pme502.xml") && serverDocumentCollection.documentExists("resources-pme.xml")) {
            bl = true;
        }
        WCCMDocument wCCMDocument3 = (WCCMDocument)serverDocumentCollection.openDocument("resources-pme502.xml", WCCMDocument.class, true, false);
        WCCMDocument wCCMDocument4 = (WCCMDocument)serverDocumentCollection.openDocument("resources-pme.xml", WCCMDocument.class, true, false);
        if (!bl) {
            wCCMDocument3.setInputStream(wCCMDocument.getInputStream());
            wCCMDocument4.setInputStream(wCCMDocument2.getInputStream());
        }
        if (wCCMDocument != null && wCCMDocument2 != null) {
            wCCMDocument.close();
            wCCMDocument2.close();
        }
        if (wCCMDocument3 != null && wCCMDocument4 != null) {
            wCCMDocument3.close();
            wCCMDocument4.close();
        }
    }

    public void copySibServiceTemplate(ServerDocumentCollection serverDocumentCollection, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copySibServiceTemplate", (Object)new Object[]{serverDocumentCollection, string});
        try {
            String string2 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
            DocumentCollection documentCollection = this._appServer_templates_documentCollection;
            if (string.equals("PROXY_SERVER")) {
                documentCollection = this._proxyServer_templates_documentCollection;
            }
            WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.getChild(SERVERS).getChild(string2).openDocument("sib-service.xml", WCCMDocument.class);
            boolean bl = false;
            if (serverDocumentCollection.documentExists("sib-service.xml")) {
                bl = true;
            }
            WCCMDocument wCCMDocument2 = (WCCMDocument)serverDocumentCollection.openDocument("sib-service.xml", WCCMDocument.class, true, false);
            if (!bl) {
                wCCMDocument2.setInputStream(wCCMDocument.getInputStream());
            }
            wCCMDocument.close();
            wCCMDocument2.close();
        }
        catch (NotFoundException notFoundException) {
            Tr.debug((TraceComponent)_tc, (String)"Could not find source or destination documents.  This is possible condition because Bobcat does not ship with these files.", (Object)notFoundException);
        }
    }

    public void copyHAManagerTemplate(ServerDocumentCollection serverDocumentCollection, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyHAManagerTemplate", (Object)new Object[]{serverDocumentCollection, string});
        String string2 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
        DocumentCollection documentCollection = this._appServer_templates_documentCollection;
        if (string.equals("PROXY_SERVER")) {
            string2 = string2.equals(DEFAULT) ? "proxy_server" : "proxy_server_zos";
            documentCollection = this._proxyServer_templates_documentCollection;
        }
        WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.getChild(SERVERS).getChild(string2).openDocument("hamanagerservice.xml", WCCMDocument.class);
        boolean bl = false;
        if (serverDocumentCollection.documentExists("hamanagerservice.xml")) {
            bl = true;
        }
        WCCMDocument wCCMDocument2 = (WCCMDocument)serverDocumentCollection.openDocument("hamanagerservice.xml", WCCMDocument.class, true, false);
        if (!bl) {
            wCCMDocument2.setInputStream(wCCMDocument.getInputStream());
        }
        wCCMDocument.close();
        wCCMDocument2.close();
    }

    public void copySecurityTemplateFile(ServerDocumentCollection serverDocumentCollection, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copySecurityTemplateFile", (Object)new Object[]{serverDocumentCollection, string});
        String string2 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
        DocumentCollection documentCollection = this._appServer_templates_documentCollection;
        if (string.equals("PROXY_SERVER")) {
            string2 = string2.equals(DEFAULT) ? "proxy_server" : "proxy_server_zos";
            documentCollection = this._proxyServer_templates_documentCollection;
        }
        WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.getChild(SERVERS).getChild(string2).openDocument("ws-security.xml", WCCMDocument.class);
        boolean bl = false;
        if (serverDocumentCollection.documentExists("ws-security.xml")) {
            bl = true;
        }
        WCCMDocument wCCMDocument2 = (WCCMDocument)serverDocumentCollection.openDocument("ws-security.xml", WCCMDocument.class, true, false);
        if (!bl) {
            wCCMDocument2.setInputStream(wCCMDocument.getInputStream());
        }
        wCCMDocument.close();
        wCCMDocument2.close();
    }

    public void copyVariablesTemplate(ServerDocumentCollection serverDocumentCollection, String string, Server server) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyVariablesTemplate", (Object)new Object[]{serverDocumentCollection, string, server});
        String string2 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
        DocumentCollection documentCollection = this._appServer_templates_documentCollection;
        WCCMDocument wCCMDocument = (WCCMDocument)documentCollection.getChild(SERVERS).getChild(string2).openDocument("variables.xml", WCCMDocument.class);
        boolean bl = false;
        if (serverDocumentCollection.documentExists("variables.xml")) {
            bl = true;
        }
        WCCMDocument wCCMDocument2 = (WCCMDocument)serverDocumentCollection.openDocument("variables.xml", WCCMDocument.class, true, false);
        if (!bl) {
            wCCMDocument2.setInputStream(wCCMDocument.getInputStream());
        }
        wCCMDocument.close();
        wCCMDocument2.close();
    }

    public void copyServerTemplate(ServerDocumentCollection serverDocumentCollection, String string, Server server) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyServerTemplate", (Object)new Object[]{serverDocumentCollection, string, server});
        String string2 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
        WCCMDocument wCCMDocument = null;
        if (string.equals("MESSAGE_BROKER") || string.equals("DEPLOYMENT_MANAGER") || string.equals("APPLICATION_SERVER")) {
            wCCMDocument = (WCCMDocument)this._appServer_templates_documentCollection.getChild(SERVERS).getChild(string2).openDocument("server.xml", WCCMDocument.class);
        } else if (string.equals("GENERIC_SERVER")) {
            wCCMDocument = (WCCMDocument)this._genericServer_templates_documentCollection.getChild(SERVERS).getChild(string2).openDocument("server.xml", WCCMDocument.class);
        } else if (string.equals("WEB_SERVER")) {
            String string3 = this.getWebServerType(server);
            wCCMDocument = (WCCMDocument)this._webServer_templates_documentCollection.getChild(SERVERS).getChild(string3).openDocument("server.xml", WCCMDocument.class);
        } else if (string.equals("PROXY_SERVER")) {
            string2 = string2.equals(DEFAULT) ? "proxy_server" : "proxy_server_zos";
            wCCMDocument = (WCCMDocument)this._proxyServer_templates_documentCollection.getChild(SERVERS).getChild(string2).openDocument("server.xml", WCCMDocument.class);
        } else if (string.equals("NODE_AGENT")) {
            wCCMDocument = null;
        }
        boolean bl = false;
        if (serverDocumentCollection.documentExists("server.xml")) {
            bl = true;
        }
        WCCMDocument wCCMDocument2 = (WCCMDocument)serverDocumentCollection.openDocument("server.xml", WCCMDocument.class, true, false);
        if (!string.equals("NODE_AGENT")) {
            if (!bl) {
                wCCMDocument2.setInputStream(wCCMDocument.getInputStream());
            }
        } else {
            this.createNodeAgentTemplate(bl, wCCMDocument2);
        }
        if (wCCMDocument != null) {
            wCCMDocument.close();
        }
        wCCMDocument2.close();
    }

    public void copyServerPMETemplate(ServerDocumentCollection serverDocumentCollection, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyServerPMETemplate", (Object)new Object[]{serverDocumentCollection, string});
        String string2 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
        boolean bl = false;
        WCCMDocument wCCMDocument = null;
        WCCMDocument wCCMDocument2 = null;
        if (string.equals("MESSAGE_BROKER") || string.equals("APPLICATION_SERVER")) {
            bl = true;
            wCCMDocument = (WCCMDocument)this._appServer_templates_documentCollection.getChild(SERVERS).getChild(string2).openDocument("server-pme.xml", WCCMDocument.class);
            wCCMDocument2 = (WCCMDocument)this._appServer_templates_documentCollection.getChild(SERVERS).getChild(string2).openDocument("server-pme51.xml", WCCMDocument.class);
        } else if (string.equals("PROXY_SERVER")) {
            bl = true;
            string2 = string2.equals(DEFAULT) ? "proxy_server" : "proxy_server_zos";
            wCCMDocument = (WCCMDocument)this._proxyServer_templates_documentCollection.getChild(SERVERS).getChild(string2).openDocument("server-pme.xml", WCCMDocument.class);
            wCCMDocument2 = (WCCMDocument)this._proxyServer_templates_documentCollection.getChild(SERVERS).getChild(string2).openDocument("server-pme51.xml", WCCMDocument.class);
        }
        if (bl) {
            boolean bl2 = false;
            if (serverDocumentCollection.documentExists("server-pme.xml") && serverDocumentCollection.documentExists("server-pme51.xml")) {
                bl2 = true;
            }
            WCCMDocument wCCMDocument3 = (WCCMDocument)serverDocumentCollection.openDocument("server-pme.xml", WCCMDocument.class, true, false);
            WCCMDocument wCCMDocument4 = (WCCMDocument)serverDocumentCollection.openDocument("server-pme51.xml", WCCMDocument.class, true, false);
            if (!bl2) {
                wCCMDocument3.setInputStream(wCCMDocument.getInputStream());
                wCCMDocument4.setInputStream(wCCMDocument2.getInputStream());
            }
            if (wCCMDocument != null && wCCMDocument2 != null) {
                wCCMDocument.close();
                wCCMDocument2.close();
            }
            wCCMDocument3.close();
            wCCMDocument4.close();
        }
    }

    public void copyCommonServerTemplates(ServerDocumentCollection serverDocumentCollection, String string, Server server) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyCommonServerTemplates", (Object)new Object[]{serverDocumentCollection, string, server});
        if (string.equals("MESSAGE_BROKER")) {
            this.copyResourceTemplate(serverDocumentCollection, string);
            this.copyResourcePMETemplate(serverDocumentCollection, string);
            this.copySibServiceTemplate(serverDocumentCollection, string);
            this.copyHAManagerTemplate(serverDocumentCollection, string);
            this.copySecurityTemplateFile(serverDocumentCollection, string);
            this.copyServerTemplate(serverDocumentCollection, string, server);
            this.copyServerPMETemplate(serverDocumentCollection, string);
            this.copyVariablesTemplate(serverDocumentCollection, string, server);
        } else if (string.equals("APPLICATION_SERVER")) {
            this.copyResourceTemplate(serverDocumentCollection, string);
            this.copyResourcePMETemplate(serverDocumentCollection, string);
            this.copySibServiceTemplate(serverDocumentCollection, string);
            this.copyHAManagerTemplate(serverDocumentCollection, string);
            this.copySecurityTemplateFile(serverDocumentCollection, string);
            this.copyServerTemplate(serverDocumentCollection, string, server);
            this.copyServerPMETemplate(serverDocumentCollection, string);
        } else if (string.equals("NODE_AGENT")) {
            this.copyHAManagerTemplate(serverDocumentCollection, string);
            this.copyServerTemplate(serverDocumentCollection, string, server);
        } else if (string.equals("DEPLOYMENT_MANAGER")) {
            this.copyServerTemplate(serverDocumentCollection, string, server);
        } else if (string.equals("GENERIC_SERVER")) {
            this.copyServerTemplate(serverDocumentCollection, string, server);
        } else if (string.equals("WEB_SERVER")) {
            this.copyServerTemplate(serverDocumentCollection, string, server);
        } else if (string.equals("PROXY_SERVER")) {
            this.copyResourceTemplate(serverDocumentCollection, string);
            this.copyResourcePMETemplate(serverDocumentCollection, string);
            this.copyProxySettingsTemplate(serverDocumentCollection, string);
            this.copyHAManagerTemplate(serverDocumentCollection, string);
            this.copySecurityTemplateFile(serverDocumentCollection, string);
            this.copyServerTemplate(serverDocumentCollection, string, server);
            this.copyServerPMETemplate(serverDocumentCollection, string);
        }
    }

    protected String getWebServerType(Server server) {
        Tr.entry((TraceComponent)_tc, (String)"getWebServerType", (Object)server);
        Iterator iterator = server.getComponents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof WebServer)) continue;
            WebServer webServer = (WebServer)e;
            return webServer.getWebserverType().getName();
        }
        return null;
    }

    protected String getServerType(Server server) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getServerType", (Object)server);
        String string = null;
        WCCMDocument wCCMDocument = (WCCMDocument)this._oldServerDocumentCollection.getParent().getParent().openDocument("serverindex.xml", WCCMDocument.class);
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            if (!serverEntry.getServerName().equals(server.getName())) continue;
            string = serverEntry.getServerType();
            break;
        }
        wCCMDocument.close();
        if (!string.equals("APPLICATION_SERVER")) {
            return string;
        }
        if (this.isPre6xGenericServerType(server)) {
            return "GENERIC_SERVER";
        }
        return string;
    }

    protected boolean isPre6xGenericServerType(Server server) {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"isGenericServer", (Object)server);
        ProcessDef processDef = server.getProcessDefinition();
        if (processDef == null) {
            object = server.getProcessDefinitions();
            processDef = (ProcessDef)object.get(0);
        }
        if ((object = processDef.getExecutableName()) != null) {
            JavaProcessDef javaProcessDef;
            if (((String)(object = ((String)object).trim())).indexOf("java") < 0 && OSInfoFactory.isISeries() && ((String)object).indexOf("/QSYS.LIB/QEJBAS5.LIB/QEJBSVR.PGM") == -1 && ((String)object).indexOf("/QSYS.LIB/QASE5.LIB/QASESRV.PGM") == -1 && ((String)object).indexOf("/QSYS.LIB/QEJBAS51.LIB/QEJBSVR.PGM") == -1) {
                return true;
            }
            if (processDef instanceof JavaProcessDef && (javaProcessDef = (JavaProcessDef)processDef).getExecutableTarget() != null && !javaProcessDef.getExecutableTarget().equals("com.ibm.ws.runtime.WsServer")) {
                return true;
            }
        }
        return false;
    }

    protected void fixupNodeNameSetting(Server server) throws Exception {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"fixupNodeNameSetting", (Object)server);
        EList eList = server.getServices();
        Iterator iterator = eList.iterator();
        AdminService adminService = null;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof AdminService)) continue;
            adminService = (AdminService)object;
            break;
        }
        if (adminService != null) {
            Object object2;
            Tr.debug((TraceComponent)_tc, (String)"Found the AdminService entry in the server services list");
            object = adminService.getConnectors();
            Iterator iterator2 = object.iterator();
            SOAPConnector sOAPConnector = null;
            while (iterator2.hasNext()) {
                object2 = iterator2.next();
                if (!(object2 instanceof SOAPConnector)) continue;
                sOAPConnector = (SOAPConnector)object2;
                break;
            }
            if (sOAPConnector != null) {
                Object object3;
                Tr.debug((TraceComponent)_tc, (String)"Found the SOAPConnector in the AdminService connectors list");
                object2 = sOAPConnector.getProperties();
                Iterator iterator3 = object2.iterator();
                Property property = null;
                while (iterator3.hasNext()) {
                    object3 = (Property)iterator3.next();
                    if (!object3.getName().equals("sslConfig")) continue;
                    property = object3;
                    break;
                }
                if (property != null) {
                    Tr.debug((TraceComponent)_tc, (String)("Found the sslConfig Property=" + property.getName()));
                    object3 = property.getValue();
                    if (((String)object3).indexOf("$(node.name)") != -1) {
                        int n = ((String)object3).indexOf("$(node.name)");
                        String string = null;
                        if (n != 0) {
                            string = ((String)object3).substring(0, n);
                        }
                        string = string == null ? this._newServerDocumentCollection.getParent().getParent().getName() + ((String)object3).substring("$(node.name)".length(), ((String)object3).length()) : string + this._newServerDocumentCollection.getParent().getParent().getName() + ((String)object3).substring("$(node.name)".length(), ((String)object3).length());
                        property.setValue(string);
                    }
                }
            }
        }
    }

    protected WebContainer locateWebContainer(ApplicationServer applicationServer) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateWebContainer", (Object)applicationServer);
        EList eList = applicationServer.getComponents();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof WebContainer)) continue;
            WebContainer webContainer = (WebContainer)e;
            return webContainer;
        }
        return null;
    }

    protected ServerIndex enrollServer(WCCMDocument wCCMDocument, Server server, String string, String string2, Server server2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"enrollServer", (Object)new Object[]{server, string, string2, server2});
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        EList eList = serverIndex.getServerEntries();
        Iterator iterator = eList.iterator();
        ServerEntry serverEntry = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            serverEntry = (ServerEntry)iterator.next();
            if (!serverEntry.getServerName().equals(server.getName())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            serverEntry = ServerindexFactory.eINSTANCE.createServerEntry();
            serverEntry.setServerDisplayName(string2);
            serverEntry.setServerName(string2);
            eList.add((Object)serverEntry);
        }
        serverEntry.setServerType(string);
        this.addServerIndexPorts(wCCMDocument, serverEntry, serverIndex.getHostName(), string, server2);
        return serverIndex;
    }

    protected void addServerIndexPorts(WCCMDocument wCCMDocument, ServerEntry serverEntry, String string, String string2, Server server) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"addServerIndexPorts", (Object)new Object[]{serverEntry, string, string2, server});
        ServerEntry serverEntry2 = this.locateServerIndexTemplate(string2, server);
        EList eList = serverEntry2.getSpecialEndpoints();
        EList eList2 = serverEntry.getSpecialEndpoints();
        Iterator iterator = eList.iterator();
        NamedEndPoint namedEndPoint = null;
        NamedEndPoint namedEndPoint2 = null;
        while (iterator.hasNext()) {
            namedEndPoint = (NamedEndPoint)iterator.next();
            Iterator iterator2 = eList2.iterator();
            boolean bl = true;
            while (iterator2.hasNext() && bl) {
                namedEndPoint2 = (NamedEndPoint)iterator2.next();
                if (!namedEndPoint.getEndPointName().equals(namedEndPoint2.getEndPointName())) continue;
                if (OSInfoFactory.isZSeries() && namedEndPoint2.getEndPointName().equals("DCS_UNICAST_ADDRESS") && WASPostUpgrade.get_dcsHost() != null) {
                    namedEndPoint2.getEndPoint().setHost(WASPostUpgrade.get_dcsHost());
                }
                bl = false;
            }
            if (!bl) continue;
            String string3 = namedEndPoint.getEndPointName();
            if (string2.equals("NODE_AGENT") && (string3.equals("SIP_DEFAULTHOST") || string3.equals("SIP_DEFAULTHOST_SECURE"))) continue;
            eList2.add((Object)this.createSpecialEndPoint(wCCMDocument, string, namedEndPoint.getEndPoint().getPort(), string3));
        }
    }

    protected NamedEndPoint createSpecialEndPoint(WCCMDocument wCCMDocument, String string, int n, String string2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createSpecialEndPoint", (Object)new Object[]{wCCMDocument, string, new Integer(n), string2});
        Vector<String> vector = new Vector<String>();
        vector.add("SIP_DEFAULTHOST");
        vector.add("SIP_DEFAULTHOST_SECURE");
        vector.add("WC_defaulthost");
        vector.add("WC_defaulthost_secure");
        vector.add("WC_adminhost");
        vector.add("WC_adminhost_secure");
        EndPoint endPoint = IpcFactory.eINSTANCE.createEndPoint();
        if (OSInfoFactory.isZSeries() && string2.equals("DCS_UNICAST_ADDRESS")) {
            if (WASPostUpgrade.get_dcsHost() != null) {
                endPoint.setHost(WASPostUpgrade.get_dcsHost());
            }
        } else if (vector.contains(string2)) {
            endPoint.setHost("*");
        } else {
            endPoint.setHost(string);
        }
        int n2 = ((CellDocumentCollectionPostImpl)this._newServerDocumentCollection.getParent().getParent().getParent().getParent()).getPortUsage().createUniquePort(wCCMDocument, n);
        endPoint.setPort(n2);
        if (string2.equals("WC_defaulthost") || string2.equals("WC_defaulthost_secure")) {
            this.createChannelToVirtualHostLink("default_host", string2, "*", Integer.toString(n2));
        } else if (string2.equals("WC_adminhost") || string2.equals("WC_adminhost_secure")) {
            this.createChannelToVirtualHostLink("admin_host", string2, "*", Integer.toString(n2));
        }
        NamedEndPoint namedEndPoint = ServerindexFactory.eINSTANCE.createNamedEndPoint();
        namedEndPoint.setEndPoint(endPoint);
        namedEndPoint.setEndPointName(string2);
        return namedEndPoint;
    }

    protected void createChannelToVirtualHostLink(String string, String string2, String string3, String string4) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createChannelToVirtualhostLink", (Object)new Object[]{string, string2, string3, string4});
        WCCMDocument wCCMDocument = (WCCMDocument)this._newServerDocumentCollection.getParent().getParent().getParent().getParent().openDocument("virtualhosts.xml", WCCMDocument.class, false, false);
        Iterator iterator = wCCMDocument.getList().iterator();
        while (iterator.hasNext()) {
            HostAlias hostAlias;
            VirtualHost virtualHost = (VirtualHost)iterator.next();
            if (!virtualHost.getName().equals(string)) continue;
            boolean bl = false;
            Iterator iterator2 = virtualHost.getAliases().iterator();
            while (iterator2.hasNext()) {
                hostAlias = (HostAlias)iterator2.next();
                if (!hostAlias.getPort().equals(string4)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            hostAlias = (HostAlias)UtilityImpl.create(class$com$ibm$websphere$models$config$host$HostAlias == null ? ServerCreationHelper.class$("com.ibm.websphere.models.config.host.HostAlias") : class$com$ibm$websphere$models$config$host$HostAlias);
            hostAlias.setHostname(string3);
            hostAlias.setPort(string4);
            virtualHost.getAliases().add((Object)hostAlias);
        }
        if (wCCMDocument != null) {
            wCCMDocument.close();
        }
    }

    protected ServerEntry locateServerIndexTemplate(String string, Server server) throws Exception {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"locateServerIndexTemplate", (Object)new Object[]{string, server});
        String string2 = null;
        if (string.equals("APPLICATION_SERVER") || string.equals("DEPLOYMENT_MANAGER") || string.equals("MESSAGE_BROKER") || string.equals("NODE_AGENT")) {
            string2 = "APPLICATION_SERVER";
        } else if (string.equals("GENERIC_SERVER")) {
            string2 = "GENERIC_SERVER";
        } else if (string.equals("WEB_SERVER")) {
            string2 = "WEB_SERVER";
        } else if (string.equals("PROXY_SERVER")) {
            string2 = "PROXY_SERVER";
        }
        WCCMDocument wCCMDocument = (WCCMDocument)this._templatesDocumentCollection.getChild(SERVERTYPES).getChild(string2).openDocument("serverindex.xml", WCCMDocument.class);
        ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
        String string3 = null;
        if (string.equals("APPLICATION_SERVER") || string.equals("DEPLOYMENT_MANAGER") || string.equals("MESSAGE_BROKER") || string.equals("NODE_AGENT")) {
            string3 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
        } else if (string.equals("GENERIC_SERVER")) {
            string3 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
        } else if (string.equals("WEB_SERVER")) {
            string3 = this.getWebServerType(server);
        } else if (string.equals("PROXY_SERVER")) {
            string3 = UpgradeBase.get_newOSInfo().getServerIndexTemplateServerEntryName();
            string3 = string3.equals(DEFAULT) ? "proxy_server" : "proxy_server_zos";
        }
        wCCMDocument.close();
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry;
            object = iterator.next();
            if (!(object instanceof ServerEntry) || !(serverEntry = (ServerEntry)object).getServerName().equals(string3)) continue;
            return serverEntry;
        }
        object = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{wCCMDocument.getName()}, "Unable to read configuration file {0}.");
        throw new UpgradeException((String)object, null, false);
    }

    protected void createNodeAgentTemplate(boolean bl, WCCMDocument wCCMDocument) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createNodeAgentTemplate", (Object)new Object[]{new Boolean(bl), wCCMDocument});
        if (!bl) {
            NodeAgentConfigBuilder nodeAgentConfigBuilder = new NodeAgentConfigBuilder();
            nodeAgentConfigBuilder.setConfigRepositoryRoot(WASPostUpgrade.get_configRoot().getAbsolutePath());
            nodeAgentConfigBuilder.setProcessName("NODE_AGENT");
            nodeAgentConfigBuilder.setNodeName(this._newServerDocumentCollection.getParent().getParent().getName());
            File file = File.createTempFile("migration", "temp_file.xml");
            file.createNewFile();
            nodeAgentConfigBuilder.write(nodeAgentConfigBuilder.buildRootElements(), file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            Tr.debug((TraceComponent)_tc, (String)("Size of inStream.available(): " + fileInputStream.available()));
            StringBuffer stringBuffer = new StringBuffer();
            int n = inputStreamReader.read();
            while (n != -1) {
                stringBuffer.append((char)n);
                n = inputStreamReader.read();
            }
            byte[] byArray = stringBuffer.toString().getBytes("UTF-8");
            Tr.debug((TraceComponent)_tc, (String)("Size of byte[]: " + byArray.length));
            wCCMDocument.setInputStream(new ByteArrayInputStream(byArray));
            wCCMDocument.close();
        }
    }
}

