/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.IpcFactory;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.serverindex.ServerindexFactory;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.CellDocumentCollectionPostImpl;
import com.ibm.ws.migration.postupgrade.ConfigHelperFactory;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.postupgrade.common.ConfigHelper;
import com.ibm.ws.migration.postupgrade.common.PortUsage;
import com.ibm.ws.migration.postupgrade.common.ServerCreationHelper;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.NodeDocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.BasicWCCMDocumentProcessor;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class ServerIndexConfig
extends BasicWCCMDocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)ServerIndexConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static Vector _unsupportedServers = new Vector();
    protected ConfigHelper _configHelper = null;
    protected String _hostName = null;
    protected boolean _isNewEntry = false;
    protected String _serverEntryName = null;
    protected HashMap _serverEntryNameList = new HashMap();
    protected NamedEndPoint _DRSNamedEndPoint = null;
    protected CellDocumentCollectionPostImpl _cellDocumentCollectionPostImpl = null;

    public ServerIndexConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
        this._cellDocumentCollectionPostImpl = (CellDocumentCollectionPostImpl)documentTransform.getNewDocumentCollection().getParent().getParent();
        this._configHelper = ConfigHelperFactory.createConfigHelper((NodeDocumentCollection)this.getTransform().getNewDocumentCollection(), (NodeDocumentCollection)this.getTransform().getOldDocumentCollection());
        this.getProcessorHelper().addOverride(ServerEntry.class, "getDeployedApplications", new Class[0]);
        this.getProcessorHelper().addOverride(EndPoint.class, "setPort", new Class[]{Integer.TYPE});
        this.getProcessorHelper().addOverride(ServerIndex.class, "setHostName", new Class[]{String.class});
        this.getProcessorHelper().addOverride(EndPoint.class, "setHost", new Class[]{String.class});
        this.getProcessorHelper().addOverride(NamedEndPoint.class, "getEndPointName", new Class[0]);
        this.getProcessorHelper().addOverride(NamedEndPoint.class, "setEndPointName", new Class[]{String.class});
        this.getProcessorHelper().addOverride(ServerIndex.class, "getServerEntries", new Class[0]);
        this.getProcessorHelper().addOverride(ServerEntry.class, "setServerType", new Class[]{String.class});
    }

    public Document getTemplateDocument() {
        Tr.entry((TraceComponent)_tc, (String)"getTemplateDocument");
        return null;
    }

    public List getServerEntries(boolean bl, ServerIndex serverIndex) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getServerEntries", (Object)new Object[]{new Boolean(bl), serverIndex});
        EList eList = serverIndex.getServerEntries();
        if (bl) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry = (ServerEntry)iterator.next();
                if (ServerCreationHelper.isSupportedServerType(serverEntry.getServerType())) continue;
                iterator.remove();
                _unsupportedServers.add(serverEntry.getServerName());
                UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.unsupported.servertype", new Object[]{serverEntry.getServerName(), serverEntry.getServerType()}, "Found server {0} to be of type {1} which is unsupported in current product version.  {0} will not be migrated."));
            }
        }
        return eList;
    }

    public void processContents(List list, List list2) throws Exception {
        super.processContents(list, list2);
        if (PortUsage.isPortBlockSet() && !this._serverEntryNameList.isEmpty()) {
            File file = new File(this.getTransform().getNewDocumentCollection().getUrl().getPath(), "serverindex.xml");
            WCCMDocument wCCMDocument = (WCCMDocument)this.getProcessorHelper().getNewDocument();
            ServerIndex serverIndex = (ServerIndex)UtilityImpl.locateConfigFileObject(wCCMDocument, ServerIndex.class);
            if (serverIndex != null) {
                Iterator iterator = serverIndex.getServerEntries().iterator();
                while (iterator.hasNext()) {
                    ServerEntry serverEntry = (ServerEntry)iterator.next();
                    String string = serverEntry.getServerName();
                    if (!this._serverEntryNameList.containsKey(string)) continue;
                    Vector vector = (Vector)this._serverEntryNameList.get(string);
                    Iterator iterator2 = serverEntry.getSpecialEndpoints().iterator();
                    while (iterator2.hasNext()) {
                        NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                        if (vector.contains(namedEndPoint.getEndPointName())) continue;
                        try {
                            namedEndPoint.getEndPoint().setPort(this._cellDocumentCollectionPostImpl.getPortUsage().checkForUniquePort(new Integer(namedEndPoint.getEndPoint().getPort()).toString(), file));
                        }
                        catch (UpgradeException upgradeException) {
                            Tr.debug((TraceComponent)_tc, (String)upgradeException.toString());
                        }
                    }
                }
            }
        }
    }

    public void logProgressMessage(ServerEntry serverEntry, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{serverEntry, bl});
        this._isNewEntry = bl;
        this._serverEntryName = serverEntry.getServerName();
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"ServerEntry", serverEntry.getServerName()}, "Adding {0} entry {1} to the model."), true);
        } else {
            this._serverEntryNameList.put(this._serverEntryName, new Vector());
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.updating.entry", new Object[]{"ServerEntry", serverEntry.getServerName()}, "Updating attributes of {0} entry {1}, it is already defined in the existing model."), true);
        }
    }

    public boolean arePrimaryKeysEqual(ServerIndex serverIndex, ServerIndex serverIndex2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + serverIndex.getClass().getName()));
        this._hostName = serverIndex2.getHostName();
        return true;
    }

    public boolean arePrimaryKeysEqual(ServerEntry serverEntry, ServerEntry serverEntry2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + serverEntry.getClass().getName()));
        return serverEntry.getServerName().equals(serverEntry2.getServerName());
    }

    public boolean arePrimaryKeysEqual(NamedEndPoint namedEndPoint, NamedEndPoint namedEndPoint2) {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + namedEndPoint.getClass().getName()));
        Tr.debug((TraceComponent)_tc, (String)("Adding: " + namedEndPoint2.getEndPointName() + " to endpoint list for server: " + this._serverEntryName));
        Iterator iterator = this._serverEntryNameList.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            Tr.debug((TraceComponent)_tc, (String)("KEY=" + (String)object + " VALUE=" + this._serverEntryNameList.get(object)));
        }
        object = (Vector)this._serverEntryNameList.get(this._serverEntryName);
        Tr.debug((TraceComponent)_tc, (String)("serverEntryNameList=" + object));
        boolean bl = namedEndPoint.getEndPointName().equals(namedEndPoint2.getEndPointName());
        if (bl) {
            String string = namedEndPoint2.getEndPointName();
            if (object != null && string != null) {
                Tr.debug((TraceComponent)_tc, (String)("serverEntryNameList != null == " + object));
                ((Vector)object).add(string);
            }
        }
        return bl;
    }

    public List getDeployedApplications(boolean bl, ServerEntry serverEntry) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getDeployedApplications");
        return new BasicEList();
    }

    public void setPort(EndPoint endPoint, int n) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setPort", (Object)new Object[]{endPoint.getClass().getName(), new Integer(n)});
        File file = new File(this.getTransform().getNewDocumentCollection().getUrl().getPath(), "serverindex.xml");
        endPoint.setPort(this._cellDocumentCollectionPostImpl.getPortUsage().checkForUniquePort(Integer.toString(n), file));
    }

    public String getEndPointName(boolean bl, NamedEndPoint namedEndPoint) {
        Tr.entry((TraceComponent)_tc, (String)"getEndPointName", (Object)new Object[]{new Boolean(bl), namedEndPoint.getEndPointName()});
        if (OSInfoFactory.isZSeries() && !((ReleaseVersionImpl)this.getTransform().getScenario().getOldProductImage().getReleaseVersion()).isR60() && namedEndPoint.getEndPointName() != null && namedEndPoint.getEndPointName().equals("DRS_CLIENT_ADDRESS")) {
            this._DRSNamedEndPoint = namedEndPoint;
        }
        return namedEndPoint.getEndPointName();
    }

    public void setEndPointName(NamedEndPoint namedEndPoint, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setEndPointName", (Object)new Object[]{namedEndPoint, string});
        File file = new File(this.getTransform().getNewDocumentCollection().getUrl().getPath(), "serverindex.xml");
        if (OSInfoFactory.isZSeries()) {
            NamedEndPoint namedEndPoint2;
            Iterator iterator = ((ServerEntry)namedEndPoint.eContainer()).getSpecialEndpoints().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                namedEndPoint2 = (NamedEndPoint)iterator.next();
                if (namedEndPoint2.getEndPointName() == null || !namedEndPoint2.getEndPointName().equals("DCS_UNICAST_ADDRESS")) continue;
                if (this._DRSNamedEndPoint != null) {
                    namedEndPoint2.getEndPoint().setPort(this._cellDocumentCollectionPostImpl.getPortUsage().checkForUniquePort(Integer.toString(this._DRSNamedEndPoint.getEndPoint().getPort()), file));
                }
                if (WASPostUpgrade.get_dcsHost() != null) {
                    namedEndPoint2.getEndPoint().setHost(WASPostUpgrade.get_dcsHost());
                }
                bl = true;
            }
            if (!bl) {
                namedEndPoint2 = ServerindexFactory.eINSTANCE.createNamedEndPoint();
                namedEndPoint2.setEndPoint(IpcFactory.eINSTANCE.createEndPoint());
                ((ServerEntry)namedEndPoint.eContainer()).getSpecialEndpoints().add((Object)namedEndPoint2);
                namedEndPoint2.setEndPointName("DCS_UNICAST_ADDRESS");
                if (this._DRSNamedEndPoint != null) {
                    namedEndPoint2.getEndPoint().setPort(this._cellDocumentCollectionPostImpl.getPortUsage().checkForUniquePort(Integer.toString(this._DRSNamedEndPoint.getEndPoint().getPort()), file));
                }
                if (WASPostUpgrade.get_dcsHost() != null) {
                    namedEndPoint2.getEndPoint().setHost(WASPostUpgrade.get_dcsHost());
                } else {
                    namedEndPoint2.getEndPoint().setHost(this._hostName);
                }
            }
            this._DRSNamedEndPoint = null;
        }
        namedEndPoint.setEndPointName(string);
    }

    public void setHostName(ServerIndex serverIndex, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setHostName", (Object)new Object[]{serverIndex.getClass().getName(), string});
    }

    public void setServerType(ServerEntry serverEntry, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setServerType", (Object)new Object[]{serverEntry, string});
        if (string.equals("MESSAGE_BROKER")) {
            serverEntry.setServerType("APPLICATION_SERVER");
        } else {
            serverEntry.setServerType(string);
        }
    }

    public void setHost(EndPoint endPoint, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setHost", (Object)new Object[]{endPoint.getClass().getName(), string});
        if (OSInfoFactory.isZSeries() && ((NamedEndPoint)endPoint.eContainer()).getEndPointName().equals("DCS_UNICAST_ADDRESS") && WASPostUpgrade.get_dcsHost() != null) {
            endPoint.setHost(WASPostUpgrade.get_dcsHost());
        } else if (((NamedEndPoint)endPoint.eContainer()).getEndPointName().equals("NODE_MULTICAST_DISCOVERY_ADDRESS")) {
            endPoint.setHost(string);
        } else if (string.equals("*") || string.equals("localhost")) {
            endPoint.setHost(string);
        } else if (OSInfoFactory.isZSeries() && (((NamedEndPoint)endPoint.eContainer()).getEndPointName().equals("ORB_LISTENER_ADDRESS") || ((NamedEndPoint)endPoint.eContainer()).getEndPointName().equals("ORB_SSL_LISTENER_ADDRESS"))) {
            if (Pattern.matches(".*[a-zA-Z].*", string)) {
                endPoint.setHost("*");
            } else {
                endPoint.setHost(string);
            }
        } else {
            endPoint.setHost(this._hostName);
        }
    }
}

