/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.postupgrade.common.ApplicationTransactionalDocumentTransform;
import com.ibm.ws.migration.postupgrade.common.CloudscapeTransactionalDocumentTransform;
import com.ibm.ws.migration.postupgrade.common.ConfigTransactionalDocumentTransform;
import com.ibm.ws.migration.postupgrade.common.PropertiesTransactionalDocumentTransform;
import com.ibm.ws.migration.postupgrade.common.TransactionalLibAppTransform;
import com.ibm.ws.migration.transform.DescriptorEnabledTransform;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.util.Vector;

public class TransformBaseConfiguration {
    private static TraceComponent _tc = Tr.register((Class)TransformBaseConfiguration.class, null, (String)"com.ibm.ws.migration.WASUpgrade");

    public TransformBaseConfiguration(Vector vector, Scenario scenario) throws Exception {
        this.createConfigTransform(vector, scenario);
        this.createPropertiesTransform(vector, scenario);
        this.createCloudscapeTransform(vector, scenario);
        this.createCloudscapeCommonTransform(vector, scenario);
        this.createLibAppTransform(vector, scenario);
        this.createApplicationTransform(vector, scenario);
    }

    protected void createApplicationTransform(Vector vector, Scenario scenario) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createApplicationTransform", (Object)new Object[]{vector, scenario});
        if (!WASPostUpgrade.get_includeApps().equals("false")) {
            DocumentCollection documentCollection = null;
            try {
                documentCollection = scenario.getNewProductImage().getProfile().getDocumentCollection().getChild("installableApps");
            }
            catch (NotFoundException notFoundException) {
                documentCollection = scenario.getNewProductImage().getProfile().getDocumentCollection().addDocumentCollection("installableApps");
            }
            try {
                ApplicationTransactionalDocumentTransform applicationTransactionalDocumentTransform = new ApplicationTransactionalDocumentTransform(scenario, scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config").getChild("cells").getChildren()[0].getChild("applications"), documentCollection, null);
                vector.add(applicationTransactionalDocumentTransform);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw illegalArgumentException;
            }
            catch (NotFoundException notFoundException) {
                Tr.debug((TraceComponent)_tc, (String)"Didn't find old application directory so not populating application transforms");
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Didn't find old application directory so not populating application transforms");
            }
        } else {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.includeapps.false", new Object[0], "Applications will not be installed, the -includeApps attribute is set to false."));
        }
    }

    protected void createLibAppTransform(Vector vector, Scenario scenario) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createLibAppTransform", (Object)new Object[]{vector, scenario});
        TransactionalLibAppTransform transactionalLibAppTransform = new TransactionalLibAppTransform(scenario, scenario.getOldProductImage().getProfile().getDocumentCollection(), scenario.getNewProductImage().getProfile().getDocumentCollection(), null);
        vector.add(transactionalLibAppTransform);
    }

    protected void createPropertiesTransform(Vector vector, Scenario scenario) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createPropertiesTransform", (Object)new Object[]{vector, scenario});
        File file = new File(new File(new File(scenario.getOldProductImage().getProfile().getDirectory().getAbsolutePath()), "properties"), "ssl.client.props");
        File file2 = new File(new File(new File(scenario.getNewProductImage().getProfile().getDirectory().getAbsolutePath()), "properties"), "ssl.client.props");
        FileUtilities.copyFile(file2, file);
        PropertiesTransactionalDocumentTransform propertiesTransactionalDocumentTransform = new PropertiesTransactionalDocumentTransform(scenario, scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("properties"), scenario.getNewProductImage().getProfile().getDocumentCollection().getChild("properties"), null);
        vector.add(propertiesTransactionalDocumentTransform);
    }

    protected void createConfigTransform(Vector vector, Scenario scenario) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createConfigTransform", (Object)new Object[]{vector, scenario});
        DescriptorEnabledTransform.Descriptor descriptor = new DescriptorEnabledTransform.Descriptor(DescriptorEnabledTransform.class);
        ConfigTransactionalDocumentTransform configTransactionalDocumentTransform = new ConfigTransactionalDocumentTransform(scenario, scenario.getOldProductImage().getProfile().getDocumentCollection().getChild("config"), scenario.getNewProductImage().getProfile().getDocumentCollection().getChild("config"), null, descriptor);
        vector.add(configTransactionalDocumentTransform);
    }

    protected void createCloudscapeTransform(Vector vector, Scenario scenario) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createCloudscapeTransform", (Object)new Object[]{vector, scenario});
        try {
            this.createCloudscapeTransform(vector, scenario, "cloudscape");
        }
        catch (Exception exception) {
            Tr.entry((TraceComponent)_tc, (String)"Unabled to find cloudscape directory: ", (Object)exception);
        }
    }

    protected void createCloudscapeCommonTransform(Vector vector, Scenario scenario) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"createCloudscapeCommonTransform", (Object)new Object[]{vector, scenario});
        try {
            this.createCloudscapeTransform(vector, scenario, "cloudscapeCommon");
        }
        catch (Exception exception) {
            Tr.entry((TraceComponent)_tc, (String)"Unabled to find cloudscape directory: ", (Object)exception);
        }
    }

    protected void createCloudscapeTransform(Vector vector, Scenario scenario, String string) throws Exception {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"createCloudscapeTransform", (Object)new Object[]{vector, scenario, string});
        DocumentCollection documentCollection = scenario.getOldProductImage().getDocumentCollection();
        DocumentCollection documentCollection2 = scenario.getNewProductImage().getDocumentCollection();
        DocumentCollection documentCollection3 = documentCollection.getChild(string);
        try {
            object = documentCollection2.getChild("derby");
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Could not find corrosponding DC in new world so adding.");
            DocumentCollection documentCollection4 = documentCollection2.addDocumentCollection("derby");
        }
        try {
            object = new CloudscapeTransactionalDocumentTransform(scenario, scenario.getOldProductImage().getDocumentCollection().getChild(string), scenario.getNewProductImage().getDocumentCollection().getChild("derby"), null);
            vector.add(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (NotFoundException notFoundException) {
            Tr.debug((TraceComponent)_tc, (String)"Didn't find old application directory so not populating application transforms");
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Didn't find old application directory so not populating application transforms");
        }
    }
}

