/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProductImageImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.utility.Profile;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

public class TransformExtensionConfigurationHelper {
    private static TraceComponent _tc = Tr.register((Class)TransformExtensionConfigurationHelper.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final String PME_SERVER_FILE = "server-pme.xml";
    public static final String PME502_SERVER_FILE = "server-pme502.xml";
    public static final String PME51_SERVER_FILE = "server-pme51.xml";
    public static final String PME_RESOURCES_FILE = "resources-pme.xml";
    public static final String PME502_RESOURCES_FILE = "resources-pme502.xml";
    public static final String PME_CLUSTER_FILE = "cluster-pme.xml";
    public static final String SERIALIZED_PME_SERVER_FILE = "server-pme.ser";
    public static final String SERIALIZED_PME51_SERVER_FILE = "server-pme51.ser";
    public static final String SERIALIZED_PME_RESOURCES_FILE = "resources-pme.ser";
    public static final String SERIALIZED_PME502_RESOURCES_FILE = "resources-pme502.ser";
    public static final String TEMPLATES_DIRECTORY = "templates" + File.separator + "servertypes" + File.separator + "APPLICATION_SERVER" + File.separator + "servers" + File.separator + "default" + File.separator;
    public static final String[] DISABLED_EE_FEATURES = new String[]{"ExtendedMessagingService", "FlowContainer", "MemberManagerService", "StaffService", "WbiaService", "BusinessContextDataService", "ServiceReferenceService", "EventsService", "BRBeans", "CorbaSDK"};
    public static final String FLOW_CONTAINER = "ProcessContainer";
    public static final String DYNAMIC_QUERY = "query";
    public static final String PROCESS_PORTAL = "BPEWebClient";
    public static final String SCHEDULER_CALENDARS = "SchedulerCalendars";
    public static final String MEMBER_MANAGER = "wmm";
    protected ReleaseVersion _backupRelease;
    protected ReleaseVersion _currentRelease;
    protected DocumentTransform _caller;
    protected Hashtable _disableMethods = new Hashtable();

    public static void copyServerTemplateFile(File file, File file2, Configuration configuration) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyServerTemplateFile", (Object)new Object[]{file, file2, configuration});
        TransformExtensionConfigurationHelper.copyTemplateFile(file, file2, PME_SERVER_FILE, configuration);
        TransformExtensionConfigurationHelper.copyTemplateFile(file, file2, PME51_SERVER_FILE, configuration);
        TransformExtensionConfigurationHelper.copyResourceTemplateFile(file, file2, configuration);
    }

    public static void copyNodeTemplateFile(File file, File file2, Configuration configuration) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyNodeTemplateFile", (Object)new Object[]{file, file2, configuration});
        TransformExtensionConfigurationHelper.copyResourceTemplateFile(file, file2, configuration);
    }

    private static void copyResourceTemplateFile(File file, File file2, Configuration configuration) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyResourceTemplateFile", (Object)new Object[]{file, file2, configuration});
        TransformExtensionConfigurationHelper.copyTemplateFile(file, file2, PME_RESOURCES_FILE, configuration);
        TransformExtensionConfigurationHelper.copyTemplateFile(file, file2, PME502_RESOURCES_FILE, configuration);
    }

    public static void copyTemplateFile(File file, File file2, String string, Configuration configuration) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"copyTemplateFile", (Object)new Object[]{file, file2, string, configuration});
        if (!configuration.exists(new File(file2, string)) && configuration.exists(new File(file, string))) {
            configuration.copyFile(new File(file, string), new File(file2, string));
            Tr.debug((TraceComponent)_tc, (String)("Created new file: " + file2.getAbsolutePath() + string));
        }
    }

    public TransformExtensionConfigurationHelper(ReleaseVersion releaseVersion, ReleaseVersion releaseVersion2, DocumentTransform documentTransform) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"TransformExtensionConfigurationHelper", (Object)new Object[]{releaseVersion, releaseVersion2, documentTransform});
        this._backupRelease = releaseVersion;
        this._currentRelease = releaseVersion2;
        this._caller = documentTransform;
        for (int i = 0; i < DISABLED_EE_FEATURES.length; ++i) {
            try {
                Method method = (class$com$ibm$ws$migration$postupgrade$common$TransformExtensionConfigurationHelper == null ? TransformExtensionConfigurationHelper.class$("com.ibm.ws.migration.postupgrade.common.TransformExtensionConfigurationHelper") : class$com$ibm$ws$migration$postupgrade$common$TransformExtensionConfigurationHelper).getDeclaredMethod("disable" + DISABLED_EE_FEATURES[i], new Class[0]);
                this._disableMethods.put(DISABLED_EE_FEATURES[i], method);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.throwInternalErrorException(noSuchMethodException);
            }
        }
    }

    public TransformExtensionConfigurationHelper(DocumentTransform documentTransform) throws UpgradeException {
        this(((ProductImageImpl)documentTransform.getScenario().getOldProductImage()).getOSInfo().releaseVersion(), ((ProductImageImpl)documentTransform.getScenario().getNewProductImage()).getOSInfo().releaseVersion(), documentTransform);
    }

    public Document getTemplateDocument(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getTemplateDocument", (Object)string);
        DocumentCollection documentCollection = this._caller.getScenario().getNewProductImage().getProfile().getDocumentCollection().getChild("config").getChild("templates");
        return documentCollection.getChild("servertypes").getChild("APPLICATION_SERVER").getChild("servers").getChild("default").openDocument(string, WCCMDocument.class);
    }

    public String[] getEEProductApplications() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getEEProductApplications");
        Vector<String> vector = new Vector<String>();
        vector.addElement(DYNAMIC_QUERY);
        vector.addElement(SCHEDULER_CALENDARS);
        vector.addElement(MEMBER_MANAGER);
        vector.addElement(FLOW_CONTAINER);
        vector.addElement(PROCESS_PORTAL);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean isWbiUserApplication(EARFile eARFile) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"isWbiUserApplication", (Object)eARFile);
        EList eList = eARFile.getFiles();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string;
            Object e = iterator.next();
            if (!(e instanceof EJBJarFile) || !(string = ((EJBJarFile)e).getURI()).startsWith("BRBeans") || !string.endsWith(".jar")) continue;
            String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.brbeans.disabled", new Object[]{eARFile.getName()}, "Application {0} disabled because the required Enterprise Edition feature is not installed.");
            UpgradeBase.get_logger().println(string2);
            return true;
        }
        return false;
    }

    public String[] getEESamples() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getEESamples");
        return new String[]{"AccountManagement.ear", "AccountReport.ear", "activitysession.ear", "BRBeansSamples.ear", "CompanyContext.ear", "CurrencyExchange.ear", "DynamicQuery.ear", "EMSSamples.ear", "JTAExtensionsSamples.ear", "TravelBooking.ear", "WebSphereTrader.ear", "TravelBookingSamp.ear", "cppsdkGallery.ear", "ValuetypeSample.ear", "BPELSamples.ear"};
    }

    public String[] getInstallableEEProductApplications() throws Exception {
        Object[] objectArray;
        Tr.entry((TraceComponent)_tc, (String)"getInstallableEEProductApplications");
        Vector vector = new Vector();
        Hashtable hashtable = this.getApplications(this._caller.getScenario().getOldProductImage().getProfile());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            this.addInstallableEEProductApplication(vector, (String)objectArray, DYNAMIC_QUERY, "EjbQuery");
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void migrateCorbaServers() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"migrateCorbaServers");
        this.disableApplicationsByFeature("CorbaSDK");
    }

    public void migrateBRBean() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"migrateBRBean");
        this.disableApplicationsByFeature("BRBeans");
    }

    public boolean enableEEFeature(String string) {
        Tr.entry((TraceComponent)_tc, (String)"enableEEFeature", (Object)string);
        if (this._backupRelease.isExtendedServerProductInstalled("ND")) {
            if (this._backupRelease.isR60() || this._backupRelease.isR61()) {
                return true;
            }
            return this._backupRelease.isExtendedServerProductInstalled("PME");
        }
        return this._backupRelease.isEEFeatureInstalled(string);
    }

    public void disableApplicationsByFeature() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableApplicationsByFeature");
        for (int i = 0; i < DISABLED_EE_FEATURES.length; ++i) {
            this.disableApplicationsByFeature(DISABLED_EE_FEATURES[i]);
        }
    }

    public void disableApplicationsByFeature(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableApplicationsByFeature", (Object)string);
        if (this.enableEEFeature(string)) {
            Method method = (Method)this._disableMethods.get(string);
            try {
                method.invoke((Object)this, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof UpgradeException) {
                    throw (UpgradeException)throwable;
                }
                throw (RuntimeException)throwable;
            }
            catch (IllegalAccessException illegalAccessException) {
                Tr.debug((TraceComponent)_tc, (String)"Method call failed because method is not public.");
                this.throwInternalErrorException(illegalAccessException);
            }
        }
    }

    protected void disableCorbaSDK() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableCorbaSDK");
        String string = LoggerImpl.get_nls().getString("advise.corba.servers.disabled", "All CORBA servers will be disabled because the Enterprise Edition feature is not installed.");
        UpgradeBase.get_logger().println(string);
    }

    protected void disableExtendedMessagingService() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableExtendedMessagingService");
        String string = LoggerImpl.get_nls().getString("advise.enterprise.extendedmessaging.disabled", "Extended messaging service disabled because the required Enterprise Edition feature is not installed.");
        UpgradeBase.get_logger().println(string);
    }

    protected void disableFlowContainer() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableFlowContainer");
        String string = LoggerImpl.get_nls().getString("advise.enterprise.businessprocesscontainer.disabled", "Business Process container disabled because the required Enterprise Edition feature is not installed.");
        UpgradeBase.get_logger().println(string);
    }

    protected void disableMemberManagerService() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableMemberManagerService");
        String string = LoggerImpl.get_nls().getString("advise.enterprise.membermanager.disabled", "Member Manager service disabled because the required Enterprise Edition feature is not installed.");
        UpgradeBase.get_logger().println(string);
    }

    protected void disableStaffService() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableStaffService");
        String string = LoggerImpl.get_nls().getString("advise.enterprise.staff.disabled", "Staff service disabled because the required Enterprise Edition feature is not installed.");
        UpgradeBase.get_logger().println(string);
    }

    protected void disableWbiaService() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableWbiaService");
        String string = LoggerImpl.get_nls().getString("advise.enterprise.wbia.disabled", "WebSphere Business Integration Adapter service disabled because the required Enterprise Edition feature is not installed.");
        UpgradeBase.get_logger().println(string);
    }

    protected void disableBusinessContextDataService() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableBusinessContextDataService");
        String string = LoggerImpl.get_nls().getString("advise.enterprise.bcd.disabled", "IBM WebSphere Business Context Data service disabled because the required IBM WebSphere Business Integration Server Foundation feature is not installed.");
        UpgradeBase.get_logger().println(string);
    }

    protected void disableEventsService() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableEventsService");
        String string = LoggerImpl.get_nls().getString("advise.enterprise.event.disabled", "IBM WebSphere Application Event service disabled because the required IBM WebSphere Business Integration Server Foundation feature is not installed.");
        UpgradeBase.get_logger().println(string);
    }

    protected void disableServiceReferenceService() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableServiceReferenceService");
        String string = LoggerImpl.get_nls().getString("advise.enterprise.srs.disabled", "IBM WebSphere Web Service Reference service disabled because the required IBM WebSphere Business Integration Server Foundation feature is not installed.");
        UpgradeBase.get_logger().println(string);
    }

    protected void disableBRBeans() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"disableBRBeans");
    }

    protected void addInstallableEEProductApplication(Vector vector, String string, String string2, String string3) {
        Tr.entry((TraceComponent)_tc, (String)"addInstallableEEProductApplication", (Object)new Object[]{vector, string, string2, string3});
        if (this.enableEEFeature(string3) && string.toLowerCase().startsWith(string2.toLowerCase())) {
            vector.addElement(string);
        }
    }

    protected Hashtable getApplications(Profile profile) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getApplications", (Object)profile);
        Hashtable<String, ApplicationDeployment> hashtable = new Hashtable<String, ApplicationDeployment>();
        DocumentCollection documentCollection = profile.getDocumentCollection().getChild("config");
        DocumentCollection documentCollection2 = documentCollection.getChild("cells");
        DocumentCollection documentCollection3 = documentCollection2.getChildren()[0];
        DocumentCollection documentCollection4 = documentCollection3.getChild("applications");
        Tr.debug((TraceComponent)_tc, (String)("Applications Path: " + documentCollection4.getUrl()));
        DocumentCollection[] documentCollectionArray = documentCollection4.getChildren();
        int n = 0;
        if (documentCollectionArray != null) {
            n = documentCollectionArray.length;
        }
        Tr.debug((TraceComponent)_tc, (String)(n + " files found in directory " + documentCollection4.getUrl()));
        for (int i = 0; i < n; ++i) {
            Object object;
            if (!documentCollectionArray[i].getName().endsWith(".ear")) continue;
            DocumentCollection documentCollection5 = null;
            try {
                documentCollection5 = documentCollectionArray[i].getChild("deployments");
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            int n2 = documentCollectionArray[i].getName().lastIndexOf(46);
            DocumentCollection documentCollection6 = null;
            try {
                documentCollection6 = documentCollection5.getChild(documentCollectionArray[i].getName().substring(0, n2));
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            if (!documentCollection6.documentExists("deployment.xml")) continue;
            WCCMDocument wCCMDocument = (WCCMDocument)documentCollection6.openDocument("deployment.xml", class$com$ibm$wsspi$migration$document$wccm$WCCMDocument == null ? TransformExtensionConfigurationHelper.class$("com.ibm.wsspi.migration.document.wccm.WCCMDocument") : class$com$ibm$wsspi$migration$document$wccm$WCCMDocument);
            Resource resource = wCCMDocument.getResource();
            EList eList = resource.getContents();
            if (eList == null) {
                wCCMDocument.close();
                object = LoggerImpl.get_nls().getFormattedMessage("advise.invalid.configuration", new Object[]{documentCollection6.getUrl().getFile() + File.separator + wCCMDocument.getName()}, "Unable to read configuration file {0}.");
                UpgradeBase.get_logger().println((String)object);
                throw new UpgradeException((String)object, null, false);
            }
            object = (Deployment)eList.get(0);
            String string = documentCollectionArray[i].getName() + "/" + documentCollection5.getName() + "/" + documentCollection6.getName();
            hashtable.put(string, (ApplicationDeployment)object.getDeployedObject());
            wCCMDocument.close();
        }
        Tr.debug((TraceComponent)_tc, (String)(hashtable.size() + " deployed applications found in directory"));
        return hashtable;
    }

    private void throwInternalErrorException(Throwable throwable) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"throwInternalErrorException", (Object)throwable);
        String string = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{throwable}, "An unexpected internal error occurred, exception {0}.");
        UpgradeBase.get_logger().println(string);
        throw new UpgradeException(string, throwable, false);
    }
}

