/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.MimeEntry;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.CellDocumentCollectionPostImpl;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.postupgrade.common.PortUsage;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.BasicWCCMDocumentProcessor;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessorHelper;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.io.File;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class VirtualHostConfig
extends BasicWCCMDocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)VirtualHostConfig.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected CellDocumentCollectionPostImpl _cellDocumentCollectionPostImpl = null;

    public VirtualHostConfig(DocumentTransform documentTransform, TransformMappingKey transformMappingKey, WCCMDocumentProcessorHelper wCCMDocumentProcessorHelper) throws Exception {
        super(documentTransform, transformMappingKey, wCCMDocumentProcessorHelper);
        this._cellDocumentCollectionPostImpl = (CellDocumentCollectionPostImpl)documentTransform.getNewDocumentCollection();
        this.getProcessorHelper().addOverride(HostAlias.class, "setPort", new Class[]{String.class});
    }

    public Document getTemplateDocument() {
        Tr.entry((TraceComponent)_tc, (String)"getTemplateDocument");
        return null;
    }

    public void logProgressMessage(VirtualHost virtualHost, Boolean bl) {
        Tr.entry((TraceComponent)_tc, (String)"logProgressMessage", (Object)new Object[]{virtualHost, bl});
        if (bl.booleanValue()) {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.adding.element", new Object[]{"VirtualHosts", virtualHost.getName()}, "Adding {0} entry {1} to the model."), true);
        } else {
            UpgradeBase.get_logger().println(LoggerImpl.get_nls().getFormattedMessage("advise.logging.updating.entry", new Object[]{"VirtualHosts", virtualHost.getName()}, "Updating attributes of {0} entry {1}, it is already defined in the existing model."), true);
        }
    }

    public boolean arePrimaryKeysEqual(VirtualHost virtualHost, VirtualHost virtualHost2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + virtualHost.getClass().getName()));
        boolean bl = virtualHost.getName().equals(virtualHost2.getName());
        EList eList = virtualHost2.getAliases();
        if (bl && WASPostUpgrade.is_replacePorts() && !virtualHost.getName().equals("admin_host")) {
            eList.clear();
        }
        if (bl && PortUsage.isPortBlockSet() && !eList.isEmpty()) {
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                HostAlias hostAlias = (HostAlias)iterator.next();
                if (hostAlias.getPort().length() <= 0) continue;
                try {
                    File file = new File(this.getTransform().getNewDocumentCollection().getUrl().getPath(), "virtualhosts.xml");
                    hostAlias.setPort(new Integer(this._cellDocumentCollectionPostImpl.getPortUsage().checkForUniquePort(hostAlias.getPort(), file)).toString());
                }
                catch (Exception exception) {
                    Tr.debug((TraceComponent)_tc, (String)exception.toString());
                }
            }
        }
        return bl;
    }

    public boolean arePrimaryKeysEqual(MimeEntry mimeEntry, MimeEntry mimeEntry2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + mimeEntry.getClass().getName()));
        return mimeEntry.getType().equals(mimeEntry2.getType());
    }

    public boolean arePrimaryKeysEqual(HostAlias hostAlias, HostAlias hostAlias2) {
        Tr.entry((TraceComponent)_tc, (String)("arePrimaryKeysEqual -- " + hostAlias.getClass().getName()));
        return hostAlias.getHostname().equals(hostAlias2.getHostname()) && hostAlias.getPort().equals(hostAlias2.getPort());
    }

    public void setPort(HostAlias hostAlias, String string) {
        Tr.entry((TraceComponent)_tc, (String)"setHost", (Object)new Object[]{hostAlias.getClass().getName(), string});
        if (PortUsage.isPortBlockSet() && string.length() > 0) {
            try {
                File file = new File(this.getTransform().getNewDocumentCollection().getUrl().getPath(), "virtualhosts.xml");
                hostAlias.setPort(new Integer(this._cellDocumentCollectionPostImpl.getPortUsage().checkForUniquePort(string, file)).toString());
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)exception.toString());
                hostAlias.setPort(string);
            }
        } else {
            hostAlias.setPort(string);
        }
    }
}

