/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.postupgrade.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.SerializedWCCMObject;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.common.XMLReflectionHelper;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.document.BasicDocument;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.document.wccm.WCCMDocumentProcessor;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.io.File;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class XMLDeserializer
implements WCCMDocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)XMLDeserializer.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final String SETTER_PREFIX = "set";
    public static final String GETTER_PREFIX = "get";
    public static final String BOOLEAN_GETTER_PREFIX = "is";
    protected Vector _oldObjects = new Vector();
    protected Vector _newObjects = new Vector();
    private Vector _serializedContents = new Vector();
    protected DocumentTransform _transform;
    protected TransformMappingKey _key;
    private WCCMDocument _oldDocument = null;
    private WCCMDocument _newDocument = null;
    protected XMLReflectionHelper _reflectionHelper = new XMLReflectionHelper();
    static /* synthetic */ Class class$org$eclipse$emf$common$util$AbstractEnumerator;

    public XMLDeserializer(DocumentTransform documentTransform, TransformMappingKey transformMappingKey) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"XMLDeserializer", (Object)new Object[]{documentTransform, transformMappingKey});
        this._transform = documentTransform;
        this._key = transformMappingKey;
    }

    public void migrate() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate");
        DocumentCollection documentCollection = this._transform.getOldDocumentCollection();
        DocumentCollection documentCollection2 = this._transform.getNewDocumentCollection();
        this.migrate(documentCollection, documentCollection2);
    }

    public void migrate(DocumentCollection documentCollection, DocumentCollection documentCollection2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate", (Object)new Object[]{documentCollection, documentCollection2});
        if (documentCollection2.documentExists(this._key.getNewDocumentName())) {
            return;
        }
        WCCMDocument wCCMDocument = this.getOldDocument(documentCollection);
        WCCMDocument wCCMDocument2 = (WCCMDocument)documentCollection2.openDocument(this._key.getNewDocumentName(), WCCMDocument.class, true, false);
        this.migrate(wCCMDocument, wCCMDocument2);
    }

    public void migrate(WCCMDocument wCCMDocument, WCCMDocument wCCMDocument2) throws IllegalArgumentException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate", (Object)new Object[]{wCCMDocument, wCCMDocument2});
        this._oldDocument = wCCMDocument;
        this._newDocument = wCCMDocument2;
        this.processContents(wCCMDocument.getList(), wCCMDocument2.getList());
        wCCMDocument.close();
        wCCMDocument2.close();
    }

    public void processContents(List list, List list2) throws IllegalArgumentException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"processContents", (Object)new Object[]{list, list2});
        for (int i = 0; i < list.size(); ++i) {
            list2.add(list.get(i));
        }
    }

    public Document getTemplateDocument() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getTemplateDocument");
        return null;
    }

    public boolean isUnexpectedClass(Class clazz) throws IllegalArgumentException {
        Tr.entry((TraceComponent)_tc, (String)"isUnexpectedClass", (Object)clazz);
        return false;
    }

    public boolean processClass(Class clazz) throws IllegalArgumentException {
        Tr.entry((TraceComponent)_tc, (String)"processClass", (Object)clazz);
        return true;
    }

    public Document getNewDocument() throws IllegalStateException {
        Tr.entry((TraceComponent)_tc, (String)"getNewDocument");
        if (this._newDocument == null) {
            throw new IllegalStateException();
        }
        return this._newDocument;
    }

    public Document getOldDocument() throws IllegalStateException {
        Tr.entry((TraceComponent)_tc, (String)"getOldDocument");
        if (this._oldDocument == null) {
            try {
                this._oldDocument = this.getOldDocument(this._transform.getOldDocumentCollection());
            }
            catch (Exception exception) {
                IllegalStateException illegalStateException = new IllegalStateException();
                illegalStateException.initCause(exception);
                throw illegalStateException;
            }
        }
        return this._oldDocument;
    }

    protected WCCMDocument getOldDocument(DocumentCollection documentCollection) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getOldDocument", (Object)documentCollection);
        WCCMDocument wCCMDocument = new WCCMDocument(this._key.getOldDocumentName(), this._transform.getScenario().getOldProductImage().getDocumentCollection());
        wCCMDocument.getList().clear();
        this._serializedContents = this.restore(documentCollection);
        this.processSerializedContents(this._serializedContents, wCCMDocument.getList());
        return wCCMDocument;
    }

    protected boolean continueProcessingTag(SerializedWCCMObject serializedWCCMObject) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"continueProcessingTag", (Object)serializedWCCMObject);
        return true;
    }

    protected void processSerializedContents(List list, List list2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processContents", (Object)new Object[]{list, list2});
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.processXML((SerializedWCCMObject)iterator.next(), list2);
        }
        this.processCrossReferences();
    }

    protected void processXML(SerializedWCCMObject serializedWCCMObject, Object object) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXML", (Object)new Object[]{serializedWCCMObject, object});
        if (!this.continueProcessingTag(serializedWCCMObject)) {
            return;
        }
        String string = serializedWCCMObject.getClassName();
        Class clazz = this.getClass(string);
        Object object2 = null;
        if (object instanceof List) {
            String string2 = serializedWCCMObject.getAbstractEnumeratorValue();
            object2 = string2 != null ? this.getAbstractEnumerator(clazz, string2) : this._reflectionHelper.create(string);
            Tr.debug((TraceComponent)_tc, (String)("Created object of type: " + object2.getClass().getName()));
            ((List)object).add(object2);
        } else {
            object2 = object;
        }
        this._oldObjects.addElement(serializedWCCMObject);
        this._newObjects.addElement(object2);
        this.processXMLAttributes(serializedWCCMObject, object2, clazz);
        this.processXMLChildTagLists(serializedWCCMObject, object2, clazz);
        this.processXMLChildTagSingleObjects(serializedWCCMObject, object2, clazz);
    }

    protected void processXMLAttributes(SerializedWCCMObject serializedWCCMObject, Object object, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXMLAttributes", (Object)new Object[]{serializedWCCMObject, object, clazz});
        Hashtable hashtable = serializedWCCMObject.getAttributeGettersAndValues();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object2 = hashtable.get(string);
            Method method = this.getAttributeSetter(string, clazz);
            if (method == null) {
                if (string.equals("getRefId") || string.equals("isDelivery") || string.equals("isDeliveryAll")) continue;
                System.out.println("Ignored method " + string + " on class " + clazz.getName());
                continue;
            }
            if ((class$org$eclipse$emf$common$util$AbstractEnumerator == null ? XMLDeserializer.class$("org.eclipse.emf.common.util.AbstractEnumerator") : class$org$eclipse$emf$common$util$AbstractEnumerator).isAssignableFrom(method.getParameterTypes()[0])) {
                object2 = this.getAbstractEnumerator(method.getParameterTypes()[0], String.valueOf(object2));
            }
            this.invoke(method, object, new Object[]{object2}, false, clazz);
        }
    }

    protected void processXMLChildTagLists(SerializedWCCMObject serializedWCCMObject, Object object, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXMLChildTagLists", (Object)new Object[]{serializedWCCMObject, object, clazz});
        Hashtable hashtable = serializedWCCMObject.getChildTagListGettersAndValues();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Method method = this.getChildTagListMethod(string, clazz);
            List list = (List)hashtable.get(string);
            List list2 = (List)this.invoke(method, object, new Object[0], false, clazz);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof SerializedWCCMObject) {
                    this.processXML((SerializedWCCMObject)e, list2);
                    continue;
                }
                list2.add(e);
            }
        }
    }

    protected void processXMLChildTagSingleObjects(SerializedWCCMObject serializedWCCMObject, Object object, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXMLChildTagSingleObjects", (Object)new Object[]{serializedWCCMObject, object, clazz});
        Hashtable hashtable = serializedWCCMObject.getChildTagSingleGettersAndValues();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object2;
            String string = (String)enumeration.nextElement();
            SerializedWCCMObject serializedWCCMObject2 = (SerializedWCCMObject)hashtable.get(string);
            if (!this.continueProcessingTag(serializedWCCMObject2)) continue;
            Method[] methodArray = this.getChildTagSingleMethods(string, clazz);
            Method method = methodArray[0];
            Method method2 = methodArray[1];
            if (this._oldObjects.contains(serializedWCCMObject2)) {
                Tr.debug((TraceComponent)_tc, (String)("Found a back XML reference on method: " + string));
                int n = this._oldObjects.indexOf(serializedWCCMObject2);
                object2 = this._newObjects.elementAt(n);
                this.invoke(method2, object, new Object[]{object2}, false, clazz);
                continue;
            }
            String string2 = serializedWCCMObject.getAbstractEnumeratorValue();
            if (string2 != null) {
                object2 = this.getAbstractEnumerator(clazz, string2);
                this.invoke(method2, object, new Object[]{object2}, false, clazz);
                continue;
            }
            object2 = this.invoke(method, object, new Object[0], false, clazz);
            if (object2 == null) {
                object2 = this._reflectionHelper.create(serializedWCCMObject2.getClassName());
                Tr.debug((TraceComponent)_tc, (String)("Created object of type: " + object2.getClass().getName()));
            }
            this.invoke(method2, object, new Object[]{object2}, false, clazz);
            this.processXML(serializedWCCMObject2, object2);
        }
    }

    protected Method getAttributeSetter(String string, Class clazz) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getAttributeSetter", (Object)new Object[]{string, clazz});
        Method[] methodArray = clazz.getMethods();
        Hashtable<String, Method> hashtable = new Hashtable<String, Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().startsWith(SETTER_PREFIX) || methodArray[i].getParameterTypes().length != 1 || !methodArray[i].getParameterTypes()[0].getName().startsWith("java.lang.") && !methodArray[i].getParameterTypes()[0].isPrimitive() && !(class$org$eclipse$emf$common$util$AbstractEnumerator == null ? XMLDeserializer.class$("org.eclipse.emf.common.util.AbstractEnumerator") : class$org$eclipse$emf$common$util$AbstractEnumerator).isAssignableFrom(methodArray[i].getParameterTypes()[0]) || !methodArray[i].getReturnType().getName().equals("void")) continue;
            hashtable.put(methodArray[i].getName(), methodArray[i]);
            Tr.debug((TraceComponent)_tc, (String)("Added setter " + methodArray[i].getName()));
        }
        String string2 = null;
        string2 = string.startsWith(GETTER_PREFIX) ? SETTER_PREFIX + string.substring(GETTER_PREFIX.length(), string.length()) : SETTER_PREFIX + string.substring(BOOLEAN_GETTER_PREFIX.length(), string.length());
        return (Method)hashtable.get(string2);
    }

    protected Method getChildTagListMethod(String string, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getChildTagListMethod", (Object)new Object[]{string, clazz});
        Method method = null;
        try {
            method = clazz.getMethod(string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            this.throwInternalErrorException(noSuchMethodException);
        }
        return method;
    }

    protected Method[] getChildTagSingleMethods(String string, Class clazz) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getChildTagSingleSetter", (Object)new Object[]{string, clazz});
        Method[] methodArray = clazz.getMethods();
        Hashtable<String, Method> hashtable = new Hashtable<String, Method>();
        Hashtable<String, Method> hashtable2 = new Hashtable<String, Method>();
        for (int i = 0; i < methodArray.length; ++i) {
            if (methodArray[i].getName().startsWith(GETTER_PREFIX) && !methodArray[i].getName().endsWith("Refs") && methodArray[i].getParameterTypes().length == 0 && this.isWebSphereClass(methodArray[i].getReturnType())) {
                hashtable.put(methodArray[i].getName(), methodArray[i]);
                Tr.debug((TraceComponent)_tc, (String)("Added getter " + methodArray[i].getName()));
                continue;
            }
            if (!methodArray[i].getName().startsWith(SETTER_PREFIX) || methodArray[i].getName().endsWith("Refs") || methodArray[i].getParameterTypes().length != 1 || !this.isWebSphereClass(methodArray[i].getParameterTypes()[0]) || !methodArray[i].getReturnType().getName().equals("void")) continue;
            hashtable2.put(methodArray[i].getName(), methodArray[i]);
            Tr.debug((TraceComponent)_tc, (String)("Added setter " + methodArray[i].getName()));
        }
        Method[] methodArray2 = new Method[2];
        methodArray2[0] = (Method)hashtable.get(string);
        String string2 = SETTER_PREFIX + string.substring(GETTER_PREFIX.length(), string.length());
        methodArray2[1] = (Method)hashtable2.get(string2);
        return methodArray2;
    }

    private boolean isWebSphereClass(Class clazz) {
        Tr.entry((TraceComponent)_tc, (String)"isWebSphereClass", (Object)clazz);
        return this._reflectionHelper.isWebSphereClass(clazz);
    }

    protected Object invoke(Method method, Object object, Object[] objectArray, boolean bl, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"invoke", (Object)new Object[]{method, object, objectArray, new Boolean(bl), clazz});
        return this._reflectionHelper.invoke(method, object, objectArray, bl, clazz);
    }

    protected Object getAbstractEnumerator(Class clazz, String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getAbstractEnumerator", (Object)new Object[]{clazz, string});
        Object object = null;
        try {
            Method method = clazz.getMethod(GETTER_PREFIX, String.class);
            object = method.invoke(null, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleInvocationTargetException(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.throwInternalErrorException(noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.throwInternalErrorException(illegalAccessException);
        }
        return object;
    }

    protected Class getClass(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getClass", (Object)string);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.throwInternalErrorException(classNotFoundException);
        }
        return clazz;
    }

    private void processCrossReferences() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processCrossReferences");
        SerializedWCCMObject serializedWCCMObject = (SerializedWCCMObject)this._serializedContents.elementAt(0);
        Vector vector = serializedWCCMObject.getCrossReferences();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            SerializedWCCMObject serializedWCCMObject2 = (SerializedWCCMObject)objectArray[0];
            String string = (String)objectArray[1];
            SerializedWCCMObject serializedWCCMObject3 = (SerializedWCCMObject)objectArray[2];
            if (!this.continueProcessingTag(serializedWCCMObject3) || !this.continueProcessingTag(serializedWCCMObject2)) continue;
            int n = this._oldObjects.indexOf(serializedWCCMObject3);
            Object e = this._newObjects.elementAt(n);
            n = this._oldObjects.indexOf(serializedWCCMObject2);
            Object e2 = this._newObjects.elementAt(n);
            String string2 = serializedWCCMObject2.getClassName();
            Class clazz = this.getClass(string2);
            Method[] methodArray = this.getChildTagSingleMethods(string, clazz);
            Method method = methodArray[1];
            this.invoke(method, e2, new Object[]{e}, false, clazz);
        }
    }

    private void handleInvocationTargetException(InvocationTargetException invocationTargetException) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"handleInvocationTargetException", (Object)invocationTargetException);
        this._reflectionHelper.handleInvocationTargetException(invocationTargetException);
    }

    protected void throwInternalErrorException(Throwable throwable) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"throwInternalErrorException", (Object)throwable);
        XMLReflectionHelper.throwInternalErrorException(throwable);
    }

    public Vector restore(DocumentCollection documentCollection) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"restore");
        Vector vector = null;
        Document document = documentCollection.openDocument(this._key.getOldDocumentName(), BasicDocument.class);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(document.getInputStream());
            vector = (Vector)objectInputStream.readObject();
            objectInputStream.close();
            document.close();
        }
        catch (Exception exception) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.error.reading.backup.options", new Object[]{documentCollection.getUrl().getFile() + File.separator + document.getName(), exception}, "Unable to read backup options file {0}, exception {1}.");
            UpgradeBase.get_logger().println(string);
            throw new UpgradeException(string, exception, false);
        }
        return vector;
    }
}

