/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.preupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminClientFactory;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.process.Service;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.security.UserRegistry;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.File;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;

public class ConfigRepository {
    private static TraceComponent _tc = Tr.register((Class)ConfigRepository.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static final String SERVER_NAME = "SERVER_NAME";
    private static final String SOAP_PORT = "SOAP_PORT";
    private static final String SOAP_HOST = "SOAP_HOST";
    private static final String RMI_PORT = "RMI_PORT";
    private static final String RMI_HOST = "RMI_HOST";
    private static final String ADMINCONSOLE = "adminconsole.ear";
    private static String HOST_ADDRESS = null;
    private static boolean _isGlobalSecurityEnabled = false;
    private static String _globalSecurityUserID = null;
    private static String _globalSecurityPassword = null;
    private static Configuration _configuration = null;
    private static boolean _hasThisClassBeenCreateBefore = false;
    private static boolean _hasLockBeenObtained = false;
    private static Vector _validConnectionProps = new Vector();
    private static Vector _openJMXAgentConnections = new Vector();
    static /* synthetic */ Class class$com$ibm$websphere$models$config$process$Server;

    public ConfigRepository(Configuration configuration) {
        Tr.entry((TraceComponent)_tc, (String)"ConfigRepository", (Object)new Object[]{configuration});
        if (!_hasThisClassBeenCreateBefore) {
            _hasThisClassBeenCreateBefore = true;
            try {
                HOST_ADDRESS = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            _configuration = configuration;
            this.gatherAllValidConnections();
            this.createJMXAgentConnections();
        }
    }

    public void lockConfigRepository() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"lockConfigRepository");
        if (!_hasLockBeenObtained) {
            _hasLockBeenObtained = true;
            String string = "lockRepository";
            String[] stringArray = new String[]{"java.lang.String"};
            Object[] objectArray = new Object[]{"Migration is processing configuration directory."};
            for (int i = 0; i < _openJMXAgentConnections.size(); ++i) {
                try {
                    AdminConnection adminConnection = (AdminConnection)_openJMXAgentConnections.get(i);
                    Boolean bl = (Boolean)adminConnection._adminClient.invoke(adminConnection._configRepository, string, objectArray, stringArray);
                    if (!bl.booleanValue()) {
                        String string2 = LoggerImpl.get_nls().getString("advise.repository.locked", "MIGR0349E: Unable to access configuration directory.");
                        UpgradeBase.get_logger().println(string2);
                        throw new UpgradeException(string2, null, false);
                    }
                    continue;
                }
                catch (UpgradeException upgradeException) {
                    throw upgradeException;
                }
                catch (Exception exception) {
                    Tr.debug((TraceComponent)_tc, (String)exception.toString());
                }
            }
        }
    }

    public static void unlockConfigRepository() {
        Tr.entry((TraceComponent)_tc, (String)"unlockConfigRepository");
        Boolean bl = null;
        for (int i = 0; i < _openJMXAgentConnections.size(); ++i) {
            AdminConnection adminConnection = (AdminConnection)_openJMXAgentConnections.get(i);
            if (adminConnection._adminClient == null) continue;
            String string = "unlockRepository";
            String[] stringArray = new String[]{"java.lang.String"};
            Object[] objectArray = new Object[]{"Migration is processing configuration directory."};
            try {
                bl = (Boolean)adminConnection._adminClient.invoke(adminConnection._configRepository, string, objectArray, stringArray);
                continue;
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)exception.toString());
            }
        }
    }

    private void gatherAllValidConnections() {
        Tr.entry((TraceComponent)_tc, (String)"gatherAllValidConnections");
        try {
            ServerIndex serverIndex = (ServerIndex)_configuration.locateConfigFileObject(new File(_configuration.getNodeDirectory(), "serverindex.xml"), ServerIndex.class);
            Hashtable<String, String> hashtable = null;
            EList eList = serverIndex.getServerEntries();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry = (ServerEntry)iterator.next();
                EList eList2 = serverEntry.getDeployedApplications();
                Iterator iterator2 = eList2.iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    if (!string.startsWith(ADMINCONSOLE)) continue;
                    Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                    if (serverEntry.getServerType().equals("DEPLOYMENT_MANAGER")) {
                        hashtable = hashtable2;
                    }
                    _validConnectionProps.add(hashtable2);
                    hashtable2.put(SERVER_NAME, serverEntry.getServerName());
                    EList eList3 = serverEntry.getSpecialEndpoints();
                    Iterator iterator3 = eList3.iterator();
                    while (iterator3.hasNext()) {
                        EndPoint endPoint;
                        NamedEndPoint namedEndPoint = (NamedEndPoint)iterator3.next();
                        String string2 = namedEndPoint.getEndPointName();
                        if (string2.equals("SOAP_CONNECTOR_ADDRESS")) {
                            endPoint = namedEndPoint.getEndPoint();
                            hashtable2.put(SOAP_PORT, new Integer(endPoint.getPort()).toString());
                            hashtable2.put(SOAP_HOST, endPoint.getHost());
                        }
                        if (!string2.equals("BOOTSTRAP_ADDRESS")) continue;
                        endPoint = namedEndPoint.getEndPoint();
                        hashtable2.put(RMI_PORT, new Integer(endPoint.getPort()).toString());
                        hashtable2.put(RMI_HOST, endPoint.getHost());
                    }
                }
            }
            if (hashtable != null) {
                _validConnectionProps.clear();
                _validConnectionProps.add(hashtable);
            }
            this.processServerFile();
            if (_validConnectionProps.size() != 0) {
                this.processSecurityFile();
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)exception.toString());
        }
    }

    private void processServerFile() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"processServerFile");
        for (int i = 0; i < _validConnectionProps.size(); ++i) {
            Hashtable hashtable = (Hashtable)_validConnectionProps.get(i);
            File file = new File(new File(new File(_configuration.getNodeDirectory(), "servers"), (String)hashtable.get(SERVER_NAME)), "server.xml");
            Server server = (Server)_configuration.locateConfigFileObject(file, class$com$ibm$websphere$models$config$process$Server == null ? ConfigRepository.class$("com.ibm.websphere.models.config.process.Server") : class$com$ibm$websphere$models$config$process$Server);
            EList eList = server.getServices();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                AdminService adminService;
                Service service = (Service)iterator.next();
                if (!(service instanceof AdminService) || (adminService = (AdminService)service).isEnable()) continue;
                _validConnectionProps.remove(i);
            }
            _configuration.closeConfigurationFile(file, false);
        }
    }

    private void processSecurityFile() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"processSecurityFile");
        File file = new File(_configuration.getCellDirectory(), "security.xml");
        Security security = (Security)_configuration.locateConfigFileObject(file, Security.class);
        _isGlobalSecurityEnabled = security.isEnabled();
        if (WASPostUpgrade.get_userName() != null) {
            _globalSecurityUserID = WASPostUpgrade.get_userName();
            _globalSecurityPassword = WASPostUpgrade.get_password();
        } else if (_isGlobalSecurityEnabled) {
            UserRegistry userRegistry = security.getActiveUserRegistry();
            _globalSecurityUserID = userRegistry.getServerId();
            _globalSecurityPassword = userRegistry.getServerPassword();
        }
    }

    private void createJMXAgentConnections() {
        int n;
        Tr.entry((TraceComponent)_tc, (String)"createJMXAgentConnections");
        Vector<Thread> vector = new Vector<Thread>();
        Thread thread = null;
        for (n = 0; n < _validConnectionProps.size(); ++n) {
            AdminConnection adminConnection = new AdminConnection((Hashtable)_validConnectionProps.get(n));
            _openJMXAgentConnections.add(adminConnection);
            thread = new Thread(adminConnection);
            thread.start();
            vector.add(thread);
        }
        for (n = 0; n < vector.size(); ++n) {
            try {
                ((Thread)vector.get(n)).join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                Tr.debug((TraceComponent)_tc, (String)interruptedException.toString());
            }
        }
    }

    private class AdminConnection
    implements Runnable {
        private AdminClient _adminClient = null;
        private ObjectName _configRepository = null;
        private Hashtable _connInfo = null;

        AdminConnection(Hashtable hashtable) {
            this._connInfo = hashtable;
        }

        public void run() {
            this.initializeAdminClient();
            if (this._adminClient != null) {
                this.initializeConfigRepositoryHandle(this._adminClient, _configuration.getNodeName());
            }
        }

        private void initializeAdminClient() {
            Tr.entry((TraceComponent)_tc, (String)"initializeAdminClient");
            Properties properties = new Properties();
            properties.setProperty("host", HOST_ADDRESS);
            if (this._connInfo.containsKey(ConfigRepository.SOAP_PORT)) {
                properties.setProperty("type", "SOAP");
                properties.setProperty("port", (String)this._connInfo.get(ConfigRepository.SOAP_PORT));
            } else if (this._connInfo.containsKey(ConfigRepository.RMI_PORT)) {
                properties.setProperty("type", "RMI");
                properties.setProperty("port", (String)this._connInfo.get(ConfigRepository.RMI_PORT));
            }
            if (_isGlobalSecurityEnabled) {
                properties.setProperty("username", _globalSecurityUserID);
                properties.setProperty("password", _globalSecurityPassword);
            }
            try {
                this._adminClient = AdminClientFactory.createAdminClient((Properties)properties);
            }
            catch (ConnectorException connectorException) {
                Tr.debug((TraceComponent)_tc, (String)connectorException.toString());
            }
        }

        private void initializeConfigRepositoryHandle(AdminClient adminClient, String string) {
            Tr.entry((TraceComponent)_tc, (String)"initializeConfigRepositoryHandle", (Object)new Object[]{string});
            Object var3_3 = null;
            try {
                ObjectName objectName = new ObjectName("WebSphere:type=ConfigRepository,node=" + _configuration.getNodeName() + ",*");
                Set set = adminClient.queryNames(objectName, null);
                if (!set.isEmpty()) {
                    this._configRepository = (ObjectName)set.iterator().next();
                }
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)exception.toString());
            }
        }
    }
}

