/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.preupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.libraries.Library;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.BasicDocument;
import com.ibm.wsspi.migration.document.CellDocumentCollection;
import com.ibm.wsspi.migration.document.CopyDocumentProcessor;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;

public class LibrariesCopyDocumentProcessor
extends CopyDocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)LibrariesCopyDocumentProcessor.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static Vector _listOfLibrariesToNotCopy = new Vector();
    protected Properties _oldCurrentLevelVariables = null;
    protected Properties _newCurrentLevelVariables = null;

    public LibrariesCopyDocumentProcessor(DocumentTransform documentTransform, TransformMappingKey transformMappingKey) throws Exception {
        super(documentTransform, transformMappingKey);
        this.instantiateVariables();
        this.copyLibraries();
    }

    protected void instantiateVariables() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"instantiateVariables");
        if (this.getTransform().getOldDocumentCollection() instanceof CellDocumentCollection) {
            String string = ((ProfileImpl)this.getTransform().getScenario().getOldProductImage().getProfile()).getOwningNodeName();
            DocumentCollection documentCollection = this.getTransform().getOldDocumentCollection().getChild("nodes").getChild(string);
            this._oldCurrentLevelVariables = UtilityImpl.instantiateVariables(documentCollection);
        } else {
            this._oldCurrentLevelVariables = UtilityImpl.instantiateVariables(this.getTransform().getOldDocumentCollection());
        }
        this._newCurrentLevelVariables = UtilityImpl.instantiateVariables(this.getTransform().getNewDocumentCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyLibraries() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyLibaries");
        WCCMDocument wCCMDocument = null;
        try {
            wCCMDocument = (WCCMDocument)this.getTransform().getOldDocumentCollection().openDocument("libraries.xml", WCCMDocument.class, false, true);
            Iterator iterator = wCCMDocument.getList().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Library)) continue;
                Library library = (Library)e;
                try {
                    this.processPaths(library.getClassPath());
                }
                catch (Exception exception) {
                    Tr.debug((TraceComponent)_tc, (String)("Could not copy the Library.  This is a valid case when dealing with cell level, classpath='" + library.getClassPath() + "'"), (Object)exception);
                }
                try {
                    this.processPaths(library.getNativePath());
                }
                catch (Exception exception) {
                    Tr.debug((TraceComponent)_tc, (String)("Could not copy the Library.  This is a valid case when dealing with cell level, nativepath='" + library.getNativePath() + "'"), (Object)exception);
                }
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Could not copy the Library.  This is a valid case when dealing with cell level", (Object)exception);
        }
        finally {
            wCCMDocument.close();
        }
    }

    protected boolean entryPathMatches(File file, File file2) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"entryPathMatches", (Object)new Object[]{file, file2});
        if (file == null || file2 == null) {
            return false;
        }
        try {
            return UtilityImpl.makePathCommon(file.getAbsolutePath()).startsWith(UtilityImpl.makePathCommon(file2.getAbsolutePath())) || UtilityImpl.makePathCommon(file.getCanonicalPath()).startsWith(UtilityImpl.makePathCommon(file2.getCanonicalPath()));
        }
        catch (IOException iOException) {
            Tr.event((TraceComponent)_tc, (String)"Failure in entryPathMatches", (Object)iOException);
            return false;
        }
    }

    protected void processPaths(EList eList) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processPaths", (Object)eList);
        String string = this._oldCurrentLevelVariables.getProperty("WAS_INSTALL_ROOT");
        String string2 = this._oldCurrentLevelVariables.getProperty("USER_INSTALL_ROOT");
        string2 = string2 != null ? UtilityImpl.resolveEntryPath(string2, this._oldCurrentLevelVariables) : "";
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            String string3;
            String string4 = (String)iterator.next();
            if (string4.startsWith("..")) {
                string4 = new File(UpgradeBase.get_oldOSInfo().installRoot(), string4).getCanonicalPath();
            }
            if (_listOfLibrariesToNotCopy.contains(string3 = (string4 = UtilityImpl.resolveEntryPath(string4, this._oldCurrentLevelVariables)).substring(string4.lastIndexOf(File.separator) + 1))) continue;
            try {
                DocumentCollection documentCollection = this.getTransform().getOldDocumentCollection().getDocumentCollection(new File(string4).toURL());
                object3 = this.getTransform().getScenario().getNewProductImage().getProfile().getDirectory();
                object2 = string4.substring(string2.length() + 1);
                object = new File((File)object3, (String)object2);
                this.copyLibrary(documentCollection, new File(string4).getCanonicalFile(), (File)object, this.getTransform().getScenario().getNewProductImage().getProfile().getDocumentCollection());
            }
            catch (NotFoundException notFoundException) {
                object3 = this.getTransform().getScenario().getOldProductImage().getDocumentCollection().getDocumentCollection(new File(string4).toURL());
                object2 = this.getTransform().getScenario().getNewProductImage().getInstallationDirectory();
                object = string4.substring(string.length() + 1);
                File file = new File((File)object2, (String)object);
                this.copyLibrary((DocumentCollection)object3, new File(string4).getCanonicalFile(), file, this.getTransform().getScenario().getNewProductImage().getDocumentCollection());
            }
        }
    }

    protected void copyLibrary(DocumentCollection documentCollection, File file, File file2, DocumentCollection documentCollection2) throws Exception {
        String[] stringArray = documentCollection.getHierarchicalName();
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                documentCollection2 = documentCollection2.getChild(stringArray[i]);
                continue;
            }
            catch (NotFoundException notFoundException) {
                documentCollection2 = documentCollection2.addDocumentCollection(stringArray[i]);
            }
        }
        if (file.isDirectory()) {
            UtilityImpl.copyDocumentCollection(documentCollection, documentCollection2);
        } else if (!documentCollection2.documentExists(file2.getName())) {
            BasicDocument basicDocument = (BasicDocument)documentCollection.openDocument(file.getName(), BasicDocument.class);
            BasicDocument basicDocument2 = (BasicDocument)documentCollection2.openDocument(file2.getName(), BasicDocument.class, true, false);
            basicDocument2.setInputStream(basicDocument.getInputStream());
            basicDocument.close();
            basicDocument2.close();
        }
    }

    static {
        _listOfLibrariesToNotCopy.add("struts.jar");
    }
}

