/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.preupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.ISeriesInfo;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.preupgrade.DefaultBackupFiles;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.document.BasicTransformMapping;
import com.ibm.wsspi.migration.document.CopyDocumentProcessor;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.NodeDocumentCollection;
import com.ibm.wsspi.migration.document.TransformMapping;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.preupgrade.PreUpgradeDocumentTransform;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.File;
import java.net.URL;
import java.util.Vector;

public class R50BackupFiles
extends DefaultBackupFiles {
    private static TraceComponent _tc = Tr.register((Class)R50BackupFiles.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    static /* synthetic */ Class class$com$ibm$ws$migration$preupgrade$ResourcesClusterCopyDocumentProcessor;
    static /* synthetic */ Class class$com$ibm$ws$migration$preupgrade$ResourcesApplicationCopyDocumentProcessor;
    static /* synthetic */ Class class$com$ibm$ws$migration$preupgrade$ResourcesCopyDocumentProcessor;
    static /* synthetic */ Class class$com$ibm$ws$migration$preupgrade$LibrariesCopyDocumentProcessor;
    static /* synthetic */ Class class$com$ibm$ws$migration$preupgrade$SecurityCopyDocumentProcessor;

    public R50BackupFiles(Scenario scenario, DocumentCollection documentCollection, DocumentCollection documentCollection2, DocumentTransform documentTransform) throws Exception {
        super(scenario, documentCollection, documentCollection2, documentTransform);
    }

    protected void baseBackupFiles() throws Exception {
        File file;
        File file2;
        File file3;
        Tr.entry((TraceComponent)_tc, (String)"baseBackupFiles");
        File file4 = this._oldOSInfo.userRoot();
        File file5 = this._oldOSInfo.installRoot();
        super.baseBackupFiles();
        File file6 = new File(new File(file4, "lib"), "app");
        if (file6.exists()) {
            this.markDocumentCollectionForBackup(true, file6);
        }
        if ((file3 = new File(file5, "cloudscape")).exists()) {
            this.markDocumentForBackup(new File(file3, "db2j.properties"));
        }
        if ((file2 = new File(file5, "cloudscapeCommon")).exists()) {
            this.markDocumentForBackup(new File(file2, "db2j.properties"));
        }
        if ((file = this._oldOSInfo.configRoot()).exists()) {
            Object object;
            DocumentTransform documentTransform;
            int n;
            Object object2;
            this.markDocumentCollectionForBackup(false, file);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory() || fileArray[i].getName().equals("temp")) continue;
                this.markDocumentCollectionForBackup(true, fileArray[i]);
            }
            DocumentTransform documentTransform2 = null;
            try {
                documentTransform2 = (DocumentTransform)this.getChild("config").getChild("cells").getChildren().get(0);
                this.replaceDocumentProcessor(documentTransform2.getTransformMappings());
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Cell directory not found, this is a possible condition.", (Object)exception);
            }
            try {
                object2 = documentTransform2.getChild("clusters").getChildren();
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    documentTransform = (DocumentTransform)((Vector)object2).get(n);
                    this.replaceClusterDocumentProcessor(documentTransform.getTransformMappings());
                }
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Cluster directory not found, this is a possible condition.", (Object)exception);
            }
            try {
                object2 = documentTransform2.getChild("applications").getChildren();
                for (n = 0; n < ((Vector)object2).size(); ++n) {
                    documentTransform = (DocumentTransform)((DocumentTransform)((Vector)object2).get(n)).getChild("deployments").getChildren().get(0);
                    this.replaceApplicationsDocumentProcessor(documentTransform.getTransformMappings());
                }
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Applications/AppXXX.ear/deployments/AppXXX directory not found, this is a possible condition.", (Object)exception);
            }
            object2 = null;
            try {
                object2 = documentTransform2.getChild("nodes").getChild(((ProfileImpl)this.getScenario().getOldProductImage().getProfile()).getOwningNodeName());
                this.replaceDocumentProcessor(object2.getTransformMappings());
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Node directory not found, this is a possible condition.", (Object)exception);
            }
            try {
                object = object2.getChild("servers").getChildren();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    DocumentTransform documentTransform3 = (DocumentTransform)((Vector)object).get(i);
                    this.replaceDocumentProcessor(documentTransform3.getTransformMappings());
                }
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Server directory not found, this is a possible condition.", (Object)exception);
            }
            object = new Configuration(file, null, null, false, this._oldOSInfo.releaseVersion(), true, true);
            this.fixupServerindexDisablement(this);
            try {
                if (((Configuration)object).isDeploymentManagerNode(((Configuration)object).getOwningNodeDirectory()) && !OSInfoFactory.isZSeries()) {
                    String string = LoggerImpl.get_nls().getString("advise.old.environment.recovery", "A deployment manager migration is detected.  Before continuing with the WASPostUpgrade process, run the backupConfig command on your federated nodes.");
                    UpgradeBase.get_logger().println(string);
                }
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)exception.toString());
            }
        }
    }

    private void replaceClusterDocumentProcessor(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"replaceClusterDocumentProcessor", (Object)vector);
        for (int i = 0; i < vector.size(); ++i) {
            TransformMapping transformMapping = (TransformMapping)vector.get(i);
            if (!transformMapping.getKey().getOldDocumentName().equals("resources.xml")) continue;
            BasicTransformMapping basicTransformMapping = new BasicTransformMapping(new TransformMappingKey("resources.xml"), class$com$ibm$ws$migration$preupgrade$ResourcesClusterCopyDocumentProcessor == null ? R50BackupFiles.class$("com.ibm.ws.migration.preupgrade.ResourcesClusterCopyDocumentProcessor") : class$com$ibm$ws$migration$preupgrade$ResourcesClusterCopyDocumentProcessor);
            vector.remove(i);
            vector.add(basicTransformMapping);
        }
    }

    private void replaceApplicationsDocumentProcessor(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"replaceClusterDocumentProcessor", (Object)vector);
        for (int i = 0; i < vector.size(); ++i) {
            TransformMapping transformMapping = (TransformMapping)vector.get(i);
            if (!transformMapping.getKey().getOldDocumentName().equals("resources.xml")) continue;
            BasicTransformMapping basicTransformMapping = new BasicTransformMapping(new TransformMappingKey("resources.xml"), class$com$ibm$ws$migration$preupgrade$ResourcesApplicationCopyDocumentProcessor == null ? R50BackupFiles.class$("com.ibm.ws.migration.preupgrade.ResourcesApplicationCopyDocumentProcessor") : class$com$ibm$ws$migration$preupgrade$ResourcesApplicationCopyDocumentProcessor);
            vector.remove(i);
            vector.add(basicTransformMapping);
        }
    }

    private void replaceDocumentProcessor(Vector vector) {
        Tr.entry((TraceComponent)_tc, (String)"replaceDocumentProcessor", (Object)vector);
        for (int i = 0; i < vector.size(); ++i) {
            BasicTransformMapping basicTransformMapping;
            TransformMapping transformMapping = (TransformMapping)vector.get(i);
            if (transformMapping.getKey().getOldDocumentName().equals("resources.xml")) {
                basicTransformMapping = new BasicTransformMapping(new TransformMappingKey("resources.xml"), class$com$ibm$ws$migration$preupgrade$ResourcesCopyDocumentProcessor == null ? R50BackupFiles.class$("com.ibm.ws.migration.preupgrade.ResourcesCopyDocumentProcessor") : class$com$ibm$ws$migration$preupgrade$ResourcesCopyDocumentProcessor);
                vector.remove(i);
                vector.add(i, basicTransformMapping);
                continue;
            }
            if (transformMapping.getKey().getOldDocumentName().equals("libraries.xml")) {
                basicTransformMapping = new BasicTransformMapping(new TransformMappingKey("libraries.xml"), class$com$ibm$ws$migration$preupgrade$LibrariesCopyDocumentProcessor == null ? R50BackupFiles.class$("com.ibm.ws.migration.preupgrade.LibrariesCopyDocumentProcessor") : class$com$ibm$ws$migration$preupgrade$LibrariesCopyDocumentProcessor);
                vector.remove(i);
                vector.add(i, basicTransformMapping);
                continue;
            }
            if (!transformMapping.getKey().getOldDocumentName().equals("security.xml")) continue;
            basicTransformMapping = new BasicTransformMapping(new TransformMappingKey("security.xml"), class$com$ibm$ws$migration$preupgrade$SecurityCopyDocumentProcessor == null ? R50BackupFiles.class$("com.ibm.ws.migration.preupgrade.SecurityCopyDocumentProcessor") : class$com$ibm$ws$migration$preupgrade$SecurityCopyDocumentProcessor);
            vector.remove(i);
            vector.add(i, basicTransformMapping);
        }
    }

    public void markDocumentCollectionForBackup(boolean bl, File file) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"markDocumentCollectionForBackup", (Object)new Object[]{new Boolean(bl), file});
        PreUpgradeDocumentTransform preUpgradeDocumentTransform = null;
        try {
            preUpgradeDocumentTransform = (PreUpgradeDocumentTransform)this.mapFileToDocumentTransform(file);
        }
        catch (NotFoundException notFoundException) {
            return;
        }
        preUpgradeDocumentTransform.markDocumentCollectionForBackup(bl);
    }

    public void markDocumentForBackup(File file) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"markDocumentForBackup", (Object)file);
        DocumentTransform documentTransform = null;
        try {
            documentTransform = this.mapFileToDocumentTransform(file);
        }
        catch (NotFoundException notFoundException) {
            return;
        }
        Vector vector = documentTransform.getTransformMappings();
        TransformMappingKey transformMappingKey = new TransformMappingKey(file.getName());
        vector.addElement(new BasicTransformMapping(transformMappingKey, CopyDocumentProcessor.class));
    }

    public DocumentTransform mapFileToDocumentTransform(File file) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"mapFileToDocumentTransform", (Object)file);
        URL uRL = file.toURL();
        DocumentCollection documentCollection = this.getOldDocumentCollection().getDocumentCollection(uRL);
        String[] stringArray = documentCollection.getHierarchicalName();
        String[] stringArray2 = this.getOldDocumentCollection().getHierarchicalName();
        DocumentTransform documentTransform = this;
        for (int i = stringArray2.length; i < stringArray.length; ++i) {
            documentTransform = documentTransform.getChild(stringArray[i]);
        }
        return documentTransform;
    }

    public void fixupServerindexDisablement(DocumentTransform documentTransform) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"fixupServerindexDisablement", (Object)documentTransform);
        if (documentTransform.getOldDocumentCollection() instanceof NodeDocumentCollection) {
            Vector vector = documentTransform.getTransformMappings();
            block0: for (int i = 0; i < vector.size(); ++i) {
                TransformMapping transformMapping = (TransformMapping)vector.elementAt(i);
                if (!transformMapping.getKey().getOldDocumentName().equals("serverindex.xml_disabled")) continue;
                TransformMappingKey transformMappingKey = new TransformMappingKey("serverindex.xml_disabled", "serverindex.xml");
                BasicTransformMapping basicTransformMapping = new BasicTransformMapping(transformMappingKey, class$com$ibm$wsspi$migration$document$CopyDocumentProcessor == null ? R50BackupFiles.class$("com.ibm.wsspi.migration.document.CopyDocumentProcessor") : class$com$ibm$wsspi$migration$document$CopyDocumentProcessor);
                vector.set(i, basicTransformMapping);
                Vector vector2 = documentTransform.getTransformMappings();
                for (int j = 0; j < vector2.size(); ++j) {
                    TransformMapping transformMapping2 = (TransformMapping)vector.elementAt(j);
                    if (!transformMapping2.getKey().getOldDocumentName().equals("serverindex.xml")) continue;
                    vector2.remove(j);
                    continue block0;
                }
            }
            return;
        }
        Vector vector = documentTransform.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            this.fixupServerindexDisablement((DocumentTransform)vector.elementAt(i));
        }
    }

    public String[] getUnsupportedXMLFiles() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getUnsupportedXMLFiles");
        ReleaseVersion releaseVersion = this._oldOSInfo.releaseVersion();
        if (releaseVersion.areExpressServerProductsInstalled() && releaseVersion.isR50() || this._oldOSInfo instanceof ISeriesInfo || releaseVersion.isR60()) {
            return new String[0];
        }
        if (releaseVersion.isEEInstalled()) {
            if (releaseVersion.isR51()) {
                return new String[]{"server-pme.xml", "server-pme51.xml", "resources-pme.xml", "resources-pme502.xml"};
            }
            if (releaseVersion.isR50() && releaseVersion.ptfLevel() >= 2) {
                return new String[]{"server-pme.xml", "resources-pme.xml", "resources-pme502.xml"};
            }
            return new String[]{"server-pme.xml", "resources-pme.xml"};
        }
        return new String[0];
    }
}

