/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.preupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.ISeriesInfo;
import com.ibm.ws.migration.common.Invoker;
import com.ibm.ws.migration.common.OSInfo;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.SerializedWCCMObject;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.common.XMLReflectionHelper;
import com.ibm.ws.migration.document.BasicDocumentCollection;
import com.ibm.ws.migration.document.CellDocumentCollectionImpl;
import com.ibm.ws.migration.document.FileDocumentCollection;
import com.ibm.ws.migration.document.NodeDocumentCollectionImpl;
import com.ibm.ws.migration.document.ServerDocumentCollectionImpl;
import com.ibm.ws.migration.preupgrade.BackupFiles;
import com.ibm.ws.migration.preupgrade.BasicPreUpgradeManager;
import com.ibm.ws.migration.preupgrade.ConfigRepository;
import com.ibm.ws.migration.preupgrade.WCCMEclipseHelper;
import com.ibm.ws.migration.preupgrade.WCCMEtoolsHelper;
import com.ibm.ws.migration.preupgrade.WCCMHelper;
import com.ibm.ws.migration.preupgrade.XMLSerializer;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.ProductImageImpl;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.ReleaseVersionImpl;
import com.ibm.ws.migration.utility.ScenarioImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.utility.Profile;
import com.ibm.wsspi.migration.utility.Scenario;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Save {
    private static TraceComponent _tc = Tr.register((Class)Save.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static File _backupDirectory = null;
    protected boolean _calledByInstall = false;
    private Hashtable _cumulativeBackupList = new Hashtable();
    private File _migrationJar = null;
    protected BasicPreUpgradeManager _manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Save(File file, boolean bl) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"Save");
        _backupDirectory = file;
        this._calledByInstall = bl;
        try {
            this.doIt();
        }
        finally {
            ConfigRepository.unlockConfigRepository();
        }
    }

    protected void setConfigDescriptors(BasicDocumentCollection.Descriptor descriptor) {
        Tr.entry((TraceComponent)_tc, (String)"setConfigDescriptors", (Object)descriptor);
        BasicDocumentCollection.Descriptor descriptor2 = new BasicDocumentCollection.Descriptor(descriptor);
        descriptor.setChildDescriptor("config", descriptor2);
        BasicDocumentCollection.Descriptor descriptor3 = new BasicDocumentCollection.Descriptor(descriptor);
        descriptor2.setChildDescriptor("cells", descriptor3);
        BasicDocumentCollection.Descriptor descriptor4 = new BasicDocumentCollection.Descriptor(descriptor, CellDocumentCollectionImpl.class);
        descriptor3.setDefaultChildDescriptor(descriptor4);
        BasicDocumentCollection.Descriptor descriptor5 = new BasicDocumentCollection.Descriptor(descriptor);
        descriptor4.setDefaultChildDescriptor(descriptor5);
        BasicDocumentCollection.Descriptor descriptor6 = new BasicDocumentCollection.Descriptor(descriptor);
        descriptor4.setChildDescriptor("nodes", descriptor6);
        BasicDocumentCollection.Descriptor descriptor7 = new BasicDocumentCollection.Descriptor(descriptor, NodeDocumentCollectionImpl.class);
        descriptor6.setDefaultChildDescriptor(descriptor7);
        descriptor7.setDefaultChildDescriptor(descriptor5);
        BasicDocumentCollection.Descriptor descriptor8 = new BasicDocumentCollection.Descriptor(descriptor);
        descriptor7.setChildDescriptor("servers", descriptor8);
        BasicDocumentCollection.Descriptor descriptor9 = new BasicDocumentCollection.Descriptor(descriptor, ServerDocumentCollectionImpl.class);
        descriptor8.setDefaultChildDescriptor(descriptor9);
        descriptor9.setDefaultChildDescriptor(descriptor5);
    }

    protected Scenario createScenario(File file, File file2, OSInfo oSInfo, OSInfo oSInfo2) throws Exception {
        Object object;
        boolean bl;
        boolean bl2;
        BasicDocumentCollection basicDocumentCollection;
        BasicDocumentCollection basicDocumentCollection2;
        Object object2;
        Tr.entry((TraceComponent)_tc, (String)"createScenario", (Object)new Object[]{file, file2, oSInfo, oSInfo2});
        BasicDocumentCollection.Descriptor descriptor = new BasicDocumentCollection.Descriptor(true, false, BasicDocumentCollection.class, FileDocumentCollection.class);
        BasicDocumentCollection.Descriptor descriptor2 = new BasicDocumentCollection.Descriptor(false, false, BasicDocumentCollection.class, FileDocumentCollection.class);
        BasicDocumentCollection basicDocumentCollection3 = new BasicDocumentCollection(oSInfo.installRoot().getName(), null, descriptor, oSInfo.installRoot().toURL());
        BasicDocumentCollection basicDocumentCollection4 = new BasicDocumentCollection(file.getName(), null, descriptor2, oSInfo.installRoot().toURL(), file.toURL());
        basicDocumentCollection3.setPeer(basicDocumentCollection4);
        basicDocumentCollection4.setPeer(basicDocumentCollection3);
        if (oSInfo instanceof ISeriesInfo) {
            object2 = new BasicDocumentCollection.Descriptor(descriptor);
            basicDocumentCollection2 = new BasicDocumentCollection(oSInfo2.userRoot().getName(), null, (BasicDocumentCollection.Descriptor)object2, oSInfo2.userRoot().toURL());
            basicDocumentCollection = basicDocumentCollection4;
            basicDocumentCollection2.setPeer(basicDocumentCollection);
            basicDocumentCollection.setPeer(basicDocumentCollection2);
        } else if (file.equals(file2)) {
            basicDocumentCollection2 = basicDocumentCollection3;
            basicDocumentCollection = basicDocumentCollection4;
        } else {
            if (oSInfo2.userRoot().getPath().startsWith(oSInfo2.installRoot().getPath())) {
                object2 = (BasicDocumentCollection)basicDocumentCollection3.getDocumentCollection(oSInfo2.userRoot().getParentFile().toURL());
                ((BasicDocumentCollection)object2).getDescriptor().setChildDescriptor(oSInfo2.userRoot().getName(), BasicDocumentCollection.HIDE_CHILD);
            }
            object2 = new BasicDocumentCollection.Descriptor(descriptor);
            basicDocumentCollection2 = new BasicDocumentCollection(oSInfo2.userRoot().getName(), null, (BasicDocumentCollection.Descriptor)object2, oSInfo2.userRoot().toURL());
            BasicDocumentCollection.Descriptor descriptor3 = new BasicDocumentCollection.Descriptor(descriptor2);
            basicDocumentCollection = new BasicDocumentCollection(file2.getName(), null, descriptor3, oSInfo2.userRoot().toURL(), file2.toURL());
            basicDocumentCollection2.setPeer(basicDocumentCollection);
            basicDocumentCollection.setPeer(basicDocumentCollection2);
        }
        this.setConfigDescriptors(basicDocumentCollection2.getDescriptor());
        this.setConfigDescriptors(basicDocumentCollection.getDescriptor());
        String string = null;
        if (oSInfo2.releaseVersion().isClient()) {
            bl2 = false;
            bl = false;
        } else {
            object = new Configuration(oSInfo2.configRoot(), null, null, false, oSInfo2.releaseVersion(), false, true);
            bl2 = ((Configuration)object).isDeploymentManagerConfiguration();
            bl = ((Configuration)object).isFederatedNode();
            string = ((Configuration)object).getOwningNodeName();
        }
        object = new ProfileImpl(basicDocumentCollection2, string, bl2, bl, oSInfo2.userRoot(), oSInfo2);
        ProfileImpl profileImpl = new ProfileImpl(basicDocumentCollection, string, bl2, bl, file2, null);
        boolean bl3 = oSInfo.releaseVersion().isR50() || oSInfo.releaseVersion().isR51() || oSInfo.releaseVersion().isR60();
        String string2 = oSInfo.releaseVersion().getWASReleaseVersion();
        ReleaseVersionImpl releaseVersionImpl = new ReleaseVersionImpl(false, bl3, string2, oSInfo.releaseVersion());
        ProductImageImpl productImageImpl = new ProductImageImpl(oSInfo.installRoot(), (Profile)object, releaseVersionImpl, oSInfo, basicDocumentCollection3);
        ProductImageImpl productImageImpl2 = new ProductImageImpl(file, profileImpl, releaseVersionImpl, null, basicDocumentCollection4);
        ScenarioImpl scenarioImpl = new ScenarioImpl(_backupDirectory.toURL(), productImageImpl, productImageImpl2, UpgradeBase.get_logger());
        basicDocumentCollection3.setScenario(scenarioImpl);
        basicDocumentCollection4.setScenario(scenarioImpl);
        basicDocumentCollection2.setScenario(scenarioImpl);
        basicDocumentCollection.setScenario(scenarioImpl);
        return scenarioImpl;
    }

    protected BackupFiles backupFiles(File file, File file2, OSInfo oSInfo, OSInfo oSInfo2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"backupFiles", (Object)new Object[]{file, file2, oSInfo, oSInfo2});
        Scenario scenario = this.createScenario(file, file2, oSInfo, oSInfo2);
        if (this._manager == null) {
            this._manager = new BasicPreUpgradeManager();
        }
        this._manager.save(scenario);
        return (BackupFiles)((Object)this._manager.getTransform(BackupFiles.class));
    }

    protected void processInstances(OSInfo oSInfo, OSInfo oSInfo2, OSInfo oSInfo3, File file) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processInstances", (Object)new Object[]{oSInfo, oSInfo3});
        File file2 = new File(_backupDirectory, "profiles");
        Properties properties = new Properties();
        Properties properties2 = oSInfo.getInstances();
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties2.getProperty(string);
            File file3 = new File(string2);
            if (!file3.exists()) {
                Tr.debug((TraceComponent)_tc, (String)("Skipped instance " + string + " because user root " + string2 + " does not exist."));
                continue;
            }
            String string3 = LoggerImpl.get_nls().getFormattedMessage("advise.information.instance.start", new Object[]{string}, "Starting to save instance {0}.");
            UpgradeBase.get_logger().println(string3);
            OSInfo oSInfo4 = OSInfoFactory.createOSInfo(new File(string2), oSInfo.installRoot(), oSInfo);
            File file4 = new File(file2, string);
            BackupFiles backupFiles = this.backupFiles(file, file4, oSInfo, oSInfo4);
            properties.setProperty(string, file4.getPath());
            oSInfo3.setInstances(properties);
            OSInfo oSInfo5 = oSInfo3.getInstance(string);
            this.serializeUnsupportedXMLFiles(oSInfo4, oSInfo2, oSInfo5, backupFiles);
        }
    }

    protected String getMigrationJar() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getMigrationJar");
        if (this._migrationJar == null) {
            File file = new File(_backupDirectory, "temp");
            file.mkdirs();
            this._migrationJar = new File(file, "migration.jar");
            if (this._migrationJar.exists()) {
                this._migrationJar.delete();
            }
            Class[] classArray = new Class[]{XMLSerializer.class, XMLReflectionHelper.class, WCCMHelper.class, WCCMEtoolsHelper.class, WCCMEclipseHelper.class, SerializedWCCMObject.class};
            try {
                ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this._migrationJar));
                for (int i = 0; i < classArray.length; ++i) {
                    String string = classArray[i].getName();
                    String string2 = "/" + string.replace('.', '/') + ".class";
                    ZipEntry zipEntry = new ZipEntry(string2.substring(1));
                    zipOutputStream.putNextEntry(zipEntry);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(classArray[i].getResourceAsStream(string2));
                    byte[] byArray = new byte[4096];
                    int n = bufferedInputStream.read(byArray, 0, 4096);
                    while (n > 0) {
                        zipOutputStream.write(byArray, 0, n);
                        n = bufferedInputStream.read(byArray, 0, 4096);
                    }
                    bufferedInputStream.close();
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.flush();
                zipOutputStream.close();
            }
            catch (IOException iOException) {
                String string = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{iOException}, "An unexpected internal error occurred, exception {0}.");
                UpgradeBase.get_logger().println(string);
                throw new UpgradeException(string, iOException, false);
            }
        }
        return this._migrationJar.getPath();
    }

    protected void serializeUnsupportedXMLFiles(OSInfo oSInfo, OSInfo oSInfo2, OSInfo oSInfo3, BackupFiles backupFiles) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"serializeUnsupportedXMLFiles", (Object)new Object[]{oSInfo, oSInfo3, backupFiles});
        File file = new File(oSInfo3.userRoot(), "config");
        String[] stringArray = backupFiles.getUnsupportedXMLFiles();
        if (!file.exists() || stringArray.length == 0 || oSInfo.releaseVersion().isExpressServerProductInstalled("embeddedEXPRESS")) {
            return;
        }
        String string = oSInfo2.addtoExecutable();
        if (oSInfo2.javaHome() != null && !oSInfo2.javaHome().exists()) {
            Tr.event((TraceComponent)_tc, (String)("Java home not found: " + string));
            string = string.replaceFirst(Pattern.quote("migration/java/bin/java"), "JDK/jre.pak/repository/package.java.jre/java/jre/bin/java");
            Tr.event((TraceComponent)_tc, (String)("Trying again with: " + string));
        }
        string = string + oSInfo.classLoaderSettings(this.getMigrationJar());
        string = string + " " + XMLSerializer.class.getName();
        Tr.debug((TraceComponent)_tc, (String)("Initial string for executable" + string));
        string = string + " " + FileUtilities.quotedFileName(oSInfo3.installRoot().getAbsolutePath()) + " " + FileUtilities.quotedFileName(oSInfo3.userRoot().getAbsolutePath()) + " " + FileUtilities.quotedFileName(file.getPath() + File.separator);
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + " " + stringArray[i];
        }
        Invoker invoker = new Invoker(oSInfo);
        int n = invoker.exec(string, "XMLSerializer");
        if (n != 0) {
            String string2 = LoggerImpl.get_nls().getFormattedMessage("advise.unexpected.internal.error", new Object[]{null}, "An unexpected internal error occurred, exception {0}.");
            UpgradeBase.get_logger().println(string2);
        }
    }

    protected void doIt() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"doIt");
        UpgradeBase.get_logger().println(LoggerImpl.get_nls().getString("advise.information.preupgrade.start", "Starting to save existing WebSphere."));
        FileUtilities.saveHashTable(UpgradeBase.get_cmdLineArgs(), new File(_backupDirectory, "websphere_backup_cmd_line_args.ser"));
        File file = new File(_backupDirectory, "websphere_backup");
        OSInfo oSInfo = OSInfoFactory.createOSInfo(file, file);
        UpgradeBase.get_logger().println(LoggerImpl.get_nls().getString("advise.information.preupgrade.save", "Saving existing files."));
        ReleaseVersion releaseVersion = UpgradeBase.get_oldOSInfo().releaseVersion();
        if (releaseVersion.isR50() || releaseVersion.isR51() || releaseVersion.isClient()) {
            BackupFiles backupFiles = this.backupFiles(file, file, UpgradeBase.get_oldOSInfo(), UpgradeBase.get_oldOSInfo());
            this.serializeUnsupportedXMLFiles(UpgradeBase.get_oldOSInfo(), UpgradeBase.get_newOSInfo(), oSInfo, backupFiles);
        } else if (oSInfo instanceof ISeriesInfo && releaseVersion.isR60()) {
            BackupFiles backupFiles = this.backupFiles(file, file, UpgradeBase.get_oldOSInfo(), UpgradeBase.get_oldOSInfo());
        }
        if (!releaseVersion.isClient()) {
            this.processInstances(UpgradeBase.get_oldOSInfo(), UpgradeBase.get_newOSInfo(), oSInfo, file);
        }
    }
}

