/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.preupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.security.SSLConfig;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.ws.migration.utility.ProfileImpl;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.wsspi.migration.document.BasicDocument;
import com.ibm.wsspi.migration.document.CellDocumentCollection;
import com.ibm.wsspi.migration.document.CopyDocumentProcessor;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.TransformMappingKey;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public class SecurityCopyDocumentProcessor
extends CopyDocumentProcessor {
    private static TraceComponent _tc = Tr.register((Class)SecurityCopyDocumentProcessor.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected Properties _oldCurrentLevelVariables = null;
    protected Properties _newCurrentLevelVariables = null;

    public SecurityCopyDocumentProcessor(DocumentTransform documentTransform, TransformMappingKey transformMappingKey) throws Exception {
        super(documentTransform, transformMappingKey);
        this.instantiateVariables();
        this.copyDummyFiles();
    }

    protected void instantiateVariables() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"instantiateVariables");
        if (this.getTransform().getOldDocumentCollection() instanceof CellDocumentCollection) {
            String string = ((ProfileImpl)this.getTransform().getScenario().getOldProductImage().getProfile()).getOwningNodeName();
            DocumentCollection documentCollection = this.getTransform().getOldDocumentCollection().getChild("nodes").getChild(string);
            this._oldCurrentLevelVariables = UtilityImpl.instantiateVariables(documentCollection);
        } else {
            this._oldCurrentLevelVariables = UtilityImpl.instantiateVariables(this.getTransform().getOldDocumentCollection());
        }
        this._newCurrentLevelVariables = UtilityImpl.instantiateVariables(this.getTransform().getNewDocumentCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDummyFiles() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyDummyFiles");
        WCCMDocument wCCMDocument = null;
        try {
            wCCMDocument = (WCCMDocument)this.getTransform().getOldDocumentCollection().openDocument("security.xml", WCCMDocument.class, false, true);
            Iterator iterator = ((Security)wCCMDocument.getList().get(0)).getRepertoire().iterator();
            while (iterator.hasNext()) {
                SSLConfig sSLConfig = (SSLConfig)iterator.next();
                Tr.debug((TraceComponent)_tc, (String)("Processing SSLConfig: " + sSLConfig.getAlias()));
                String string = sSLConfig.getSetting().getKeyFileName();
                String string2 = sSLConfig.getSetting().getTrustFileName();
                if (string != null) {
                    this.copyKeyOrTrustFile(string);
                }
                if (string2 == null) continue;
                this.copyKeyOrTrustFile(string2);
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Caught exception: ", (Object)exception);
        }
        finally {
            wCCMDocument.close();
        }
    }

    protected void copyKeyOrTrustFile(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"copyKeyOrTrustFile", (Object)string);
        String string2 = this._oldCurrentLevelVariables.getProperty("WAS_INSTALL_ROOT");
        String string3 = this._oldCurrentLevelVariables.getProperty("USER_INSTALL_ROOT");
        string3 = UtilityImpl.resolveEntryPath(string3, this._oldCurrentLevelVariables);
        if (string.indexOf("${") >= 0) {
            string = UtilityImpl.resolveEntryPath(string, this._oldCurrentLevelVariables);
        }
        try {
            string = new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            Tr.event((TraceComponent)_tc, (String)"Security : Cannot resolve key or trust filename correctly", (Object)new Object[]{string, iOException});
        }
        try {
            DocumentCollection documentCollection = this.getTransform().getScenario().getOldProductImage().getProfile().getDocumentCollection().getDocumentCollection(new File(string).toURL());
            File file = this.getTransform().getScenario().getNewProductImage().getProfile().getDirectory();
            String string4 = string.substring(string3.length() + 1);
            File file2 = new File(file, string4);
            Tr.debug((TraceComponent)_tc, (String)"Found oldFilePath under Profile image");
            this.copyFile(documentCollection, new File(string), file2);
        }
        catch (NotFoundException notFoundException) {
            try {
                DocumentCollection documentCollection = this.getTransform().getScenario().getOldProductImage().getDocumentCollection().getDocumentCollection(new File(string).toURL());
                File file = this.getTransform().getScenario().getNewProductImage().getInstallationDirectory();
                String string5 = string.substring(string2.length() + 1);
                File file3 = new File(file, string5);
                Tr.debug((TraceComponent)_tc, (String)"Found oldFilePath under Product image.");
                this.copyFile(documentCollection, new File(string), file3);
            }
            catch (NotFoundException notFoundException2) {
                Tr.debug((TraceComponent)_tc, (String)"Caught exception( means could not find Dummy file under WAS_INSTALL_ROOT or USER_INSTALL_ROOT: ", (Object)notFoundException2);
            }
        }
    }

    protected boolean entryPathMatches(File file, File file2) throws IOException {
        Tr.entry((TraceComponent)_tc, (String)"entryPathMatches", (Object)new Object[]{file, file2});
        if (file == null || file2 == null) {
            return false;
        }
        try {
            return UtilityImpl.makePathCommon(file.getAbsolutePath()).startsWith(UtilityImpl.makePathCommon(file2.getAbsolutePath())) || UtilityImpl.makePathCommon(file.getCanonicalPath()).startsWith(UtilityImpl.makePathCommon(file2.getCanonicalPath()));
        }
        catch (IOException iOException) {
            Tr.event((TraceComponent)_tc, (String)"Failure in entryPathMatches", (Object)iOException);
            return false;
        }
    }

    protected void copyFile(DocumentCollection documentCollection, File file, File file2) throws Exception {
        String string = this._oldCurrentLevelVariables.getProperty("WAS_INSTALL_ROOT");
        String string2 = this._oldCurrentLevelVariables.getProperty("USER_INSTALL_ROOT");
        string2 = string2 != null ? UtilityImpl.resolveEntryPath(string2, this._oldCurrentLevelVariables) : "";
        Tr.event((TraceComponent)_tc, (String)"copyFile", (Object)new Object[]{file.getAbsolutePath(), file2.getAbsolutePath(), string, string2});
        String[] stringArray = documentCollection.getHierarchicalName();
        File file3 = new File(string2).getCanonicalFile();
        File file4 = new File(string).getCanonicalFile();
        boolean bl = documentCollection.getUrl().equals(file.toURL());
        if (bl) {
            DocumentCollection documentCollection2 = null;
            if (this.entryPathMatches(file, file3)) {
                documentCollection2 = this.getTransform().getScenario().getNewProductImage().getProfile().getDocumentCollection();
            } else if (this.entryPathMatches(file, file4)) {
                documentCollection2 = this.getTransform().getScenario().getNewProductImage().getDocumentCollection();
            }
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    documentCollection2 = documentCollection2.getChild(stringArray[i]);
                    continue;
                }
                catch (NotFoundException notFoundException) {
                    documentCollection2 = documentCollection2.addDocumentCollection(stringArray[i]);
                }
            }
            UtilityImpl.copyDocumentCollection(documentCollection, documentCollection2);
        } else {
            BasicDocument basicDocument = (BasicDocument)documentCollection.openDocument(file.getName(), BasicDocument.class);
            DocumentCollection documentCollection3 = null;
            if (this.entryPathMatches(file, new File(string2))) {
                documentCollection3 = this.getTransform().getScenario().getNewProductImage().getProfile().getDocumentCollection();
            } else if (this.entryPathMatches(file, new File(string))) {
                documentCollection3 = this.getTransform().getScenario().getNewProductImage().getDocumentCollection();
            }
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    documentCollection3 = documentCollection3.getChild(stringArray[i]);
                    continue;
                }
                catch (NotFoundException notFoundException) {
                    documentCollection3 = documentCollection3.addDocumentCollection(stringArray[i]);
                }
            }
            if (!documentCollection3.documentExists(file2.getName())) {
                BasicDocument basicDocument2 = (BasicDocument)documentCollection3.openDocument(file2.getName(), BasicDocument.class, true, false);
                basicDocument2.setInputStream(basicDocument.getInputStream());
                basicDocument2.close();
            }
            basicDocument.close();
        }
    }
}

