/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.preupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.ReleaseVersion;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.preupgrade.Save;
import com.ibm.ws.migration.utility.ArgumentException;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import java.io.File;
import java.util.Enumeration;

public class WASPreUpgrade
extends UpgradeBase {
    private static TraceComponent _tc = Tr.register((Class)WASPreUpgrade.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static ReleaseVersion _oldRelease = null;
    protected static final String[] POSITIONAL_PARMS;
    protected File _summaryLog = null;

    public WASPreUpgrade() {
    }

    public WASPreUpgrade(String[] stringArray) throws UpgradeException {
        this.parseArgs(stringArray);
        this.parsePositionalParms(stringArray, POSITIONAL_PARMS);
        this.setupTrace();
    }

    public void save() throws Exception {
        this.checkArguments();
        this.verifyOrCreateBackupDirectory();
        UpgradeBase._logger = new LoggerImpl(UpgradeBase._backupDirectory, "WASPreUpgrade.log", this._summaryLog);
        Save save = new Save(UpgradeBase._backupDirectory, this._calledByInstall);
        UpgradeBase._logger.println(LoggerImpl.get_nls().getString("advise.information.preupgrade.complete", "Completed saving of the existing WebSphere environment."));
        String string = null;
        string = LoggerImpl.loggedError() ? LoggerImpl.get_nls().getString("advise.logging.completed.with.errors", "The migration failed to complete.") : (LoggerImpl.loggedWarning() ? LoggerImpl.get_nls().getString("advise.logging.waspreupgrade.completed.warning", "The first step of migration completed with warnings.") : LoggerImpl.get_nls().getString("advise.logging.waspreupgrade.completed.successfully", "The first step of migration completed successfully."));
        UpgradeBase._logger.println(string);
    }

    protected void parseArgs(String[] stringArray) throws UpgradeException {
        this.parseArgs(stringArray, POSITIONAL_PARMS);
    }

    protected void checkArguments() throws UpgradeException {
        super.checkArguments();
        String[] stringArray = new String[]{"-backupDirectory", "-currentWASDirectory", "-adminNodeName", "-import", "-nameServiceHost", "-nameServicePort", "-traceString", "-traceFile", "-summaryLogName", "-zWAS"};
        Enumeration enumeration = UpgradeBase._cmdLineArgs.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!WASPreUpgrade.isInvalidKey(stringArray, string)) continue;
            throw new ArgumentException(LoggerImpl.get_nls().getFormattedMessage("advise.cmd.line.illegal", new Object[]{string}, "Illegal Argument Specified: {0}"), null, true);
        }
        this.checkArgumentZWAS();
        this.checkArgumentSummaryLogName();
    }

    protected void checkArgumentSummaryLogName() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentSummaryLogName");
        if (UpgradeBase._cmdLineArgs.containsKey("-summaryLogName")) {
            this._summaryLog = new File((String)UpgradeBase._cmdLineArgs.get("-summaryLogName"));
        }
    }

    protected void checkArgumentZWAS() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkArgumentZWAS");
        if (OSInfoFactory.isZSeries() && !UpgradeBase._cmdLineArgs.containsKey("-zWAS")) {
            String string = LoggerImpl.get_nls().getFormattedMessage("advise.zos.invalid.direct.invocation", new Object[]{"WASPreUpgrade"}, "{0} command not supported on z/OS for direct invocation from the Unix shell.  Use the WebSphere z/OS Customization Dialog migration option instead.");
            UpgradeBase._logger.println(string);
            throw new UpgradeException(string, null, true);
        }
    }

    protected void checkRequiredArguments() throws UpgradeException {
        super.checkRequiredArguments();
        UpgradeBase._oldOSInfo = OSInfoFactory.createOSInfo(UpgradeBase._userRoot, null);
        try {
            _oldRelease = UpgradeBase._oldOSInfo.releaseVersion();
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"checkRequiredArguments Exception: ", (Object)exception);
            throw new ArgumentException(LoggerImpl.get_nls().getString("advise.cmd.line.currentWASDirectory", "You must specify the currently installed WebSphere directory name."), null, true);
        }
        if (this.checkOldWASVersion(_oldRelease)) {
            throw new ArgumentException(LoggerImpl.get_nls().getString("advise.cmd.line.currentWASDirectory", "You must specify the currently installed WebSphere directory name."), null, true);
        }
    }

    protected void verifyOrCreateBackupDirectory() throws UpgradeException {
        File file = UpgradeBase._backupDirectory;
        if (file.exists()) {
            if (!file.isDirectory()) {
                String string = LoggerImpl.get_nls().getString("advise.invalid.backup.directory", "The input backup directory cannot be used, it is a file.");
                if (_tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)string);
                }
                throw new UpgradeException(string, null, true);
            }
            if (!file.canWrite()) {
                String string = LoggerImpl.get_nls().getString("advise.backup.directory.notwriteable", "The input backup directory cannot be used, it is not writeable.");
                if (_tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)string);
                }
                throw new UpgradeException(string, null, true);
            }
        } else if (!file.mkdirs()) {
            String string = LoggerImpl.get_nls().getString("advise.backup.directory.notcreatable", "The input backup directory cannot be used, it cannot be created.");
            if (_tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)string);
            }
            throw new UpgradeException(string, null, true);
        }
    }

    protected void setupTrace() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"setupTrace");
        String string = System.getProperty("com.ibm.websphere.migration.serverRoot");
        String string2 = System.getProperty("was.install.root");
        File file = null;
        File file2 = null;
        if (string != null) {
            file = new File(string);
        }
        if (string2 != null) {
            file2 = new File(string2);
        }
        UpgradeBase._newOSInfo = OSInfoFactory.createOSInfo(file, file2);
        super.setupTrace("WASPreUpgrade");
    }

    protected boolean checkOldWASVersion(ReleaseVersion releaseVersion) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"checkOldWASVersion", (Object)releaseVersion);
        boolean bl = super.checkOldWASVersion(releaseVersion);
        if (bl) {
            return bl;
        }
        return UpgradeBase._oldOSInfo.isInvalidReleaseOnOS(releaseVersion, bl);
    }

    public static String retrieveUsage() {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)"retrieveUsage");
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(LoggerImpl.get_nls().getString("usage.pre.line1", "java com.ibm.websphere.migration.WASPreUpgrade") + _lineSeparator).append("\t" + LoggerImpl.get_nls().getString("usage.line2", "<backupDirectoryName> ") + _lineSeparator).append("\t" + LoggerImpl.get_nls().getString("usage.pre.line3", "<currentWebSphereDirectory>") + _lineSeparator);
        stringBuffer.append("\t" + LoggerImpl.get_nls().getString("usage.line9", "[ -traceString <trace spec> [-traceFile <file name>]]") + _lineSeparator);
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = 99;
        boolean bl = true;
        try {
            WASPreUpgrade.copyright("Product Upgrade PreUpgrade tool, Version 1.0");
            if (stringArray.length == 0) {
                WASPreUpgrade.displayOutput(WASPreUpgrade.retrieveUsage());
                System.exit(-1);
            }
            object = new WASPreUpgrade(stringArray);
            ((WASPreUpgrade)object).save();
            System.exit(0);
        }
        catch (UpgradeException upgradeException) {
            WASPreUpgrade.handleException(upgradeException);
            if (upgradeException.shouldDisplayHelp()) {
                System.err.println(WASPreUpgrade.retrieveUsage());
            }
        }
        catch (Throwable throwable) {
            WASPreUpgrade.handleException(throwable);
        }
        object = null;
        object = bl ? LoggerImpl.get_nls().getString("advise.logging.completed.with.failures", "Failed.") : LoggerImpl.get_nls().getString("advise.logging.completed.with.errors", "Completed with errors.");
        if (LoggerImpl.isRegistered()) {
            UpgradeBase._logger.println((String)object);
        } else {
            System.err.println((String)object);
        }
        System.exit(n);
    }

    protected void setupDefaultTrace(String string) {
        Tr.debug((TraceComponent)_tc, (String)"setupDefaultTrace", (Object)string);
        try {
            String string2;
            if (!UpgradeBase._cmdLineArgs.containsKey("-traceString") && !OSInfoFactory.isZSeries() && (string2 = (String)UpgradeBase._cmdLineArgs.get("-backupDirectory")) != null) {
                File file = new File(new File(string2, "logs"), string + ".trace");
                if (file.exists()) {
                    file.delete();
                }
                UpgradeBase._cmdLineArgs.put("-traceString", "*=all=enabled");
                UpgradeBase._cmdLineArgs.put("-traceFile", file.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        _lineSeparator = System.getProperty("line.separator");
        POSITIONAL_PARMS = new String[]{"-backupDirectory", "-currentWASDirectory", "-adminNodeName"};
    }
}

