/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.preupgrade;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.migration.common.CommonDeclares;
import com.ibm.websphere.migration.common.OSInfo;
import com.ibm.websphere.migration.exceptions.WASUpgradeException;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public abstract class WCCMHelper {
    protected static TraceComponent _tc = Tr.register((Class)WCCMHelper.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    protected String _configRoot;
    protected OSInfo _osInfo;
    protected Hashtable _crossReferences;
    protected Hashtable _configurationFilesList = new Hashtable();

    public WCCMHelper(String string, OSInfo oSInfo) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"WCCMHelper", (Object)new Object[]{string, oSInfo});
        this._configRoot = string;
        this._osInfo = oSInfo;
    }

    public Hashtable getCrossReferences() {
        Tr.entry((TraceComponent)_tc, (String)"getCrossReferences");
        this._crossReferences = new Hashtable();
        return this._crossReferences;
    }

    public abstract boolean isCrossReference(Object var1, Object var2, Object var3, Method var4) throws WASUpgradeException;

    public List getContents(File file) throws WASUpgradeException, FileNotFoundException {
        Tr.entry((TraceComponent)_tc, (String)"getContents", (Object)file);
        String string = file.getPath();
        Object object = null;
        object = this._configurationFilesList.containsKey(string) ? this._configurationFilesList.get(string) : this.getResource(file);
        return this.getContentsFromResource(object);
    }

    public void closeConfigurationFiles() {
        Tr.entry((TraceComponent)_tc, (String)"closeConfigurationFiles");
        Enumeration enumeration = this._configurationFilesList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.closeConfigurationFile(string);
        }
    }

    public abstract void collectCrossReferences(Object var1);

    public abstract boolean isAbstractEnumerator(Object var1) throws WASUpgradeException;

    public abstract String getAbstractEnumeratorValue(Object var1) throws WASUpgradeException;

    protected Object getResource(File file) throws WASUpgradeException, FileNotFoundException {
        Tr.entry((TraceComponent)_tc, (String)"getResource", (Object)file);
        File file2 = new File(this._configRoot, "cells");
        File file3 = file;
        while (!file3.getParentFile().equals(file2)) {
            file3 = file3.getParentFile();
        }
        Object object = null;
        Repository repository = this.createRepository(file3);
        try {
            String string = file.getPath().substring(file3.getPath().length() + 1, file.getPath().length());
            ConfigRoot configRoot = repository.getConfigRoot();
            Method method = ConfigRoot.class.getMethod("getResource", Integer.TYPE, String.class);
            object = method.invoke((Object)configRoot, new Integer(0), string);
            this._configurationFilesList.put(file.getPath(), object);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            String string = throwable.getMessage().trim();
            if (throwable instanceof FileNotFoundException && string.startsWith("http:") && string.endsWith(".xmi")) {
                throw (FileNotFoundException)throwable;
            }
            this.throwInternalErrorException(throwable);
        }
        catch (Exception exception) {
            this.throwInternalErrorException(exception);
        }
        return object;
    }

    protected Repository createRepository(File file) throws WASUpgradeException {
        Repository repository;
        block8: {
            Tr.entry((TraceComponent)_tc, (String)"createRepository", (Object)file);
            boolean bl = true;
            Class<?> clazz = null;
            try {
                clazz = Class.forName("com.ibm.ws.runtime.service.RepositoryFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
            }
            repository = null;
            Class[] classArray = new Class[]{String.class, String.class, String.class, String.class, String.class};
            Object[] objectArray = new Object[]{"ws-server", this._configRoot, file.getName(), null, null};
            try {
                if (bl) {
                    Method method = clazz.getMethod("createRepository", classArray);
                    repository = (Repository)method.invoke(null, objectArray);
                    break block8;
                }
                try {
                    clazz = Class.forName("com.ibm.ws.runtime.service.RepositoryImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.throwInternalErrorException(classNotFoundException);
                }
                Constructor<?> constructor = clazz.getConstructor(classArray);
                repository = (Repository)constructor.newInstance(objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.throwInternalErrorException(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                this.throwInternalErrorException(exception);
            }
        }
        return repository;
    }

    protected abstract List getContentsFromResource(Object var1) throws WASUpgradeException;

    protected abstract void closeConfigurationFile(String var1);

    protected void throwInternalErrorException(Throwable throwable) throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"throwInternalErrorException", (Object)throwable);
        String string = CommonDeclares._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{throwable}, "An unexpected internal error occurred, exception {0}.");
        throw new WASUpgradeException(string);
    }
}

