/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.preupgrade;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.websphere.migration.common.CommonDeclares;
import com.ibm.websphere.migration.common.Logger;
import com.ibm.websphere.migration.common.OSInfo;
import com.ibm.websphere.migration.common.OSInfoFactory;
import com.ibm.websphere.migration.exceptions.WASUpgradeException;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.migration.common.SerializedWCCMObject;
import com.ibm.ws.migration.common.XMLReflectionHelper;
import com.ibm.ws.migration.preupgrade.WCCMEtoolsHelper;
import com.ibm.ws.migration.preupgrade.WCCMHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class XMLSerializer {
    protected static TraceComponent _tc = Tr.register((Class)XMLSerializer.class, null, (String)"com.ibm.websphere.migration.WASUpgrade");
    public static final String DEFAULT_APPLICATION_TYPE = "ws-server";
    protected Vector _oldObjects = new Vector();
    protected Vector _newObjects = new Vector();
    protected Hashtable _crossReferences;
    private Vector _contents = new Vector();
    private File _xmlFile;
    private WCCMHelper _helper;
    protected XMLReflectionHelper _reflectionHelper = new XMLReflectionHelper();

    private static void initializer() {
        CommonDeclares._nls = new NLS("com.ibm.websphere.migration.WASUpgrade");
        ModelMgr.initialize((String)DEFAULT_APPLICATION_TYPE);
        try {
            Class<?> clazz = Class.forName("com.ibm.websphere.models.config.init.PMEConfigInit");
            Method method = clazz.getMethod("init", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XMLSerializer(File file, WCCMHelper wCCMHelper) {
        Tr.entry((TraceComponent)_tc, (String)"XMLSerializer", (Object)file);
        this._xmlFile = file;
        this._helper = wCCMHelper;
        this._crossReferences = this._helper.getCrossReferences();
    }

    public Vector serialize() throws Exception, FileNotFoundException {
        Tr.entry((TraceComponent)_tc, (String)"serialize");
        this.processContents(this._helper.getContents(this._xmlFile));
        return this._contents;
    }

    protected void processContents(List list) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processContents", (Object)list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.processXML(iterator.next(), this._contents);
        }
        this.processCrossReferences();
    }

    protected void processXML(Object object, Object object2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXML", (Object)new Object[]{object, object2});
        Class clazz = this.getInterfaceClass(object);
        String string = clazz.getName();
        SerializedWCCMObject serializedWCCMObject = null;
        if (object2 instanceof List) {
            serializedWCCMObject = this._helper.isAbstractEnumerator(object) ? new SerializedWCCMObject(string, this._helper.getAbstractEnumeratorValue(object)) : new SerializedWCCMObject(string);
            ((List)object2).add(serializedWCCMObject);
        } else {
            serializedWCCMObject = (SerializedWCCMObject)object2;
        }
        this._oldObjects.addElement(object);
        this._newObjects.addElement(serializedWCCMObject);
        this.collectCrossReferences(object);
        this.processXMLAttributes(object, serializedWCCMObject, clazz);
        this.processXMLChildTagLists(object, serializedWCCMObject, clazz);
        this.processXMLChildTagSingleObjects(object, serializedWCCMObject, clazz);
    }

    protected void processXMLAttributes(Object object, SerializedWCCMObject serializedWCCMObject, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXMLAttributes", (Object)new Object[]{object, serializedWCCMObject, clazz});
        Method[][] methodArray = this.getAttributeMethods(clazz);
        Method[] methodArray2 = methodArray[0];
        Method[] methodArray3 = methodArray[1];
        for (int i = 0; i < methodArray2.length; ++i) {
            Object object2 = this.invoke(methodArray2[i], object, new Object[0], true, clazz);
            if (object2 == null) continue;
            serializedWCCMObject.addAttributeGetterAndValue(methodArray2[i], object2);
        }
    }

    protected void processXMLChildTagLists(Object object, SerializedWCCMObject serializedWCCMObject, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXMLChildTagLists", (Object)new Object[]{object, serializedWCCMObject, clazz});
        Method[] methodArray = this.getChildTagListMethods(clazz);
        for (int i = 0; i < methodArray.length; ++i) {
            List list = (List)this.invoke(methodArray[i], object, new Object[0], true, clazz);
            List list2 = serializedWCCMObject.getListForChildTagListMethod(methodArray[i]);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.isWebSphereClass(e.getClass())) {
                    this.processXML(e, list2);
                    continue;
                }
                if (e.getClass().getName().equals("java.lang.String")) {
                    this.addUniqueStringEntry(list2, (String)e);
                    continue;
                }
                if (e instanceof Short || e instanceof Integer || e instanceof Long) {
                    this.addUniqueNonfractionalNumericEntry(list2, (Number)e);
                    continue;
                }
                Tr.debug((TraceComponent)_tc, (String)("Found an List entry of unexpected type: " + e.getClass().getName()));
                this.throwInternalErrorException(null);
            }
        }
    }

    protected void processXMLChildTagSingleObjects(Object object, SerializedWCCMObject serializedWCCMObject, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processXMLChildTagSingleObjects", (Object)new Object[]{object, serializedWCCMObject, clazz});
        Method[][] methodArray = this.getChildTagSingleMethods(clazz);
        Method[] methodArray2 = methodArray[0];
        Method[] methodArray3 = methodArray[1];
        for (int i = 0; i < methodArray2.length; ++i) {
            Object object2 = this.invoke(methodArray2[i], object, new Object[0], true, clazz);
            if (object2 == null) continue;
            Tr.debug((TraceComponent)_tc, (String)("Found object of class: " + object2.getClass().getName()));
            if (this._helper.isCrossReference(object, object2, serializedWCCMObject, methodArray2[i])) continue;
            if (this._oldObjects.contains(object2)) {
                Tr.debug((TraceComponent)_tc, (String)("Found a back XML reference on method: " + methodArray2[i]));
                int n = this._oldObjects.indexOf(object2);
                Object e = this._newObjects.elementAt(n);
                serializedWCCMObject.addSingleChildGetterAndValue(methodArray2[i], e);
                continue;
            }
            SerializedWCCMObject serializedWCCMObject2 = new SerializedWCCMObject(this.getInterfaceClass(object2).getName());
            serializedWCCMObject.addSingleChildGetterAndValue(methodArray2[i], serializedWCCMObject2);
            this.processXML(object2, serializedWCCMObject2);
        }
    }

    protected Method[][] getAttributeMethods(Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getAttributeMethods", (Object)clazz);
        return this._reflectionHelper.getAttributeMethods(clazz);
    }

    protected Method[] getChildTagListMethods(Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getChildTagListMethods", (Object)clazz);
        return this._reflectionHelper.getChildTagListMethods(clazz);
    }

    protected Method[][] getChildTagSingleMethods(Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getChildTagSingleMethods", (Object)clazz);
        return this._reflectionHelper.getChildTagSingleMethods(clazz);
    }

    private boolean isWebSphereClass(Class clazz) {
        Tr.entry((TraceComponent)_tc, (String)"isWebSphereClass", (Object)clazz);
        return this._reflectionHelper.isWebSphereClass(clazz);
    }

    protected Class getInterfaceClass(Object object) {
        Tr.entry((TraceComponent)_tc, (String)"getInterfaceClass", (Object)object);
        return this._reflectionHelper.getInterfaceClass(object);
    }

    protected Object invoke(Method method, Object object, Object[] objectArray, boolean bl, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"invoke", (Object)new Object[]{method, object, objectArray, new Boolean(bl), clazz});
        return this._reflectionHelper.invoke(method, object, objectArray, bl, clazz);
    }

    protected void addUniqueStringEntry(List list, String string) {
        Tr.entry((TraceComponent)_tc, (String)"addUniqueStringEntry", (Object)new Object[]{list, string});
        this._reflectionHelper.addUniqueStringEntry(list, string);
    }

    protected void addUniqueNonfractionalNumericEntry(List list, Number number) {
        Tr.entry((TraceComponent)_tc, (String)"addUniqueNonfractionalNumericEntry", (Object)new Object[]{list, number});
        this._reflectionHelper.addUniqueNonfractionalNumericEntry(list, number);
    }

    private void collectCrossReferences(Object object) {
        Tr.entry((TraceComponent)_tc, (String)"collectCrossReferences", (Object)object);
        this._helper.collectCrossReferences(object);
    }

    private void processCrossReferences() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processCrossReferences");
        SerializedWCCMObject serializedWCCMObject = (SerializedWCCMObject)this._contents.elementAt(0);
        Enumeration enumeration = this._crossReferences.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            int n = this._oldObjects.indexOf(k);
            SerializedWCCMObject serializedWCCMObject2 = (SerializedWCCMObject)this._newObjects.elementAt(n);
            Vector vector = (Vector)this._crossReferences.get(k);
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Object[] objectArray = (Object[])enumeration2.nextElement();
                SerializedWCCMObject serializedWCCMObject3 = (SerializedWCCMObject)objectArray[1];
                serializedWCCMObject.addCrossReference(serializedWCCMObject3, (Method)objectArray[0], serializedWCCMObject2);
            }
        }
    }

    private void handleInvocationTargetException(InvocationTargetException invocationTargetException) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"handleInvocationTargetException", (Object)invocationTargetException);
        this._reflectionHelper.handleInvocationTargetException(invocationTargetException);
    }

    protected void throwInternalErrorException(Throwable throwable) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"throwInternalErrorException", (Object)throwable);
        XMLReflectionHelper.throwInternalErrorException(throwable);
    }

    public void save() throws WASUpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"save");
        String string = this._xmlFile.getName();
        String string2 = string.substring(0, string.lastIndexOf("."));
        File file = this._xmlFile.getParentFile();
        File file2 = new File(file, string2 + ".ser");
        if (file2.exists()) {
            file2.delete();
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file2));
            objectOutputStream.writeObject(this._contents);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            String string3 = CommonDeclares._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
            throw new WASUpgradeException(string3);
        }
    }

    public static void processDirectories(File file, Vector vector, WCCMHelper wCCMHelper) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"processDirectories", (Object)new Object[]{file, vector, wCCMHelper});
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    XMLSerializer.processDirectories(fileArray[i], vector, wCCMHelper);
                    continue;
                }
                if (!vector.contains(fileArray[i].getName())) continue;
                XMLSerializer xMLSerializer = new XMLSerializer(fileArray[i], wCCMHelper);
                try {
                    xMLSerializer.serialize();
                    xMLSerializer.save();
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    String string = fileNotFoundException.getMessage().trim();
                    if (string.startsWith("http:") && string.endsWith(".xmi")) continue;
                    string = CommonDeclares._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{fileNotFoundException}, "An unexpected internal error occurred, exception {0}.");
                    throw new WASUpgradeException(string);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        ManagerAdmin.configureClientTrace((String)"*=all=enabled", (String)"stdout", null, (boolean)false, (String)"basic", (boolean)true);
        Tr.entry((TraceComponent)_tc, (String)"main", (Object)stringArray);
        if (stringArray.length < 3) {
            System.exit(-1);
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        XMLSerializer.initializer();
        try {
            CommonDeclares._logger = new Logger(null, null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Serializable serializable;
            Object object;
            OSInfo oSInfo = OSInfoFactory.createOSInfo(string2, string);
            boolean bl = true;
            try {
                object = Class.forName("com.ibm.websphere.migration.common.Configuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl = false;
            }
            object = null;
            if (bl) {
                try {
                    serializable = Class.forName("com.ibm.ws.migration.preupgrade.WCCMEclipseHelper");
                    Constructor<?> constructor = ((Class)serializable).getConstructor(String.class, OSInfo.class);
                    object = (WCCMHelper)constructor.newInstance(string3, oSInfo);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            } else {
                object = new WCCMEtoolsHelper(string3, oSInfo);
            }
            serializable = new Vector();
            for (int i = 3; i < stringArray.length; ++i) {
                ((Vector)serializable).add((String)stringArray[i]);
            }
            File file = new File(string3, "cells");
            XMLSerializer.processDirectories(file, (Vector)serializable, (WCCMHelper)object);
            ((WCCMHelper)object).closeConfigurationFiles();
            System.exit(0);
        }
        catch (WASUpgradeException wASUpgradeException) {
            wASUpgradeException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String string4 = CommonDeclares._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{throwable}, "An unexpected internal error occurred, exception {0}.");
            Logger.println(string4);
        }
        System.exit(-2);
    }
}

