/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.utility;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.Document;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.ConfigRepositoryDocumentCollectionHelper;
import com.ibm.ws.migration.postupgrade.Federated.DMgrConnectionInfo;
import com.ibm.ws.migration.utility.ConfigRepositoryConnectionImpl;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ConfigRepositoryConnectionFederatedImpl
extends ConfigRepositoryConnectionImpl {
    private static TraceComponent _tc = Tr.register((Class)ConfigRepositoryConnectionFederatedImpl.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private String _originalOldCellName = null;
    private String _originalNewCellName = null;

    public ConfigRepositoryConnectionFederatedImpl(File file) {
        super(file);
    }

    public String getOriginalOldCellName() {
        Tr.entry((TraceComponent)_tc, (String)"getOrignalOldCellName");
        return this._originalOldCellName;
    }

    public String getOriginalNewCellName() {
        Tr.entry((TraceComponent)_tc, (String)"getOrignalNewCellName");
        return this._originalNewCellName;
    }

    public ConfigRepository getConfigRepository() throws AdminException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"getConfigRepository");
        Properties properties = new Properties();
        properties.put("location", "local");
        properties.put("was.repository.root", this._configRoot);
        _DMConnectionProps = properties;
        _localConnectionProps = properties;
        this._activeRepository = this._localRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)properties);
        this._cellName = (String)UpgradeBase.get_cmdLineArgs().get("-cellName");
        if (this._cellName == null || this._cellName.equals("")) {
            this._cellName = this.getCellName();
        }
        Repository repository = RepositoryFactory.createRepository((String)this._configRoot.getAbsolutePath(), (String)this._cellName, null, null);
        this._resourceSet = new WASResourceSetImpl();
        this._resourceSet.getResources().clear();
        ConfigRepository configRepository = this.getCorrectRepositoryForScenario();
        this.verifyCorrectRepositoryConnection();
        return configRepository;
    }

    protected ConfigRepository getCorrectRepositoryForScenario() throws Exception {
        Object object;
        Object object2;
        Tr.entry((TraceComponent)_tc, (String)"getCorrectRepositoryForScenario");
        String string = new File(new File(this._configRoot.getParentFile(), "properties"), "soap.client.props").getAbsolutePath();
        File file = UpgradeBase.get_oldOSInfo().installRoot();
        File file2 = UpgradeBase.get_newOSInfo().installRoot();
        File file3 = UpgradeBase.get_oldOSInfo().userRoot();
        File file4 = UpgradeBase.get_newOSInfo().userRoot();
        Configuration configuration = new Configuration(new File(file3, "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
        Configuration configuration2 = new Configuration(new File(file4, "config"), null, null, false, UpgradeBase.get_newOSInfo().releaseVersion(), false, true);
        this._originalOldCellName = configuration.getCellName();
        this._originalNewCellName = configuration2.getCellName();
        DMgrConnectionInfo dMgrConnectionInfo = new DMgrConnectionInfo(configuration);
        dMgrConnectionInfo.initializeAdminClient();
        Properties properties = dMgrConnectionInfo.getDMConnectProps();
        if (properties.containsKey("type") && properties.get("type").equals("SOAP")) {
            object2 = properties.getProperty("host");
            properties.remove("host");
            properties.put("SOAP_HOST", object2);
            object = properties.getProperty("port");
            properties.remove("port");
            properties.put("SOAP_PORT", object);
        }
        if (properties.containsKey("type") && properties.get("type").equals("RMI")) {
            object2 = properties.getProperty("host");
            properties.remove("host");
            properties.put("RMI_HOST", object2);
            object = properties.getProperty("port");
            properties.remove("port");
            properties.put("RMI_PORT", object);
        }
        if (properties.containsKey("securityEnabled")) {
            if (properties.get("securityEnabled").equals("true")) {
                this._isGlobalSecurityEnabled = true;
                this._globalSecurityUserID = properties.getProperty("username");
                this._globalSecurityPassword = properties.getProperty("password");
                this._keyStore = properties.getProperty("javax.net.ssl.keyStore");
                this._keyStorePassword = properties.getProperty("javax.net.ssl.keyStorePassword");
                this._keyStoreType = properties.getProperty("com.ibm.ssl.keyStoreType");
                this._trustStore = properties.getProperty("javax.net.ssl.trustStore");
                this._trustStorePassword = properties.getProperty("javax.net.ssl.trustStorePassword");
                this._trustStoreType = properties.getProperty("com.ibm.ssl.trustStoreType");
            }
            properties.remove("securityEnabled");
            properties.put("autoAcceptSignerForThisConnectionOnly", "true");
        }
        if (properties.containsKey("com.ibm.SOAP.requestTimeout")) {
            properties.remove("com.ibm.SOAP.requestTimeout");
        }
        this._validConnectionProps.clear();
        this._validConnectionProps.add(properties);
        Tr.debug((TraceComponent)_tc, (String)"Connection properties being used to make Federated DMgr Connection.");
        object2 = properties.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (UtilityImpl.containPassword((String)object)) {
                Tr.debug((TraceComponent)_tc, (String)("key=" + (String)object + " value=" + "xxxxxx"));
                continue;
            }
            Tr.debug((TraceComponent)_tc, (String)("key=" + (String)object + " value=" + properties.getProperty((String)object)));
        }
        object = new ConfigRepositoryConnectionImpl.ConfigRepositoryConnection(this, (Hashtable)this._validConnectionProps.get(0));
        Thread thread = new Thread((Runnable)object);
        thread.start();
        thread.join();
        Tr.debug((TraceComponent)_tc, (String)"Renaming cell directory to reflect Federation");
        this.extractAndUpdateWASPreBackupConfigDocuments(configuration);
        Tr.debug((TraceComponent)_tc, (String)"Extracting Documents from Master Repository on DMGR into the WASPre backup directory");
        this.renameCellDirectory(this.getOriginalOldCellName(), this.getOriginalNewCellName());
        return this._localRepository;
    }

    public void renameCellDirectory(String string, String string2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"renameCellDirectory", (Object)new Object[]{string, string2});
        String[] stringArray = this.getLocalConfigRepository().listResourceNames("cells", 1, Integer.MAX_VALUE);
        String[] stringArray2 = (String[])stringArray.clone();
        Tr.debug((TraceComponent)_tc, (String)("oldCellName: " + string));
        Tr.debug((TraceComponent)_tc, (String)("newCellName: " + string2));
        if (!string.equals(string2)) {
            DocumentContentSource documentContentSource;
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = stringArray2[i].replaceFirst(string2, string);
            }
            Vector<Document> vector = new Vector<Document>();
            Vector<DocumentContentSource> vector2 = new Vector<DocumentContentSource>();
            for (int i = 0; i < stringArray.length; ++i) {
                Tr.debug((TraceComponent)_tc, (String)("Document to be deleted: " + stringArray[i]));
                Tr.debug((TraceComponent)_tc, (String)("Document to be created: " + stringArray2[i]));
                vector.add(new Document(stringArray[i]));
                documentContentSource = this.getLocalConfigRepository().extract(stringArray[i]);
                DocumentContentSource documentContentSource2 = new DocumentContentSource(new Document(stringArray2[i]), documentContentSource.getSource());
                vector2.add(documentContentSource2);
            }
            DocumentContentSource[] documentContentSourceArray = new DocumentContentSource[vector2.size()];
            vector2.toArray(documentContentSourceArray);
            documentContentSource = new Document[vector.size()];
            vector.toArray((T[])documentContentSource);
            Tr.debug((TraceComponent)_tc, (String)"Starting the rename process via ConfigRepository");
            this.getLocalConfigRepository().delete((Document[])documentContentSource);
            this.getLocalConfigRepository().create(documentContentSourceArray);
        }
    }

    private void extractAndUpdateWASPreBackupConfigDocuments(Configuration configuration) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"extracAndUpdateWASPreBackupConfigDocuments", (Object)new Object[]{configuration});
        String[] stringArray = this.getRemoteConfigRepository().listResourceNames("cells/" + configuration.getCellName(), 1, Integer.MAX_VALUE);
        File file = configuration.getConfigDirectory();
        DocumentContentSource[] documentContentSourceArray = this.getRemoteConfigRepository().extract(stringArray);
        for (int i = 0; i < documentContentSourceArray.length; ++i) {
            DocumentContentSource documentContentSource = documentContentSourceArray[i];
            File file2 = new File(configuration.getConfigDirectory(), documentContentSource.getDocument().getURI());
            if (!file2.getParentFile().exists()) {
                file2.getParentFile().mkdirs();
            }
            file2.createNewFile();
            try {
                FileUtilities.copyBufferedInputStream(new BufferedInputStream(documentContentSource.getSource()), file2);
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Failure extracting file, possibly due to file having no contents.", (Object)exception);
                file2.createNewFile();
            }
            documentContentSourceArray[i] = null;
        }
    }

    protected void verifyCorrectRepositoryConnection() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"verifyCorrectRepositoryConnection");
        File file = UpgradeBase.get_oldOSInfo().userRoot();
        Configuration configuration = new Configuration(new File(file, "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
        if (!configuration.isFederatedNode()) {
            this.checkUserInstallRoot(configuration);
            this.checkHost(configuration);
        }
        this.checkVersion(configuration);
    }

    protected InputStream getLocalSource(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getLocalSource", (Object)string);
        File file = UpgradeBase.get_oldOSInfo().userRoot();
        Configuration configuration = new Configuration(new File(file, "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
        File file2 = new File(configuration.getConfigDirectory(), string);
        return new FileInputStream(file2);
    }

    protected void modifyRepositoryToLocal() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"modifyRepositoryToLocal");
        String string = LoggerImpl._nls.getString("advise.incorrect.repository.connection", "Incorrect Deployment Manager connection established.");
        UpgradeBase.get_logger().println(string);
        throw new Exception(string);
    }

    protected void checkVersion(Configuration configuration) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"checkVersion", (Object)new Object[]{configuration});
        if (this._remoteRepository != null) {
            int n;
            String string = null;
            File file = new File(configuration.getCellDirectory(), "nodes");
            File[] fileArray = file.listFiles();
            boolean bl = false;
            boolean bl2 = false;
            for (n = 0; n < fileArray.length; ++n) {
                Tr.debug((TraceComponent)_tc, (String)("DMGR Matching: " + fileArray[n]));
                if (!fileArray[n].isDirectory() || !configuration.isDeploymentManagerNode(fileArray[n])) continue;
                try {
                    String string2 = new File(new File(configuration.getOwningNodeDirectory().getParentFile(), fileArray[n].getName()), "node-metadata.properties").getAbsolutePath();
                    string2 = ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(string2);
                    Tr.debug((TraceComponent)_tc, (String)("DMGR Matching: extraction of: " + string2));
                    InputStream inputStream = this._remoteRepository.extract(string2).getSource();
                    Tr.debug((TraceComponent)_tc, (String)("DMGR Matched: " + fileArray[n].getName()));
                    string = fileArray[n].getName();
                    bl = true;
                    continue;
                }
                catch (Exception exception) {
                    Tr.debug((TraceComponent)_tc, (String)("DMGR Match failed: node " + fileArray[n].getName() + " does not exist in the repository"), (Object)exception);
                    bl2 = true;
                }
            }
            if (!bl) {
                Tr.debug((TraceComponent)_tc, (String)"Using local mode: node-metadata.properties file missing.");
                this.modifyRepositoryToLocal();
                return;
            }
            if (bl2) {
                Tr.debug((TraceComponent)_tc, (String)"Extra DMGRs found in backup directory");
                for (n = 0; n < fileArray.length; ++n) {
                    Tr.debug((TraceComponent)_tc, (String)("Extra DMGRs: examining " + fileArray[n].getName()));
                    if (!fileArray[n].isDirectory() || !configuration.isDeploymentManagerNode(fileArray[n]) || fileArray[n].getName().equals(string)) continue;
                    try {
                        Tr.debug((TraceComponent)_tc, (String)("Extra DMGRs: found extra DMGR " + fileArray[n].getName()));
                        FileUtilities.deleteDirectoryAndContents(fileArray[n]);
                        continue;
                    }
                    catch (Exception exception) {
                        Tr.debug((TraceComponent)_tc, (String)("Error: Could not delete extra dmgr folder (" + fileArray[n].getName() + ") from backup directory.  Admin client dmgr='" + string + "' "), (Object)exception);
                    }
                }
            }
        }
    }
}

