/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.utility;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.exception.RepositoryException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.client.ConfigRepositoryClientFactory;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.security.Security;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.migration.common.Configuration;
import com.ibm.ws.migration.common.OSInfoFactory;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.document.ConfigRepositoryDocumentCollectionHelper;
import com.ibm.ws.migration.postupgrade.WASPostUpgrade;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.ws.migration.utility.UtilityImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ConfigRepositoryConnectionImpl {
    private static TraceComponent _tc = Tr.register((Class)ConfigRepositoryConnectionImpl.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static Properties _DMConnectionProps = null;
    protected static Properties _localConnectionProps = null;
    protected static final String CONNECTION_TYPE_SERVER = "remote";
    protected static final String CONNECTION_TYPE_STANDALONE = "local";
    protected static final String SERVER_NAME = "SERVER_NAME";
    protected static final String SOAP_PORT = "SOAP_PORT";
    protected static final String SOAP_HOST = "SOAP_HOST";
    protected static final String RMI_PORT = "RMI_PORT";
    protected static final String RMI_HOST = "RMI_HOST";
    protected ConfigRepository _localRepository = null;
    protected ConfigRepository _remoteRepository = null;
    protected ConfigRepository _activeRepository = null;
    protected boolean _isGlobalSecurityEnabled = false;
    protected String _globalSecurityUserID = null;
    protected String _globalSecurityPassword = null;
    protected String _keyStore = null;
    protected String _keyStorePassword = null;
    protected String _keyStoreType = null;
    protected String _trustStore = null;
    protected String _trustStorePassword = null;
    protected String _trustStoreType = null;
    protected ArrayList _validConnectionProps = new ArrayList();
    protected String _cellName = null;
    protected ResourceSet _resourceSet = null;
    protected File _configRoot = null;

    public ConfigRepositoryConnectionImpl(File file) {
        Tr.entry((TraceComponent)_tc, (String)"ConfigRepositoryConnectionImpl", (Object)new Object[]{file});
        this._configRoot = file;
    }

    public ConfigRepository getActiveConfigRepository() {
        Tr.entry((TraceComponent)_tc, (String)"getActiveConfigRepository");
        return this._activeRepository;
    }

    public ConfigRepository getRemoteConfigRepository() {
        Tr.entry((TraceComponent)_tc, (String)"getRemoteConfigRepository");
        return this._remoteRepository;
    }

    public ConfigRepository getLocalConfigRepository() {
        Tr.entry((TraceComponent)_tc, (String)"getLocalConfigRepository");
        return this._localRepository;
    }

    public static Properties getRemoteConnectionProperties() {
        Tr.entry((TraceComponent)_tc, (String)"getRemoteConnectionProperties");
        return _DMConnectionProps;
    }

    public ConfigRepository getConfigRepository() throws AdminException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"getConfigRepository");
        Properties properties = new Properties();
        properties.put("location", CONNECTION_TYPE_STANDALONE);
        properties.put("was.repository.root", this._configRoot);
        _DMConnectionProps = properties;
        _localConnectionProps = properties;
        this._activeRepository = this._localRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)properties);
        this._cellName = (String)UpgradeBase.get_cmdLineArgs().get("-cellName");
        if (this._cellName == null || this._cellName.equals("")) {
            this._cellName = this.getCellName();
        }
        Repository repository = RepositoryFactory.createRepository((String)this._configRoot.getAbsolutePath(), (String)this._cellName, null, null);
        this._resourceSet = new WASResourceSetImpl();
        this.gatherAllValidConnectionInfoSets();
        this.getActiveConnectionConfigRepository();
        if (this._remoteRepository != null) {
            this._activeRepository = this._remoteRepository;
        }
        this._resourceSet.getResources().clear();
        this.verifyCorrectRepositoryConnection();
        ConfigRepository configRepository = this.getCorrectRepositoryForScenario();
        return configRepository;
    }

    protected void validateCurrentDMgrStateAcceptable(Configuration configuration) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"validateCurrentDMgrStateAcceptable", (Object)configuration);
        if (this._remoteRepository != null) {
            String string = new File(configuration.getOwningNodeDirectory(), "node-metadata.properties").getAbsolutePath();
            string = ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(string);
            InputStream inputStream = null;
            try {
                inputStream = this._remoteRepository.extract(string).getSource();
            }
            catch (Exception exception) {
                return;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            if (properties.getProperty("com.ibm.websphere.baseProductVersion").startsWith("6.1") && WASPostUpgrade.is_keepDmgrEnabled()) {
                String string2 = LoggerImpl._nls.getString("advise.two.dmgr.running.with.keepdmgrenabled", "Detected current version of Deployment Manager running while -keepDMgrEnabled attribute set.");
                UpgradeBase.get_logger().println(string2);
                throw new Exception(string2);
            }
        }
    }

    protected void verifyCorrectRepositoryConnection() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"verifyCorrectRepositoryConnection");
        File file = UpgradeBase.get_newOSInfo().userRoot();
        Configuration configuration = new Configuration(new File(file, "config"), null, null, false, UpgradeBase.get_newOSInfo().releaseVersion(), false, true);
        if (configuration.isDeploymentManagerConfiguration() && WASPostUpgrade.is_keepDmgrEnabled()) {
            this.validateCurrentDMgrStateAcceptable(configuration);
        }
        this.checkUserInstallRoot(configuration);
        this.checkHost(configuration);
        this.checkVersion(configuration);
    }

    protected void modifyRepositoryToLocal() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"modifyRepositoryToLocal");
        this._activeRepository = this._localRepository;
        this._remoteRepository = this._localRepository;
        _DMConnectionProps = _localConnectionProps;
    }

    protected void checkVersion(Configuration configuration) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"checkVersion", (Object)new Object[]{configuration});
        if (this._remoteRepository != null) {
            String string = new File(configuration.getOwningNodeDirectory(), "node-metadata.properties").getAbsolutePath();
            string = ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(string);
            InputStream inputStream = null;
            try {
                inputStream = this._remoteRepository.extract(string).getSource();
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Using local mode: node-metadata.properties file missing.");
                this.modifyRepositoryToLocal();
                return;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            if (!properties.getProperty("com.ibm.websphere.baseProductVersion").startsWith("6.1")) {
                Tr.debug((TraceComponent)_tc, (String)"Wrong ConfigRepository connection, using local mode instead: Version missmatch");
                this.modifyRepositoryToLocal();
            }
        }
    }

    protected void checkHost(Configuration configuration) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"checkHost", (Object)new Object[]{configuration});
        if (this._remoteRepository != null) {
            String string = new File(configuration.getOwningNodeDirectory(), "serverindex.xml").getAbsolutePath();
            string = ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(string);
            URI uRI = URI.createFileURI((String)CONNECTION_TYPE_STANDALONE);
            WASResourceImpl wASResourceImpl = new WASResourceImpl(uRI);
            wASResourceImpl.load((InputStream)new BufferedInputStream(this.getLocalSource(string)), new HashMap());
            uRI = URI.createFileURI((String)CONNECTION_TYPE_SERVER);
            WASResourceImpl wASResourceImpl2 = new WASResourceImpl(uRI);
            wASResourceImpl2.load((InputStream)new BufferedInputStream(this._remoteRepository.extract(string).getSource()), new HashMap());
            ServerIndex serverIndex = (ServerIndex)wASResourceImpl.getContents().get(0);
            ServerIndex serverIndex2 = (ServerIndex)wASResourceImpl2.getContents().get(0);
            if (!serverIndex.getHostName().equals(serverIndex2.getHostName())) {
                Tr.debug((TraceComponent)_tc, (String)"Wrong ConfigRepository connection, using local mode instead: HostName missmatch");
                this.modifyRepositoryToLocal();
            }
        }
    }

    protected InputStream getLocalSource(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getLocalSource", (Object)string);
        return this._localRepository.extract(string).getSource();
    }

    protected void checkUserInstallRoot(Configuration configuration) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"checkUserInstallRoot", (Object)new Object[]{configuration});
        if (this._remoteRepository != null) {
            Object object;
            String string = new File(configuration.getOwningNodeDirectory(), "variables.xml").getAbsolutePath();
            string = ConfigRepositoryDocumentCollectionHelper.getConfigRepositoryCompliantPath(string);
            URI uRI = URI.createFileURI((String)CONNECTION_TYPE_STANDALONE);
            WASResourceImpl wASResourceImpl = new WASResourceImpl(uRI);
            wASResourceImpl.load((InputStream)new BufferedInputStream(this.getLocalSource(string)), new HashMap());
            uRI = URI.createFileURI((String)CONNECTION_TYPE_SERVER);
            WASResourceImpl wASResourceImpl2 = new WASResourceImpl(uRI);
            try {
                wASResourceImpl2.load((InputStream)new BufferedInputStream(this._remoteRepository.extract(string).getSource()), new HashMap());
            }
            catch (Exception exception) {
                Tr.debug((TraceComponent)_tc, (String)"Wrong ConfigRepository connection, using local mode instead:  USER_INSTALL_ROOT missmatch.");
                this.modifyRepositoryToLocal();
                return;
            }
            Iterator iterator = ((VariableMap)wASResourceImpl.getContents().get(0)).getEntries().iterator();
            Iterator iterator2 = ((VariableMap)wASResourceImpl2.getContents().get(0)).getEntries().iterator();
            String string2 = null;
            while (iterator.hasNext()) {
                object = (VariableSubstitutionEntry)iterator.next();
                if (!object.getSymbolicName().equals("USER_INSTALL_ROOT")) continue;
                string2 = object.getValue();
                break;
            }
            object = null;
            while (iterator2.hasNext()) {
                VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)iterator2.next();
                if (!variableSubstitutionEntry.getSymbolicName().equals("USER_INSTALL_ROOT")) continue;
                object = variableSubstitutionEntry.getValue();
                break;
            }
            if (!string2.equals(object)) {
                Tr.debug((TraceComponent)_tc, (String)"Wrong ConfigRepository connection, using local mode instead:  USER_INSTALL_ROOT missmatch.");
                this.modifyRepositoryToLocal();
            }
        }
    }

    protected ConfigRepository getCorrectRepositoryForScenario() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getCorrectRepositoryForScenario");
        return this._activeRepository;
    }

    public String getCellName() {
        Tr.entry((TraceComponent)_tc, (String)"getCellName");
        String[] stringArray = this._activeRepository.listResourceNames("cells/", 2, 1);
        return stringArray[0].substring(stringArray[0].lastIndexOf("/") + 1);
    }

    protected void gatherAllValidConnectionInfoSets() throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"gatherAllValidConnections");
        String[] stringArray = null;
        if (this._cellName != null) {
            stringArray = this._localRepository.listResourceNames("cells/" + this._cellName + "/" + "nodes" + "/", 2, 1);
        }
        block0: for (int i = 0; i < stringArray.length; ++i) {
            Resource resource = this.getResource((String)stringArray[i] + "/" + "serverindex.xml");
            ServerIndex serverIndex = this.locateServerIndex(resource);
            EList eList = serverIndex.getServerEntries();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                ServerEntry serverEntry = (ServerEntry)iterator.next();
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                this._validConnectionProps.add(hashtable);
                EList eList2 = serverEntry.getSpecialEndpoints();
                Iterator iterator2 = eList2.iterator();
                while (iterator2.hasNext()) {
                    EndPoint endPoint;
                    NamedEndPoint namedEndPoint = (NamedEndPoint)iterator2.next();
                    String string = namedEndPoint.getEndPointName();
                    if (string.equals("SOAP_CONNECTOR_ADDRESS")) {
                        endPoint = namedEndPoint.getEndPoint();
                        hashtable.put(SOAP_PORT, new Integer(endPoint.getPort()).toString());
                        hashtable.put(SOAP_HOST, endPoint.getHost());
                    }
                    if (!string.equals("BOOTSTRAP_ADDRESS")) continue;
                    endPoint = namedEndPoint.getEndPoint();
                    hashtable.put(RMI_PORT, new Integer(endPoint.getPort()).toString());
                    hashtable.put(RMI_HOST, endPoint.getHost());
                }
                if (!serverEntry.getServerType().equals("DEPLOYMENT_MANAGER")) continue;
                this._validConnectionProps.clear();
                this._validConnectionProps.add(hashtable);
                i = stringArray.length;
                continue block0;
            }
        }
        if (this._validConnectionProps.size() != 0) {
            this.processSecurityFile();
            this.processSOAPClientProps();
        }
    }

    public Resource getResource(String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getResource", (Object)string);
        DocumentContentSource documentContentSource = null;
        try {
            documentContentSource = this._activeRepository.extract(string);
        }
        catch (RepositoryException repositoryException) {
            throw new UpgradeException(repositoryException);
        }
        return this.getResource(documentContentSource);
    }

    public Resource getResource(DocumentContentSource documentContentSource) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"getResource", (Object)documentContentSource);
        try {
            Resource resource = this._resourceSet.getResource(URI.createFileURI((String)documentContentSource.getDocument().getURI()), false);
            if (resource == null) {
                resource = new WASResourceImpl(URI.createFileURI((String)documentContentSource.getDocument().getURI()));
                this._resourceSet.getResources().add((Object)resource);
                resource.load(documentContentSource.getSource(), new HashMap());
            }
            return resource;
        }
        catch (IOException iOException) {
            throw new UpgradeException(iOException);
        }
    }

    private void processSecurityFile() throws UpgradeException {
        Configuration configuration;
        Tr.entry((TraceComponent)_tc, (String)"processSecurityFile");
        File file = UpgradeBase.get_oldOSInfo().userRoot();
        Security security = null;
        if (WASPostUpgrade.is_wasPostUpgrade()) {
            configuration = new Configuration(new File(file, "config"), null, null, false, UpgradeBase.get_oldOSInfo().releaseVersion(), false, true);
            File file2 = new File(configuration.getCellDirectory(), "security.xml");
            Tr.debug((TraceComponent)_tc, (String)("Processing security file " + file2.getAbsolutePath()));
            security = (Security)configuration.locateConfigFileObject(file2, Security.class);
            this._isGlobalSecurityEnabled = security.isEnabled();
        } else {
            configuration = this.getResource("cells/" + this._cellName + "/" + "security.xml");
            security = this.locateSecurity((Resource)configuration);
            this._isGlobalSecurityEnabled = security.isEnabled();
        }
        if (WASPostUpgrade.get_userName() != null) {
            this._globalSecurityUserID = WASPostUpgrade.get_userName();
            this._globalSecurityPassword = WASPostUpgrade.get_password();
        } else if (this._isGlobalSecurityEnabled) {
            configuration = security.getActiveUserRegistry();
            this._globalSecurityUserID = configuration.getServerId();
            this._globalSecurityPassword = configuration.getServerPassword();
        }
    }

    private void processSOAPClientProps() throws UpgradeException {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"processSOAPClientProps");
        Properties properties = new Properties();
        File file = null;
        if (WASPostUpgrade.is_wasPostUpgrade()) {
            object = UpgradeBase.get_oldOSInfo().getProfileName();
            Tr.debug((TraceComponent)_tc, (String)("oldProfileName is " + (String)object));
            String string = WASPostUpgrade.get_oldInstanceName();
            Tr.debug((TraceComponent)_tc, (String)("oldInstanceName is " + string));
            if (UpgradeBase.get_oldOSInfo().releaseVersion().isR50() || UpgradeBase.get_oldOSInfo().releaseVersion().isR51() || OSInfoFactory.isISeries()) {
                if (string == null) {
                    Tr.debug((TraceComponent)_tc, (String)"Not migrating v5.x instance");
                    file = new File(new File(new File(UpgradeBase.get_backupDirectory().getAbsolutePath(), "websphere_backup"), "properties"), "soap.client.props");
                } else {
                    Tr.debug((TraceComponent)_tc, (String)"Migrating a v5.x instance");
                    file = new File(new File(new File(new File(UpgradeBase.get_backupDirectory().getAbsolutePath(), "profiles"), string), "properties"), "soap.client.props");
                }
            } else {
                Tr.debug((TraceComponent)_tc, (String)"Old release is v6.x");
                file = new File(new File(new File(new File(UpgradeBase.get_backupDirectory().getAbsolutePath(), "profiles"), (String)object), "properties"), "soap.client.props");
            }
        } else {
            file = new File(new File(UpgradeBase.get_userRoot(), "properties"), "soap.client.props");
        }
        Tr.debug((TraceComponent)_tc, (String)("soap.client.props in use: " + file.getAbsolutePath()));
        try {
            object = new FileInputStream(file);
            properties.load((InputStream)object);
        }
        catch (Exception exception) {
            Tr.entry((TraceComponent)_tc, (String)("Unable to load soap.client.properties while trying to establish a connection " + exception));
        }
        this._keyStore = properties.getProperty("com.ibm.ssl.keyStore");
        Tr.entry((TraceComponent)_tc, (String)("set _keyStore to " + this._keyStore));
        this._keyStorePassword = properties.getProperty("com.ibm.ssl.keyStorePassword");
        this._keyStoreType = properties.getProperty("com.ibm.ssl.keyStoreType");
        Tr.entry((TraceComponent)_tc, (String)("set _keyStoreType to " + this._keyStoreType));
        this._trustStore = properties.getProperty("com.ibm.ssl.trustStore");
        Tr.entry((TraceComponent)_tc, (String)("set _trustStore to " + this._trustStore));
        this._trustStorePassword = properties.getProperty("com.ibm.ssl.trustStorePassword");
        this._trustStoreType = properties.getProperty("com.ibm.ssl.trustStoreType");
        Tr.entry((TraceComponent)_tc, (String)("set _trustStoreType to " + this._trustStoreType));
    }

    private Security locateSecurity(Resource resource) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateSecurity", (Object)resource);
        EList eList = resource.getContents();
        Iterator iterator = eList.iterator();
        Object var4_4 = null;
        while (iterator.hasNext() && var4_4 == null) {
            Object e = iterator.next();
            if (!(e instanceof Security)) continue;
            return (Security)e;
        }
        return null;
    }

    private ServerIndex locateServerIndex(Resource resource) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"locateServerIndex", (Object)resource);
        EList eList = resource.getContents();
        Iterator iterator = eList.iterator();
        Object var4_4 = null;
        while (iterator.hasNext() && var4_4 == null) {
            Object e = iterator.next();
            if (!(e instanceof ServerIndex)) continue;
            return (ServerIndex)e;
        }
        return null;
    }

    protected void getActiveConnectionConfigRepository() {
        int n;
        Tr.entry((TraceComponent)_tc, (String)"getActiveConnectionConfigRepository");
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Thread thread = null;
        for (n = 0; n < this._validConnectionProps.size(); ++n) {
            ConfigRepositoryConnection configRepositoryConnection = new ConfigRepositoryConnection((Hashtable)this._validConnectionProps.get(n));
            thread = new Thread(configRepositoryConnection);
            thread.start();
            arrayList.add(thread);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            try {
                ((Thread)arrayList.get(n)).join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                Tr.debug((TraceComponent)_tc, (String)interruptedException.toString());
            }
        }
    }

    protected class ConfigRepositoryConnection
    implements Runnable {
        private Hashtable _connInfo = null;

        ConfigRepositoryConnection(Hashtable hashtable) {
            this._connInfo = hashtable;
        }

        public void run() {
            this.initializeConfigRepository();
        }

        private void initializeConfigRepository() {
            Tr.entry((TraceComponent)_tc, (String)"initializeConfigRepository");
            Properties properties = new Properties();
            properties.setProperty("location", ConfigRepositoryConnectionImpl.CONNECTION_TYPE_SERVER);
            if (this._connInfo.containsKey(ConfigRepositoryConnectionImpl.SOAP_PORT)) {
                properties.setProperty("type", "SOAP");
                properties.setProperty("port", (String)this._connInfo.get(ConfigRepositoryConnectionImpl.SOAP_PORT));
                properties.setProperty("host", (String)this._connInfo.get(ConfigRepositoryConnectionImpl.SOAP_HOST));
            } else if (this._connInfo.containsKey(ConfigRepositoryConnectionImpl.RMI_PORT)) {
                properties.setProperty("type", "RMI");
                properties.setProperty("port", (String)this._connInfo.get(ConfigRepositoryConnectionImpl.RMI_PORT));
                properties.setProperty("host", (String)this._connInfo.get(ConfigRepositoryConnectionImpl.RMI_HOST));
            }
            if (ConfigRepositoryConnectionImpl.this._isGlobalSecurityEnabled) {
                properties.setProperty("securityEnabled", "true");
                properties.setProperty("username", ConfigRepositoryConnectionImpl.this._globalSecurityUserID);
                properties.setProperty("password", ConfigRepositoryConnectionImpl.this._globalSecurityPassword);
                properties.setProperty("javax.net.ssl.keyStore", ConfigRepositoryConnectionImpl.this._keyStore);
                properties.setProperty("javax.net.ssl.keyStorePassword", ConfigRepositoryConnectionImpl.this._keyStorePassword);
                Tr.debug((TraceComponent)_tc, (String)("javax.net.ssl.keyStore = " + ConfigRepositoryConnectionImpl.this._keyStore));
                if (ConfigRepositoryConnectionImpl.this._keyStoreType != null) {
                    properties.setProperty("com.ibm.ssl.keyStoreType", ConfigRepositoryConnectionImpl.this._keyStoreType);
                    Tr.debug((TraceComponent)_tc, (String)("com.ibm.ssl.keyStoreType = " + ConfigRepositoryConnectionImpl.this._keyStoreType));
                }
                properties.setProperty("javax.net.ssl.trustStore", ConfigRepositoryConnectionImpl.this._trustStore);
                properties.setProperty("javax.net.ssl.trustStorePassword", ConfigRepositoryConnectionImpl.this._trustStorePassword);
                Tr.debug((TraceComponent)_tc, (String)("javax.net.ssl.trustStore = " + ConfigRepositoryConnectionImpl.this._trustStore));
                if (ConfigRepositoryConnectionImpl.this._trustStoreType != null) {
                    properties.setProperty("com.ibm.ssl.trustStoreType", ConfigRepositoryConnectionImpl.this._trustStoreType);
                    Tr.debug((TraceComponent)_tc, (String)("com.ibm.ssl.trustStoreType = " + ConfigRepositoryConnectionImpl.this._trustStoreType));
                }
                properties.setProperty("autoAcceptSignerForThisConnectionOnly", "true");
            } else {
                properties.setProperty("securityEnabled", "false");
            }
            try {
                if (ConfigRepositoryConnectionImpl.this._remoteRepository == null) {
                    Tr.debug((TraceComponent)_tc, (String)"Connection Set settings");
                    Iterator<Object> iterator = properties.keySet().iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        String string2 = (String)properties.get(string);
                        if (UtilityImpl.containPassword(string)) {
                            Tr.debug((TraceComponent)_tc, (String)("key=" + string + " value=" + "xxxxxx"));
                            continue;
                        }
                        Tr.debug((TraceComponent)_tc, (String)("key=" + string + " value=" + string2));
                    }
                    ConfigRepositoryConnectionImpl.this._remoteRepository = ConfigRepositoryClientFactory.getConfigRepositoryClient((Properties)properties);
                    ConfigRepositoryConnectionImpl.this._remoteRepository.initialize(new Properties());
                    Tr.debug((TraceComponent)_tc, (String)"Connection Established");
                    _DMConnectionProps = properties;
                }
            }
            catch (AdminException adminException) {
                Tr.debug((TraceComponent)_tc, (String)"AdminException to follow from method initializeConfigRepository()");
                Tr.debug((TraceComponent)_tc, (String)adminException.toString());
            }
            catch (Throwable throwable) {
                Tr.debug((TraceComponent)_tc, (String)"Exception thrownin run(): ", (Object)throwable);
                throwable.printStackTrace(System.err);
                throwable.printStackTrace(System.out);
            }
        }
    }
}

