/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.utility;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.migration.common.FileUtilities;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.utility.Logger;
import com.ibm.wsspi.migration.utility.WASLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class LoggerImpl
implements WASLogger {
    private static TraceComponent _tc = Tr.register((Class)LoggerImpl.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    protected static TraceNLS _nls = null;
    protected static String _timeStamp = null;
    private static Vector _messages = new Vector();
    private static FileOutputStream _logger = null;
    private static FileOutputStream _systemoutLog = null;
    static final String messageHeader = "MIGR";
    protected static final String messageTemplate = "MIGRxxxxL";
    protected static final String warningMessage = "W";
    protected static final String errorMessage = "E";
    protected static boolean _initializedLogging = false;
    protected static PrintStream _originalErr = null;
    protected static PrintStream _originalOut = null;
    protected static PrintStream _newErr = null;
    protected static PrintStream _newOut = null;
    protected static PrintStream _systemErr = null;
    protected static PrintStream _systemOut = null;
    protected static boolean _loggedWarning = false;
    protected static boolean _loggedError = false;
    protected static File _logLocation = null;

    public static WASLogger getLogger() {
        return null;
    }

    public File getLogLocation() {
        Tr.entry((TraceComponent)_tc, (String)"getLogLocation");
        return _logLocation;
    }

    public Vector getAllmessages() {
        Tr.entry((TraceComponent)_tc, (String)"getAllmessages");
        return _messages;
    }

    public LoggerImpl(File file, String string) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"LoggerImpl", (Object)new Object[]{file, string});
        this.initializeLogging(file, string, null);
    }

    public LoggerImpl(File file, String string, File file2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"LoggerImpl", (Object)new Object[]{file, string, file2});
        this.initializeLogging(file, string, file2);
    }

    public static boolean Unregister() {
        if (LoggerImpl.isRegistered()) {
            System.setOut(_originalOut);
            System.setErr(_originalErr);
        }
        return LoggerImpl.isRegistered();
    }

    public static boolean isRegistered() {
        return _initializedLogging;
    }

    public static boolean loggedWarning() {
        return _loggedWarning;
    }

    public static boolean loggedError() {
        return _loggedError;
    }

    private static void setWarningOrError(String string) {
        try {
            if (string.indexOf(messageHeader) != -1) {
                int n = string.indexOf(messageHeader) + messageTemplate.length();
                if (n < 1 || n > string.length()) {
                    Tr.event((TraceComponent)_tc, (String)"Error trying to parse warning level on string, index out of bounds:", (Object)new Object[]{string, new Integer(n), new Integer(string.length())});
                } else {
                    String string2 = string.substring(n - 1, n);
                    if (string2.equalsIgnoreCase(warningMessage)) {
                        _loggedWarning = true;
                    } else if (string2.equalsIgnoreCase(errorMessage)) {
                        _loggedError = true;
                    }
                }
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)("Problems parsing: " + string));
        }
    }

    protected void initializeLogging(File file, String string, File file2) throws UpgradeException {
        Tr.entry((TraceComponent)_tc, (String)"initializeLogging", (Object)new Object[]{file, string, file2});
        if (LoggerImpl.isRegistered()) {
            return;
        }
        try {
            LoggerImpl.set_timeStamp(FileUtilities.generateTimeStamp());
            String string2 = FileUtilities.generateFileName(string, LoggerImpl.get_timeStamp());
            if (file2 != null) {
                boolean bl = true;
                if (!file2.getParentFile().exists()) {
                    bl = file2.getParentFile().mkdirs();
                }
                if (bl) {
                    _systemoutLog = new FileOutputStream(file2, true);
                    _systemErr = new PrintStream(_systemoutLog);
                    _systemOut = new PrintStream(_systemoutLog);
                } else {
                    Tr.debug((TraceComponent)_tc, (String)"Could not create -summaryLog because directories could not be created.");
                }
            }
            _originalErr = System.err;
            _originalOut = System.out;
            if (!file.exists()) {
                file.mkdirs();
            }
            _logLocation = new File(file, string2);
            _logger = new FileOutputStream(_logLocation, true);
            _newOut = new PrintStream(_logger);
            _newErr = new PrintStream(_logger);
            System.setOut(_newOut);
            System.setErr(_newErr);
            _initializedLogging = true;
            System.out.println(_nls.getFormattedMessage("advise.logging.initialized", new Object[]{string}, "Initialized Log File: {0}"));
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"Logger failed to initialize with the following exception: ", (Object)exception);
            String string3 = _nls.getFormattedMessage("advise.logging.initialized.failure", new Object[]{_logLocation.getAbsolutePath()}, "Failure to initialize Log File: {0}");
            throw new UpgradeException(string3, exception, false);
        }
    }

    public void printStackTrace(Throwable throwable) {
        this.printStackTrace(throwable, false);
    }

    public void printStackTrace(Throwable throwable, boolean bl) {
        if (LoggerImpl.isRegistered()) {
            if (_systemoutLog != null) {
                System.setOut(_systemOut);
                System.setErr(_systemErr);
                throwable.printStackTrace();
            }
            System.setOut(_newOut);
            System.setErr(_newErr);
            throwable.printStackTrace();
        }
    }

    public void println(String string) {
        this.print(string);
    }

    private void print(String string) {
        LoggerImpl.setWarningOrError(string);
        if (LoggerImpl.isRegistered()) {
            System.setOut(_originalOut);
            System.setErr(_originalErr);
            System.out.println(string);
            if (_systemoutLog != null) {
                System.setOut(_systemOut);
                System.setErr(_systemErr);
                System.out.println(string);
            }
            System.setOut(_newOut);
            System.setErr(_newErr);
        }
        System.out.println(string);
    }

    private void print(String string, boolean bl) {
        LoggerImpl.setWarningOrError(string);
        if (LoggerImpl.isRegistered() && !bl) {
            System.setOut(_originalOut);
            System.setErr(_originalErr);
            System.out.println(string);
            if (_systemoutLog != null) {
                System.setOut(_systemOut);
                System.setErr(_systemErr);
                System.out.println(string);
            }
            System.setOut(_newOut);
            System.setErr(_newErr);
        }
        System.out.println(string);
        Tr.debug((TraceComponent)_tc, (String)string);
    }

    public void println(String string, Throwable throwable) {
        LoggerImpl.setWarningOrError(string);
        LoggerImpl.setWarningOrError(throwable.toString());
        if (LoggerImpl.isRegistered()) {
            System.setOut(_originalOut);
            System.setErr(_originalErr);
            System.out.println(string);
            System.out.println(throwable.toString());
            if (_systemoutLog != null) {
                System.setOut(_systemOut);
                System.setErr(_systemErr);
                System.out.println(string);
                System.out.println(throwable.toString());
            }
            System.setOut(_newOut);
            System.setErr(_newErr);
        }
        System.out.print(string);
        System.out.println(throwable.toString());
        Tr.debug((TraceComponent)_tc, (String)string, (Object)throwable);
    }

    public void println(String string, Throwable throwable, boolean bl) {
        LoggerImpl.setWarningOrError(string);
        LoggerImpl.setWarningOrError(throwable.toString());
        if (LoggerImpl.isRegistered() && !bl) {
            System.setOut(_originalOut);
            System.setErr(_originalErr);
            System.out.println(string);
            System.out.println(throwable.toString());
            if (_systemoutLog != null) {
                System.setOut(_systemOut);
                System.setErr(_systemErr);
                System.out.println(string);
                System.out.println(throwable.toString());
            }
            System.setOut(_newOut);
            System.setErr(_newErr);
        }
        System.out.print(string);
        System.out.println(throwable.toString());
        Tr.debug((TraceComponent)_tc, (String)string, (Object)throwable);
    }

    public void println(String string, boolean bl) {
        this.print(string, bl);
    }

    public void println(Logger.Level level, String string) {
        if (level.equals(Logger.Level.WARNING)) {
            _loggedWarning = true;
        } else if (level.equals(Logger.Level.ERROR)) {
            _loggedError = true;
        }
        this.print(string);
    }

    public void println(Logger.Level level, String string, Throwable throwable) {
        if (level.equals(Logger.Level.WARNING)) {
            _loggedWarning = true;
        } else if (level.equals(Logger.Level.ERROR)) {
            _loggedError = true;
        }
        if (LoggerImpl.isRegistered()) {
            System.setOut(_originalOut);
            System.setErr(_originalErr);
            System.out.println(string);
            System.out.println(throwable.toString());
            if (_systemoutLog != null) {
                System.setOut(_systemOut);
                System.setErr(_systemErr);
                System.out.println(string);
                System.out.println(throwable.toString());
            }
            System.setOut(_newOut);
            System.setErr(_newErr);
        }
        System.out.print(string);
        System.out.println(throwable.toString());
        Tr.debug((TraceComponent)_tc, (String)string, (Object)throwable);
    }

    public void println(Logger.Level level, String string, boolean bl) {
        if (level.equals(Logger.Level.WARNING)) {
            _loggedWarning = true;
        } else if (level.equals(Logger.Level.ERROR)) {
            _loggedError = true;
        }
        this.print(string, bl);
    }

    public void println(Logger.Level level, String string, Throwable throwable, boolean bl) {
        if (level.equals(Logger.Level.WARNING)) {
            _loggedWarning = true;
        } else if (level.equals(Logger.Level.ERROR)) {
            _loggedError = true;
        }
        if (LoggerImpl.isRegistered() && !bl) {
            System.setOut(_originalOut);
            System.setErr(_originalErr);
            System.out.println(string);
            System.out.println(throwable.toString());
            if (_systemoutLog != null) {
                System.setOut(_systemOut);
                System.setErr(_systemErr);
                System.out.println(string);
                System.out.println(throwable.toString());
            }
            System.setOut(_newOut);
            System.setErr(_newErr);
        }
        System.out.print(string);
        System.out.println(throwable.toString());
        Tr.debug((TraceComponent)_tc, (String)string, (Object)throwable);
    }

    public static TraceNLS get_nls() {
        return _nls;
    }

    public static void set_nls(TraceNLS traceNLS) {
        _nls = traceNLS;
    }

    public static String get_timeStamp() {
        return _timeStamp;
    }

    public static void set_timeStamp(String string) {
        _timeStamp = string;
    }
}

