/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.migration.utility;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.variables.VariableMap;
import com.ibm.websphere.models.config.variables.VariableSubstitutionEntry;
import com.ibm.ws.migration.common.UpgradeBase;
import com.ibm.ws.migration.utility.LoggerImpl;
import com.ibm.ws.migration.utility.UpgradeException;
import com.ibm.wsspi.migration.document.BasicDocument;
import com.ibm.wsspi.migration.document.CellDocumentCollection;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.NodeDocumentCollection;
import com.ibm.wsspi.migration.document.ServerDocumentCollection;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.document.wccm.WCCMDocument;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;

public class UtilityImpl {
    public static String WAS_ROOT = "WAS_INSTALL_ROOT";
    public static String PROFILE_ROOT = "USER_INSTALL_ROOT";
    public static String WASVariableOpen = "${";
    public static String WASVariableClose = "}";
    private static TraceComponent _tc = Tr.register((Class)UtilityImpl.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static Hashtable _factories = new Hashtable();
    static /* synthetic */ Class class$com$ibm$wsspi$migration$document$BasicDocument;

    public static String fixUpPath(String string, DocumentCollection documentCollection, DocumentCollection documentCollection2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"fixUpPath", (Object)new Object[]{string, documentCollection, documentCollection2});
        return UtilityImpl.fixUpPath(string, UtilityImpl.getVariables(documentCollection), UtilityImpl.getVariables(documentCollection2));
    }

    public static String makePathCommon(String string) {
        Tr.entry((TraceComponent)_tc, (String)"makePathCommon", (Object)string);
        return string.replace('\\', '/');
    }

    public static Properties getVariables(DocumentCollection documentCollection) {
        Tr.entry((TraceComponent)_tc, (String)"getVariables", (Object)documentCollection);
        DocumentCollection documentCollection2 = documentCollection;
        try {
            while (true) {
                if (documentCollection2 instanceof CellDocumentCollection) {
                    return ((CellDocumentCollection)documentCollection2).getVariables();
                }
                if (documentCollection2 instanceof NodeDocumentCollection) {
                    return ((NodeDocumentCollection)documentCollection2).getVariables();
                }
                if (documentCollection2 instanceof ServerDocumentCollection) {
                    return ((ServerDocumentCollection)documentCollection2).getVariables();
                }
                documentCollection2 = documentCollection2.getParent();
            }
        }
        catch (NotFoundException notFoundException) {
            return new Properties();
        }
    }

    public static String fixUpPath(String string, Properties properties, Properties properties2) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"fixUpPath", (Object)new Object[]{string, properties, properties2});
        if (properties != null && properties2 != null) {
            String string2 = properties.getProperty("WAS_INSTALL_ROOT");
            String string3 = properties.getProperty("USER_INSTALL_ROOT");
            String string4 = UtilityImpl.resolveEntryPath(properties2.getProperty("WAS_INSTALL_ROOT"), properties2);
            String string5 = UtilityImpl.resolveEntryPath(properties2.getProperty("USER_INSTALL_ROOT"), properties2);
            if ((string2 = UtilityImpl.resolveEntryPath(string2, properties)) == null || string3 == null) {
                string = UtilityImpl.replacePrefix(string, string3, string5);
                string = UtilityImpl.replacePrefix(string, string2, string4);
            } else if (string2.length() > string3.length()) {
                string = UtilityImpl.replacePrefix(string, string2, string4);
                string = UtilityImpl.replacePrefix(string, string3, string5);
            } else {
                string = UtilityImpl.replacePrefix(string, string3, string5);
                string = UtilityImpl.replacePrefix(string, string2, string4);
            }
        }
        return string;
    }

    public static String replacePrefix(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.replace('\\', '/').startsWith(string2.replace('\\', '/'))) {
            stringBuffer.replace(0, string2.length(), string3);
        }
        return stringBuffer.toString();
    }

    public static String resolveEntryPath(String string, Properties properties) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"resolveEntryPath", (Object)new Object[]{string, properties});
        StringTokenizer stringTokenizer = new StringTokenizer(string, "${}()", true);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("$") && ((string2 = stringTokenizer.nextToken()).equals("{") || string2.equals("("))) {
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    if (!string2.equals("}") && !string2.equals(")")) {
                        stringBuffer.append(string2);
                    }
                    if (!string2.equals("}") && !string2.equals(")")) continue;
                    String string3 = properties.getProperty(stringBuffer.toString());
                    if (string3 == null) {
                        String string4 = LoggerImpl._nls.getFormattedMessage("advise.could.not.resolve.variable", new Object[]{stringBuffer.toString()}, "Could not resolve variable {0}.");
                        UpgradeBase.get_logger().println(string4);
                        throw new Exception(string4);
                    }
                    stringBuffer2.append(string3);
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer2.append(stringTokenizer.nextToken());
                    }
                    return UtilityImpl.resolveEntryPath(stringBuffer2.toString(), properties);
                }
            }
            stringBuffer2.append(string2);
        }
        return stringBuffer2.toString();
    }

    public static Properties getVariables(WCCMDocument wCCMDocument, Properties properties) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getVariables", (Object)new Object[]{wCCMDocument, properties});
        Iterator iterator = wCCMDocument.getList().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof VariableMap)) continue;
            VariableMap variableMap = (VariableMap)e;
            EList eList = variableMap.getEntries();
            Iterator iterator2 = eList.iterator();
            while (iterator2.hasNext()) {
                VariableSubstitutionEntry variableSubstitutionEntry = (VariableSubstitutionEntry)iterator2.next();
                String string = variableSubstitutionEntry.getSymbolicName();
                String string2 = variableSubstitutionEntry.getValue();
                if (string == null || string2 == null) continue;
                properties.put(string, string2);
            }
        }
        return properties;
    }

    public static void copyDocumentCollection(DocumentCollection documentCollection, DocumentCollection documentCollection2) throws Exception {
        Object object;
        Tr.entry((TraceComponent)_tc, (String)"copyDocumentCollection", (Object)new Object[]{documentCollection, documentCollection2});
        String[] stringArray = documentCollection.getDocumentNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (documentCollection2.documentExists(stringArray[i])) continue;
            BasicDocument basicDocument = (BasicDocument)documentCollection.openDocument(stringArray[i], class$com$ibm$wsspi$migration$document$BasicDocument == null ? UtilityImpl.class$("com.ibm.wsspi.migration.document.BasicDocument") : class$com$ibm$wsspi$migration$document$BasicDocument);
            object = (BasicDocument)documentCollection2.openDocument(stringArray[i], class$com$ibm$wsspi$migration$document$BasicDocument == null ? UtilityImpl.class$("com.ibm.wsspi.migration.document.BasicDocument") : class$com$ibm$wsspi$migration$document$BasicDocument, true, false);
            ((BasicDocument)object).setInputStream(basicDocument.getInputStream());
            basicDocument.close();
            ((BasicDocument)object).close();
        }
        DocumentCollection[] documentCollectionArray = documentCollection.getChildren();
        for (int i = 0; i < documentCollectionArray.length; ++i) {
            object = documentCollectionArray[i];
            DocumentCollection documentCollection3 = null;
            try {
                documentCollection3 = documentCollection2.getChild(object.getName());
            }
            catch (NotFoundException notFoundException) {
                documentCollection3 = documentCollection2.addDocumentCollection(object.getName());
            }
            UtilityImpl.copyDocumentCollection((DocumentCollection)object, documentCollection3);
        }
    }

    public static Object locateConfigFileObject(WCCMDocument wCCMDocument, Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"locateConfigFileObject", (Object)new Object[]{wCCMDocument, clazz});
        if (wCCMDocument.getList().size() != 0) {
            List list = wCCMDocument.getList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!clazz.isInstance(e)) continue;
                return e;
            }
        } else {
            wCCMDocument.getList().add(UtilityImpl.create(clazz));
            return wCCMDocument.getList().get(0);
        }
        return null;
    }

    public static Object create(Class clazz) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"create", (Object)clazz);
        return UtilityImpl.create(clazz.getName());
    }

    public static Object create(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"create", (Object)string);
        Object object = null;
        try {
            String string2 = string.substring(0, string.lastIndexOf("."));
            String string3 = string.substring(string.lastIndexOf(".") + 1);
            EFactory eFactory = UtilityImpl.getFactory(string2);
            Class<?> clazz = eFactory.getClass();
            Method method = clazz.getMethod("create" + string3, new Class[0]);
            object = method.invoke((Object)eFactory, new Object[0]);
        }
        catch (Exception exception) {
            String string4 = LoggerImpl._nls.getFormattedMessage("advise.unexpected.internal.error", new Object[]{exception}, "An unexpected internal error occurred, exception {0}.");
            UpgradeBase.get_logger().println(string4);
            throw new UpgradeException(string4, exception, false);
        }
        return object;
    }

    private static EFactory getFactory(String string) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getFactory", (Object)string);
        EFactory eFactory = (EFactory)_factories.get(string);
        if (eFactory == null) {
            String string2 = string.substring(string.lastIndexOf(".") + 1);
            string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
            Class<?> clazz = Class.forName(string + "." + string2 + "Package");
            Field field = clazz.getField("eNS_URI");
            String string3 = (String)field.get(null);
            EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(string3);
            Method method = clazz.getMethod("get" + string2 + "Factory", new Class[0]);
            eFactory = (EFactory)method.invoke((Object)ePackage, new Object[0]);
            _factories.put(string, eFactory);
        }
        return eFactory;
    }

    public static Properties instantiateVariables(DocumentCollection documentCollection) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"instantiateVariables", (Object)documentCollection);
        if (documentCollection instanceof CellDocumentCollection) {
            return ((CellDocumentCollection)documentCollection).getVariables();
        }
        if (documentCollection instanceof NodeDocumentCollection) {
            return ((NodeDocumentCollection)documentCollection).getVariables();
        }
        if (documentCollection instanceof ServerDocumentCollection) {
            return ((ServerDocumentCollection)documentCollection).getVariables();
        }
        return new Properties();
    }

    public static File expandVariables(String string, Properties properties) {
        if (string == null) {
            Tr.error((TraceComponent)_tc, (String)"expandVariables failed because source == null");
            return null;
        }
        if (properties == null) {
            Tr.error((TraceComponent)_tc, (String)"expandVariables cannot do work because variables == null");
            return new File(string);
        }
        int n = 0;
        int n2 = string.indexOf(WASVariableOpen);
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (n2 < 0) {
            return new File(string);
        }
        while (n2 != -1) {
            stringBuffer.append(string.substring(n, n2));
            n = n2;
            n2 = string.indexOf(WASVariableClose, n);
            if (n2 < 0) break;
            String string2 = string.substring(n + WASVariableOpen.length(), n2);
            String string3 = properties.getProperty(string2);
            if (string3 != null) {
                stringBuffer.append(string3);
            } else {
                stringBuffer.append(string.substring(n, n2 + WASVariableClose.length()));
            }
            n = n2 + WASVariableClose.length();
            n2 = string.indexOf(WASVariableOpen, n);
        }
        stringBuffer.append(string.substring(n, string.length()));
        return new File(stringBuffer.toString());
    }

    public static String contractVariable(String string, String string2, String string3) {
        if (string == null) {
            Tr.error((TraceComponent)_tc, (String)"contractVariable failed because source == null");
            return string;
        }
        if (string2 == null) {
            Tr.error((TraceComponent)_tc, (String)"contractVariable cannot do work because valueToReplace == null");
            return string;
        }
        if (string3 == null) {
            Tr.error((TraceComponent)_tc, (String)"contractVariable cannot do work because variableName == null");
            return string;
        }
        if (string2.length() < 1) {
            Tr.error((TraceComponent)_tc, (String)"contractVariable cannot do work because valueToReplace.length()<1");
            return string;
        }
        int n = string.indexOf(string2);
        int n2 = n + string2.length();
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() - string2.length() + string3.length() + 3);
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append("${");
        stringBuffer.append(string3);
        stringBuffer.append("}");
        stringBuffer.append(string.substring(n2, string.length()));
        return stringBuffer.toString();
    }

    public static String contractRootVariables(File file, Properties properties) {
        if (file == null) {
            Tr.error((TraceComponent)_tc, (String)"contractProfileRoot failed because File source == null");
            return null;
        }
        if (properties == null) {
            Tr.error((TraceComponent)_tc, (String)"contractProfileRoot cannot do work because variables == null");
            return file.getAbsolutePath();
        }
        String string = file.getAbsolutePath();
        String string2 = new File(properties.getProperty(PROFILE_ROOT)).getAbsolutePath();
        String string3 = new File(properties.getProperty(WAS_ROOT)).getAbsolutePath();
        string = UtilityImpl.contractVariable(string, string2, PROFILE_ROOT);
        string = UtilityImpl.contractVariable(string, string3, WAS_ROOT);
        return string;
    }

    public static boolean startsWith(String string, String[] stringArray) {
        if (string == null || stringArray == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; !bl && i < stringArray.length; ++i) {
            bl = string.startsWith(stringArray[i]);
        }
        return bl;
    }

    public static boolean containPassword(String string) {
        return string.toLowerCase().indexOf("password") != -1;
    }

    public static String replacePassword(String string) {
        String string2 = string;
        try {
            String string3 = "(\\w*[pP][aA][sS]{2}[wW][oO][rR][dD]\\w*)(\\s)*([= | \\s])([^ ,])*([ ,]|$)";
            String string4 = "$1=XXXXX$5";
            string2 = string2.replaceAll(string3, string4);
        }
        catch (Exception exception) {
            return string;
        }
        return string2;
    }
}

