/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.migration.document;

import [Ljava.lang.String;;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDocument
implements Document {
    private static TraceComponent _tc = Tr.register((Class)XMLDocument.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static String lineSeparator = System.getProperty("line.separator");
    private Element _root = null;
    private Node _docRoot = null;
    private org.w3c.dom.Document _doc = null;
    private StringBuffer _dtd = new StringBuffer();
    private File _tempFile = null;
    private byte[] _bArray = null;
    private String _fileName = null;
    private boolean _internalContentsModified = false;
    private boolean _closed = false;
    private DocumentCollection _dc;

    public XMLDocument(String string, DocumentCollection documentCollection) throws IllegalArgumentException {
        Tr.entry((TraceComponent)_tc, (String)"XMLDocument", (Object)new Object[]{string, documentCollection});
        if (string == null || documentCollection == null) {
            throw new IllegalArgumentException();
        }
        this._dc = documentCollection;
        this._fileName = string;
    }

    public Element getRoot() {
        Tr.entry((TraceComponent)_tc, (String)"getRoot");
        this._internalContentsModified = true;
        return this._root;
    }

    public org.w3c.dom.Document getDocument() {
        Tr.entry((TraceComponent)_tc, (String)"getDocument");
        this._internalContentsModified = true;
        return this._doc;
    }

    public void close() throws Exception {
        Object object;
        Object object2;
        Object object3;
        Tr.entry((TraceComponent)_tc, (String)"close");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object3 = new DOMSource(this._docRoot);
            object2 = new StreamResult(this._tempFile);
            object = TransformerFactory.newInstance();
            Transformer transformer = ((TransformerFactory)object).newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform((Source)object3, (Result)object2);
            this.addDTD(this._tempFile);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw transformerConfigurationException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw transformerFactoryConfigurationError;
        }
        catch (TransformerException transformerException) {
            throw transformerException;
        }
        try {
            object3 = new BufferedReader(new FileReader(this._tempFile));
            object2 = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "8859_1"));
            object = ((BufferedReader)object3).readLine();
            while (object != null) {
                ((Writer)object2).write((String)object);
            }
            ((BufferedWriter)object2).close();
            ((BufferedReader)object3).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        this._bArray = byteArrayOutputStream.toByteArray();
        this._internalContentsModified = false;
        this._closed = true;
    }

    public InputStream getInputStream() throws IllegalStateException {
        Tr.entry((TraceComponent)_tc, (String)"getInputStream");
        if (this._internalContentsModified) {
            throw new IllegalStateException();
        }
        return new ByteArrayInputStream(this._bArray);
    }

    public void setInputStream(InputStream inputStream) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setInputStream", (Object)inputStream);
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        if (this._closed) {
            throw new IllegalStateException();
        }
        inputStream = this.setInitialState(inputStream);
        this._tempFile = File.createTempFile("migration", "temp.xml");
        this._tempFile.createNewFile();
        Object object = new FileWriter(this._tempFile);
        Object object2 = new InputStreamReader(inputStream);
        int n = ((InputStreamReader)object2).read();
        while (n != -1) {
            ((OutputStreamWriter)object).write(n);
            n = ((InputStreamReader)object2).read();
        }
        ((OutputStreamWriter)object).close();
        this.extractDTD(new BufferedReader(new FileReader(this._tempFile)));
        object = DocumentBuilderFactory.newInstance();
        try {
            object2 = ((DocumentBuilderFactory)object).newDocumentBuilder();
            this._doc = ((DocumentBuilder)object2).parse(this._tempFile);
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)("Failed opening XML document: " + this.getDocumentCollection().getName() + this._fileName), (Object)exception);
            Tr.debug((TraceComponent)_tc, (String)("_tempFile: " + this._tempFile.getAbsolutePath()));
            this._tempFile = this.removeDOCTYPE(this._tempFile);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            this._doc = documentBuilder.parse(this._tempFile);
        }
        this._root = this._doc.getDocumentElement();
        this._docRoot = this._doc.getDocumentElement().getParentNode();
        this._root.normalize();
    }

    private File removeDOCTYPE(File file) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"removeDOCTYPE", (Object)file);
        File file2 = File.createTempFile("migration", "temp");
        file2.createNewFile();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("<!DOCTYPE")) continue;
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        bufferedReader.close();
        bufferedWriter.close();
        return file2;
    }

    private InputStream setInitialState(InputStream inputStream) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setInititalState", (Object)inputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            Vector<Byte> vector = new Vector<Byte>();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte by = (byte)bufferedInputStream.read();
            while (by != -1) {
                vector.add(new Byte(by));
                by = (byte)bufferedInputStream.read();
            }
            byte[] byArray = new byte[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                byArray[i] = (Byte)vector.get(i);
            }
            this._bArray = byArray;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            Tr.debug((TraceComponent)_tc, (String)"Exception thrown setting initial state of XMLDocument: ", (Object)iOException);
            throw iOException;
        }
        return byteArrayInputStream;
    }

    public String getName() {
        Tr.entry((TraceComponent)_tc, (String)"getName");
        return this._fileName;
    }

    public boolean isClosed() {
        Tr.entry((TraceComponent)_tc, (String)"isClosed");
        return this._closed;
    }

    public DocumentCollection getDocumentCollection() {
        Tr.entry((TraceComponent)_tc, (String)"getDocumentCollection");
        return this._dc;
    }

    private void extractDTD(BufferedReader bufferedReader) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"extractDTD", (Object)bufferedReader);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = bufferedReader.read();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string).append(lineSeparator);
        }
        String string2 = "<!DOCTYPE";
        String string3 = "<!";
        String string4 = ">";
        String string5 = lineSeparator;
        Class<?> clazz = Class.forName("com.ibm.ws.migration.postupgrade.common.StringRegionTokenizer");
        Class[] classArray = new Class[]{String.class, String;.class, Boolean.TYPE};
        Object[] objectArray = new Object[]{stringBuffer.toString(), new String[]{string2, string3, string4, string5}, new Boolean(true)};
        Constructor<?> constructor = clazz.getConstructor(classArray);
        Object obj = constructor.newInstance(objectArray);
        Method method = clazz.getMethod("hasMoreTokens", new Class[0]);
        Method method2 = clazz.getMethod("nextToken", new Class[0]);
        String string6 = null;
        while (((Boolean)method.invoke(obj, new Object[0])).booleanValue()) {
            string6 = (String)method2.invoke(obj, new Object[0]);
            if (!string6.equals(string2)) continue;
            this._dtd.append(string6);
            int n2 = 1;
            do {
                string6 = (String)method2.invoke(obj, new Object[0]);
                this._dtd.append(string6);
                if (string6.equals(string3)) {
                    ++n2;
                    continue;
                }
                if (!string6.equals(string4)) continue;
                --n2;
            } while (n2 != 0);
        }
        bufferedReader.close();
    }

    private void addDTD(File file) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"addDTD", (Object)file);
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            string = bufferedReader.readLine();
            if (string != null) {
                stringBuffer.append(string).append(lineSeparator);
            }
            stringBuffer.append(lineSeparator);
            stringBuffer.append(this._dtd);
            stringBuffer.append(lineSeparator).append(lineSeparator);
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string).append(lineSeparator);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._tempFile), "8859_1"));
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    public URL getAbsoluteUrl() throws MalformedURLException {
        Tr.entry((TraceComponent)_tc, (String)"getAbsoluteUrl");
        return new File(this.getDocumentCollection().getAbsoluteUrl().getFile(), this.getName()).toURL();
    }

    public URL getAliasUrl() throws MalformedURLException {
        Tr.entry((TraceComponent)_tc, (String)"getAliasUrl");
        return new File(this.getDocumentCollection().getAliasUrl().getFile(), this.getName()).toURL();
    }
}

