/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.migration.document.wccm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.resource.WASResourceImpl;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.RepositoryFactory;
import com.ibm.wsspi.migration.document.Document;
import com.ibm.wsspi.migration.document.DocumentCollection;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class WCCMDocument
implements Document {
    private static TraceComponent _tc = Tr.register((Class)WCCMDocument.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private static ResourceSet _resourceSet = new WASResourceSetImpl();
    private static Repository _repository = RepositoryFactory.createRepository((String)"", null, null, null);
    private List _contents = null;
    private Resource _resource = null;
    private URI _uri = null;
    private File _configDir = null;
    private byte[] _bArray = null;
    private String _fileName = null;
    private boolean _internalContentsModified = false;
    private boolean _closed = false;
    private DocumentCollection _collection = null;

    public WCCMDocument(String string, DocumentCollection documentCollection) throws IllegalArgumentException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"WCCMDocument", (Object)new Object[]{string, documentCollection});
        if (string == null || documentCollection == null) {
            throw new IllegalArgumentException();
        }
        this._configDir = new File(documentCollection.getUrl().getFile());
        this._fileName = string;
        this._uri = URI.createFileURI((String)new File(this._configDir, string).getPath());
        this._collection = documentCollection;
        this.preInitialization();
    }

    public DocumentCollection getDocumentCollection() {
        Tr.entry((TraceComponent)_tc, (String)"getDocumentCollection");
        return this._collection;
    }

    private void preInitialization() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"preInitialization");
        this._resource = _resourceSet.getResource(this._uri, false);
        if (this._resource == null) {
            this._resource = new WASResourceImpl(this._uri);
        }
        this._contents = this._resource.getContents();
    }

    public void setInputStream(InputStream inputStream) throws IllegalArgumentException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"setInputStream", (Object)inputStream);
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        if (!this._closed) {
            inputStream = this.setInitialState(inputStream);
            try {
                if (this._resource.isLoaded()) {
                    this._resource.unload();
                }
                this._resource.load(inputStream, new HashMap());
                this._contents = this._resource.getContents();
            }
            catch (IOException iOException) {
                throw new Exception(iOException);
            }
        } else {
            throw new IllegalStateException("Document already closed.");
        }
    }

    private InputStream setInitialState(InputStream inputStream) throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"setInitialState", (Object)inputStream);
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            Vector<Byte> vector = new Vector<Byte>();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte by = (byte)bufferedInputStream.read();
            while (by != -1) {
                vector.add(new Byte(by));
                by = (byte)bufferedInputStream.read();
            }
            byte[] byArray = new byte[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                byArray[i] = (Byte)vector.get(i);
            }
            this._bArray = byArray;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
        return byteArrayInputStream;
    }

    public void close() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"close");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this._resource.save((OutputStream)byteArrayOutputStream, new HashMap());
        }
        catch (IOException iOException) {
            throw new Exception(iOException);
        }
        this._bArray = byteArrayOutputStream.toByteArray();
        this._internalContentsModified = false;
        this._closed = true;
    }

    public List getList() {
        Tr.entry((TraceComponent)_tc, (String)"getList");
        this._internalContentsModified = true;
        return this._contents;
    }

    public Resource getResource() {
        Tr.entry((TraceComponent)_tc, (String)"getResource");
        return this._resource;
    }

    public InputStream getInputStream() throws IllegalStateException {
        Tr.entry((TraceComponent)_tc, (String)"getInputStream");
        if (this._internalContentsModified) {
            throw new IllegalStateException();
        }
        return new ByteArrayInputStream(this._bArray);
    }

    public String getName() {
        Tr.entry((TraceComponent)_tc, (String)"getName");
        return this._fileName;
    }

    public boolean isClosed() {
        Tr.entry((TraceComponent)_tc, (String)"isClosed");
        return this._closed;
    }

    public URL getAbsoluteUrl() throws MalformedURLException {
        Tr.entry((TraceComponent)_tc, (String)"getAbsoluteUrl");
        return new File(this.getDocumentCollection().getAbsoluteUrl().getFile(), this.getName()).toURL();
    }

    public URL getAliasUrl() throws MalformedURLException {
        Tr.entry((TraceComponent)_tc, (String)"getAliasUrl");
        return new File(this.getDocumentCollection().getAliasUrl().getFile(), this.getName()).toURL();
    }
}

