/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.migration.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.DocumentProcessor;
import com.ibm.wsspi.migration.document.TransformMapping;
import com.ibm.wsspi.migration.document.exceptions.NotFoundException;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.utility.Scenario;
import com.ibm.wsspi.migration.utility.WASLogger;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Vector;

public class BasicDocumentTransform
implements DocumentTransform {
    private static TraceComponent _tc = Tr.register((Class)BasicDocumentTransform.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    private DocumentCollection _oldDocumentCollection;
    private DocumentCollection _newDocumentCollection;
    private DocumentTransform _parent;
    private Vector _transformMappings = new Vector();
    private Vector _children;
    private Scenario _scenario;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public BasicDocumentTransform(Scenario scenario, DocumentCollection documentCollection, DocumentCollection documentCollection2, DocumentTransform documentTransform) throws IllegalArgumentException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"BasicDocumentTransform", (Object)new Object[]{scenario, documentCollection, documentCollection2, documentTransform});
        if (scenario == null || documentCollection == null || documentCollection2 == null) {
            throw new IllegalArgumentException();
        }
        this._oldDocumentCollection = documentCollection;
        this._newDocumentCollection = documentCollection2;
        this._parent = documentTransform;
        this._scenario = scenario;
    }

    public void migrate() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrate");
        this.migrateDocuments();
        this.migrateDocumentCollections();
    }

    public DocumentCollection getOldDocumentCollection() {
        Tr.entry((TraceComponent)_tc, (String)"getOldDocumentCollection");
        try {
            Method method = this._oldDocumentCollection.getClass().getMethod("setScenario", Scenario.class);
            if (this._oldDocumentCollection.getScenario() == null) {
                method.invoke((Object)this._oldDocumentCollection, this.getScenario());
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"getOldDocumentCollection Exception: ", (Object)exception);
        }
        return this._oldDocumentCollection;
    }

    public DocumentCollection getNewDocumentCollection() {
        Tr.entry((TraceComponent)_tc, (String)"getNewDocumentCollection");
        try {
            Method method = this._newDocumentCollection.getClass().getMethod("setScenario", Scenario.class);
            if (this._newDocumentCollection.getScenario() == null) {
                method.invoke((Object)this._newDocumentCollection, this.getScenario());
            }
        }
        catch (Exception exception) {
            Tr.debug((TraceComponent)_tc, (String)"getNewDocumentCollection Exception: ", (Object)exception);
        }
        return this._newDocumentCollection;
    }

    public DocumentTransform createChildTransform(DocumentCollection documentCollection, DocumentCollection documentCollection2) throws IllegalArgumentException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"createChildTransform", (Object)new Object[]{documentCollection, documentCollection2});
        if (documentCollection == null || documentCollection2 == null) {
            throw new IllegalArgumentException();
        }
        return new BasicDocumentTransform(this._scenario, documentCollection, documentCollection2, this);
    }

    public Vector getChildren() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getChildren");
        if (this._children == null) {
            DocumentCollection[] documentCollectionArray = this._oldDocumentCollection.getChildren();
            this._children = new Vector(documentCollectionArray.length);
            for (int i = 0; i < documentCollectionArray.length; ++i) {
                DocumentCollection documentCollection;
                DocumentCollection documentCollection2 = documentCollectionArray[i];
                try {
                    documentCollection = this._newDocumentCollection.getPeerDocumentCollection(documentCollection2);
                }
                catch (NotFoundException notFoundException) {
                    documentCollection = this._newDocumentCollection.addPeerDocumentCollection(documentCollection2);
                }
                this._children.addElement(this.createChildTransform(documentCollection2, documentCollection));
            }
        }
        return this._children;
    }

    public DocumentTransform getChild(String string) throws IllegalArgumentException, NotFoundException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"getChild", (Object)string);
        if (string == null) {
            throw new IllegalArgumentException();
        }
        DocumentTransform documentTransform = null;
        Vector vector = this.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            DocumentTransform documentTransform2 = (DocumentTransform)vector.elementAt(i);
            if (!string.equals(documentTransform2.getName())) continue;
            documentTransform = documentTransform2;
            break;
        }
        if (documentTransform == null) {
            throw new NotFoundException("");
        }
        return documentTransform;
    }

    public DocumentTransform getParent() throws NotFoundException {
        Tr.entry((TraceComponent)_tc, (String)"getParent");
        if (this._parent == null) {
            throw new NotFoundException("");
        }
        return this._parent;
    }

    public String getName() {
        Tr.entry((TraceComponent)_tc, (String)"getName");
        return this._oldDocumentCollection.getName();
    }

    public Vector getTransformMappings() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"getTransformMappings");
        return this._transformMappings;
    }

    public Scenario getScenario() {
        Tr.entry((TraceComponent)_tc, (String)"getScenario");
        return this._scenario;
    }

    protected void migrateDocuments() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrateDocuments");
        if (this._transformMappings.size() > 0) {
            for (int i = 0; i < this._transformMappings.size(); ++i) {
                TransformMapping transformMapping = (TransformMapping)this._transformMappings.elementAt(i);
                if (!this.getOldDocumentCollection().documentExists(transformMapping.getKey().getOldDocumentName())) continue;
                String string = new File(this.getOldDocumentCollection().getUrl().getFile(), transformMapping.getKey().getOldDocumentName()).getPath();
                Class<?> clazz = Class.forName("com.ibm.ws.migration.utility.LoggerImpl");
                Method method = clazz.getMethod("get_nls", new Class[0]);
                TraceNLS traceNLS = (TraceNLS)method.invoke(null, new Object[0]);
                Method method2 = traceNLS.getClass().getMethod("getFormattedMessage", class$java$lang$String == null ? BasicDocumentTransform.class$("java.lang.String") : class$java$lang$String, array$Ljava$lang$Object == null ? BasicDocumentTransform.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object, class$java$lang$String == null ? BasicDocumentTransform.class$("java.lang.String") : class$java$lang$String);
                String string2 = (String)method2.invoke((Object)traceNLS, "advise.processing.configuration.file", new Object[]{string}, "Starting to process configuration file {0}.");
                ((WASLogger)this.getScenario().getLogger()).println(string2, true);
                Vector vector = transformMapping.getDocumentProcessors();
                for (int j = 0; j < vector.size(); ++j) {
                    Class clazz2 = (Class)vector.elementAt(j);
                    DocumentProcessor documentProcessor = this.createDocumentProcessor(transformMapping, clazz2);
                    documentProcessor.migrate();
                }
            }
        }
    }

    protected void migrateDocumentCollections() throws Exception {
        Tr.entry((TraceComponent)_tc, (String)"migrateDocumentCollections");
        Vector vector = this.getChildren();
        for (int i = 0; i < vector.size(); ++i) {
            DocumentTransform documentTransform = (DocumentTransform)vector.elementAt(i);
            documentTransform.migrate();
        }
    }

    protected DocumentProcessor createDocumentProcessor(TransformMapping transformMapping, Class clazz) throws IllegalArgumentException, Exception {
        Tr.entry((TraceComponent)_tc, (String)"createDocumentProcessor", (Object)new Object[]{transformMapping, clazz});
        if (transformMapping == null || clazz == null) {
            throw new IllegalArgumentException();
        }
        return transformMapping.createDocumentProcessor(clazz, this);
    }
}

