/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.migration.transform;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.migration.document.DocumentCollection;
import com.ibm.wsspi.migration.document.NodeDocumentCollection;
import com.ibm.wsspi.migration.transform.DocumentTransform;
import com.ibm.wsspi.migration.transform.MigrationFactory;
import com.ibm.wsspi.migration.utility.Profile;
import com.ibm.wsspi.migration.utility.Scenario;
import com.ibm.wsspi.migration.utility.WASReleaseVersion;
import java.util.Vector;

public abstract class WASMigrationFactory
implements MigrationFactory {
    private static TraceComponent _tc = Tr.register((Class)WASMigrationFactory.class, null, (String)"com.ibm.ws.migration.WASUpgrade");
    public static final String CONFIG_TRANSFORM = "config";
    public static final String PROPERTIES_TRANSFORM = "properties";
    public static final String APPLICATIONS_TRANSFORM = "applications";

    public static abstract class PreUpgradeTransformModifier {
        public PreUpgradeTransformModifier() {
            Tr.entry((TraceComponent)_tc, (String)"PreUpgradeTransformModifier");
        }

        public void modifyTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyTransform", (Object)documentTransform);
            WASReleaseVersion wASReleaseVersion = (WASReleaseVersion)documentTransform.getScenario().getOldProductImage().getReleaseVersion();
            Profile profile = documentTransform.getScenario().getOldProductImage().getProfile();
            if (wASReleaseVersion.isR50()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        this.modifyR50DmgrTransform(documentTransform);
                    } else if (profile.isNodeFederated()) {
                        this.modifyR50FederatedNDStandaloneTransform(documentTransform);
                    } else {
                        this.modifyR50NDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        this.modifyR50FederatedBaseTransform(documentTransform);
                    } else {
                        this.modifyR50BaseTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.modifyR50ClientTransform(documentTransform);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    this.modifyR50ExpressTransform(documentTransform);
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.modifyR50BobcatTransform(documentTransform);
                }
            }
            if (wASReleaseVersion.isR51()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        this.modifyR51DmgrTransform(documentTransform);
                    } else if (profile.isNodeFederated()) {
                        this.modifyR51FederatedNDStandaloneTransform(documentTransform);
                    } else {
                        this.modifyR51NDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        this.modifyR51FederatedBaseTransform(documentTransform);
                    } else {
                        this.modifyR51BaseTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.modifyR51ClientTransform(documentTransform);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    this.modifyR51ExpressTransform(documentTransform);
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.modifyR51BobcatTransform(documentTransform);
                }
            }
            if (wASReleaseVersion.isR60()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        this.modifyR60DmgrTransform(documentTransform);
                    } else if (profile.isNodeFederated()) {
                        this.modifyR60FederatedNDStandaloneTransform(documentTransform);
                    } else {
                        this.modifyR60NDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        this.modifyR60FederatedBaseTransform(documentTransform);
                    } else {
                        this.modifyR60BaseTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.modifyR60ClientTransform(documentTransform);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    this.modifyR60ExpressTransform(documentTransform);
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.modifyR60BobcatTransform(documentTransform);
                }
            }
        }

        protected void modifyR50BaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50BaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50DmgrTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50DmgrTransform", (Object)documentTransform);
            this.modifyDmgrTransform(documentTransform);
        }

        protected void modifyR50ClientTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50ClientTransform", (Object)documentTransform);
            this.modifyClientTransform(documentTransform);
        }

        protected void modifyR50ExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50ExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50BobcatTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50BobcatTransform", (Object)documentTransform);
            this.modifyBobcatTransform(documentTransform);
        }

        protected void modifyR50NDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50NDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50FederatedNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50FederatedNDStandaloneTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR50FederatedBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50FederatedBaseTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR51BaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51BaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51DmgrTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51DmgrTransform", (Object)documentTransform);
            this.modifyDmgrTransform(documentTransform);
        }

        protected void modifyR51ClientTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51ClientTransform", (Object)documentTransform);
            this.modifyClientTransform(documentTransform);
        }

        protected void modifyR51ExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51ExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51BobcatTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51BobcatTransform", (Object)documentTransform);
            this.modifyBobcatTransform(documentTransform);
        }

        protected void modifyR51NDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51NDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51FederatedNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51FederatedNDStandaloneTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR51FederatedBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51FederatedBaseTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR60BaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60BaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60DmgrTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60DmgrTransform", (Object)documentTransform);
            this.modifyDmgrTransform(documentTransform);
        }

        protected void modifyR60ClientTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60ClientTransform", (Object)documentTransform);
            this.modifyClientTransform(documentTransform);
        }

        protected void modifyR60ExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60ExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60BobcatTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60BobcatTransform", (Object)documentTransform);
            this.modifyBobcatTransform(documentTransform);
        }

        protected void modifyR60NDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60NDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60FederatedNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60FederatedNDStandaloneTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR60FederatedBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60FederatedBaseTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected abstract void modifyFederatedTransform(DocumentTransform var1) throws Exception;

        protected abstract void modifyClientTransform(DocumentTransform var1) throws Exception;

        protected abstract void modifyDmgrTransform(DocumentTransform var1) throws Exception;

        protected abstract void modifyBobcatTransform(DocumentTransform var1) throws Exception;

        protected abstract void modifyApplicationServerTransform(DocumentTransform var1) throws Exception;
    }

    public static abstract class PostUpgradeTransformModifier {
        private boolean _autoTraverse;

        public PostUpgradeTransformModifier(boolean bl) {
            Tr.entry((TraceComponent)_tc, (String)"PostUpgradeTransformModifier", (Object)new Boolean(bl));
            this._autoTraverse = bl;
        }

        public void modifyTransform(DocumentTransform documentTransform) throws Exception {
            Object object;
            Tr.entry((TraceComponent)_tc, (String)"modifyTransform", (Object)documentTransform);
            WASReleaseVersion wASReleaseVersion = (WASReleaseVersion)documentTransform.getScenario().getOldProductImage().getReleaseVersion();
            WASReleaseVersion wASReleaseVersion2 = (WASReleaseVersion)documentTransform.getScenario().getNewProductImage().getReleaseVersion();
            Profile profile = documentTransform.getScenario().getOldProductImage().getProfile();
            if (wASReleaseVersion.isR50()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        if (this.isNodeTransform(documentTransform)) {
                            object = this.getOldNodeDocumentCollection(documentTransform);
                            if (object.isDeploymentManager()) {
                                this.modifyR50DmgrTransform(documentTransform);
                            } else {
                                this.modifyR5xFederatedNodeInDmgrTransform(documentTransform);
                            }
                        } else {
                            this.modifyR50DmgrTransform(documentTransform);
                        }
                    } else if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.modifyR50FederatedNDStandaloneToBaseTransform(documentTransform);
                        } else {
                            this.modifyR50FederatedNDStandaloneToNDStandaloneTransform(documentTransform);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.modifyR50NDStandaloneToBaseTransform(documentTransform);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.modifyR50NDStandaloneToExpressTransform(documentTransform);
                    } else {
                        this.modifyR50NDStandaloneToNDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.modifyR50FederatedBaseToBaseTransform(documentTransform);
                        } else {
                            this.modifyR50FederatedBaseToNDStandaloneTransform(documentTransform);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.modifyR50BaseToBaseTransform(documentTransform);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.modifyR50BaseToExpressTransform(documentTransform);
                    } else {
                        this.modifyR50BaseToNDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.modifyR50ClientTransform(documentTransform);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.modifyR50ExpressToBaseTransform(documentTransform);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.modifyR50ExpressToExpressTransform(documentTransform);
                    } else {
                        this.modifyR50ExpressToNDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.modifyR50BobcatTransform(documentTransform);
                }
            }
            if (wASReleaseVersion.isR51()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        if (this.isNodeTransform(documentTransform)) {
                            object = this.getOldNodeDocumentCollection(documentTransform);
                            if (object.isDeploymentManager()) {
                                this.modifyR51DmgrTransform(documentTransform);
                            } else {
                                this.modifyR5xFederatedNodeInDmgrTransform(documentTransform);
                            }
                        } else {
                            this.modifyR51DmgrTransform(documentTransform);
                        }
                    } else if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.modifyR51FederatedNDStandaloneToBaseTransform(documentTransform);
                        } else {
                            this.modifyR51FederatedNDStandaloneToNDStandaloneTransform(documentTransform);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.modifyR51NDStandaloneToBaseTransform(documentTransform);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.modifyR51NDStandaloneToExpressTransform(documentTransform);
                    } else {
                        this.modifyR51NDStandaloneToNDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.modifyR51FederatedBaseToBaseTransform(documentTransform);
                        } else {
                            this.modifyR51FederatedBaseToNDStandaloneTransform(documentTransform);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.modifyR51BaseToBaseTransform(documentTransform);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.modifyR51BaseToExpressTransform(documentTransform);
                    } else {
                        this.modifyR51BaseToNDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.modifyR51ClientTransform(documentTransform);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.modifyR51ExpressToBaseTransform(documentTransform);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.modifyR51ExpressToExpressTransform(documentTransform);
                    } else {
                        this.modifyR51ExpressToNDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.modifyR51BobcatTransform(documentTransform);
                }
            }
            if (wASReleaseVersion.isR60()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        if (this.isNodeTransform(documentTransform)) {
                            object = this.getOldNodeDocumentCollection(documentTransform);
                            if (object.isDeploymentManager()) {
                                this.modifyR60DmgrTransform(documentTransform);
                            } else {
                                NodeDocumentCollection.WASRelease wASRelease = (NodeDocumentCollection.WASRelease)object.getRelease();
                                if (wASRelease.isR5x()) {
                                    this.modifyR5xFederatedNodeInDmgrTransform(documentTransform);
                                } else {
                                    this.modifyR60FederatedNodeInDmgrTransform(documentTransform);
                                }
                            }
                        } else {
                            this.modifyR60DmgrTransform(documentTransform);
                        }
                    } else if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.modifyR60FederatedNDStandaloneToBaseTransform(documentTransform);
                        } else {
                            this.modifyR60FederatedNDStandaloneToNDStandaloneTransform(documentTransform);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.modifyR60NDStandaloneToBaseTransform(documentTransform);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.modifyR60NDStandaloneToExpressTransform(documentTransform);
                    } else {
                        this.modifyR60NDStandaloneToNDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.modifyR60FederatedBaseToBaseTransform(documentTransform);
                        } else {
                            this.modifyR60FederatedBaseToNDStandaloneTransform(documentTransform);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.modifyR60BaseToBaseTransform(documentTransform);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.modifyR60BaseToExpressTransform(documentTransform);
                    } else {
                        this.modifyR60BaseToNDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.modifyR60ClientTransform(documentTransform);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.modifyR60ExpressToBaseTransform(documentTransform);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.modifyR60ExpressToExpressTransform(documentTransform);
                    } else {
                        this.modifyR60ExpressToNDStandaloneTransform(documentTransform);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.modifyR60BobcatTransform(documentTransform);
                }
            }
            if (this._autoTraverse) {
                object = documentTransform.getChildren();
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    this.modifyTransform((DocumentTransform)((Vector)object).elementAt(i));
                }
            }
        }

        protected void modifyR50BaseToExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50BaseToExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50BaseToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50BaseToBaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50BaseToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50BaseToNDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50FederatedBaseToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50FederatedBaseToBaseTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR50FederatedBaseToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50FederatedBaseToNDStandaloneTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR50DmgrTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50DmgrTransform", (Object)documentTransform);
            this.modifyDmgrTransform(documentTransform);
        }

        protected void modifyR50ClientTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50ClientTransform", (Object)documentTransform);
            this.modifyClientTransform(documentTransform);
        }

        protected void modifyR50ExpressToExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50ExpressToExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50ExpressToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50ExpressToBaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50ExpressToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50ExpressToNDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50BobcatTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50BobcatTransform", (Object)documentTransform);
            this.modifyBobcatTransform(documentTransform);
        }

        protected void modifyR50NDStandaloneToExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50NDStandaloneToExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50NDStandaloneToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50NDStandaloneToBaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50NDStandaloneToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50NDStandaloneToNDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR50FederatedNDStandaloneToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50FederatedNDStandaloneToBaseTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR50FederatedNDStandaloneToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR50FederatedNDStandaloneToNDStandaloneTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR51BaseToExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51BaseToExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51BaseToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51BaseToBaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51BaseToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51BaseToNDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51FederatedBaseToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51FederatedBaseToBaseTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR51FederatedBaseToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51FederatedBaseToNDStandaloneTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR51DmgrTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51DmgrTransform", (Object)documentTransform);
            this.modifyDmgrTransform(documentTransform);
        }

        protected void modifyR51ClientTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51ClientTransform", (Object)documentTransform);
            this.modifyClientTransform(documentTransform);
        }

        protected void modifyR51ExpressToExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51ExpressToExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51ExpressToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51ExpressToBaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51ExpressToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51ExpressToNDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51BobcatTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51BobcatTransform", (Object)documentTransform);
            this.modifyBobcatTransform(documentTransform);
        }

        protected void modifyR51NDStandaloneToExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51NDStandaloneToExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51NDStandaloneToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51NDStandaloneToBaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51NDStandaloneToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51NDStandaloneToNDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR51FederatedNDStandaloneToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51FederatedNDStandaloneToBaseTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR51FederatedNDStandaloneToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR51FederatedNDStandaloneToNDStandaloneTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR5xFederatedNodeInDmgrTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR5xFederatedNodeInDmgrTransform", (Object)documentTransform);
            this.modifyFederatedNodeInDmgrTransform(documentTransform);
        }

        protected void modifyR60BaseToExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60BaseToExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60BaseToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60BaseToBaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60BaseToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60BaseToNDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60FederatedBaseToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60FederatedBaseToBaseTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR60FederatedBaseToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60FederatedBaseToNDStandaloneTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR60DmgrTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60DmgrTransform", (Object)documentTransform);
            this.modifyDmgrTransform(documentTransform);
        }

        protected void modifyR60ClientTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60ClientTransform", (Object)documentTransform);
            this.modifyClientTransform(documentTransform);
        }

        protected void modifyR60ExpressToExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60ExpressToExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60ExpressToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60ExpressToBaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60ExpressToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60ExpressToNDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60BobcatTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60BobcatTransform", (Object)documentTransform);
            this.modifyBobcatTransform(documentTransform);
        }

        protected void modifyR60NDStandaloneToExpressTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60NDStandaloneToExpressTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60NDStandaloneToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60NDStandaloneToBaseTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60NDStandaloneToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60NDStandaloneToNDStandaloneTransform", (Object)documentTransform);
            this.modifyApplicationServerTransform(documentTransform);
        }

        protected void modifyR60FederatedNDStandaloneToBaseTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60FederatedNDStandaloneToBaseTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR60FederatedNDStandaloneToNDStandaloneTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60FederatedNDStandaloneToNDStandaloneTransform", (Object)documentTransform);
            this.modifyFederatedTransform(documentTransform);
        }

        protected void modifyR60FederatedNodeInDmgrTransform(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"modifyR60FederatedNodeInDmgrTransform", (Object)documentTransform);
            this.modifyFederatedNodeInDmgrTransform(documentTransform);
        }

        protected abstract void modifyFederatedTransform(DocumentTransform var1) throws Exception;

        protected abstract void modifyClientTransform(DocumentTransform var1) throws Exception;

        protected abstract void modifyDmgrTransform(DocumentTransform var1) throws Exception;

        protected abstract void modifyBobcatTransform(DocumentTransform var1) throws Exception;

        protected abstract void modifyApplicationServerTransform(DocumentTransform var1) throws Exception;

        protected abstract void modifyFederatedNodeInDmgrTransform(DocumentTransform var1) throws Exception;

        private boolean isNodeTransform(DocumentTransform documentTransform) throws Exception {
            return this.getOldNodeDocumentCollection(documentTransform) != null;
        }

        private NodeDocumentCollection getOldNodeDocumentCollection(DocumentTransform documentTransform) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"getOldNodeDocumentCollection", (Object)documentTransform);
            NodeDocumentCollection nodeDocumentCollection = null;
            for (DocumentCollection documentCollection = documentTransform.getOldDocumentCollection(); documentCollection != null; documentCollection = documentCollection.getParent()) {
                if (!(documentCollection instanceof NodeDocumentCollection)) continue;
                nodeDocumentCollection = (NodeDocumentCollection)documentCollection;
                break;
            }
            return nodeDocumentCollection;
        }
    }

    public static abstract class PreUpgradeTransformProvider {
        public PreUpgradeTransformProvider() {
            Tr.entry((TraceComponent)_tc, (String)"PreUpgradeTransformProvider");
        }

        public void provideTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideTransforms", (Object)new Object[]{vector, scenario});
            WASReleaseVersion wASReleaseVersion = (WASReleaseVersion)scenario.getOldProductImage().getReleaseVersion();
            Profile profile = scenario.getOldProductImage().getProfile();
            if (wASReleaseVersion.isR50()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        this.provideR50DmgrTransforms(vector, scenario);
                    } else if (profile.isNodeFederated()) {
                        this.provideR50FederatedNDStandaloneTransforms(vector, scenario);
                    } else {
                        this.provideR50NDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        this.provideR50FederatedBaseTransforms(vector, scenario);
                    } else {
                        this.provideR50BaseTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.provideR50ClientTransforms(vector, scenario);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    this.provideR50ExpressTransforms(vector, scenario);
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.provideR50BobcatTransforms(vector, scenario);
                }
            }
            if (wASReleaseVersion.isR51()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        this.provideR51DmgrTransforms(vector, scenario);
                    } else if (profile.isNodeFederated()) {
                        this.provideR51FederatedNDStandaloneTransforms(vector, scenario);
                    } else {
                        this.provideR51NDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        this.provideR51FederatedBaseTransforms(vector, scenario);
                    } else {
                        this.provideR51BaseTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.provideR51ClientTransforms(vector, scenario);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    this.provideR51ExpressTransforms(vector, scenario);
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.provideR51BobcatTransforms(vector, scenario);
                }
            }
            if (wASReleaseVersion.isR60()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        this.provideR60DmgrTransforms(vector, scenario);
                    } else if (profile.isNodeFederated()) {
                        this.provideR60FederatedNDStandaloneTransforms(vector, scenario);
                    } else {
                        this.provideR60NDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        this.provideR60FederatedBaseTransforms(vector, scenario);
                    } else {
                        this.provideR60BaseTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.provideR60ClientTransforms(vector, scenario);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    this.provideR60ExpressTransforms(vector, scenario);
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.provideR60BobcatTransforms(vector, scenario);
                }
            }
        }

        protected void provideR50BaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50BaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50DmgrTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50DmgrTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultDmgrTransforms(vector, scenario);
        }

        protected void provideR50ClientTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50ClientTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultClientTransforms(vector, scenario);
        }

        protected void provideR50ExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50ExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50BobcatTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50BobcatTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultBobcatTransforms(vector, scenario);
        }

        protected void provideR50NDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50NDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50FederatedNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50FederatedNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR50FederatedBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50FederatedBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR51BaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51BaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51DmgrTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51DmgrTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultDmgrTransforms(vector, scenario);
        }

        protected void provideR51ClientTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51ClientTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultClientTransforms(vector, scenario);
        }

        protected void provideR51ExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51ExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51BobcatTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51BobcatTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultBobcatTransforms(vector, scenario);
        }

        protected void provideR51NDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51NDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51FederatedNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51FederatedNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR51FederatedBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51FederatedBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR60BaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60BaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60DmgrTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60DmgrTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultDmgrTransforms(vector, scenario);
        }

        protected void provideR60ClientTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60ClientTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultClientTransforms(vector, scenario);
        }

        protected void provideR60ExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60ExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60BobcatTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60BobcatTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultBobcatTransforms(vector, scenario);
        }

        protected void provideR60NDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60NDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60FederatedNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60FederatedNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR60FederatedBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60FederatedBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected abstract void provideDefaultFederatedTransforms(Vector var1, Scenario var2) throws Exception;

        protected abstract void provideDefaultClientTransforms(Vector var1, Scenario var2) throws Exception;

        protected abstract void provideDefaultDmgrTransforms(Vector var1, Scenario var2) throws Exception;

        protected abstract void provideDefaultBobcatTransforms(Vector var1, Scenario var2) throws Exception;

        protected abstract void provideDefaultApplicationServerTransforms(Vector var1, Scenario var2) throws Exception;
    }

    public static abstract class PostUpgradeTransformProvider {
        public PostUpgradeTransformProvider() {
            Tr.entry((TraceComponent)_tc, (String)"PostUpgradeTransformProvider");
        }

        public void provideTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideTransforms", (Object)new Object[]{vector, scenario});
            WASReleaseVersion wASReleaseVersion = (WASReleaseVersion)scenario.getOldProductImage().getReleaseVersion();
            WASReleaseVersion wASReleaseVersion2 = (WASReleaseVersion)scenario.getNewProductImage().getReleaseVersion();
            Profile profile = scenario.getOldProductImage().getProfile();
            if (wASReleaseVersion.isR50()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        this.provideR50DmgrTransforms(vector, scenario);
                    } else if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.provideR50FederatedNDStandaloneToBaseTransforms(vector, scenario);
                        } else {
                            this.provideR50FederatedNDStandaloneToNDStandaloneTransforms(vector, scenario);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.provideR50NDStandaloneToBaseTransforms(vector, scenario);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.provideR50NDStandaloneToExpressTransforms(vector, scenario);
                    } else {
                        this.provideR50NDStandaloneToNDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.provideR50FederatedBaseToBaseTransforms(vector, scenario);
                        } else {
                            this.provideR50FederatedBaseToNDStandaloneTransforms(vector, scenario);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.provideR50BaseToBaseTransforms(vector, scenario);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.provideR50BaseToExpressTransforms(vector, scenario);
                    } else {
                        this.provideR50BaseToNDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.provideR50ClientTransforms(vector, scenario);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.provideR50ExpressToBaseTransforms(vector, scenario);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.provideR50ExpressToExpressTransforms(vector, scenario);
                    } else {
                        this.provideR50ExpressToNDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.provideR50BobcatTransforms(vector, scenario);
                }
            }
            if (wASReleaseVersion.isR51()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        this.provideR51DmgrTransforms(vector, scenario);
                    } else if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.provideR51FederatedNDStandaloneToBaseTransforms(vector, scenario);
                        } else {
                            this.provideR51FederatedNDStandaloneToNDStandaloneTransforms(vector, scenario);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.provideR51NDStandaloneToBaseTransforms(vector, scenario);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.provideR51NDStandaloneToExpressTransforms(vector, scenario);
                    } else {
                        this.provideR51NDStandaloneToNDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.provideR51FederatedBaseToBaseTransforms(vector, scenario);
                        } else {
                            this.provideR51FederatedBaseToNDStandaloneTransforms(vector, scenario);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.provideR51BaseToBaseTransforms(vector, scenario);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.provideR51BaseToExpressTransforms(vector, scenario);
                    } else {
                        this.provideR51BaseToNDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.provideR51ClientTransforms(vector, scenario);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.provideR51ExpressToBaseTransforms(vector, scenario);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.provideR51ExpressToExpressTransforms(vector, scenario);
                    } else {
                        this.provideR51ExpressToNDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.provideR51BobcatTransforms(vector, scenario);
                }
            }
            if (wASReleaseVersion.isR60()) {
                if (wASReleaseVersion.getVersion().equals("ND")) {
                    if (profile.isDeploymentManager()) {
                        this.provideR60DmgrTransforms(vector, scenario);
                    } else if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.provideR60FederatedNDStandaloneToBaseTransforms(vector, scenario);
                        } else {
                            this.provideR60FederatedNDStandaloneToNDStandaloneTransforms(vector, scenario);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.provideR60NDStandaloneToBaseTransforms(vector, scenario);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.provideR60NDStandaloneToExpressTransforms(vector, scenario);
                    } else {
                        this.provideR60NDStandaloneToNDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("BASE")) {
                    if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.provideR60FederatedBaseToBaseTransforms(vector, scenario);
                        } else {
                            this.provideR60FederatedBaseToNDStandaloneTransforms(vector, scenario);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.provideR60BaseToBaseTransforms(vector, scenario);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.provideR60BaseToExpressTransforms(vector, scenario);
                    } else {
                        this.provideR60BaseToNDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("CLIENT")) {
                    this.provideR60ClientTransforms(vector, scenario);
                }
                if (wASReleaseVersion.getVersion().equals("EXPRESS")) {
                    if (profile.isNodeFederated()) {
                        if (wASReleaseVersion2.getVersion().equals("BASE")) {
                            this.provideR60FederatedBaseToBaseTransforms(vector, scenario);
                        } else {
                            this.provideR60FederatedBaseToNDStandaloneTransforms(vector, scenario);
                        }
                    } else if (wASReleaseVersion2.getVersion().equals("BASE")) {
                        this.provideR60ExpressToBaseTransforms(vector, scenario);
                    } else if (wASReleaseVersion2.getVersion().equals("EXPRESS")) {
                        this.provideR60ExpressToExpressTransforms(vector, scenario);
                    } else {
                        this.provideR60ExpressToNDStandaloneTransforms(vector, scenario);
                    }
                }
                if (wASReleaseVersion.getVersion().equals("embeddedEXPRESS")) {
                    this.provideR60BobcatTransforms(vector, scenario);
                }
            }
        }

        protected void provideR50BaseToExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50BaseToExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50BaseToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50BaseToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50BaseToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50BaseToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50FederatedBaseToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50FederatedBaseToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR50FederatedBaseToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50FederatedBaseToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR50DmgrTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50DmgrTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultDmgrTransforms(vector, scenario);
        }

        protected void provideR50ClientTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50ClientTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultClientTransforms(vector, scenario);
        }

        protected void provideR50ExpressToExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50ExpressToExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50ExpressToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50ExpressToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50ExpressToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50ExpressToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50BobcatTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50BobcatTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultBobcatTransforms(vector, scenario);
        }

        protected void provideR50NDStandaloneToExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50NDStandaloneToExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50NDStandaloneToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50NDStandaloneToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50NDStandaloneToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50NDStandaloneToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR50FederatedNDStandaloneToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50FederatedNDStandaloneToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR50FederatedNDStandaloneToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR50FederatedNDStandaloneToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR51BaseToExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51BaseToExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51BaseToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51BaseToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51BaseToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51BaseToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51FederatedBaseToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51FederatedBaseToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR51FederatedBaseToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51FederatedBaseToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR51DmgrTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51DmgrTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultDmgrTransforms(vector, scenario);
        }

        protected void provideR51ClientTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51ClientTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultClientTransforms(vector, scenario);
        }

        protected void provideR51ExpressToExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51ExpressToExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51ExpressToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51ExpressToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51ExpressToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51ExpressToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51BobcatTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51BobcatTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultBobcatTransforms(vector, scenario);
        }

        protected void provideR51NDStandaloneToExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51NDStandaloneToExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51NDStandaloneToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51NDStandaloneToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51NDStandaloneToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51NDStandaloneToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR51FederatedNDStandaloneToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51FederatedNDStandaloneToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR51FederatedNDStandaloneToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR51FederatedNDStandaloneToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR60BaseToExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60BaseToExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60BaseToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60BaseToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60BaseToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60BaseToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60FederatedBaseToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60FederatedBaseToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR60FederatedBaseToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60FederatedBaseToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR60DmgrTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60DmgrTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultDmgrTransforms(vector, scenario);
        }

        protected void provideR60ClientTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60ClientTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultClientTransforms(vector, scenario);
        }

        protected void provideR60ExpressToExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60ExpressToExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60ExpressToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60ExpressToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60ExpressToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60ExpressToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60BobcatTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60BobcatTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultBobcatTransforms(vector, scenario);
        }

        protected void provideR60NDStandaloneToExpressTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60NDStandaloneToExpressTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60NDStandaloneToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60NDStandaloneToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60NDStandaloneToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60NDStandaloneToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultApplicationServerTransforms(vector, scenario);
        }

        protected void provideR60FederatedNDStandaloneToBaseTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60FederatedNDStandaloneToBaseTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected void provideR60FederatedNDStandaloneToNDStandaloneTransforms(Vector vector, Scenario scenario) throws Exception {
            Tr.entry((TraceComponent)_tc, (String)"provideR60FederatedNDStandaloneToNDStandaloneTransforms", (Object)new Object[]{vector, scenario});
            this.provideDefaultFederatedTransforms(vector, scenario);
        }

        protected abstract void provideDefaultFederatedTransforms(Vector var1, Scenario var2) throws Exception;

        protected abstract void provideDefaultClientTransforms(Vector var1, Scenario var2) throws Exception;

        protected abstract void provideDefaultDmgrTransforms(Vector var1, Scenario var2) throws Exception;

        protected abstract void provideDefaultBobcatTransforms(Vector var1, Scenario var2) throws Exception;

        protected abstract void provideDefaultApplicationServerTransforms(Vector var1, Scenario var2) throws Exception;
    }
}

