/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.util;

import com.ibm.ws.jsf.JSFConstants;
import com.ibm.ws.jsf.configuration.FacesConfigParser;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.servlet.ServletContext;

public class FacesConfigUtil {
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.util.FacesConfigUtil";
    private static final Object lock = new Object();
    private static FacesConfigParser serverConfigParser = null;
    private static String[] factoryNames = new String[]{"javax.faces.application.ApplicationFactory", "javax.faces.context.FacesContextFactory", "javax.faces.lifecycle.LifecycleFactory", "javax.faces.render.RenderKitFactory"};

    public static void createDefaultJSFFactories() {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createDefaultJSFFactories", "Creating default JSF factories");
        }
        String string = "com.sun.faces.application.ApplicationFactoryImpl";
        FactoryFinder.setFactory("javax.faces.application.ApplicationFactory", string);
        String string2 = "com.sun.faces.context.FacesContextFactoryImpl";
        FactoryFinder.setFactory("javax.faces.context.FacesContextFactory", string2);
        String string3 = "com.sun.faces.lifecycle.LifecycleFactoryImpl";
        FactoryFinder.setFactory("javax.faces.lifecycle.LifecycleFactory", string3);
        String string4 = "com.sun.faces.renderkit.RenderKitFactoryImpl";
        FactoryFinder.setFactory("javax.faces.render.RenderKitFactory", string4);
    }

    public static void parseJSFConfiguration(ServletContext servletContext) {
        if (System.getSecurityManager() != null) {
            final ServletContext servletContext2 = servletContext;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    FacesConfigUtil._parseJSFConfiguration(servletContext2);
                    return null;
                }
            });
        } else {
            FacesConfigUtil._parseJSFConfiguration(servletContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _parseJSFConfiguration(ServletContext servletContext) throws FacesException {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "_parseJSFConfiguration", "Request for JSF configuration for webmodule [" + servletContext.getServletContextName() + "]. Loading JSF configuration.");
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "_parseJSFConfiguration", "Parsing server configuration for webmodule [" + servletContext.getServletContextName() + "]");
        }
        FacesConfigParser facesConfigParser = null;
        if (log.isLoggable(Level.FINEST)) {
            log.logp(Level.FINEST, CLASS_NAME, "_parseJSFConfiguration", "Entering synch block for obtaining server configuration");
        }
        Object object = lock;
        synchronized (object) {
            if (log.isLoggable(Level.FINEST)) {
                log.logp(Level.FINEST, CLASS_NAME, "_parseJSFConfiguration", "Inside synch block for obtaining server configuration");
            }
            FacesConfigParser facesConfigParser2 = FacesConfigUtil.parseJSFServerConfig();
            try {
                facesConfigParser = (FacesConfigParser)facesConfigParser2.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                String string = servletContext.getServletContextName();
                String string2 = "Failed to clone FacesConfigParser object for webmodule [" + string + "]";
                if (log.isLoggable(Level.SEVERE)) {
                    log.logp(Level.SEVERE, CLASS_NAME, "_parseJSFConfiguration", string2, cloneNotSupportedException);
                }
                throw new FacesException(string2, cloneNotSupportedException);
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.logp(Level.FINEST, CLASS_NAME, "_parseJSFConfiguration", "Exited synch block for obtaining server configuration");
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "_parseJSFConfiguration", "Parsing application configuration for webmodule [" + servletContext.getServletContextName() + "]");
        }
        facesConfigParser.recreateParser(servletContext);
        FacesConfigUtil.parseJSFApplicationConfig(facesConfigParser, servletContext);
        try {
            facesConfigParser.initializeConfiguration(servletContext);
        }
        catch (FacesException facesException) {
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "_parseJSFConfiguration", "Failed to initialize configuration for webmodule [" + servletContext.getServletContextName() + "]", facesException);
            }
            throw facesException;
        }
        facesConfigParser = null;
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "_parseJSFConfiguration", "Verifying factories for webmodule [" + servletContext.getServletContextName() + "]");
        }
        FacesConfigUtil.verifyFactories();
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "_parseJSFConfiguration", "Completed processing configuration for webmodule [" + servletContext.getServletContextName() + "]");
        }
    }

    private static void verifyFactories() throws FacesException {
        int n = factoryNames.length;
        for (int i = 0; i < n; ++i) {
            try {
                FactoryFinder.getFactory(factoryNames[i]);
                continue;
            }
            catch (Exception exception) {
                throw new FacesException(exception);
            }
        }
    }

    private static void parseJSFApplicationConfig(FacesConfigParser facesConfigParser, ServletContext servletContext) {
        Iterator iterator;
        Object object;
        Object object2;
        URL uRL = null;
        try {
            object2 = new LinkedList<URL>();
            object = Util.getCurrentLoader(FacesConfigUtil.class).getResources("META-INF/faces-config.xml");
            while (object.hasMoreElements()) {
                object2.add(0, object.nextElement());
            }
            iterator = object2.iterator();
        }
        catch (IOException iOException) {
            String string = null;
            try {
                string = Util.getExceptionMessageString("com.sun.faces.CANT_PARSE_FILE", new Object[]{"/META-INF/faces-config.xml"});
            }
            catch (Exception exception) {
                string = "Can't parse configuration file:/META-INF/faces-config.xml";
            }
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "parseJSFApplicationConfig", string, iOException);
            }
            throw new FacesException(string, iOException);
        }
        while (iterator.hasNext()) {
            uRL = (URL)iterator.next();
            try {
                facesConfigParser.parse(uRL);
            }
            catch (Exception exception) {
                object = null;
                try {
                    object = Util.getExceptionMessageString("com.sun.faces.CANT_PARSE_FILE", new Object[]{uRL.toExternalForm()});
                }
                catch (Exception exception2) {
                    object = "Can't parse configuration file:" + uRL.toExternalForm();
                }
                if (log.isLoggable(Level.SEVERE)) {
                    log.logp(Level.SEVERE, CLASS_NAME, "parseJSFApplicationConfig", (String)object, exception);
                }
                throw new FacesException((String)object, exception);
            }
        }
        object2 = servletContext.getInitParameter("javax.faces.CONFIG_FILES");
        if (object2 != null) {
            object2 = ((String)object2).trim();
            while (((String)object2).length() > 0) {
                int n = ((String)object2).indexOf(",");
                if (n >= 0) {
                    object = ((String)object2).substring(0, n).trim();
                    object2 = ((String)object2).substring(n + 1).trim();
                } else {
                    object = ((String)object2).trim();
                    object2 = "";
                }
                if (((String)object).length() < 1) break;
                try {
                    uRL = servletContext.getResource((String)object);
                    facesConfigParser.parse(uRL);
                }
                catch (Exception exception) {
                    String string = null;
                    try {
                        string = Util.getExceptionMessageString("com.sun.faces.CANT_PARSE_FILE", new Object[]{object});
                    }
                    catch (Exception exception3) {
                        string = "Can't parse configuration file:" + (String)object;
                    }
                    if (log.isLoggable(Level.SEVERE)) {
                        log.logp(Level.SEVERE, CLASS_NAME, "parseJSFApplicationConfig", string, exception);
                    }
                    throw new FacesException(string, exception);
                }
            }
        }
        try {
            uRL = servletContext.getResource("/WEB-INF/faces-config.xml");
            if (uRL != null) {
                facesConfigParser.parse(uRL);
            }
        }
        catch (Exception exception) {
            String string = null;
            try {
                string = Util.getExceptionMessageString("com.sun.faces.CANT_PARSE_FILE", new Object[]{uRL.toExternalForm()});
            }
            catch (Exception exception4) {
                string = "Can't parse configuration file:" + uRL.toExternalForm();
            }
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "parseJSFApplicationConfig", string, exception);
            }
            throw new FacesException(string, exception);
        }
    }

    private static FacesConfigParser parseJSFServerConfig() {
        if (serverConfigParser != null) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "parseJSFServerConfig", "Already parsed JSF server configuration return current instance of configuration");
            }
            return serverConfigParser;
        }
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "parseJSFServerConfig", "Start parsing of global config");
        }
        long l = System.currentTimeMillis();
        serverConfigParser = FacesConfigUtil.readSerializedConfig();
        Util.doAssert(null != serverConfigParser);
        long l2 = System.currentTimeMillis();
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "parseJSFServerConfig", "End parsing of global config:  parse time =[" + (l2 - l) + "]");
        }
        return serverConfigParser;
    }

    private static FacesConfigParser readSerializedConfig() {
        try {
            URL uRL = Util.getCurrentLoader(FacesConfigUtil.class).getResource(JSFConstants.SERIALIZED_CONFIG);
            InputStream inputStream = uRL.openStream();
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            return (FacesConfigParser)objectInputStream.readObject();
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.SEVERE)) {
                log.logp(Level.SEVERE, CLASS_NAME, "readSerializedConfig", "Failed to read serialized FacesConfigParser object", exception);
            }
            return null;
        }
    }
}

