/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.util;

import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.configuration.JspConfigPropertyGroup;
import com.ibm.ws.jsp.runtime.metadata.JspComponentMetaData;
import com.ibm.ws.util.URIMatcher;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspURIMatcher
extends URIMatcher {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.util.JspURIMatcher";
    private Map sortedMap = new TreeMap();

    public JspURIMatcher(IServletContext iServletContext) {
        this.addImplicitJspMappings();
        this.addJspFileExtensions(iServletContext);
        this.addPropertyGroupExtensions(iServletContext);
        this.addJspMappedServlets(iServletContext);
    }

    private void addImplicitJspMappings() {
        for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
            String string = Constants.STANDARD_JSP_EXTENSIONS[i];
            this.put(string, "implicitJspExtensions");
        }
    }

    private void addJspFileExtensions(IServletContext iServletContext) {
        WebAppConfig webAppConfig = iServletContext.getWebAppConfig();
        Map map = webAppConfig.getJspAttributes();
        String string = (String)map.get("jsp.file.extensions");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ": ;");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                this.put(string2, "jsp.file.extension");
            }
        }
    }

    private void addPropertyGroupExtensions(IServletContext iServletContext) {
        WebAppConfig webAppConfig = iServletContext.getWebAppConfig();
        JspComponentMetaData jspComponentMetaData = (JspComponentMetaData)webAppConfig.getMetaData().getJspComponentMetadata();
        List list = jspComponentMetaData.getJspPropertyGroups();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JspConfigPropertyGroup jspConfigPropertyGroup = (JspConfigPropertyGroup)iterator.next();
            Iterator iterator2 = jspConfigPropertyGroup.getUrlPatterns().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                this.put(string, "jspPropertyGroupURI");
            }
        }
    }

    private void addJspMappedServlets(IServletContext iServletContext) {
        WebAppConfig webAppConfig = iServletContext.getWebAppConfig();
        Iterator iterator = webAppConfig.getServletInfos();
        while (iterator.hasNext()) {
            List list;
            ServletConfig servletConfig = (ServletConfig)iterator.next();
            if (!servletConfig.isJsp() || (list = servletConfig.getMappings()) == null || list.isEmpty()) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                ServletMapping servletMapping = (ServletMapping)iterator2.next();
                String string = servletMapping.getUrlPattern();
                this.put(string, "jspMappedServlets");
            }
        }
    }

    public void put(String string, Object object) {
        block3: {
            try {
                super.put(string, object);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "put", "adding [" + string + "] target =[" + object + "]");
                }
                this.sortedMap.put(string, object);
            }
            catch (Exception exception) {
                if (!log.isLoggable(Level.FINEST)) break block3;
                log.logp(Level.FINEST, CLASS_NAME, "put", "problem occured when adding new target [" + string + "] target =[" + object + "]", exception);
            }
        }
    }

    public String toString() {
        return this.sortedMap.toString();
    }
}

