/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.configuration;

import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspConfiguration {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.configuration.JspConfiguration";
    protected boolean isXml = false;
    protected boolean isXmlSpecified = false;
    protected boolean elIgnored = true;
    protected boolean scriptingInvalid = false;
    protected String pageEncoding = null;
    protected ArrayList preludeList = new ArrayList();
    protected ArrayList codaList = new ArrayList();
    protected JspConfigurationManager configManager = null;

    protected JspConfiguration(JspConfigurationManager jspConfigurationManager) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "JspConfiguration", "default values isXml = [{0}] isXmlSpecified = [{1}] elIgnored = [{2}] scriptingInvalid = [{3}] pageEncoding = [{4}]", new Object[]{new Boolean(this.isXml), new Boolean(this.isXmlSpecified), new Boolean(this.elIgnored), new Boolean(this.scriptingInvalid), this.pageEncoding});
        }
        this.configManager = jspConfigurationManager;
    }

    protected JspConfiguration(JspConfigurationManager jspConfigurationManager, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "JspConfiguration", "isXml = [{0}] isXmlSpecified = [{1}] elIgnored = [{2}] scriptingInvalid = [{3}] pageEncoding = [{4}]", new Object[]{new Boolean(bl), new Boolean(bl2), new Boolean(bl3), new Boolean(bl4), this.pageEncoding});
        }
        this.isXml = bl;
        this.isXmlSpecified = bl2;
        this.elIgnored = bl3;
        this.scriptingInvalid = bl4;
        this.configManager = jspConfigurationManager;
    }

    public JspConfiguration createEmptyJspConfiguration() {
        return this.configManager.createJspConfiguration();
    }

    public void addIncludePrelude(String string) {
        this.preludeList.add(string);
    }

    public void addIncludeCoda(String string) {
        this.codaList.add(string);
    }

    public boolean isXml() {
        return this.isXml;
    }

    public boolean elIgnored() {
        return this.elIgnored;
    }

    public boolean scriptingInvalid() {
        return this.scriptingInvalid;
    }

    public String getPageEncoding() {
        return this.pageEncoding;
    }

    public ArrayList getPreludeList() {
        return this.preludeList;
    }

    public ArrayList getCodaList() {
        return this.codaList;
    }

    public void setElIgnored(boolean bl) {
        this.elIgnored = bl;
    }

    public void setIsXml(boolean bl) {
        this.isXml = bl;
        this.isXmlSpecified = true;
    }

    public void setPageEncoding(String string) {
        if (string != null) {
            this.pageEncoding = EncodingUtils.getJvmConverter(string);
            if (logger.isLoggable(Level.FINER) && !this.pageEncoding.equalsIgnoreCase(string)) {
                logger.logp(Level.FINER, CLASS_NAME, "setPageEncoding", "specified pageEncoding [{0}] was converted to [{1}] by WebSphere JVM converter", new Object[]{string, this.pageEncoding});
            }
        } else {
            this.pageEncoding = null;
        }
    }

    public void setScriptingInvalid(boolean bl) {
        this.scriptingInvalid = bl;
    }

    public boolean isXmlSpecified() {
        return this.isXmlSpecified;
    }

    public JspConfigurationManager getConfigManager() {
        return this.configManager;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return new String("" + string + "isXml =                       [" + this.isXml + "]" + string + "isXmlSpecified =              [" + this.isXmlSpecified + "]" + string + "elIgnored =                   [" + this.elIgnored + "]" + string + "scriptingInvalid              [" + this.scriptingInvalid + "]" + string + "pageEncoding                  [" + this.pageEncoding + "]" + string + "preludeList                   [" + this.preludeList + "]" + string + "codaList                      [" + this.codaList + "]" + string);
    }
}

