/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.configuration;

import com.ibm.ws.jsp.Constants;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfigProperty;
import com.ibm.ws.jsp.configuration.JspConfigPropertyGroup;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.configuration.StaticIncludeJspConfiguration;
import com.ibm.ws.util.URIMatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspConfigurationManager {
    protected boolean isServlet24 = false;
    protected URIMatcher uriMatcher = null;
    protected List jspExtensionList = new ArrayList();
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.configuration.JspConfigurationManager";

    public JspConfigurationManager(List list, boolean bl, List list2) throws JspCoreException {
        Object object;
        this.isServlet24 = bl;
        this.uriMatcher = new URIMatcher();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (JspConfigPropertyGroup)iterator.next();
            Iterator iterator2 = ((JspConfigPropertyGroup)object).getUrlPatterns().iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                if (!arrayList.contains(string)) {
                    arrayList.add(string);
                    try {
                        this.uriMatcher.put(string, object);
                    }
                    catch (Exception exception) {
                        logger.logp(Level.WARNING, CLASS_NAME, "JspConfigurationManager", "Failed to add url pattern [" + string + "] to match list.", exception);
                    }
                } else {
                    throw new JspCoreException("jsp.error.dup.url.pattern", new Object[]{string});
                }
                if (this.jspExtensionList.contains(string)) continue;
                boolean bl2 = true;
                for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
                    if (!string.equals(Constants.STANDARD_JSP_EXTENSIONS[i])) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                this.jspExtensionList.add(string);
            }
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!((String)object).startsWith("*.") || this.jspExtensionList.contains(object)) continue;
            boolean bl3 = true;
            for (int i = 0; i < Constants.STANDARD_JSP_EXTENSIONS.length; ++i) {
                if (!((String)object).equals(Constants.STANDARD_JSP_EXTENSIONS[i])) continue;
                bl3 = false;
                break;
            }
            if (!bl3) continue;
            this.jspExtensionList.add(object);
        }
    }

    public synchronized JspConfiguration getConfigurationForUrl(String string) {
        List list = this.uriMatcher.matchAll(string);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForUrl", "begin creation of new JspConfiguration for url = [{0}] uris matched = [{1}]", new Object[]{string, new Integer(list.size())});
        }
        JspConfiguration jspConfiguration = new JspConfiguration(this);
        if (list.size() > 0) {
            if (this.isServlet24) {
                jspConfiguration.setElIgnored(false);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JspConfigPropertyGroup jspConfigPropertyGroup = (JspConfigPropertyGroup)iterator.next();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForUrl", "handling config url pattern(s) " + jspConfigPropertyGroup.getUrlPatterns());
                }
                Iterator iterator2 = jspConfigPropertyGroup.iterator();
                while (iterator2.hasNext()) {
                    JspConfigProperty jspConfigProperty = (JspConfigProperty)iterator2.next();
                    switch (jspConfigProperty.getType()) {
                        case 6: {
                            jspConfiguration.addIncludeCoda((String)jspConfigProperty.getValue());
                            break;
                        }
                        case 2: {
                            jspConfiguration.setElIgnored((Boolean)jspConfigProperty.getValue());
                            break;
                        }
                        case 1: {
                            jspConfiguration.setIsXml((Boolean)jspConfigProperty.getValue());
                            break;
                        }
                        case 4: {
                            jspConfiguration.setPageEncoding((String)jspConfigProperty.getValue());
                            break;
                        }
                        case 5: {
                            jspConfiguration.addIncludePrelude((String)jspConfigProperty.getValue());
                            break;
                        }
                        case 3: {
                            jspConfiguration.setScriptingInvalid((Boolean)jspConfigProperty.getValue());
                        }
                    }
                }
            }
        } else if (this.isServlet24) {
            jspConfiguration.setElIgnored(false);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForUrl", "complete creation of new JspConfiguration for url = [{0}] {1}", new Object[]{string, jspConfiguration.toString()});
        }
        return jspConfiguration;
    }

    public synchronized JspConfiguration getConfigurationForStaticInclude(String string, JspConfiguration jspConfiguration) {
        List list = this.uriMatcher.matchAll(string);
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForStaticInclude", "begin creation of new StaticIncludeJspConfiguration for url = [{0}] uris matched = [{1}] (config inherited from parent)", new Object[]{string, new Integer(list.size())});
        }
        StaticIncludeJspConfiguration staticIncludeJspConfiguration = new StaticIncludeJspConfiguration(jspConfiguration);
        if (list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                JspConfigPropertyGroup jspConfigPropertyGroup = (JspConfigPropertyGroup)iterator.next();
                Iterator iterator2 = jspConfigPropertyGroup.iterator();
                while (iterator2.hasNext()) {
                    JspConfigProperty jspConfigProperty = (JspConfigProperty)iterator2.next();
                    if (jspConfigProperty.getType() != 4) continue;
                    staticIncludeJspConfiguration.setPageEncoding((String)jspConfigProperty.getValue());
                }
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.logp(Level.FINEST, CLASS_NAME, "getConfigurationForStaticInclude", "complete creation of new StaticIncludeJspConfiguration for url = [{0}] {1}", new Object[]{string, staticIncludeJspConfiguration.toString()});
        }
        return staticIncludeJspConfiguration;
    }

    public List getJspExtensionList() {
        return this.jspExtensionList;
    }

    public JspConfiguration createJspConfiguration() {
        return new JspConfiguration(this);
    }
}

