/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.configuration;

import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.runtime.metadata.JspComponentMetaData;
import com.ibm.ws.management.AdminHelper;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JspWebAppConfig
implements JspXmlExtConfig {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.configuration.JspWebAppConfig";
    List jspPropertyGroups = null;
    HashMap tagLibMap = null;
    JspOptions jspOptions = null;
    JspComponentMetaData jspMetadata = null;
    boolean isServlet24 = false;
    List jspFileExtensions = new ArrayList();
    List servletClassNameList = new ArrayList();
    File outputDir = null;

    public JspWebAppConfig(IServletContext iServletContext) {
        Object object;
        WebAppConfig webAppConfig = iServletContext.getWebAppConfig();
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "webGroupCfg =[" + webAppConfig + "]");
        }
        this.populateJspOptions(webAppConfig);
        this.isServlet24 = webAppConfig.isServlet2_4();
        boolean bl = webAppConfig.isAutoResponseEncoding();
        this.jspOptions.setAutoResponseEncoding(bl);
        this.jspMetadata = (JspComponentMetaData)webAppConfig.getMetaData().getJspComponentMetadata();
        this.jspPropertyGroups = this.jspMetadata.getJspPropertyGroups();
        this.tagLibMap = (HashMap)this.jspMetadata.getJspTaglibs();
        this.jspOptions.setLooseLibMap(this.jspMetadata.getLooseLibs());
        this.jspOptions.setServlet2_2(this.jspMetadata.isServlet2_2());
        this.jspOptions.setServletEngineReloadEnabled(this.jspMetadata.isServletEngineReloadEnabled());
        this.jspOptions.setServletEngineReloadInterval(this.jspMetadata.getServletEngineReloadInterval());
        this.jspOptions.setIsZOS(AdminHelper.getPlatformHelper().isZOS());
        this.outputDir = this.jspOptions.isZOS() ? new File(iServletContext.getCommonTempDirectory()) : (File)iServletContext.getAttribute("javax.servlet.context.tempdir");
        if (this.outputDir == null && (object = System.getProperty("java.io.tmpdir")) != null) {
            this.outputDir = new File((String)object);
        }
        if (!this.jspOptions.isReloadEnabledSet()) {
            if (this.jspOptions.isServlet2_2()) {
                this.jspOptions.setReloadEnabled(true);
                this.jspOptions.setReloadInterval(5000L);
                logger.logp(Level.FINE, CLASS_NAME, "JspWebAppConfig", "JSP engine reloadEnabled flag not set for application " + this.jspMetadata.getApplicationDisplayName() + ".  Application is Servlet 2.2; using defaults for reloadEnabled [" + this.jspOptions.isReloadEnabled() + "] and reloadInterval [" + this.jspOptions.getReloadInterval() + "]. " + " TrackDependencies = [" + this.jspOptions.isTrackDependencies() + "], DisableJSPRuntimeCompilation = [" + this.jspOptions.isDisableJspRuntimeCompilation() + "].");
            } else {
                this.jspOptions.setReloadEnabled(this.jspMetadata.isServletEngineReloadEnabled());
                this.jspOptions.setReloadInterval(this.jspMetadata.getServletEngineReloadInterval());
                logger.logp(Level.FINE, CLASS_NAME, "JspWebAppConfig", "JSP engine reloadEnabled flag not set for application " + this.jspMetadata.getApplicationDisplayName() + ".  Using webcontainer's settings for reloadEnabled [" + this.jspOptions.isReloadEnabled() + "] and reloadInterval [" + this.jspOptions.getReloadInterval() + "]. " + " TrackDependencies = [" + this.jspOptions.isTrackDependencies() + "], DisableJSPRuntimeCompilation = [" + this.jspOptions.isDisableJspRuntimeCompilation() + "].");
            }
        } else {
            logger.logp(Level.FINE, CLASS_NAME, "JspWebAppConfig", "JSP engine reload settings for application " + this.jspMetadata.getApplicationDisplayName() + ":  reloadEnabled [" + this.jspOptions.isReloadEnabled() + "], reloadInterval [" + this.jspOptions.getReloadInterval() + "], TrackDependencies = [" + this.jspOptions.isTrackDependencies() + "], DisableJSPRuntimeCompilation = [" + this.jspOptions.isDisableJspRuntimeCompilation() + "].");
        }
        this.jspOptions.setOutputDir(this.outputDir);
        object = webAppConfig.getServletInfos();
        while (object.hasNext()) {
            IServletConfig iServletConfig = (IServletConfig)object.next();
            this.servletClassNameList.add(iServletConfig.getClassName());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "tagLibMap = " + this.tagLibMap);
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "jspOptions = " + this.jspOptions);
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "isServlet24 = " + this.isServlet24);
            logger.logp(Level.FINER, CLASS_NAME, "JspWebAppConfig", "jspPropertyGroups = " + this.jspPropertyGroups);
        }
    }

    private void populateJspOptions(WebAppConfig webAppConfig) {
        Map map = webAppConfig.getJspAttributes();
        Properties properties = new Properties();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "populateJspOptions", "JspWebAppConfig jspoption key = [" + string + "] value =[" + string2 + "]");
            }
            if (string != null && string.equals("jsp.file.extensions")) {
                this.createJspFileExtensionList(string2);
            }
            properties.put(string, string2);
        }
        this.populateDisableJspRuntimeCompilation(properties);
        this.populateUseStringCast(properties);
        this.populateUseRepeatInt(properties);
        this.populateUseScriptVarDupInit(properties);
        this.populateAllowUnmatchedEndTag(properties);
        this.populateUseCDataTrim(properties);
        this.populateJdkSourceLevel(properties);
        this.populateEvalQuotedAndEscapedExpression(properties);
        this.populateConvertExpression(properties);
        this.populateDisableELCache(properties);
        this.populateConvertAttrValueToString(properties);
        this.populateAllowNullParentInTagFile(properties);
        this.populateModifyPageContextVar(properties);
        this.populateDisableTldSearch(properties);
        this.jspOptions = new JspOptions(properties);
    }

    private void populateDisableJspRuntimeCompilation(Properties properties) {
        String string = properties.getProperty("disableJspRuntimeCompilation");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "populateDisableJspRuntimeCompilation", "JspWebAppConfig populateDisableJspRuntimeCompilation value = " + string);
        }
        if (string == null) {
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "populateDisableJspRuntimeCompilation", "JspWebAppConfig populateDisableJspRuntimeCompilation webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("disablejspruntimecompilation");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "populateDisableJspRuntimeCompilation", "JspWebAppConfig populateDisableJspRuntimeCompilation webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("disableJspRuntimeCompilation", string2);
                }
            }
        }
    }

    private void populateUseStringCast(Properties properties) {
        String string = properties.getProperty("useStringCast");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "useStringCast", "JspWebAppConfig useStringCast value = " + string);
        }
        if (string == null) {
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "useStringCast", "JspWebAppConfig useStringCast webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.usestringcast");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "useStringCast", "JspWebAppConfig useStringCast webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("useStringCast", string2);
                }
            }
        }
    }

    private void populateUseRepeatInt(Properties properties) {
        String string = properties.getProperty("useRepeatInt");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "useRepeatInt", "JspWebAppConfig useRepeatInt value = " + string);
        }
        if (string == null) {
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "useRepeatInt", "JspWebAppConfig useRepeatInt webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.userepeatint");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "useRepeatInt", "JspWebAppConfig useRepeatInt webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("useRepeatInt", string2);
                }
            }
        }
    }

    private void populateUseScriptVarDupInit(Properties properties) {
        String string = properties.getProperty("useScriptVarDupInit");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "useScriptVarDupInit", "JspWebAppConfig useScriptVarDupInit value = " + string);
        }
        if (string == null) {
            boolean bl = false;
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "useScriptVarDupInit", "JspWebAppConfig useScriptVarDupInit webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.usescriptvardupinit");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "useScriptVarDupInit", "JspWebAppConfig useScriptVarDupInit webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("useScriptVarDupInit", string2);
                }
            }
        }
    }

    private void populateAllowUnmatchedEndTag(Properties properties) {
        String string = properties.getProperty("allowUnmatchedEndTag");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "allowUnmatchedEndTag", "JspWebAppConfig allowUnmatchedEndTag value = " + string);
        }
        if (string == null) {
            boolean bl = false;
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "allowUnmatchedEndTag", "JspWebAppConfig allowUnmatchedEndTag webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.allowunmatchedendtag");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "allowUnmatchedEndTag", "JspWebAppConfig allowUnmatchedEndTag webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("allowUnmatchedEndTag", string2);
                }
            }
        }
    }

    private void populateConvertExpression(Properties properties) {
        String string = properties.getProperty("convertExpression");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "convertExpression", "JspWebAppConfig convertExpression value = " + string);
        }
        if (string == null) {
            boolean bl = false;
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "convertExpression", "JspWebAppConfig convertExpression webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.convertexpression");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "convertExpression", "JspWebAppConfig convertExpression webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("convertExpression", string2);
                }
            }
        }
    }

    private void populateUseCDataTrim(Properties properties) {
        String string = properties.getProperty("useCDataTrim");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "useCDataTrim", "JspWebAppConfig useCDataTrim value = " + string);
        }
        if (string == null) {
            boolean bl = false;
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "useCDataTrim", "JspWebAppConfig useCDataTrim webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.usecdatatrim");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "useCDataTrim", "JspWebAppConfig useCDataTrim webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("useCDataTrim", string2);
                }
            }
        }
    }

    private void populateJdkSourceLevel(Properties properties) {
        String string = properties.getProperty("jdkSourceLevel");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "populateJdkSourceLevel", "JspWebAppConfig populateJdkSourceLevel value = " + string);
        }
        if (string == null) {
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "populateJdkSourceLevel", "JspWebAppConfig populateJdkSourceLevel webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.ws.jsp.jdksourcelevel");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "populateJdkSourceLevel", "JspWebAppConfig populateJdkSourceLevel webconValue = " + string2);
                }
                if (string2 != null && (string2.equals("13") || string2.equals("14") || string2.equals("15"))) {
                    properties.put("jdkSourceLevel", string2);
                }
            }
        }
    }

    private void populateEvalQuotedAndEscapedExpression(Properties properties) {
        String string = properties.getProperty("evalQuotedAndEscapedExpression");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "evalQuotedAndEscapedExpression", "JspWebAppConfig evalQuotedAndEscapedExpression value = " + string);
        }
        if (string == null) {
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "evalQuotedAndEscapedExpression", "JspWebAppConfig evalQuotedAndEscapedExpression webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.evalquotedandescapedexpression");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "evalQuotedAndEscapedExpression", "JspWebAppConfig evalQuotedAndEscapedExpression webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("evalQuotedAndEscapedExpression", string2);
                }
            }
        }
    }

    private void populateDisableELCache(Properties properties) {
        String string = properties.getProperty("disableELCache");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "populateDisableELCache", "JspWebAppConfig disableELCache value = " + string);
        }
        if (string == null) {
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "populateDisableELCache", "JspWebAppConfig disableELCache webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.disableelcache");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "populateDisableELCache", "JspWebAppConfig com.ibm.wsspi.jsp.disableELCache webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("disableELCache", string2);
                }
            }
        }
    }

    private void populateConvertAttrValueToString(Properties properties) {
        String string = properties.getProperty("convertAttrValueToString");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "convertAttrValueToString", "JspWebAppConfig convertAttrValueToString value = " + string);
        }
        if (string == null) {
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "convertAttrValueToString", "JspWebAppConfig convertAttrValueToString webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.convertattrvaluetostring");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "convertAttrValueToString", "JspWebAppConfig convertAttrValueToString webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("convertAttrValueToString", string2);
                }
            }
        }
    }

    private void populateAllowNullParentInTagFile(Properties properties) {
        String string = properties.getProperty("allowNullParentInTagFile");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "allowNullParentInTagFile", "JspWebAppConfig allowNullParentInTagFile value = " + string);
        }
        if (string == null) {
            boolean bl = false;
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "allowNullParentInTagFile", "JspWebAppConfig allowNullParentInTagFile webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.allownullparentintagfile");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "allowNullParentInTagFile", "JspWebAppConfig allowNullParentInTagFile webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("allowNullParentInTagFile", string2);
                }
            }
        }
    }

    private void populateModifyPageContextVar(Properties properties) {
        String string = properties.getProperty("modifyPageContextVariable");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "populateModifyPageContextVar", "JspWebAppConfig populateModifyPageContextVariable value = " + string);
        }
        if (string == null) {
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "populateModifyPageContextVar", "JspWebAppConfig populateModifyPageContextVariable webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.modifypagecontextvariable");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "populateModifyPageContextVar", "JspWebAppConfig populateModifyPageContextVariable webconValue = " + string2);
                }
                if (string2 != null) {
                    properties.put("modifyPageContextVariable", string2);
                }
            }
        }
    }

    private void populateDisableTldSearch(Properties properties) {
        String string = properties.getProperty("disableTldSearch");
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "populateDisableTldSearch", "JspWebAppConfig disableTldSearch value = " + string);
        }
        if (string == null) {
            Properties properties2 = WebContainer.getWebContainerProperties();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "populateDisableTldSearch", "JspWebAppConfig populateDisableTldSearch webContainerProperties = " + properties2);
            }
            if (properties2 != null) {
                String string2 = properties2.getProperty("com.ibm.wsspi.jsp.disabletldsearch");
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "populateDisableTldSearch", "JspWebAppConfig populateDisableTldSearch webconValue = " + string2);
                }
                if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("false"))) {
                    properties.put("disableTldSearch", string2);
                }
            }
        }
    }

    public Map getTagLibMap() {
        return new HashMap(this.tagLibMap);
    }

    public List getJspPropertyGroups() {
        return this.jspPropertyGroups;
    }

    public boolean isServlet24() {
        return this.isServlet24;
    }

    public JspOptions getJspOptions() {
        return this.jspOptions;
    }

    public List getJspFileExtensions() {
        return this.jspFileExtensions;
    }

    private void createJspFileExtensionList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ": ;");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.jspFileExtensions.contains(string2)) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.logp(Level.WARNING, CLASS_NAME, "createJspFileExtensionList", "duplicate value for jsp init param jsp.file.extensions ", string2);
                continue;
            }
            this.jspFileExtensions.add(string2);
        }
    }

    public boolean containsServletClassName(String string) {
        return this.servletClassNameList.contains(string);
    }
}

