/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inputsource;

import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class JspInputSourceImpl
implements JspInputSource {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.inputsource.JspInputSourceImpl";
    protected URL contextURL = null;
    protected URL absoluteURL = null;
    protected String relativeURL = null;
    protected URLStreamHandler urlStreamHandler = null;
    protected long lastModified = 0L;
    protected Document document = null;

    public JspInputSourceImpl(URL uRL, String string, URLStreamHandler uRLStreamHandler) {
        this.contextURL = uRL;
        this.relativeURL = string;
        this.urlStreamHandler = uRLStreamHandler;
        String string2 = string;
        if (string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        try {
            this.absoluteURL = uRLStreamHandler != null ? new URL(uRL, string2, uRLStreamHandler) : new URL(uRL, string2);
        }
        catch (MalformedURLException malformedURLException) {
            logger.logp(Level.WARNING, CLASS_NAME, "JspInputSourceImpl", "Failed to create inputsource contextURL =[" + uRL + " relativeURL =[" + string + "]", malformedURLException);
        }
    }

    public JspInputSourceImpl(JspInputSourceImpl jspInputSourceImpl, String string, URLStreamHandler uRLStreamHandler) {
        this(jspInputSourceImpl.contextURL, string, uRLStreamHandler);
    }

    public URL getAbsoluteURL() {
        return this.absoluteURL;
    }

    public URL getContextURL() {
        return this.contextURL;
    }

    public Document getDocument() {
        return this.document;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = null;
        URLConnection uRLConnection = this.absoluteURL.openConnection();
        uRLConnection.setUseCaches(false);
        inputStream = uRLConnection.getInputStream();
        this.lastModified = uRLConnection.getLastModified();
        return inputStream;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getRelativeURL() {
        return this.relativeURL;
    }

    public boolean isXmlDocument() {
        return this.document != null;
    }
}

