/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.inputsource;

import com.ibm.ws.jsp.inputsource.JspURLConnection;
import com.ibm.ws.webcontainer.util.ExtendedDocumentRootUtils;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JspURLStreamHandler
extends URLStreamHandler {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.inputsource.JspUrlStreamHandler";
    private String relativeUrl = null;
    private ExtendedDocumentRootUtils edru = null;
    private boolean searchOnClasspath = false;
    private ClassLoader classloader = null;
    private static Map ENCODED_CHARACTER_MAP = new HashMap();
    private static Pattern CHARS_REQUIRING_ENCODING = null;

    public JspURLStreamHandler(String string, ExtendedDocumentRootUtils extendedDocumentRootUtils, boolean bl, ClassLoader classLoader) {
        this.relativeUrl = string;
        this.edru = extendedDocumentRootUtils;
        this.searchOnClasspath = bl;
        this.classloader = classLoader;
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        return new JspURLConnection(uRL, this.relativeUrl, this.edru, this.searchOnClasspath, this.classloader);
    }

    protected void parseURL(URL uRL, String string, int n, int n2) {
        String string2 = JspURLStreamHandler.replaceEncodedChars(string);
        if (logger.isLoggable(Level.FINEST) && !string.equals(string2)) {
            logger.logp(Level.FINEST, CLASS_NAME, "parseURL", "parseURL spec [" + string + "]");
            logger.logp(Level.FINEST, CLASS_NAME, "parseURL", "parseURL spec encoded [" + string2 + "]");
        }
        int n3 = string2.length();
        super.parseURL(uRL, string2, n, n + n3);
    }

    public static String replaceEncodedChars(String string) {
        Matcher matcher = CHARS_REQUIRING_ENCODING.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (matcher.find()) {
            bl = true;
            matcher.appendReplacement(stringBuffer, (String)ENCODED_CHARACTER_MAP.get(matcher.group()));
        }
        if (bl) {
            stringBuffer = matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return string;
    }

    static {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "!\"#$%&'()*+,:;<=>?@[]^`{|}~";
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            String string2 = String.valueOf(cArray[i]);
            stringBuffer.append("(\\" + string2 + ")");
            if (i != cArray.length - 1) {
                stringBuffer.append("|");
            }
            try {
                String string3 = URLEncoder.encode(string2, "UTF-8");
                ENCODED_CHARACTER_MAP.put(string2, string3);
                continue;
            }
            catch (Exception exception) {
                logger.logp(Level.FINER, CLASS_NAME, "staticInit", "failed\tto add encoding " + string2, exception);
            }
        }
        CHARS_REQUIRING_ENCODING = Pattern.compile(stringBuffer.toString());
    }
}

