/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.configuration.JspXmlExtConfig;
import com.ibm.ws.jsp.inputsource.JspInputSourceFactoryImpl;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.taglib.TagLibraryInfoProxy;
import com.ibm.ws.jsp.taglib.TldParser;
import com.ibm.ws.jsp.taglib.config.AvailabilityCondition;
import com.ibm.ws.jsp.taglib.config.AvailabilityConditionType;
import com.ibm.ws.jsp.taglib.config.GlobalTagLibConfig;
import com.ibm.ws.jsp.taglib.config.ImplicitTagLibConfig;
import com.ibm.ws.jsp.taglib.config.TagLibCacheConfigParser;
import com.ibm.ws.jsp.taglib.config.TldPathConfig;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.JspInputSourceFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.jsp.tagext.TagLibraryInfo;

public class GlobalTagLibraryCache
extends Hashtable
implements JspCoreContext,
JspClassloaderContext {
    private static final long serialVersionUID = 3257286933104505909L;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.GlobalTagLibraryCache";
    private URL contextURL;
    private String root;
    private JspInputSourceFactory inputSourceFactory;
    private Map implicitTagLibPrefixMap;
    private Map optimizedTagConfigMap;
    private List eventListenerList;
    private List globalTagLibConfigList;
    private ClassLoader loader;
    private JspConfigurationManager configManager;

    public GlobalTagLibraryCache() {
        this((ClassLoader)null);
    }

    public GlobalTagLibraryCache(ClassLoader classLoader) {
        block30: {
            this.contextURL = null;
            this.root = "";
            this.inputSourceFactory = null;
            this.implicitTagLibPrefixMap = new HashMap();
            this.optimizedTagConfigMap = new HashMap();
            this.eventListenerList = new ArrayList();
            this.globalTagLibConfigList = null;
            this.loader = null;
            this.configManager = null;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "entry");
                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "loader: [" + classLoader + "]");
            }
            this.loader = classLoader;
            String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("was.install.root");
                }
            });
            this.root = new File(string + File.separator + "lib").getPath();
            try {
                this.contextURL = new URL("file", null, this.getRealPath("/"));
            }
            catch (MalformedURLException malformedURLException) {
                logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "Failed to create context URL for docRoot: " + this.root, malformedURLException);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "contextURL: [" + this.contextURL + "]");
            }
            this.inputSourceFactory = new JspInputSourceFactoryImpl(this.contextURL, null, false, this.getClassLoader());
            TldParser tldParser = null;
            try {
                Object object;
                Object object2;
                Object object3;
                this.configManager = new JspConfigurationManager(Collections.EMPTY_LIST, true, Collections.EMPTY_LIST);
                tldParser = new TldParser(this, this.configManager, false);
                TagLibCacheConfigParser tagLibCacheConfigParser = new TagLibCacheConfigParser();
                tagLibCacheConfigParser.parse(this.getClass().getResourceAsStream("/com/ibm/ws/jsp/resources/taglibcacheconfig.xml"));
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "tagLibCacheConfigParser.getImplicitTagLibList(): [" + tagLibCacheConfigParser.getImplicitTagLibList() + "]");
                }
                Object object4 = tagLibCacheConfigParser.getImplicitTagLibList().iterator();
                while (object4.hasNext()) {
                    object3 = (ImplicitTagLibConfig)object4.next();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "implicitTagLibConfig: [" + object3 + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "implicitTagLibConfig.getUri(): [" + ((ImplicitTagLibConfig)object3).getUri() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "contains(implicitTagLibConfig.getUri(): [" + this.contains(((ImplicitTagLibConfig)object3).getUri()) + "]");
                    }
                    if (this.contains(((ImplicitTagLibConfig)object3).getUri())) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "implicitTagLibConfig.getLocation(): [" + ((ImplicitTagLibConfig)object3).getLocation() + "]");
                    }
                    object2 = this.inputSourceFactory.createJspInputSource(((ImplicitTagLibConfig)object3).getLocation());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "inputSource.getRelativeURL(): [" + object2.getRelativeURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "inputSource.getAbsoluteURL(): [" + object2.getAbsoluteURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "inputSource.getContextURL(): [" + object2.getContextURL() + "]");
                    }
                    try {
                        object = tldParser.parseTLD((JspInputSource)object2, "webinf");
                        this.put(((ImplicitTagLibConfig)object3).getUri(), object);
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "putting into implicitTagLibPrefixMap, prefix: [" + ((ImplicitTagLibConfig)object3).getPrefix() + "]  uri: [" + ((ImplicitTagLibConfig)object3).getUri() + "]");
                        }
                        this.implicitTagLibPrefixMap.put(((ImplicitTagLibConfig)object3).getPrefix(), ((ImplicitTagLibConfig)object3).getUri());
                    }
                    catch (JspCoreException jspCoreException) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to load tld in jar. uri = [" + object2.getAbsoluteURL() + "]", jspCoreException);
                    }
                }
                this.globalTagLibConfigList = tagLibCacheConfigParser.getGlobalTagLibList();
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "globalTagLibConfigList: [" + this.globalTagLibConfigList + "]");
                }
                object4 = this.globalTagLibConfigList.listIterator();
                while (object4.hasNext()) {
                    object3 = (GlobalTagLibConfig)object4.next();
                    if (this.loadImplicitTldFromJar((GlobalTagLibConfig)object3, tldParser)) continue;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to find jar [" + ((GlobalTagLibConfig)object3).getJarName() + "]. Removing from list of available global tag libraries");
                    }
                    object4.remove();
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", " about to search for META-INF/taglibcacheconfig.xml");
                }
                object4 = this.getClassLoader().getResources("META-INF/taglibcacheconfig.xml");
                while (object4.hasMoreElements()) {
                    object3 = (URL)object4.nextElement();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "META-INF/taglibcacheconfig.xml found in {0} ", ((URL)object3).toExternalForm());
                    }
                    try {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "about to open:[" + ((URL)object3).toExternalForm() + "]");
                        }
                        object2 = ((URL)object3).openStream();
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "about to parse inputstream:[" + object2 + "]");
                        }
                        tagLibCacheConfigParser.parse((InputStream)object2);
                        object = tagLibCacheConfigParser.getGlobalTagLibList();
                        ListIterator listIterator = object.listIterator();
                        while (listIterator.hasNext()) {
                            GlobalTagLibConfig globalTagLibConfig = (GlobalTagLibConfig)listIterator.next();
                            if (logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "globalTagLibConfig: [" + globalTagLibConfig + "]");
                                logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "globalTagLibConfig.getTldPathList() [" + globalTagLibConfig.getTldPathList() + "]");
                                Iterator iterator = globalTagLibConfig.getTldPathList().iterator();
                                while (iterator.hasNext()) {
                                    TldPathConfig tldPathConfig = (TldPathConfig)iterator.next();
                                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "tldPathConfig.getTldPath() [" + tldPathConfig.getTldPath() + "]");
                                    logger.logp(Level.FINE, CLASS_NAME, "GlobalTagLibraryCache", "tldPathConfig.getUri() [" + tldPathConfig.getUri() + "]");
                                }
                            }
                            if (this.loadImplicitTldFromJar(globalTagLibConfig, tldParser)) continue;
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to find jar [" + globalTagLibConfig.getJarName() + "]. Removing from list of available global tag libraries");
                            }
                            listIterator.remove();
                        }
                        this.globalTagLibConfigList.addAll(object);
                    }
                    catch (IOException iOException) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "GlobalTagLibraryCache", "jsp warning failed to load META-INF/taglibcacheconfig.xml in jar. url = [" + object3 + "]", object4);
                    }
                }
            }
            catch (JspCoreException jspCoreException) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.logp(Level.SEVERE, CLASS_NAME, "GlobalTagLibraryCache", "implicittaglibs failed to load ", jspCoreException);
                }
            }
            catch (IOException iOException) {
                if (!logger.isLoggable(Level.SEVERE)) break block30;
                logger.logp(Level.SEVERE, CLASS_NAME, "GlobalTagLibraryCache", "implicittaglibs failed to load ", iOException);
            }
        }
    }

    private boolean loadImplicitTldFromJar(GlobalTagLibConfig globalTagLibConfig, TldParser tldParser) {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "loadImplicitTldFromJar: entry");
        }
        boolean bl = false;
        URL uRL = this.getClassLoader().getResource(globalTagLibConfig.getJarName());
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "globalTagLibConfig.getJarName(): [" + globalTagLibConfig.getJarName() + "]");
            if (uRL != null) {
                logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "jarUrl: [" + uRL.toExternalForm() + "]");
            }
        }
        if (uRL != null) {
            bl = true;
            Iterator iterator = globalTagLibConfig.getTldPathList().iterator();
            while (iterator.hasNext()) {
                Object object;
                TldPathConfig tldPathConfig = (TldPathConfig)iterator.next();
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldPathConfig.getUri(): [" + tldPathConfig.getUri() + "]");
                }
                if (tldPathConfig.getUri() != null) {
                    object = new TagLibraryInfoProxy(globalTagLibConfig.getJarName(), tldPathConfig.getTldPath(), tldPathConfig.containsListenerDefs(), this);
                    this.put(tldPathConfig.getUri(), object);
                    continue;
                }
                object = null;
                try {
                    TagLibraryInfoImpl tagLibraryInfoImpl;
                    URL uRL2 = new URL("jar:" + uRL.toString() + "!/");
                    object = this.inputSourceFactory.createJspInputSource(uRL2, tldPathConfig.getTldPath());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldInputSource.getRelativeURL(): [" + object.getRelativeURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldInputSource.getAbsoluteURL(): [" + object.getAbsoluteURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldInputSource.getContextURL(): [" + object.getContextURL() + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "url: [" + uRL2 + "]");
                        logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "tldPathConfig.getTldPath(): [" + tldPathConfig.getTldPath() + "]");
                    }
                    if ((tagLibraryInfoImpl = tldParser.parseTLD((JspInputSource)object, globalTagLibConfig.getJarName())).getReliableURN() != null) {
                        if (this.containsKey(tagLibraryInfoImpl.getReliableURN())) continue;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadImplicitTldFromJar", "Global jar tld loaded for {0}", tagLibraryInfoImpl.getReliableURN());
                        }
                        tagLibraryInfoImpl.setURI(tagLibraryInfoImpl.getReliableURN());
                        this.put(tagLibraryInfoImpl.getReliableURN(), tagLibraryInfoImpl);
                        tldPathConfig.setUri(tagLibraryInfoImpl.getReliableURN());
                        this.eventListenerList.addAll(tldParser.getEventListenerList());
                        continue;
                    }
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadImplicitTldFromJar", "jsp warning failed to find a uri tag in [" + object.getAbsoluteURL() + "]");
                }
                catch (JspCoreException jspCoreException) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadImplicitTldFromJar", "jsp warning failed to load tld in jar. uri = [" + object.getAbsoluteURL() + "]", jspCoreException);
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadImplicitTldFromJar", "jsp warning failed to load tld in jar. uri = [" + object.getAbsoluteURL() + "]", iOException);
                }
            }
        }
        return bl;
    }

    public JspClassloaderContext getJspClassloaderContext() {
        return this;
    }

    public JspInputSourceFactory getJspInputSourceFactory() {
        return this.inputSourceFactory;
    }

    public String getRealPath(String string) {
        String string2 = "";
        string2 = string.startsWith("/") ? this.root + string : this.root + "/" + string;
        return string2;
    }

    public Set getResourcePaths(String string) {
        File[] fileArray;
        HashSet<String> hashSet = new HashSet<String>();
        File file = new File(this.root + string);
        if (file.exists() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string2 = fileArray[i].getPath();
                string2 = string2.substring(this.root.length());
                string2 = string2.replace('\\', '/');
                if (fileArray[i].isDirectory() && !string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public ClassLoader getClassLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        return this.getClass().getClassLoader();
    }

    public String getClassPath() {
        return "";
    }

    public Map getImplicitTagLibPrefixMap() {
        return this.implicitTagLibPrefixMap;
    }

    public Map getOptimizedTagConfigMap() {
        return this.optimizedTagConfigMap;
    }

    public List getEventListenerList() {
        return this.eventListenerList;
    }

    public Map getGlobalTagLibMapForWebApp(JspCoreContext jspCoreContext, JspXmlExtConfig jspXmlExtConfig) {
        Object object;
        Object object2;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "entry");
            logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "context: [" + jspCoreContext + "]  jspConfig: [" + jspXmlExtConfig + "]");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator<Object> iterator = this.implicitTagLibPrefixMap.values().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            object = (TagLibraryInfo)this.get(object2);
            hashMap.put((String)object2, object);
        }
        iterator = this.globalTagLibConfigList.iterator();
        while (iterator.hasNext()) {
            object2 = (GlobalTagLibConfig)iterator.next();
            object = ((GlobalTagLibConfig)object2).getTldPathList().iterator();
            while (object.hasNext()) {
                boolean bl = false;
                TldPathConfig tldPathConfig = (TldPathConfig)object.next();
                if (tldPathConfig.getAvailabilityConditionList().size() > 0) {
                    Iterator iterator2 = tldPathConfig.getAvailabilityConditionList().iterator();
                    while (iterator2.hasNext()) {
                        AvailabilityCondition availabilityCondition = (AvailabilityCondition)iterator2.next();
                        if (availabilityCondition.getType().equals(AvailabilityConditionType.webinfFileType)) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "WEB-INF File Availability Condition found for {0}", availabilityCondition.getValue());
                            }
                            if (!new File(jspCoreContext.getRealPath(availabilityCondition.getValue())).exists()) continue;
                            bl = true;
                        } else {
                            if (!availabilityCondition.getType().equals(AvailabilityConditionType.servletClassNameType)) continue;
                            if (logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "Servlet Class Name Availability Condition found for {0}", availabilityCondition.getValue());
                            }
                            if (!jspXmlExtConfig.containsServletClassName(availabilityCondition.getValue())) continue;
                            bl = true;
                        }
                        break;
                    }
                } else {
                    bl = true;
                }
                if (!bl) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getGlobalTagLibMapForWebApp", "global tld {0} is available", tldPathConfig.getUri());
                }
                hashMap.put(tldPathConfig.getUri(), this.get(tldPathConfig.getUri()));
            }
        }
        return hashMap;
    }

    public String getOptimizedClassPath() {
        return this.getClassPath();
    }

    public boolean isPredefineClassEnabled() {
        return false;
    }

    public byte[] predefineClass(String string, byte[] byArray) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadTldFromJarInputStream(GlobalTagLibConfig globalTagLibConfig, TldParser tldParser) {
        Object object;
        HashMap<String, TldPathConfig> hashMap = new HashMap<String, TldPathConfig>();
        Object object2 = globalTagLibConfig.getTldPathList().iterator();
        while (object2.hasNext()) {
            object = (TldPathConfig)object2.next();
            hashMap.put(((TldPathConfig)object).getTldPath(), (TldPathConfig)object);
        }
        object2 = null;
        object2 = new JarInputStream(globalTagLibConfig.getJarURL().openStream());
        object = null;
        byte[] byArray = new byte[1024];
        while ((object = ((JarInputStream)object2).getNextJarEntry()) != null) {
            TldPathConfig tldPathConfig = (TldPathConfig)hashMap.get(((ZipEntry)object).getName());
            if (tldPathConfig == null) continue;
            JspInputSource jspInputSource = null;
            try {
                TagLibraryInfoImpl tagLibraryInfoImpl;
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = ((FilterInputStream)object2).read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                jspInputSource = this.inputSourceFactory.createJspInputSource(globalTagLibConfig.getJarURL(), tldPathConfig.getTldPath());
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldInputSource.getRelativeURL(): [" + jspInputSource.getRelativeURL() + "]");
                    logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldInputSource.getAbsoluteURL(): [" + jspInputSource.getAbsoluteURL() + "]");
                    logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldInputSource.getContextURL(): [" + jspInputSource.getContextURL() + "]");
                    logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "globalTagLibConfig.getJarURL(): [" + globalTagLibConfig.getJarURL() + "]");
                    logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "tldPathConfig.getTldPath(): [" + tldPathConfig.getTldPath() + "]");
                }
                if ((tagLibraryInfoImpl = tldParser.parseTLD(jspInputSource, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), globalTagLibConfig.getJarURL().toExternalForm())).getReliableURN() != null) {
                    if (this.containsKey(tagLibraryInfoImpl.getReliableURN())) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadTldFromJarInputStream", "Global jar tld loaded for {0}", tagLibraryInfoImpl.getReliableURN());
                    }
                    tagLibraryInfoImpl.setURI(tagLibraryInfoImpl.getReliableURN());
                    this.put(tagLibraryInfoImpl.getReliableURN(), tagLibraryInfoImpl);
                    tldPathConfig.setUri(tagLibraryInfoImpl.getReliableURN());
                    this.eventListenerList.addAll(tldParser.getEventListenerList());
                    continue;
                }
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromJarInputStream", "jsp warning failed to find a uri tag in [" + jspInputSource.getAbsoluteURL() + "]");
            }
            catch (JspCoreException jspCoreException) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromJarInputStream", "jsp warning failed to load tld in jar. uri = [" + jspInputSource.getAbsoluteURL() + "]", jspCoreException);
            }
        }
        Object var13_14 = null;
        if (object2 == null) return;
        try {
            ((ZipInputStream)object2).close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.logp(Level.WARNING, CLASS_NAME, "loadTldFromJarInputStream", "jsp warning failed to load jar. url = [" + globalTagLibConfig.getJarURL() + "]", iOException);
                }
                Object var13_15 = null;
                if (object2 == null) return;
                try {
                    ((ZipInputStream)object2).close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (object2 == null) throw throwable;
            try {
                ((ZipInputStream)object2).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void addGlobalTagLibConfig(GlobalTagLibConfig globalTagLibConfig) {
        block2: {
            try {
                TldParser tldParser = new TldParser(this, this.configManager, false, globalTagLibConfig.getClassloader());
                this.loadTldFromJarInputStream(globalTagLibConfig, tldParser);
                this.globalTagLibConfigList.add(globalTagLibConfig);
            }
            catch (JspCoreException jspCoreException) {
                if (!logger.isLoggable(Level.SEVERE)) break block2;
                logger.logp(Level.SEVERE, CLASS_NAME, "addGlobalTagLibConfig", "failed to create TldParser ", jspCoreException);
            }
        }
    }
}

