/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.taglib.ImplicitTagLibraryInfoImpl;
import com.ibm.ws.jsp.taglib.TagClassInfo;
import com.ibm.ws.jsp.taglib.TagFileClassInfo;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.taglib.TagLibraryInfoProxy;
import com.ibm.ws.jsp.taglib.TldParser;
import com.ibm.ws.jsp.translator.JspTranslator;
import com.ibm.ws.jsp.translator.JspTranslatorFactory;
import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTag;
import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTagConfig;
import com.ibm.ws.jsp.translator.optimizedtag.OptimizedTagConfigParser;
import com.ibm.ws.jsp.translator.utils.NameMangler;
import com.ibm.ws.jsp.translator.utils.TagFileId;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.tagfilescan.TagFileScanResult;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.TagFileResources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;

public class TagLibraryCache
extends Hashtable {
    private static final long serialVersionUID = 3256719585204975926L;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TagLibraryCache";
    static final String TAGFILE_SCAN_ID = "TagFileScan";
    public static final int ABS_URI = 0;
    public static final int ROOT_REL_URI = 1;
    public static final int NOROOT_REL_URI = 2;
    private JspTranslationContext ctxt = null;
    private TldParser tldParser = null;
    private Map tagClassMap = new HashMap();
    private Map tagFileResourcesMap = new HashMap();
    private Map implicitTagLibPrefixMap = new HashMap();
    private Map optimizedTagConfigMap = null;
    private Map looseLibMap = null;
    private List eventListenerList = new ArrayList();
    private JspConfigurationManager configManager = null;
    private JspOptions jspOptions = null;
    private String outputDir = null;
    private Map tagFileLockMap = null;

    public TagLibraryCache(JspTranslationContext jspTranslationContext, Map map, JspOptions jspOptions, JspConfigurationManager jspConfigurationManager, Map map2, Map map3, Map map4) throws JspCoreException {
        OptimizedTagConfigParser optimizedTagConfigParser;
        Object object;
        Object object2;
        this.ctxt = jspTranslationContext;
        this.configManager = jspConfigurationManager;
        this.jspOptions = jspOptions;
        this.outputDir = jspOptions.getOutputDir().getPath();
        if (jspOptions.getLooseLibMap() != null) {
            this.looseLibMap = jspOptions.getLooseLibMap();
        }
        this.tldParser = new TldParser(jspTranslationContext, jspConfigurationManager, false);
        List list = this.loadWebXmlMap(map);
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "TagLibraryCache", "disableTldSearch is set to: " + jspOptions.isDisableTldSearch());
        }
        if (!jspOptions.isDisableTldSearch()) {
            this.loadLibJarMap(list);
            this.loadWebInfMap("/WEB-INF", list);
            this.loadWebInfTagFiles("/WEB-INF/tags");
        }
        if (this.looseLibMap != null) {
            object2 = this.looseLibMap.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                this.loadLooseLibTagFiles((String)this.looseLibMap.get(object), list);
            }
        }
        if (jspOptions.isUseImplicitTagLibs() && jspOptions.getTranslationContextClass() == null) {
            object2 = map2.keySet().iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (this.containsKey(object)) continue;
                optimizedTagConfigParser = map2.get(object);
                if (optimizedTagConfigParser instanceof TagLibraryInfoImpl) {
                    TagLibraryInfoImpl tagLibraryInfoImpl = (TagLibraryInfoImpl)((Object)optimizedTagConfigParser);
                    TagLibraryInfoImpl tagLibraryInfoImpl2 = tagLibraryInfoImpl.copy("");
                    this.put(object, tagLibraryInfoImpl2);
                    continue;
                }
                if (!(optimizedTagConfigParser instanceof TagLibraryInfoProxy)) continue;
                this.put(object, optimizedTagConfigParser);
            }
            this.implicitTagLibPrefixMap.putAll(map3);
        }
        if (jspOptions.isUseOptimizedTags()) {
            object2 = jspTranslationContext.getJspInputSourceFactory().createJspInputSource("/WEB-INF/optimizedtags.xml");
            try {
                object = object2.getInputStream();
                if (object != null) {
                    optimizedTagConfigParser = new OptimizedTagConfigParser(jspTranslationContext);
                    this.optimizedTagConfigMap = optimizedTagConfigParser.parse((InputStream)object);
                } else {
                    this.optimizedTagConfigMap = new HashMap();
                }
            }
            catch (IOException iOException) {
                this.optimizedTagConfigMap = new HashMap();
            }
            this.optimizedTagConfigMap.putAll(map4);
        }
    }

    private List loadWebXmlMap(Map map) throws JspCoreException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            TagLibraryInfoImpl tagLibraryInfoImpl;
            String string2;
            String string3;
            block7: {
                string3 = (String)iterator.next();
                if (this.containsKey(string3)) continue;
                string2 = (String)map.get(string3);
                tagLibraryInfoImpl = null;
                string = string2;
                if (string2.endsWith(".jar")) {
                    tagLibraryInfoImpl = this.loadTaglibTldFromJar(string2);
                    string = string + "/META-INF/taglib.tld";
                } else {
                    JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(string2);
                    try {
                        tagLibraryInfoImpl = this.tldParser.parseTLD(jspInputSource, "webinf");
                    }
                    catch (JspCoreException jspCoreException) {
                        if (!logger.isLoggable(Level.WARNING)) break block7;
                        logger.logp(Level.WARNING, CLASS_NAME, "loadWebXmlMap", "jsp warning failed to load tld at [" + string2 + "]");
                    }
                }
            }
            if (tagLibraryInfoImpl == null) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.logp(Level.WARNING, CLASS_NAME, "loadWebXmlMap", "jsp warning failed to load tld at [" + string2 + "]");
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "loadWebXmlMap", "webxml tld loaded for {0}", string3);
            }
            this.put(string3, tagLibraryInfoImpl);
            tagLibraryInfoImpl.setURI(string3);
            arrayList.add(string);
            this.eventListenerList.addAll(this.tldParser.getEventListenerList());
        }
        return arrayList;
    }

    private void loadLibJarMap(List list) {
        Set set = this.ctxt.getResourcePaths("/WEB-INF/lib");
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.endsWith(".jar")) continue;
                this.loadTldsFromJar(string, list);
            }
        }
    }

    protected void loadTldsFromJar(String string, List list) {
        block2: {
            try {
                JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(string);
                URL uRL = new URL("jar:" + jspInputSource.getAbsoluteURL().toExternalForm() + "!/");
                this.loadTldsFromJar(uRL, string, list);
            }
            catch (MalformedURLException malformedURLException) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.logp(Level.WARNING, CLASS_NAME, "loadTldsFromJar", "jsp error failed to load tld in jar. uri = [" + string + "]", malformedURLException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadTldsFromJar(URL uRL, String string, List list) {
        block28: {
            Throwable throwable2222;
            InputStream inputStream;
            JarFile jarFile;
            block26: {
                jarFile = null;
                inputStream = null;
                String string2 = null;
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                jarURLConnection.setUseCaches(false);
                jarFile = jarURLConnection.getJarFile();
                String string3 = jarFile.getName();
                string3 = string3.substring(0, string3.indexOf(".jar"));
                if (string3.indexOf(File.separatorChar) != -1) {
                    string3 = string3.substring(string3.lastIndexOf(File.separatorChar) + 1);
                }
                string3 = NameMangler.mangleString(string3);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    block25: {
                        JarEntry jarEntry = enumeration.nextElement();
                        string2 = jarEntry.getName();
                        if (!string2.startsWith("META-INF/") || !string2.endsWith(".tld") || list.contains(string + "/" + string2)) continue;
                        inputStream = jarFile.getInputStream(jarEntry);
                        JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(uRL, string2);
                        try {
                            TagLibraryInfoImpl tagLibraryInfoImpl = this.tldParser.parseTLD(jspInputSource, inputStream, string3);
                            if (tagLibraryInfoImpl.getReliableURN() != null && !tagLibraryInfoImpl.getReliableURN().trim().equals("")) {
                                tagLibraryInfoImpl.setURI(tagLibraryInfoImpl.getReliableURN());
                                if (!this.containsKey(tagLibraryInfoImpl.getReliableURN())) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.logp(Level.FINE, CLASS_NAME, "loadTldsFromJar", "jar tld loaded for " + tagLibraryInfoImpl.getReliableURN() + ", name tld : " + string2);
                                    }
                                    this.put(tagLibraryInfoImpl.getReliableURN(), tagLibraryInfoImpl);
                                    this.eventListenerList.addAll(this.tldParser.getEventListenerList());
                                }
                            }
                        }
                        catch (JspCoreException jspCoreException) {
                            if (!logger.isLoggable(Level.WARNING)) break block25;
                            logger.logp(Level.WARNING, CLASS_NAME, "loadTldsFromJar", "jsp error failed to load tld in jar. uri = [" + string + "]", jspCoreException);
                        }
                    }
                    inputStream.close();
                    inputStream = null;
                }
                Object var14_15 = null;
                if (inputStream == null) break block26;
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2222) {}
            }
            break block28;
            {
                catch (Exception exception) {
                    Throwable throwable32222;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTldsFromJar", "jsp error failed to load tld in jar. uri = [" + string + "]", exception);
                    }
                    Object var14_16 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable32222) {
                            // empty catch block
                        }
                    }
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable32222) {}
                    }
                }
            }
            catch (Throwable throwable4) {
                Throwable throwable52222;
                Object var14_17 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable52222) {
                        // empty catch block
                    }
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable52222) {
                        // empty catch block
                    }
                }
                throw throwable4;
            }
        }
    }

    private void loadWebInfMap(String string, List list) {
        Set set = this.ctxt.getResourcePaths(string);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2.endsWith(".tld") && !list.contains(string2)) {
                    try {
                        JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(string2);
                        TagLibraryInfoImpl tagLibraryInfoImpl = this.tldParser.parseTLD(jspInputSource, "webinf");
                        if (tagLibraryInfoImpl.getReliableURN() == null || tagLibraryInfoImpl.getReliableURN().trim().equals("")) continue;
                        tagLibraryInfoImpl.setURI(tagLibraryInfoImpl.getReliableURN());
                        if (this.containsKey(tagLibraryInfoImpl.getReliableURN())) continue;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadWebInfMap", "webinf tld loaded for {0}", tagLibraryInfoImpl.getReliableURN());
                        }
                        this.put(tagLibraryInfoImpl.getReliableURN(), tagLibraryInfoImpl);
                        this.eventListenerList.addAll(this.tldParser.getEventListenerList());
                    }
                    catch (JspCoreException jspCoreException) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "loadWebInfMap", "webinf tld failed to load for resourcePath =[" + string2 + "]", jspCoreException);
                    }
                    continue;
                }
                if (!string2.endsWith("/")) continue;
                this.loadWebInfMap(string2.substring(0, string2.lastIndexOf(47)), list);
            }
        }
    }

    private void loadWebInfTagFiles(String string) {
        Set set = this.ctxt.getResourcePaths(string);
        ArrayList<TagFileInfo> arrayList = new ArrayList<TagFileInfo>();
        if (set != null) {
            Object object;
            Object object2;
            TagLibraryInfoImpl tagLibraryInfoImpl = null;
            Object object3 = set.iterator();
            while (object3.hasNext()) {
                object2 = (String)object3.next();
                if (((String)object2).endsWith("/")) {
                    this.loadWebInfTagFiles(((String)object2).substring(0, ((String)object2).lastIndexOf(47)));
                    continue;
                }
                if (!((String)object2).endsWith(".tld")) continue;
                try {
                    object = this.ctxt.getJspInputSourceFactory().createJspInputSource((String)object2);
                    tagLibraryInfoImpl = this.tldParser.parseTLD((JspInputSource)object, "webinf");
                    if (tagLibraryInfoImpl == null) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadWebInfTagFiles", "Adding TagLibraryInfoImpl for [{0}]", string);
                    }
                    this.put(string, tagLibraryInfoImpl);
                }
                catch (JspCoreException jspCoreException) {
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadWebInfTagFiles", "webinf tagfile directory tld failed to load for resourcePath =[" + (String)object2 + "]", jspCoreException);
                }
            }
            if (tagLibraryInfoImpl == null) {
                object3 = this.ctxt.getJspInputSourceFactory().createJspInputSource(string);
                tagLibraryInfoImpl = new ImplicitTagLibraryInfoImpl(string, (JspInputSource)object3);
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (!((String)object).endsWith(".tag") && !((String)object).endsWith(".tagx")) continue;
                    try {
                        JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().copyJspInputSource(tagLibraryInfoImpl.getInputSource(), (String)object);
                        JspTranslator jspTranslator = JspTranslatorFactory.getFactory().createTranslator(TAGFILE_SCAN_ID, jspInputSource, this.ctxt, this.configManager.createJspConfiguration(), this.jspOptions, this.implicitTagLibPrefixMap);
                        JspVisitorInputMap jspVisitorInputMap = new JspVisitorInputMap();
                        jspVisitorInputMap.put("TagLibraryInfo", tagLibraryInfoImpl);
                        String string2 = ((String)object).substring(((String)object).lastIndexOf(47) + 1);
                        string2 = string2.substring(0, string2.indexOf(".tag"));
                        jspVisitorInputMap.put("TagFileName", string2);
                        jspVisitorInputMap.put("TagFilePath", object);
                        HashMap hashMap = jspTranslator.processVisitors(jspVisitorInputMap);
                        TagFileScanResult tagFileScanResult = (TagFileScanResult)hashMap.get(TAGFILE_SCAN_ID);
                        TagFileInfo tagFileInfo = new TagFileInfo(string2, (String)object, tagFileScanResult.getTagInfo());
                        arrayList.add(tagFileInfo);
                    }
                    catch (JspCoreException jspCoreException) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "loadWebInfTagFiles", "webinf tagfile failed to scan =[" + (String)object + "]", jspCoreException);
                    }
                }
                if (arrayList.size() > 0) {
                    tagLibraryInfoImpl.setTagFiles(arrayList);
                    arrayList.clear();
                    tagLibraryInfoImpl.setFunctions(arrayList);
                    tagLibraryInfoImpl.setTags(arrayList);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadWebInfTagFiles", "Adding ImplicitTagLibraryInfoImpl for [{0}]", string);
                    }
                    this.put(string, tagLibraryInfoImpl);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private TagLibraryInfoImpl loadTaglibTldFromJar(String string) {
        TagLibraryInfoImpl tagLibraryInfoImpl;
        block36: {
            Throwable throwable2222;
            ZipFile zipFile;
            InputStream inputStream;
            block37: {
                Object object;
                tagLibraryInfoImpl = null;
                if (this.looseLibMap != null && this.looseLibMap.containsKey(string)) {
                    String string2 = (String)this.looseLibMap.get(string);
                    try {
                        URL uRL = new File(string2).toURL();
                        JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(uRL, "META-INF/taglib.tld");
                        tagLibraryInfoImpl = this.tldParser.parseTLD(jspInputSource, "webinf");
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadTaglibTldFromJar", "tld loaded for [{0}]", string);
                        }
                        break block36;
                    }
                    catch (JspCoreException jspCoreException) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.logp(Level.WARNING, CLASS_NAME, "loadTaglibTldFromJar", "jsp error failed to parse loose library tld . location = [" + string2 + "]", jspCoreException);
                        }
                        break block36;
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.logp(Level.WARNING, CLASS_NAME, "loadTaglibTldFromJar", "jsp error failed to parse loose library tld . location = [" + string2 + "]", malformedURLException);
                        }
                        break block36;
                    }
                }
                inputStream = null;
                zipFile = null;
                JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(string);
                URL uRL = new URL("jar:" + jspInputSource.getAbsoluteURL().toExternalForm() + "!/");
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                jarURLConnection.setUseCaches(false);
                try {
                    zipFile = jarURLConnection.getJarFile();
                }
                catch (IOException iOException) {
                    object = this.ctxt.getJspClassloaderContext().getClassLoader().getResource(string);
                    if (object != null) {
                        object = new URL("jar:" + ((URL)object).toExternalForm() + "!/");
                        jarURLConnection = (JarURLConnection)((URL)object).openConnection();
                        jarURLConnection.setUseCaches(false);
                        zipFile = jarURLConnection.getJarFile();
                    }
                    throw new JspCoreException("jsp.error.unable.to.locate.tld.jar.file", new Object[]{string});
                }
                Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    String string3 = ((ZipEntry)object).getName();
                    if (!string3.equals("META-INF/taglib.tld")) continue;
                    inputStream = ((JarFile)zipFile).getInputStream((ZipEntry)object);
                    String string4 = zipFile.getName();
                    if ((string4 = string4.substring(0, string4.indexOf(".jar"))).indexOf(File.separatorChar) != -1) {
                        string4 = string4.substring(string4.lastIndexOf(File.separatorChar) + 1);
                    }
                    string4 = NameMangler.mangleString(string4);
                    JspInputSource jspInputSource2 = this.ctxt.getJspInputSourceFactory().createJspInputSource(uRL, "META-INF/taglib.tld");
                    tagLibraryInfoImpl = this.tldParser.parseTLD(jspInputSource2, inputStream, string4);
                    if (tagLibraryInfoImpl == null || !logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "loadTaglibTldFromJar", "tld loaded for [{0}]", string);
                }
                Object var14_21 = null;
                if (inputStream == null) break block37;
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2222) {
                    // empty catch block
                }
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2222) {}
            }
            break block36;
            {
                catch (JspCoreException jspCoreException) {
                    Throwable throwable32222;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTaglibTldFromJar", "jsp error failed to parse tld in jar. uri = [" + string + "]", jspCoreException);
                    }
                    Object var14_22 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable32222) {
                            // empty catch block
                        }
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable32222) {}
                    }
                    break block36;
                }
                catch (IOException iOException) {
                    Throwable throwable42222;
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTaglibTldFromJar", "jsp error failed to parse tld in jar. uri = [" + string + "]", iOException);
                    }
                    Object var14_23 = null;
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable42222) {
                            // empty catch block
                        }
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable42222) {}
                    }
                }
            }
            catch (Throwable throwable5) {
                Throwable throwable62222;
                Object var14_24 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable62222) {
                        // empty catch block
                    }
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable throwable62222) {
                        // empty catch block
                    }
                }
                throw throwable5;
            }
        }
        return tagLibraryInfoImpl;
    }

    private void loadLooseLibTagFiles(String string, List list) {
        File file;
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "loadLooseLibTagFiles", "looseLibDir {0}", string);
        }
        if ((file = new File(string)) == null) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{string};
        }
        if (stringArray != null) {
            TagLibraryInfoImpl tagLibraryInfoImpl = null;
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                String string2 = stringArray[i];
                if (string2.endsWith(".tld")) {
                    block19: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadLooseLibTagFiles", "tld located {0}", string2);
                        }
                        try {
                            object = new File(string).toURL();
                            JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource((URL)object, string2);
                            tagLibraryInfoImpl = this.tldParser.parseTLD(jspInputSource, "webinf");
                            if (logger.isLoggable(Level.FINE)) {
                                logger.logp(Level.FINE, CLASS_NAME, "loadLooseLibTagFiles", "tli {0}", (Object)tagLibraryInfoImpl);
                            }
                        }
                        catch (JspCoreException jspCoreException) {
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.logp(Level.WARNING, CLASS_NAME, "loadLooseLibTagFiles", "jsp error failed to parse loose library tld . location = [" + string + "]", jspCoreException);
                            }
                        }
                        catch (MalformedURLException malformedURLException) {
                            if (!logger.isLoggable(Level.WARNING)) break block19;
                            logger.logp(Level.WARNING, CLASS_NAME, "loadLooseLibTagFiles", "jsp error failed to parse loose library tld . location = [" + string + "]", malformedURLException);
                        }
                    }
                    if (tagLibraryInfoImpl == null) continue;
                    object = tagLibraryInfoImpl.getReliableURN();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadLooseLibTagFiles", "Adding TagLibraryInfoImpl for [{0}]", object);
                    }
                    this.put(object, tagLibraryInfoImpl);
                    continue;
                }
                if (string2.endsWith(".jar")) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "loadLooseLibTagFiles", "looseLibDir is a jar");
                    }
                    try {
                        object = new URL("jar:" + new File(string2).toURL() + "!/");
                        this.loadTldsFromJar((URL)object, string2, list);
                    }
                    catch (MalformedURLException malformedURLException) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.logp(Level.WARNING, CLASS_NAME, "loadLooseLibTagFiles", "jsp error failed to parse loose library tld . location = [" + string2 + "]", malformedURLException);
                    }
                    continue;
                }
                object = new StringBuffer(string);
                if (string.endsWith("/") || string.endsWith("\\")) {
                    ((StringBuffer)object).append(string2);
                } else {
                    ((StringBuffer)object).append("/");
                    ((StringBuffer)object).append(string2);
                }
                if (!new File(((StringBuffer)object).toString()).isDirectory()) continue;
                this.loadLooseLibTagFiles(((StringBuffer)object).toString(), list);
            }
        }
    }

    public synchronized TagLibraryInfoImpl getTagLibraryInfo(String string, String string2, String string3) {
        TagLibraryInfoImpl tagLibraryInfoImpl;
        block13: {
            int n = TagLibraryCache.uriType(string);
            tagLibraryInfoImpl = null;
            if (this.containsKey(string)) {
                TagLibraryInfoProxy tagLibraryInfoProxy;
                Object v = this.get(string);
                if (v instanceof TagLibraryInfoImpl) {
                    TagLibraryInfoImpl tagLibraryInfoImpl2 = (TagLibraryInfoImpl)((Object)v);
                    tagLibraryInfoImpl = tagLibraryInfoImpl2.copy(string2);
                } else if (v instanceof TagLibraryInfoProxy && (tagLibraryInfoImpl = (tagLibraryInfoProxy = (TagLibraryInfoProxy)v).getTagLibraryInfoImpl(string2)) != null) {
                    this.put(string, tagLibraryInfoImpl);
                }
            } else if (n == 1 || n == 2) {
                if (string.endsWith(".jar")) {
                    TagLibraryInfoImpl tagLibraryInfoImpl3 = this.loadTaglibTldFromJar(string);
                    if (tagLibraryInfoImpl3 != null) {
                        tagLibraryInfoImpl3.setURI(string);
                        this.put(string, tagLibraryInfoImpl3);
                        tagLibraryInfoImpl = tagLibraryInfoImpl3.copy(string2);
                    }
                } else {
                    try {
                        JspInputSource jspInputSource;
                        TagLibraryInfoImpl tagLibraryInfoImpl4 = null;
                        String string4 = string;
                        if (n == 2) {
                            string4 = string3.substring(0, string3.lastIndexOf("/") + 1);
                            string4 = string4 + string;
                        }
                        if ((tagLibraryInfoImpl4 = this.tldParser.parseTLD(jspInputSource = this.ctxt.getJspInputSourceFactory().createJspInputSource(string4), "webinf")) != null) {
                            tagLibraryInfoImpl4.setURI(string);
                            this.put(string, tagLibraryInfoImpl4);
                            tagLibraryInfoImpl = tagLibraryInfoImpl4.copy(string2);
                        }
                    }
                    catch (JspCoreException jspCoreException) {
                        if (!logger.isLoggable(Level.WARNING)) break block13;
                        logger.logp(Level.WARNING, CLASS_NAME, "getTagLibraryInfo", "jsp error failed to parse tld in WEB-INF. uri = [" + string + "]", jspCoreException);
                    }
                }
            }
        }
        return tagLibraryInfoImpl;
    }

    public synchronized TagFileResources getTagFileResources(TagFileResources tagFileResources) {
        if (!this.tagFileResourcesMap.containsKey(tagFileResources.getInputSource().getAbsoluteURL().toExternalForm())) {
            this.tagFileResourcesMap.put(tagFileResources.getInputSource().getAbsoluteURL().toExternalForm(), tagFileResources);
            return tagFileResources;
        }
        return (TagFileResources)this.tagFileResourcesMap.get(tagFileResources.getInputSource().getAbsoluteURL().toExternalForm());
    }

    public synchronized TagClassInfo getTagClassInfo(TagInfo tagInfo) {
        return (TagClassInfo)this.tagClassMap.get(tagInfo.getTagClassName());
    }

    public synchronized void addTagClassInfo(TagInfo tagInfo, Class clazz) {
        this.tagClassMap.put(tagInfo.getTagClassName(), new TagClassInfo(clazz));
    }

    public synchronized void addTagFileClassInfo(TagFileInfo tagFileInfo) {
        this.tagClassMap.put(tagFileInfo.getTagInfo().getTagClassName(), new TagFileClassInfo(tagFileInfo.getTagInfo()));
    }

    public synchronized void reloadTld(String string, long l) throws JspCoreException {
        Object object;
        Object object2 = null;
        Object object3 = this.keySet().iterator();
        while (object3.hasNext()) {
            TagLibraryInfoImpl tagLibraryInfoImpl;
            object = (String)object3.next();
            Object v = this.get(object);
            if (!(v instanceof TagLibraryInfoImpl) || (tagLibraryInfoImpl = (TagLibraryInfoImpl)((Object)v)).getTldFilePath() == null || !tagLibraryInfoImpl.getTldFilePath().equals(string)) continue;
            object2 = object;
            break;
        }
        if (object2 != null && ((TagLibraryInfoImpl)((Object)(object3 = (TagLibraryInfoImpl)((Object)this.get(object2))))).getLoadedTimestamp() < l) {
            object = this.tldParser.parseTLD(((TagLibraryInfoImpl)((Object)object3)).getInputSource(), "webinf");
            ((TagLibraryInfoImpl)((Object)object)).setURI(object3.getURI());
            this.put(object2, object);
            object3 = null;
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "reloadTld", "tld [{0}] reloaded", string);
            }
        }
    }

    public synchronized TagLibraryInfoImpl reloadImplicitTld(String string) throws JspCoreException {
        TagLibraryInfoImpl tagLibraryInfoImpl = null;
        if (this.containsKey(string)) {
            this.remove(string);
            this.loadWebInfTagFiles(string);
            tagLibraryInfoImpl = (TagLibraryInfoImpl)((Object)this.get(string));
        }
        return tagLibraryInfoImpl;
    }

    public Map getImplicitTagLibPrefixMap() {
        return this.implicitTagLibPrefixMap;
    }

    public List getEventListenerList() {
        return this.eventListenerList;
    }

    public synchronized OptimizedTag getOptimizedTag(String string, String string2, String string3) {
        OptimizedTag optimizedTag = null;
        String string4 = string + string2 + string3;
        if (this.optimizedTagConfigMap.containsKey(string4)) {
            OptimizedTagConfig optimizedTagConfig = (OptimizedTagConfig)this.optimizedTagConfigMap.get(string4);
            try {
                optimizedTag = (OptimizedTag)optimizedTagConfig.getOptClass().newInstance();
            }
            catch (InstantiationException instantiationException) {
                logger.logp(Level.WARNING, CLASS_NAME, "getOptimizedTag", "failed to instantiate optimized tag [" + optimizedTagConfig.getOptClass() + "]", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.logp(Level.WARNING, CLASS_NAME, "getOptimizedTag", "Illegal access of optimized tag [" + optimizedTagConfig.getOptClass() + "]", illegalAccessException);
            }
        }
        return optimizedTag;
    }

    public synchronized Object getTagFileLock(List list) {
        TagFileId tagFileId;
        Object object = null;
        if (this.tagFileLockMap == null) {
            this.tagFileLockMap = new HashMap();
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            tagFileId = (TagFileId)iterator.next();
            Object v = this.tagFileLockMap.get(tagFileId.toString());
            if (v == null) continue;
            object = v;
            break;
        }
        if (object == null) {
            object = new Object();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                tagFileId = (TagFileId)iterator.next();
                this.tagFileLockMap.put(tagFileId.toString(), object);
            }
        }
        return object;
    }

    public synchronized void releaseTagFileLock(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TagFileId tagFileId = (TagFileId)iterator.next();
            this.tagFileLockMap.remove(tagFileId.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private TagLibraryInfoImpl loadSerializedTld(JspInputSource jspInputSource, JspInputSource jspInputSource2) {
        TagLibraryInfoImpl tagLibraryInfoImpl;
        block16: {
            tagLibraryInfoImpl = null;
            String string = jspInputSource.getAbsoluteURL().toExternalForm().replace('\\', '_');
            string = string.replace('/', '_');
            File file = new File(this.outputDir + File.separator + NameMangler.mangleString(string) + ".ser");
            if (file.exists() && file.lastModified() >= jspInputSource2.getLastModified()) {
                FileInputStream fileInputStream;
                ObjectInputStream objectInputStream;
                block15: {
                    objectInputStream = null;
                    fileInputStream = null;
                    fileInputStream = new FileInputStream(file);
                    objectInputStream = new ObjectInputStream(fileInputStream);
                    tagLibraryInfoImpl = (TagLibraryInfoImpl)((Object)objectInputStream.readObject());
                    if (tagLibraryInfoImpl == null) break block15;
                    System.out.println("tld loaded from " + file.getPath());
                }
                Object var10_8 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (objectInputStream != null) {
                        objectInputStream.close();
                    }
                    break block16;
                }
                catch (IOException iOException) {}
                break block16;
                {
                    catch (Exception exception) {
                        Object var10_9 = null;
                        try {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            if (objectInputStream != null) {
                                objectInputStream.close();
                            }
                            break block16;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        if (objectInputStream != null) {
                            objectInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return tagLibraryInfoImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void serializeTld(JspInputSource jspInputSource, TagLibraryInfoImpl tagLibraryInfoImpl) {
        block14: {
            String string = jspInputSource.getAbsoluteURL().toExternalForm().replace('\\', '_');
            string = string.replace('/', '_');
            File file = new File(this.outputDir + File.separator + NameMangler.mangleString(string) + ".ser");
            System.out.println("serialixedTliFile = " + file.getPath());
            ObjectOutputStream objectOutputStream = null;
            FileOutputStream fileOutputStream = null;
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject((Object)tagLibraryInfoImpl);
            System.out.println("tld serialized to " + file.getPath());
            Object var9_7 = null;
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                break block14;
            }
            catch (IOException iOException) {}
            break block14;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var9_8 = null;
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        if (objectOutputStream != null) {
                            objectOutputStream.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                    if (objectOutputStream != null) {
                        objectOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private static int uriType(String string) {
        if (string.indexOf(58) != -1) {
            return 0;
        }
        if (string.startsWith("/")) {
            return 1;
        }
        return 2;
    }
}

