/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagLibraryValidator;

public class TagLibraryInfoImpl
extends TagLibraryInfo {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TagLibraryInfoImpl";
    protected String tldOriginatorId = "";
    protected JspInputSource inputSource = null;
    protected Class tlvClass = null;
    protected Map tlvInitParams = null;

    public TagLibraryInfoImpl(String string, JspInputSource jspInputSource) {
        super("", "");
        this.tldOriginatorId = string;
        this.inputSource = jspInputSource;
    }

    protected TagLibraryInfoImpl(String string, String string2, String string3, JspInputSource jspInputSource) {
        super(string, string2);
        this.tldOriginatorId = string3;
        this.inputSource = jspInputSource;
    }

    public String getTldFilePath() {
        return this.inputSource.getRelativeURL();
    }

    public long getLoadedTimestamp() {
        return this.inputSource.getLastModified();
    }

    public JspInputSource getInputSource() {
        return this.inputSource;
    }

    void setPrefixString(String string) {
        this.prefix = string;
    }

    void setURI(String string) {
        this.uri = string;
    }

    void setInfoString(String string) {
        this.info = string;
    }

    void setReliableURN(String string) {
        this.urn = string;
    }

    void setRequiredVersion(String string) {
        this.jspversion = string;
    }

    void setShortName(String string) {
        this.shortname = string;
    }

    void setTlibversion(String string) {
        this.tlibversion = string;
    }

    void setTags(List list) {
        this.tags = new TagInfo[list.size()];
        if (list.size() > 0) {
            this.tags = list.toArray(this.tags);
        }
    }

    void setTags(TagInfo[] tagInfoArray) {
        this.tags = tagInfoArray;
    }

    void setTagFiles(List list) {
        this.tagFiles = new TagFileInfo[list.size()];
        if (list.size() > 0) {
            this.tagFiles = list.toArray(this.tagFiles);
        }
    }

    void setTagFiles(TagFileInfo[] tagFileInfoArray) {
        this.tagFiles = tagFileInfoArray;
    }

    void setFunctions(List list) {
        this.functions = new FunctionInfo[list.size()];
        if (list.size() > 0) {
            this.functions = list.toArray(this.functions);
        }
    }

    void setFunctions(FunctionInfo[] functionInfoArray) {
        this.functions = functionInfoArray;
    }

    void setTabLibraryValidator(Class clazz, Map map) {
        this.tlvClass = clazz;
        this.tlvInitParams = map;
    }

    public TagLibraryValidator getTagLibraryValidator() {
        TagLibraryValidator tagLibraryValidator = null;
        if (this.tlvClass != null) {
            try {
                tagLibraryValidator = (TagLibraryValidator)this.tlvClass.newInstance();
                if (this.tlvInitParams != null) {
                    tagLibraryValidator.setInitParameters(this.tlvInitParams);
                } else {
                    tagLibraryValidator.setInitParameters(new HashMap());
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                logger.logp(Level.WARNING, CLASS_NAME, "getTagLibraryValidator", "Illegal access of tag library validator [" + tagLibraryValidator.getClass() + "]", illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                logger.logp(Level.WARNING, CLASS_NAME, "getTagLibraryValidator", "Failed to instantiate tag library validator [" + tagLibraryValidator.getClass() + "]", instantiationException);
            }
        }
        return tagLibraryValidator;
    }

    public String getTlibversion() {
        return this.tlibversion;
    }

    public TagLibraryInfoImpl copy(String string) {
        TagLibraryInfoImpl tagLibraryInfoImpl = new TagLibraryInfoImpl(string, this.uri, this.tldOriginatorId, this.inputSource);
        tagLibraryInfoImpl.setInfoString(this.info);
        tagLibraryInfoImpl.setReliableURN(this.urn);
        tagLibraryInfoImpl.setRequiredVersion(this.jspversion);
        tagLibraryInfoImpl.setShortName(this.shortname);
        tagLibraryInfoImpl.setTlibversion(this.tlibversion);
        tagLibraryInfoImpl.setTags(this.tags);
        tagLibraryInfoImpl.setTagFiles(this.tagFiles);
        tagLibraryInfoImpl.setFunctions(this.functions);
        tagLibraryInfoImpl.setTabLibraryValidator(this.tlvClass, this.tlvInitParams);
        return tagLibraryInfoImpl;
    }

    public String getOriginatorId() {
        return this.tldOriginatorId;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TagLibraryInfo name [");
        if (this.shortname != null) {
            stringBuffer.append(this.shortname);
        }
        stringBuffer.append("] info [");
        if (this.info != null) {
            stringBuffer.append(this.info);
        }
        stringBuffer.append("] urn [");
        if (this.urn != null) {
            stringBuffer.append(this.urn);
        }
        stringBuffer.append("] jspversion [");
        if (this.jspversion != null) {
            stringBuffer.append(this.jspversion);
        }
        stringBuffer.append("] tlibversion [");
        if (this.tlibversion != null) {
            stringBuffer.append(this.tlibversion);
        }
        stringBuffer.append("]\n");
        if (this.tags != null) {
            for (n = 0; n < this.tags.length; ++n) {
                this.tagToString(stringBuffer, this.tags[n]);
            }
        }
        if (this.tagFiles != null) {
            for (n = 0; n < this.tagFiles.length; ++n) {
                stringBuffer.append("tagFile name [");
                if (this.tagFiles[n].getName() != null) {
                    stringBuffer.append(this.tagFiles[n].getName());
                }
                stringBuffer.append("] path [");
                if (this.tagFiles[n].getPath() != null) {
                    stringBuffer.append(this.tagFiles[n].getPath());
                }
                stringBuffer.append("]\n");
                if (this.tagFiles[n].getTagInfo() == null) continue;
                this.tagToString(stringBuffer, this.tagFiles[n].getTagInfo());
            }
        }
        if (this.functions != null) {
            for (n = 0; n < this.functions.length; ++n) {
                stringBuffer.append("function name [");
                if (this.functions[n].getName() != null) {
                    stringBuffer.append(this.functions[n].getName());
                }
                stringBuffer.append("] class [");
                if (this.functions[n].getFunctionClass() != null) {
                    stringBuffer.append(this.functions[n].getFunctionClass());
                }
                stringBuffer.append("] signature [");
                if (this.functions[n].getFunctionSignature() != null) {
                    stringBuffer.append(this.functions[n].getFunctionSignature());
                }
                stringBuffer.append("]\n");
            }
        }
        return stringBuffer.toString();
    }

    private void tagToString(StringBuffer stringBuffer, TagInfo tagInfo) {
        int n;
        TagAttributeInfo[] tagAttributeInfoArray;
        stringBuffer.append("tag tagName [");
        if (tagInfo.getTagName() != null) {
            stringBuffer.append(tagInfo.getTagName());
        }
        stringBuffer.append("] tagClassName [");
        if (tagInfo.getTagClassName() != null) {
            stringBuffer.append(tagInfo.getTagClassName());
        }
        stringBuffer.append("] bodycontent [");
        if (tagInfo.getBodyContent() != null) {
            stringBuffer.append(tagInfo.getBodyContent());
        }
        stringBuffer.append("] info [");
        if (tagInfo.getInfoString() != null) {
            stringBuffer.append(tagInfo.getInfoString());
        }
        stringBuffer.append("] displayName [");
        if (tagInfo.getDisplayName() != null) {
            stringBuffer.append(tagInfo.getDisplayName());
        }
        stringBuffer.append("] smallIcon [");
        if (tagInfo.getSmallIcon() != null) {
            stringBuffer.append(tagInfo.getSmallIcon());
        }
        stringBuffer.append("] largeIcon [");
        if (tagInfo.getLargeIcon() != null) {
            stringBuffer.append(tagInfo.getLargeIcon());
        }
        stringBuffer.append("] dynamicAttributes [");
        stringBuffer.append(tagInfo.hasDynamicAttributes());
        stringBuffer.append("]\n");
        if (tagInfo.getAttributes() != null) {
            tagAttributeInfoArray = tagInfo.getAttributes();
            for (n = 0; n < tagAttributeInfoArray.length; ++n) {
                stringBuffer.append("attribute name [");
                if (tagAttributeInfoArray[n].getName() != null) {
                    stringBuffer.append(tagAttributeInfoArray[n].getName());
                }
                stringBuffer.append("] type [");
                if (tagAttributeInfoArray[n].getTypeName() != null) {
                    stringBuffer.append(tagAttributeInfoArray[n].getTypeName());
                }
                stringBuffer.append("] requestTime [");
                stringBuffer.append(tagAttributeInfoArray[n].canBeRequestTime());
                stringBuffer.append("] fragment [");
                stringBuffer.append(tagAttributeInfoArray[n].isFragment());
                stringBuffer.append("] required [");
                stringBuffer.append(tagAttributeInfoArray[n].isRequired());
                stringBuffer.append("]\n");
            }
        }
        if (tagInfo.getTagVariableInfos() != null) {
            tagAttributeInfoArray = tagInfo.getTagVariableInfos();
            for (n = 0; n < tagAttributeInfoArray.length; ++n) {
                stringBuffer.append("variable nameGiven [");
                if (tagAttributeInfoArray[n].getNameGiven() != null) {
                    stringBuffer.append(tagAttributeInfoArray[n].getNameGiven());
                }
                stringBuffer.append("] nameFromAttribute [");
                if (tagAttributeInfoArray[n].getNameFromAttribute() != null) {
                    stringBuffer.append(tagAttributeInfoArray[n].getNameFromAttribute());
                }
                stringBuffer.append("] className [");
                if (tagAttributeInfoArray[n].getClassName() != null) {
                    stringBuffer.append(tagAttributeInfoArray[n].getClassName());
                }
                stringBuffer.append("] declare [");
                stringBuffer.append(tagAttributeInfoArray[n].getDeclare());
                stringBuffer.append("] scope [");
                stringBuffer.append(tagAttributeInfoArray[n].getScope());
                stringBuffer.append("]\n");
            }
        }
    }
}

