/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.taglib.GlobalTagLibraryCache;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.taglib.TldParser;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TagLibraryInfoProxy {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TagLibraryInfoProxy";
    private String jarName = null;
    private String tldPath = null;
    private TagLibraryInfoImpl tli = null;
    private GlobalTagLibraryCache globalTagLibraryCache = null;
    private boolean containsListenerDefs = false;
    private List eventListenerList = null;

    public TagLibraryInfoProxy(String string, String string2, boolean bl, GlobalTagLibraryCache globalTagLibraryCache) {
        this.jarName = string;
        this.tldPath = string2;
        this.globalTagLibraryCache = globalTagLibraryCache;
        this.containsListenerDefs = bl;
    }

    public synchronized TagLibraryInfoImpl getTagLibraryInfoImpl(String string) {
        if (this.tli == null) {
            this.loadTld();
        }
        if (this.tli == null) {
            return this.tli;
        }
        return this.tli.copy(string);
    }

    public boolean containsListenerDefs() {
        return this.containsListenerDefs;
    }

    public synchronized List getEventListenerList() {
        if (this.eventListenerList == null) {
            this.loadTld();
        }
        return this.eventListenerList;
    }

    private void loadTld() {
        block11: {
            URL uRL = this.globalTagLibraryCache.getClassLoader().getResource(this.jarName);
            if (uRL != null) {
                JspInputSource jspInputSource = null;
                try {
                    JspConfigurationManager jspConfigurationManager = new JspConfigurationManager(Collections.EMPTY_LIST, true, Collections.EMPTY_LIST);
                    TldParser tldParser = new TldParser(this.globalTagLibraryCache, jspConfigurationManager, false);
                    URL uRL2 = new URL("jar:" + uRL.toString() + "!/");
                    jspInputSource = this.globalTagLibraryCache.getJspInputSourceFactory().createJspInputSource(uRL2, this.tldPath);
                    this.tli = tldParser.parseTLD(jspInputSource, this.jarName);
                    if (this.tli.getReliableURN() != null) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadTld", "Global jar tld in proxy loaded for {0}", this.tli.getReliableURN());
                        }
                        this.tli.setURI(this.tli.getReliableURN());
                        if (this.containsListenerDefs) {
                            this.eventListenerList = new ArrayList();
                            this.eventListenerList.addAll(tldParser.getEventListenerList());
                        }
                    } else if (logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTld", "jsp warning failed to find a uri tag in [" + jspInputSource.getAbsoluteURL() + "]");
                    }
                }
                catch (JspCoreException jspCoreException) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTld", "jsp warning failed to load tld in jar. uri = [" + jspInputSource.getAbsoluteURL() + "]", jspCoreException);
                    }
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Level.WARNING)) break block11;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadTld", "jsp warning failed to load tld in jar. uri = [" + jspInputSource.getAbsoluteURL() + "]", iOException);
                }
            }
        }
        if (this.eventListenerList == null) {
            this.eventListenerList = Collections.EMPTY_LIST;
        }
    }
}

