/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslator;
import com.ibm.ws.jsp.translator.JspTranslatorFactory;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.tagfilescan.TagFileScanResult;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.FunctionInfo;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagFileInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TldParser
extends DefaultHandler {
    protected static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TldParser";
    public static final String TAGLIB_DTD_PUBLIC_ID_11 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN";
    public static final String TAGLIB_DTD_RESOURCE_PATH_11 = "/javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd";
    public static final String TAGLIB_DTD_PUBLIC_ID_12 = "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN";
    public static final String TAGLIB_DTD_RESOURCE_PATH_12 = "/javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd";
    public static final String XMLSCHEMA_DTD_PUBLIC_ID = "-//W3C//DTD XMLSCHEMA 200102//EN";
    public static final String XMLSCHEMA_DTD_RESOURCE_PATH = "/javax/servlet/resources/XMLSchema.dtd";
    public static final String DATATYPES_DTD_PUBLIC_ID = "datatypes";
    public static final String DATATYPES_DTD_RESOURCE_PATH = "/javax/servlet/resources/datatypes.dtd";
    public static final String TAGLIB_XSD_SYSTEM_ID_20 = "web-jsptaglibrary_2_0.xsd";
    public static final String TAGLIB_XSD_RESOURCE_PATH_20 = "/javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd";
    public static final String J2EE14_XSD_SYSTEM_ID = "j2ee_1_4.xsd";
    public static final String J2EE14_XSD_RESOURCE_PATH = "/javax/servlet/resources/j2ee_1_4.xsd";
    public static final String XML_XSD_SYSTEM_ID = "http://www.w3.org/2001/xml.xsd";
    public static final String XML_XSD_RESOURCE_PATH = "/javax/servlet/resources/xml.xsd";
    public static final String WEB_SERVICE_CLIENT_XSD_SYSTEM_ID = "http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd";
    public static final String WEB_SERVICE_CLIENT_XSD_RESOURCE_PATH = "/javax/servlet/resources/j2ee_web_services_client_1_1.xsd";
    private static final int TAGLIB_ELEMENT = 1;
    private static final int TAG_ELEMENT = 2;
    private static final int TAGFILE_ELEMENT = 3;
    private static final int FUNCTION_ELEMENT = 4;
    private static final int ATTRIBUTE_ELEMENT = 5;
    protected int currentElement = 0;
    protected JspCoreContext ctxt = null;
    protected JspConfigurationManager configManager = null;
    protected ClassLoader classloader = null;
    protected SAXParser saxParser = null;
    protected TagLibraryInfoImpl tli = null;
    protected List tags = new ArrayList();
    protected String tagName = null;
    protected String tagDescription = null;
    protected String tagClassName = null;
    protected String teiClassName = null;
    protected String bodyContent = "JSP";
    protected String displayName = null;
    protected String smallIcon = null;
    protected String largeIcon = null;
    protected boolean dynamicAttributes = false;
    protected List attributes = new ArrayList();
    protected String attributeName = null;
    protected boolean required = false;
    protected String type = null;
    protected boolean reqTime = false;
    protected boolean fragment = false;
    protected List variables = new ArrayList();
    protected String nameGiven = null;
    protected String nameFromAttribute = null;
    protected String variableClassName = "java.lang.String";
    protected boolean declare = true;
    protected int scope = 0;
    protected List tagFiles = new ArrayList();
    protected String tagFileName = null;
    protected String path = null;
    protected List functions = new ArrayList();
    protected String functionName = null;
    protected String functionClass = null;
    protected String functionSignature = null;
    protected String validatorClass = null;
    protected HashMap validatorInitParams = null;
    protected String paramName = null;
    protected String paramValue = null;
    protected StringBuffer chars = null;
    protected List eventListenerList = new ArrayList();
    private JspOptions jspOptions = new JspOptions();
    protected String tldLocation = null;

    public TldParser(JspCoreContext jspCoreContext, JspConfigurationManager jspConfigurationManager, boolean bl, ClassLoader classLoader) throws JspCoreException {
        this(jspCoreContext, jspConfigurationManager, bl);
        if (classLoader != null) {
            this.classloader = classLoader;
        }
    }

    public TldParser(JspCoreContext jspCoreContext, JspConfigurationManager jspConfigurationManager, boolean bl) throws JspCoreException {
        this.ctxt = jspCoreContext;
        this.configManager = jspConfigurationManager;
        this.classloader = jspCoreContext.getJspClassloaderContext().getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(TldParser.class.getClassLoader());
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            if (bl) {
                sAXParserFactory.setFeature("http://xml.org/sax/features/validation", true);
                sAXParserFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            this.saxParser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JspCoreException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new JspCoreException(sAXException);
        }
        finally {
            thread.setContextClassLoader(classLoader);
        }
    }

    private void reset() {
        this.resetTagFile();
        this.resetTag();
        this.resetFunction();
        this.resetVariable();
        this.resetAttribute();
        this.resetValidator();
        this.tags.clear();
        this.tagFiles.clear();
        this.functions.clear();
        this.eventListenerList.clear();
    }

    private void resetTagFile() {
        this.tagFileName = null;
        this.path = null;
    }

    private void resetTag() {
        this.tagName = null;
        this.tagClassName = null;
        this.teiClassName = null;
        this.bodyContent = "JSP";
        this.tagDescription = null;
        this.displayName = null;
        this.smallIcon = null;
        this.largeIcon = null;
        this.dynamicAttributes = false;
        this.attributes.clear();
        this.variables.clear();
    }

    private void resetFunction() {
        this.functionClass = null;
        this.functionSignature = null;
        this.functionName = null;
    }

    private void resetVariable() {
        this.nameGiven = null;
        this.nameFromAttribute = null;
        this.variableClassName = "java.lang.String";
        this.declare = true;
        this.scope = 0;
    }

    private void resetAttribute() {
        this.attributeName = null;
        this.required = false;
        this.type = null;
        this.reqTime = false;
        this.fragment = false;
    }

    private void resetValidator() {
        this.validatorClass = null;
        this.validatorInitParams = null;
        this.paramName = null;
        this.paramValue = null;
    }

    public TagLibraryInfoImpl parseTLD(JspInputSource jspInputSource, String string) throws JspCoreException {
        this.tldLocation = jspInputSource.getRelativeURL();
        this.tli = new TagLibraryInfoImpl(string, jspInputSource);
        try {
            this.parse(jspInputSource.getInputStream());
        }
        catch (SAXException sAXException) {
            this.tli = null;
            this.logParseErrorMessage(sAXException);
            throw new JspCoreException(sAXException);
        }
        catch (IOException iOException) {
            this.tli = null;
            this.logParseErrorMessage(iOException);
            throw new JspCoreException(iOException);
        }
        return this.tli;
    }

    public TagLibraryInfoImpl parseTLD(JspInputSource jspInputSource, InputStream inputStream, String string) throws JspCoreException {
        this.tldLocation = jspInputSource.getRelativeURL();
        this.tli = new TagLibraryInfoImpl(string, jspInputSource);
        try {
            this.parse(inputStream);
        }
        catch (SAXException sAXException) {
            this.tli = null;
            this.logParseErrorMessage(sAXException);
            throw new JspCoreException(sAXException);
        }
        catch (IOException iOException) {
            this.tli = null;
            this.logParseErrorMessage(iOException);
            throw new JspCoreException(iOException);
        }
        return this.tli;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream inputStream) throws SAXException, IOException {
        this.reset();
        try {
            ParserFactory.parseDocument(this.saxParser, inputStream, (DefaultHandler)this);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public List getEventListenerList() {
        return this.eventListenerList;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.chars = new StringBuffer();
        if (string3.equals("taglib")) {
            this.currentElement = 1;
        } else if (string3.equals("tag")) {
            this.currentElement = 2;
        } else if (string3.equals("tag-file")) {
            this.currentElement = 3;
        } else if (string3.equals("function")) {
            this.currentElement = 4;
        } else if (string3.equals("attribute")) {
            this.currentElement = 5;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        for (int i = 0; i < n2; ++i) {
            if (this.chars == null) continue;
            this.chars.append(cArray[n + i]);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("tlibversion") || string3.equals("tlib-version")) {
            this.tli.setTlibversion(this.chars.toString().trim());
        } else if (string3.equals("jspversion") || string3.equals("jsp-version")) {
            this.tli.setRequiredVersion(this.chars.toString().trim());
        } else if (string3.equals("shortname") || string3.equals("short-name")) {
            this.tli.setShortName(this.chars.toString().trim());
        } else if (string3.equals("uri")) {
            this.tli.setReliableURN(this.chars.toString().trim());
        } else if (string3.equals("info") || string3.equals("description")) {
            switch (this.currentElement) {
                case 1: {
                    this.tli.setInfoString(this.chars.toString().trim());
                    break;
                }
                case 2: {
                    this.tagDescription = this.chars.toString().trim();
                }
            }
        } else if (string3.equals("tag")) {
            TagAttributeInfo[] tagAttributeInfoArray = new TagAttributeInfo[this.attributes.size()];
            if (this.attributes.size() > 0) {
                tagAttributeInfoArray = this.attributes.toArray(tagAttributeInfoArray);
            }
            TagVariableInfo[] tagVariableInfoArray = new TagVariableInfo[this.variables.size()];
            if (this.variables.size() > 0) {
                tagVariableInfoArray = this.variables.toArray(tagVariableInfoArray);
            }
            TagExtraInfo tagExtraInfo = null;
            if (this.teiClassName != null) {
                if (this.teiClassName.trim().equals("")) {
                    logger.logp(Level.WARNING, CLASS_NAME, "endElement", "TagExtraInfo specified in tld without a value.  tld=[" + this.tldLocation + "]");
                } else {
                    try {
                        tagExtraInfo = (TagExtraInfo)this.classloader.loadClass(this.teiClassName).newInstance();
                    }
                    catch (Exception exception) {
                        String string4 = JspCoreException.getMsg("jsp.error.failed.load.tei.class", new Object[]{this.teiClassName});
                        logger.logp(Level.WARNING, CLASS_NAME, "endElement", string4);
                    }
                }
            }
            TagInfo tagInfo = new TagInfo(this.tagName, this.tagClassName, this.bodyContent, this.tagDescription, (TagLibraryInfo)this.tli, tagExtraInfo, tagAttributeInfoArray, this.displayName, this.smallIcon, this.largeIcon, tagVariableInfoArray, this.dynamicAttributes);
            this.tags.add(tagInfo);
            this.resetTag();
            this.currentElement = 1;
        } else {
            if (string3.equals("tag-file")) {
                try {
                    JspInputSource jspInputSource = this.ctxt.getJspInputSourceFactory().copyJspInputSource(this.tli.getInputSource(), this.path);
                    JspTranslator jspTranslator = JspTranslatorFactory.getFactory().createTranslator("TagFileScan", jspInputSource, this.ctxt, this.configManager.createJspConfiguration(), this.jspOptions, new HashMap());
                    JspVisitorInputMap jspVisitorInputMap = new JspVisitorInputMap();
                    jspVisitorInputMap.put("TagLibraryInfo", this.tli);
                    jspVisitorInputMap.put("TagFileName", this.tagFileName);
                    jspVisitorInputMap.put("TagFilePath", this.path);
                    HashMap hashMap = jspTranslator.processVisitors(jspVisitorInputMap);
                    TagFileScanResult tagFileScanResult = (TagFileScanResult)hashMap.get("TagFileScan");
                    TagFileInfo tagFileInfo = new TagFileInfo(this.tagFileName, this.path, tagFileScanResult.getTagInfo());
                    this.tagFiles.add(tagFileInfo);
                    this.resetTagFile();
                    this.currentElement = 1;
                }
                catch (JspCoreException jspCoreException) {
                    throw new SAXException(jspCoreException);
                }
            }
            if (string3.equals("function")) {
                FunctionInfo functionInfo = new FunctionInfo(this.functionName, this.functionClass, this.functionSignature);
                this.functions.add(functionInfo);
                this.resetFunction();
                this.currentElement = 1;
            } else if (string3.equals("name")) {
                switch (this.currentElement) {
                    case 3: {
                        this.tagFileName = this.chars.toString().trim();
                        break;
                    }
                    case 2: {
                        this.tagName = this.chars.toString().trim();
                        break;
                    }
                    case 4: {
                        this.functionName = this.chars.toString().trim();
                        break;
                    }
                    case 5: {
                        this.attributeName = this.chars.toString().trim();
                    }
                }
            } else if (string3.equals("path")) {
                this.path = this.chars.toString().trim();
            } else if (string3.equals("tag-class") || string3.equals("tagclass")) {
                this.tagClassName = this.chars.toString().trim();
            } else if (string3.equals("tei-class") || string3.equals("teiclass")) {
                this.teiClassName = this.chars.toString().trim();
            } else if (string3.equals("body-content") || string3.equals("bodycontent")) {
                this.bodyContent = this.chars.toString().trim();
            } else if (string3.equals("variable")) {
                TagVariableInfo tagVariableInfo = new TagVariableInfo(this.nameGiven, this.nameFromAttribute, this.variableClassName, this.declare, this.scope);
                this.variables.add(tagVariableInfo);
                this.resetVariable();
            } else if (string3.equals("attribute")) {
                if (this.fragment) {
                    this.type = "javax.servlet.jsp.tagext.JspFragment";
                    this.reqTime = true;
                }
                if (!this.reqTime) {
                    this.type = "java.lang.String";
                }
                TagAttributeInfo tagAttributeInfo = new TagAttributeInfo(this.attributeName, this.required, this.type, this.reqTime, this.fragment);
                this.attributes.add(tagAttributeInfo);
                this.resetAttribute();
                this.currentElement = 2;
            } else if (string3.equals("required")) {
                String string5 = this.chars.toString().trim();
                this.required = string5.equalsIgnoreCase("yes") || string5.equalsIgnoreCase("true");
            } else if (string3.equals("rtexprvalue")) {
                String string6 = this.chars.toString().trim();
                this.reqTime = string6.equalsIgnoreCase("yes") || string6.equalsIgnoreCase("true");
            } else if (!string3.equals("listener")) {
                if (string3.equals("listener-class")) {
                    this.eventListenerList.add(this.chars.toString().trim());
                } else if (string3.equals("type")) {
                    this.type = this.chars.toString().trim();
                } else if (string3.equals("function-class")) {
                    this.functionClass = this.chars.toString().trim();
                } else if (string3.equals("function-signature")) {
                    this.functionSignature = this.chars.toString().trim();
                } else if (string3.equals("dynamic-attributes")) {
                    String string7 = this.chars.toString().trim();
                    this.dynamicAttributes = string7.equalsIgnoreCase("yes") || string7.equalsIgnoreCase("true");
                } else if (string3.equals("fragment")) {
                    String string8 = this.chars.toString().trim();
                    this.fragment = string8.equalsIgnoreCase("yes") || string8.equalsIgnoreCase("true");
                } else if (string3.equals("name-given")) {
                    this.nameGiven = this.chars.toString().trim();
                } else if (string3.equals("name-from-attribute")) {
                    this.nameFromAttribute = this.chars.toString().trim();
                } else if (string3.equals("variable-class")) {
                    this.variableClassName = this.chars.toString().trim();
                } else if (string3.equals("declare")) {
                    String string9 = this.chars.toString().trim();
                    this.declare = string9.equalsIgnoreCase("yes") || string9.equalsIgnoreCase("true");
                } else if (string3.equals("scope")) {
                    String string10 = this.chars.toString().trim();
                    if (string10.equals("AT_BEGIN")) {
                        this.scope = 1;
                    } else if (string10.equals("NESTED")) {
                        this.scope = 0;
                    } else if (string10.equals("AT_END")) {
                        this.scope = 2;
                    }
                } else if (string3.equals("validator")) {
                    if (this.validatorClass != null) {
                        if (this.validatorClass.trim().equals("")) {
                            logger.logp(Level.WARNING, CLASS_NAME, "endElement", "TagLibraryValidator specified in tld without a value.  tld=[" + this.tldLocation + "]");
                        } else {
                            try {
                                Class<?> clazz = this.classloader.loadClass(this.validatorClass);
                                this.tli.setTabLibraryValidator(clazz, this.validatorInitParams);
                            }
                            catch (Exception exception) {
                                String string11 = JspCoreException.getMsg("jsp.error.failed.load.tlv.class", new Object[]{this.validatorClass});
                                logger.logp(Level.FINE, CLASS_NAME, "endElement", string11, exception);
                                throw new SAXException(string11);
                            }
                        }
                    }
                    this.resetValidator();
                } else if (string3.equals("validator-class")) {
                    this.validatorClass = this.chars.toString().trim();
                } else if (string3.equals("init-param")) {
                    if (this.validatorInitParams == null) {
                        this.validatorInitParams = new HashMap();
                    }
                    this.validatorInitParams.put(this.paramName, this.paramValue);
                } else if (string3.equals("param-name")) {
                    this.paramName = this.chars.toString().trim();
                } else if (string3.equals("param-value")) {
                    this.paramValue = this.chars.toString().trim();
                } else if (string3.equals("small-icon")) {
                    this.smallIcon = this.chars.toString().trim();
                } else if (string3.equals("large-icon")) {
                    this.largeIcon = this.chars.toString().trim();
                } else if (string3.equals("taglib")) {
                    this.tli.setTags(this.tags);
                    this.tli.setTagFiles(this.tagFiles);
                    this.tli.setFunctions(this.functions);
                    this.currentElement = 0;
                }
            }
        }
        this.chars = null;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        InputSource inputSource = null;
        String string3 = null;
        if (string != null) {
            if (string.equals(TAGLIB_DTD_PUBLIC_ID_11)) {
                string3 = TAGLIB_DTD_RESOURCE_PATH_11;
            } else if (string.equals(TAGLIB_DTD_PUBLIC_ID_12)) {
                string3 = TAGLIB_DTD_RESOURCE_PATH_12;
            } else if (string.equals(XMLSCHEMA_DTD_PUBLIC_ID)) {
                string3 = XMLSCHEMA_DTD_RESOURCE_PATH;
            } else if (string.equals(DATATYPES_DTD_PUBLIC_ID)) {
                string3 = DATATYPES_DTD_RESOURCE_PATH;
            }
        } else if (string2 != null) {
            if (string2.endsWith(TAGLIB_XSD_SYSTEM_ID_20)) {
                string3 = TAGLIB_XSD_RESOURCE_PATH_20;
            } else if (string2.endsWith(J2EE14_XSD_SYSTEM_ID)) {
                string3 = J2EE14_XSD_RESOURCE_PATH;
            } else if (string2.equals(XML_XSD_SYSTEM_ID)) {
                string3 = XML_XSD_RESOURCE_PATH;
            } else if (string2.equals(WEB_SERVICE_CLIENT_XSD_SYSTEM_ID)) {
                string3 = WEB_SERVICE_CLIENT_XSD_RESOURCE_PATH;
            }
        }
        if (string3 != null) {
            InputStream inputStream = this.getClass().getResourceAsStream(string3);
            if (inputStream == null) {
                throw new SAXException(JspCoreException.getMsg("jsp.error.internal.dtd.not.found") + "[" + string3 + "]");
            }
            inputSource = new InputSource(inputStream);
            inputSource.setSystemId(string2);
        }
        return inputSource;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        String string = sAXParseException.getMessage();
        String string2 = "Parser warning during parse of Tag Library [" + this.tldLocation + "]";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        logger.logp(Level.WARNING, CLASS_NAME, "warning", string2);
    }

    private void logParseErrorMessage(Exception exception) {
        String string = exception.getMessage();
        String string2 = "Failed to parse Tag Library [" + this.tldLocation + "]";
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        logger.logp(Level.SEVERE, CLASS_NAME, "logParseErrorMessage", string2);
    }
}

